--TEST--
Oracle Database 12c Implicit Result Sets: test with a PL/SQL function
--SKIPIF--
<?php
if (!extension_loaded('oci8')) die ("skip no oci8 extension");
$target_dbs = array('oracledb' => true, 'timesten' => false);  // test runs on these DBs
require(__DIR__.'/skipif.inc');
preg_match('/.*Release ([[:digit:]]+)\.([[:digit:]]+)\.([[:digit:]]+)\.([[:digit:]]+)\.([[:digit:]]+)*/', oci_server_version($c), $matches);
if (!(isset($matches[0]) && $matches[1] >= 12)) {
    die("skip expected output only valid when using Oracle Database 12c or greater");
}
preg_match('/^[[:digit:]]+/', oci_client_version(), $matches);
if (!(isset($matches[0]) && $matches[0] >= 12)) {
    die("skip works only with Oracle 12c or greater version of Oracle client libraries");
}
?>
--FILE--
<?php

require(__DIR__.'/connect.inc');

// Initialization

$stmtarray = array(
    "create or replace function imp_res_func_error return number as
      c1 sys_refcursor;
    begin
      open c1 for select * from dual;
      dbms_sql.return_result(c1);
      return 1234;
    end;"
);

oci8_test_sql_execute($c, $stmtarray);

// Run Test

echo "Test 1\n";
$s = oci_parse($c, "select imp_res_func_error from dual");
$r = oci_execute($s);   // This will fail with ORA-29478 in Oracle 12.1
if ($r) {
    while (($row = oci_fetch_array($s, OCI_ASSOC+OCI_RETURN_NULLS)) != false) {
        foreach ($row as $item) {
            echo "  ".$item;
        }
        echo "\n";
    }
}
// Clean up

$stmtarray = array(
    "drop function imp_res_func_error",
);

oci8_test_sql_execute($c, $stmtarray);

?>
--EXPECTF--
Test 1

Warning: oci_execute(): ORA-29478: %s
ORA-06512: %s
ORA-06512: %s
ORA-06512: %s
