/* Generated by re2c 3.1 */
/*
 * phpdbg_lexer.l
 */

#include "phpdbg.h"
#include "phpdbg_cmd.h"

#include "phpdbg_parser.h"

#define LEX(v) (PHPDBG_G(lexer).v)

#define YYCTYPE unsigned char
#define YYSETCONDITION(x) LEX(state) = x;
#define YYGETCONDITION() LEX(state)
#define YYCURSOR LEX(cursor)
#define YYMARKER LEX(marker)
#define YYCTXMARKER LEX(ctxmarker)
#define yyleng LEX(len)
#define yytext ((char*) LEX(text))
#undef YYDEBUG
#define YYDEBUG(a, b)
#define YYFILL(n)

#define NORMAL 0
#define PRE_RAW 1
#define RAW 2
#define INITIAL 3

ZEND_EXTERN_MODULE_GLOBALS(phpdbg)

void phpdbg_init_lexer (phpdbg_param_t *stack, char *input) {
	PHPDBG_G(parser_stack) = stack;

	YYSETCONDITION(INITIAL);

	LEX(text) = YYCURSOR = (unsigned char *) input;
	LEX(len) = strlen(input);
}

static int unescape_string(char *s) {
	switch (*s) {
		case '\'':
		case '\"': {
			char start = *s;
			size_t off = 1;
			do {
				if (s[off] == '\\') {
					off++;
				}
				*s = s[off];
			} while ((++s)[off] != start);
			return off + 1;
		}
	}

	return 0;
}

int phpdbg_lex (phpdbg_param_t* yylval) {

restart:
	LEX(text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm_NORMAL[] = {
		/* table 1 .. 8: 0 */
		  0,  62,  62,  62,  62,  62,  62,  62, 
		 62,  40,   0,  62,  62,  40,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 40,  62,  50,  40,  62,  62,  62,  14, 
		 62,  62,  62,  62,  62,  62,  63,  62, 
		127, 127, 127, 127, 127, 127, 127, 127, 
		127, 127,  40,  62,  62,  62,  62,  62, 
		 62, 254, 254, 254, 254, 254, 254, 190, 
		190, 190, 190, 190, 190, 190, 190, 190, 
		190, 190, 190, 190, 190, 190, 190, 190, 
		190, 190, 190,  62,   2,  62,  62, 190, 
		 62, 254, 254, 254, 254, 254, 254, 190, 
		190, 190, 190, 190, 190, 190, 190, 190, 
		190, 190, 190, 190, 190, 190, 190, 190, 
		190, 190, 190,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		 62,  62,  62,  62,  62,  62,  62,  62, 
		/* table 9 .. 10: 256 */
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64, 128,   0,  64,  64, 128,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		128,  64,   0,   0,  64,  64,  64,   0, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,   0,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
	};
	static const unsigned char yybm_PRE_RAW[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  64,   0,   0,   0,  64,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 64,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0, 128,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	static const unsigned char yybm_RAW[] = {
		  0, 232, 232, 232, 232, 232, 232, 232, 
		232, 232,   0, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232,  64, 224, 232, 232, 232,  32, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232,  16, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
		232, 232, 232, 232, 232, 232, 232, 232, 
	};
	static const unsigned char yybm_INITIAL[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128,   0,   0,   0, 128,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	if (YYGETCONDITION() < 2) {
		if (YYGETCONDITION() < 1) {
			goto yyc_NORMAL;
		} else {
			goto yyc_PRE_RAW;
		}
	} else {
		if (YYGETCONDITION() < 3) {
			goto yyc_RAW;
		} else {
			goto yyc_INITIAL;
		}
	}
/* *********************************** */
yyc_NORMAL:
	YYDEBUG(0, *YYCURSOR);
	YYFILL(11);
	yych = *YYCURSOR;
	if (yybm_NORMAL[256+yych] & 128) {
		goto yy5;
	}
	switch (yych) {
		case 0x00:
		case '\t':
		case '\n': goto yy1;
		case '"': goto yy6;
		case '#': goto yy8;
		case '\'': goto yy10;
		case '-': goto yy11;
		case '.':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy12;
		case '0': goto yy14;
		case ':': goto yy15;
		case 'D':
		case 'd': goto yy16;
		case 'E':
		case 'e': goto yy17;
		case 'F':
		case 'f': goto yy18;
		case 'I':
		case 'i': goto yy19;
		case 'N':
		case 'n': goto yy20;
		case 'O':
		case 'o': goto yy21;
		case 'T':
		case 't': goto yy22;
		case 'Y':
		case 'y': goto yy23;
		case 'Z': goto yy24;
		case 'z': goto yy25;
		default: goto yy2;
	}
yy1:
	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return 0;
}
yy2:
	YYDEBUG(2, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
yy3:
	YYDEBUG(3, *YYCURSOR);
	if (yybm_NORMAL[256+yych] & 64) {
		goto yy2;
	}
	if (yych <= ' ') goto yy4;
	if (yych == '#') goto yy4;
	if (yych <= '\'') goto yy26;
	goto yy28;
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng - unescape_string(yytext));
	yylval->len = yyleng;
	return T_ID;
}
yy5:
	YYDEBUG(5, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_NORMAL[256+yych] & 128) {
		goto yy5;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	/* ignore whitespace */

	goto restart;
}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '"') goto yy26;
	goto yy30;
yy7:
	YYDEBUG(7, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 3) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy4;
			} else {
				goto yy9;
			}
		} else {
			if (yyaccept == 2) {
				goto yy13;
			} else {
				goto yy71;
			}
		}
	} else {
		if (yyaccept <= 5) {
			if (yyaccept == 4) {
				goto yy73;
			} else {
				goto yy85;
			}
		} else {
			goto yy100;
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy9;
		if (yych <= '-') {
			YYCTXMARKER = YYCURSOR;
			goto yy35;
		}
		YYCTXMARKER = YYCURSOR;
		goto yy36;
	} else {
		if (yych <= '/') goto yy9;
		if (yych <= '9') {
			YYCTXMARKER = YYCURSOR;
			goto yy36;
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy26;
	goto yy39;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 1) {
		goto yy12;
	}
	if (yych == 'r') goto yy44;
	goto yy3;
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_NORMAL[0+yych] & 1) {
		goto yy12;
	}
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy13;
			if (yych <= 0x08) goto yy2;
		} else {
			if (yych == '\r') goto yy13;
			if (yych <= 0x1F) goto yy2;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy2;
			if (yych <= '"') goto yy26;
			if (yych >= '$') goto yy2;
		} else {
			if (yych <= '\'') goto yy26;
			if (yych <= '/') goto yy2;
			if (yych <= ':') goto yy28;
			goto yy2;
		}
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = atoi(yytext);
	return T_DIGITS;
}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 1) {
		goto yy12;
	}
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy13;
			if (yych <= 0x08) goto yy3;
			goto yy13;
		} else {
			if (yych == '\r') goto yy13;
			goto yy3;
		}
	} else {
		if (yych <= '#') {
			if (yych <= ' ') goto yy13;
			if (yych <= '"') goto yy3;
			goto yy13;
		} else {
			if (yych == 'x') goto yy45;
			goto yy3;
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy47;
	if (yych == '\\') goto yy48;
	goto yy46;
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy49;
	if (yych == 'i') goto yy49;
	goto yy3;
yy17:
	YYDEBUG(17, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy50;
	if (yych == 'n') goto yy50;
	goto yy3;
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'A') goto yy51;
	if (yych == 'a') goto yy51;
	goto yy3;
yy19:
	YYDEBUG(19, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'F') goto yy52;
	if (yych == 'f') goto yy52;
	goto yy3;
yy20:
	YYDEBUG(20, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy53;
	if (yych == 'o') goto yy53;
	goto yy3;
yy21:
	YYDEBUG(21, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == 'F') goto yy54;
		if (yych <= 'M') goto yy3;
		goto yy55;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy3;
			goto yy54;
		} else {
			if (yych == 'n') goto yy55;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy56;
	if (yych == 'r') goto yy56;
	goto yy3;
yy23:
	YYDEBUG(23, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy57;
	if (yych == 'e') goto yy57;
	goto yy3;
yy24:
	YYDEBUG(24, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy58;
	goto yy3;
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'e') goto yy59;
	goto yy3;
yy26:
	YYDEBUG(26, *YYCURSOR);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
yy27:
	YYDEBUG(27, *YYCURSOR);
	if (yybm_NORMAL[0+yych] & 2) {
		goto yy26;
	}
	if (yych <= '#') goto yy7;
	goto yy60;
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy61;
	if (yych == '\\') goto yy48;
	goto yy7;
yy29:
	YYDEBUG(29, *YYCURSOR);
	++YYCURSOR;
	YYFILL(4);
	yych = *YYCURSOR;
yy30:
	YYDEBUG(30, *YYCURSOR);
	if (yybm_NORMAL[0+yych] & 4) {
		goto yy29;
	}
	if (yych <= ' ') {
		if (yych <= 0x00) goto yy7;
		if (yych == '\n') goto yy7;
	} else {
		if (yych <= '"') goto yy62;
		if (yych <= '#') goto yy31;
		if (yych <= ':') goto yy33;
		goto yy34;
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy32:
	YYDEBUG(32, *YYCURSOR);
	if (yybm_NORMAL[0+yych] & 8) {
		goto yy31;
	}
	if (yych <= '\n') goto yy7;
	if (yych <= '"') goto yy63;
	goto yy64;
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy65;
	goto yy32;
yy34:
	YYDEBUG(34, *YYCURSOR);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy7;
			if (yych <= 0x08) goto yy26;
			goto yy7;
		} else {
			if (yych == '\r') goto yy7;
			if (yych <= 0x1F) goto yy26;
			goto yy7;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '!') goto yy26;
			if (yych <= '"') goto yy29;
			if (yych <= '#') goto yy7;
			goto yy26;
		} else {
			if (yych <= ':') goto yy60;
			if (yych == '\\') goto yy29;
			goto yy26;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy36;
	if (yych <= '/') goto yy7;
	if (yych >= ':') goto yy7;
yy36:
	YYDEBUG(36, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '.') goto yy36;
	if (yych <= '/') goto yy37;
	if (yych <= '9') goto yy36;
yy37:
	YYDEBUG(37, *YYCURSOR);
	YYCURSOR = YYCTXMARKER;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return T_POUND;
}
yy38:
	YYDEBUG(38, *YYCURSOR);
	++YYCURSOR;
	YYFILL(4);
	yych = *YYCURSOR;
yy39:
	YYDEBUG(39, *YYCURSOR);
	if (yybm_NORMAL[0+yych] & 16) {
		goto yy38;
	}
	if (yych <= '\n') {
		if (yych <= 0x00) goto yy7;
		if (yych >= '\n') goto yy7;
	} else {
		if (yych <= '#') goto yy40;
		if (yych <= '\'') goto yy62;
		if (yych <= ':') goto yy42;
		goto yy43;
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy41:
	YYDEBUG(41, *YYCURSOR);
	if (yybm_NORMAL[0+yych] & 32) {
		goto yy40;
	}
	if (yych <= '\n') goto yy7;
	if (yych <= '\'') goto yy63;
	goto yy66;
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy67;
	goto yy41;
yy43:
	YYDEBUG(43, *YYCURSOR);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy7;
			if (yych <= 0x08) goto yy26;
			if (yych <= '\n') goto yy7;
			goto yy26;
		} else {
			if (yych <= '\r') goto yy7;
			if (yych == ' ') goto yy7;
			goto yy26;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '#') goto yy7;
			if (yych == '\'') goto yy38;
			goto yy26;
		} else {
			if (yych <= ':') goto yy60;
			if (yych == '\\') goto yy38;
			goto yy26;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych <= '\f') {
			if (yych == '\t') goto yy68;
			goto yy3;
		} else {
			if (yych <= '\r') goto yy68;
			if (yych <= 0x1F) goto yy3;
			goto yy68;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy3;
			if (yych <= '-') goto yy69;
			goto yy70;
		} else {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy70;
			goto yy3;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 64) {
		goto yy72;
	}
	goto yy3;
yy46:
	YYDEBUG(46, *YYCURSOR);
	++YYCURSOR;
	YYCURSOR -= 1;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return T_COLON;
}
yy47:
	YYDEBUG(47, *YYCURSOR);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return T_DCOLON;
}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy4;
			if (yych <= 0x08) goto yy48;
			goto yy4;
		} else {
			if (yych == '\r') goto yy4;
			if (yych <= 0x1F) goto yy48;
			goto yy4;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy48;
			if (yych <= '#') goto yy4;
			goto yy48;
		} else {
			if (yych <= '\'') goto yy4;
			if (yych == ':') goto yy74;
			goto yy48;
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy75;
	if (yych == 's') goto yy75;
	goto yy3;
yy50:
	YYDEBUG(50, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'A') goto yy76;
	if (yych == 'a') goto yy76;
	goto yy3;
yy51:
	YYDEBUG(51, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'L') goto yy77;
	if (yych == 'l') goto yy77;
	goto yy3;
yy52:
	YYDEBUG(52, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\f') {
		if (yych == '\t') goto yy78;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy78;
		if (yych == ' ') goto yy78;
		goto yy3;
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\f') {
		if (yych <= 0x00) goto yy79;
		if (yych <= 0x08) goto yy3;
		if (yych <= '\n') goto yy79;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy79;
		if (yych == ' ') goto yy79;
		goto yy3;
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'F') goto yy53;
	if (yych == 'f') goto yy53;
	goto yy3;
yy55:
	YYDEBUG(55, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\f') {
		if (yych <= 0x00) goto yy80;
		if (yych <= 0x08) goto yy3;
		if (yych <= '\n') goto yy80;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy80;
		if (yych == ' ') goto yy80;
		goto yy3;
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy81;
	if (yych == 'u') goto yy81;
	goto yy3;
yy57:
	YYDEBUG(57, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy55;
	if (yych == 's') goto yy55;
	goto yy3;
yy58:
	YYDEBUG(58, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy82;
	goto yy3;
yy59:
	YYDEBUG(59, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'n') goto yy83;
	goto yy3;
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy7;
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy84;
	goto yy7;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\r') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy4;
			goto yy27;
		} else {
			if (yych <= '\n') goto yy4;
			if (yych <= '\f') goto yy27;
			goto yy4;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy27;
			goto yy4;
		} else {
			if (yych == '#') goto yy4;
			goto yy27;
		}
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	++YYCURSOR;
	goto yy4;
yy64:
	YYDEBUG(64, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '"') goto yy31;
	if (yych == '\\') goto yy31;
	goto yy7;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy86;
	goto yy32;
yy66:
	YYDEBUG(66, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\'') goto yy40;
	if (yych == '\\') goto yy40;
	goto yy7;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy87;
	goto yy41;
yy68:
	YYDEBUG(68, *YYCURSOR);
	++YYCURSOR;
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\f') {
			if (yych == '\t') goto yy68;
			goto yy7;
		} else {
			if (yych <= '\r') goto yy68;
			if (yych <= 0x1F) goto yy7;
			goto yy68;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy7;
			if (yych <= '-') goto yy88;
			goto yy89;
		} else {
			if (yych <= '/') goto yy7;
			if (yych <= '9') goto yy89;
			goto yy7;
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy70;
	if (yych <= '/') goto yy3;
	if (yych >= ':') goto yy3;
yy70:
	YYDEBUG(70, *YYCURSOR);
	yyaccept = 3;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy71;
			if (yych <= 0x08) goto yy2;
			if (yych >= '\v') goto yy2;
		} else {
			if (yych <= 0x1F) {
				if (yych >= 0x0E) goto yy2;
			} else {
				if (yych <= ' ') goto yy71;
				if (yych <= '!') goto yy2;
				goto yy26;
			}
		}
	} else {
		if (yych <= '-') {
			if (yych <= '#') goto yy71;
			if (yych == '\'') goto yy26;
			goto yy2;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy70;
				goto yy2;
			} else {
				if (yych <= '9') goto yy70;
				if (yych <= ':') goto yy28;
				goto yy2;
			}
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
yy72:
	YYDEBUG(72, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_NORMAL[0+yych] & 64) {
		goto yy72;
	}
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy73;
			if (yych <= 0x08) goto yy2;
		} else {
			if (yych == '\r') goto yy73;
			if (yych <= 0x1F) goto yy2;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy2;
			if (yych <= '"') goto yy26;
			if (yych >= '$') goto yy2;
		} else {
			if (yych <= '\'') goto yy26;
			if (yych <= '/') goto yy2;
			if (yych <= ':') goto yy28;
			goto yy2;
		}
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, ADDR_PARAM);
	yylval->addr = strtoul(yytext, 0, 16);
	return T_ADDR;
}
yy74:
	YYDEBUG(74, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\\') goto yy48;
	goto yy7;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'A') goto yy90;
	if (yych == 'a') goto yy90;
	goto yy3;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'B') goto yy91;
	if (yych == 'b') goto yy91;
	goto yy3;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy92;
	if (yych == 's') goto yy92;
	goto yy3;
yy78:
	YYDEBUG(78, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy78;
	} else {
		if (yych <= '\r') goto yy78;
		if (yych == ' ') goto yy78;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_IF;
}
yy79:
	YYDEBUG(79, *YYCURSOR);
	++YYCURSOR;
	YYCURSOR -= 1;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 0;
	return T_FALSY;
}
yy80:
	YYDEBUG(80, *YYCURSOR);
	++YYCURSOR;
	YYCURSOR -= 1;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 1;
	return T_TRUTHY;
}
yy81:
	YYDEBUG(81, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy55;
	if (yych == 'e') goto yy55;
	goto yy3;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy93;
	goto yy3;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy93;
	goto yy3;
yy84:
	YYDEBUG(84, *YYCURSOR);
	++YYCURSOR;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_PROTO;
}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy85;
	if (yych == '\n') goto yy85;
	goto yy32;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy85;
	if (yych == '\n') goto yy85;
	goto yy41;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy89;
	if (yych <= '/') goto yy7;
	if (yych >= ':') goto yy7;
yy89:
	YYDEBUG(89, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '.') goto yy89;
	if (yych <= '/') goto yy71;
	if (yych <= '9') goto yy89;
	goto yy71;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'B') goto yy94;
	if (yych == 'b') goto yy94;
	goto yy3;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'L') goto yy95;
	if (yych == 'l') goto yy95;
	goto yy3;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy53;
	if (yych == 'e') goto yy53;
	goto yy3;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '_') goto yy96;
	goto yy3;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'L') goto yy97;
	if (yych == 'l') goto yy97;
	goto yy3;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy3;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 128) {
		goto yy99;
	}
	goto yy3;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy101;
	if (yych == 'e') goto yy101;
	goto yy3;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy55;
	if (yych == 'd') goto yy55;
	goto yy3;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_NORMAL[0+yych] & 128) {
		goto yy99;
	}
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy100;
			if (yych <= 0x08) goto yy2;
		} else {
			if (yych == '\r') goto yy100;
			if (yych <= 0x1F) goto yy2;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy2;
			if (yych <= '"') goto yy26;
			if (yych >= '$') goto yy2;
		} else {
			if (yych <= '\'') goto yy26;
			if (yych == ':') goto yy28;
			goto yy2;
		}
	}
yy100:
	YYDEBUG(100, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, OP_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_OPCODE;
}
yy101:
	YYDEBUG(101, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy53;
	if (yych == 'd') goto yy53;
	goto yy3;
/* *********************************** */
yyc_PRE_RAW:
	YYDEBUG(102, *YYCURSOR);
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '\r') {
		if (yych == '\t') goto yy104;
		if (yych >= '\r') goto yy104;
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') goto yy105;
		} else {
			if (yych == '-') goto yy106;
		}
	}
	++YYCURSOR;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(RAW);

	YYCURSOR = LEX(text);
	goto restart;
}
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 64) {
		goto yy105;
	}
	goto yy103;
yy105:
	YYDEBUG(105, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 64) {
		goto yy105;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	/* ignore whitespace */

	goto restart;
}
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != 'r') goto yy103;
yy107:
	YYDEBUG(107, *YYCURSOR);
	++YYCURSOR;
	YYFILL(2);
	yych = *YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 128) {
		goto yy110;
	}
	if (yych <= '\r') {
		if (yych == '\t') goto yy107;
		if (yych >= '\r') goto yy107;
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') goto yy107;
		} else {
			if (yych == '-') goto yy109;
		}
	}
yy108:
	YYDEBUG(108, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy103;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 128) {
		goto yy110;
	}
	goto yy108;
yy110:
	YYDEBUG(110, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 128) {
		goto yy110;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
/* *********************************** */
yyc_RAW:
	YYDEBUG(111, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 8) {
		goto yy113;
	}
	if (yych <= '\n') goto yy112;
	if (yych <= '"') goto yy115;
	if (yych <= '#') goto yy117;
	if (yych <= '\'') goto yy118;
	goto yy119;
yy112:
	YYDEBUG(112, *YYCURSOR);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return 0;
}
yy113:
	YYDEBUG(113, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 8) {
		goto yy113;
	}
	if (yych <= '\n') goto yy114;
	if (yych <= '"') goto yy115;
	if (yych <= '#') goto yy114;
	if (yych <= '\'') goto yy118;
	goto yy119;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrdup(yytext);
	yylval->len = yyleng;
	return T_INPUT;
}
yy115:
	YYDEBUG(115, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 32) {
		goto yy120;
	}
	if (yych >= '#') goto yy121;
yy116:
	YYDEBUG(116, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy114;
yy117:
	YYDEBUG(117, *YYCURSOR);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy118:
	YYDEBUG(118, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 64) {
		goto yy122;
	}
	if (yych <= '\'') goto yy116;
	goto yy123;
yy119:
	YYDEBUG(119, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 16) {
		goto yy119;
	}
	if (yych <= '!') {
		if (yych <= 0x00) goto yy114;
		if (yych == '\n') goto yy114;
		goto yy113;
	} else {
		if (yych <= '"') goto yy124;
		if (yych == '\'') goto yy125;
		goto yy113;
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 32) {
		goto yy120;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy113;
yy121:
	YYDEBUG(121, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 32) {
		goto yy120;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy126;
	goto yy121;
yy122:
	YYDEBUG(122, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 64) {
		goto yy122;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '\'') goto yy113;
yy123:
	YYDEBUG(123, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 64) {
		goto yy122;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '\'') goto yy127;
	goto yy123;
yy124:
	YYDEBUG(124, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy114;
			goto yy126;
		} else {
			if (yych <= '\n') goto yy114;
			if (yych <= '!') goto yy126;
			goto yy115;
		}
	} else {
		if (yych <= '\'') {
			if (yych <= '#') goto yy120;
			if (yych <= '&') goto yy126;
			goto yy128;
		} else {
			if (yych == '\\') goto yy129;
			goto yy126;
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy114;
			goto yy127;
		} else {
			if (yych <= '\n') goto yy114;
			if (yych <= '!') goto yy127;
			goto yy130;
		}
	} else {
		if (yych <= '\'') {
			if (yych <= '#') goto yy122;
			if (yych <= '&') goto yy127;
			goto yy118;
		} else {
			if (yych == '\\') goto yy131;
			goto yy127;
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy114;
			goto yy126;
		} else {
			if (yych <= '\n') goto yy114;
			if (yych <= '!') goto yy126;
			goto yy124;
		}
	} else {
		if (yych <= '\'') {
			if (yych <= '#') goto yy120;
			if (yych <= '&') goto yy126;
			goto yy128;
		} else {
			if (yych == '\\') goto yy129;
			goto yy126;
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy114;
			goto yy127;
		} else {
			if (yych <= '\n') goto yy114;
			if (yych <= '!') goto yy127;
			goto yy130;
		}
	} else {
		if (yych <= '\'') {
			if (yych <= '#') goto yy122;
			if (yych <= '&') goto yy127;
			goto yy125;
		} else {
			if (yych == '\\') goto yy131;
			goto yy127;
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 128) {
		goto yy132;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy127;
	if (yych <= '\'') goto yy120;
	goto yy133;
yy129:
	YYDEBUG(129, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '&') {
		if (yych <= 0x00) goto yy114;
		if (yych == '\n') goto yy114;
		goto yy126;
	} else {
		if (yych <= '\'') goto yy134;
		if (yych == '\\') goto yy129;
		goto yy126;
	}
yy130:
	YYDEBUG(130, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 128) {
		goto yy132;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy122;
	if (yych <= '\'') goto yy126;
	goto yy133;
yy131:
	YYDEBUG(131, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '!') {
		if (yych <= 0x00) goto yy114;
		if (yych == '\n') goto yy114;
		goto yy127;
	} else {
		if (yych <= '"') goto yy135;
		if (yych == '\\') goto yy131;
		goto yy127;
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 128) {
		goto yy132;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy127;
	if (yych <= '\'') goto yy126;
yy133:
	YYDEBUG(133, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 128) {
		goto yy132;
	}
	if (yych <= '\n') goto yy116;
	if (yych <= '\'') goto yy136;
	goto yy133;
yy134:
	YYDEBUG(134, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy114;
			goto yy136;
		} else {
			if (yych <= '\n') goto yy114;
			if (yych <= '!') goto yy136;
		}
	} else {
		if (yych <= '\'') {
			if (yych <= '#') goto yy132;
			if (yych <= '&') goto yy136;
			goto yy128;
		} else {
			if (yych == '\\') goto yy137;
			goto yy136;
		}
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy114;
		} else {
			if (yych <= '\n') goto yy114;
			if (yych >= '"') goto yy130;
		}
	} else {
		if (yych <= '\'') {
			if (yych <= '#') goto yy132;
			if (yych >= '\'') goto yy134;
		} else {
			if (yych == '\\') goto yy137;
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy114;
			goto yy136;
		} else {
			if (yych <= '\n') goto yy114;
			if (yych <= '!') goto yy136;
			goto yy135;
		}
	} else {
		if (yych <= '\'') {
			if (yych <= '#') goto yy132;
			if (yych <= '&') goto yy136;
			goto yy134;
		} else {
			if (yych != '\\') goto yy136;
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych <= 0x00) goto yy114;
		if (yych <= '\t') goto yy136;
		goto yy114;
	} else {
		if (yych == '\\') goto yy137;
		goto yy136;
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(138, *YYCURSOR);
	YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '\r') {
			if (yych == '\t') goto yy141;
			if (yych >= '\r') goto yy141;
		} else {
			if (yych == ' ') goto yy142;
			if (yych >= 'E') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Q') goto yy139;
			if (yych <= 'R') goto yy144;
			if (yych <= 'S') goto yy145;
		} else {
			if (yych <= 'q') {
				if (yych <= 'e') goto yy143;
			} else {
				if (yych <= 'r') goto yy146;
				if (yych <= 's') goto yy145;
			}
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	++YYCURSOR;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(NORMAL);

	YYCURSOR = LEX(text);
	goto restart;
}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm_INITIAL[0+yych] & 128) {
		goto yy142;
	}
	goto yy140;
yy142:
	YYDEBUG(142, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_INITIAL[0+yych] & 128) {
		goto yy142;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	/* ignore whitespace */

	goto restart;
}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'V') goto yy147;
	if (yych == 'v') goto yy147;
	goto yy140;
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy149;
	if (yych == 'u') goto yy149;
	goto yy140;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'H') goto yy150;
	if (yych == 'h') goto yy150;
	goto yy140;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy140;
			goto yy151;
		} else {
			if (yych == '\r') goto yy151;
			goto yy140;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= ' ') goto yy151;
			if (yych <= 'T') goto yy140;
			goto yy149;
		} else {
			if (yych == 'u') goto yy149;
			goto yy140;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy152;
	} else {
		if (yych <= '\r') goto yy152;
		if (yych == ' ') goto yy152;
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy140;
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy153;
	if (yych == 'n') goto yy153;
	goto yy148;
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy154;
		goto yy148;
	} else {
		if (yych <= '\r') goto yy154;
		if (yych == ' ') goto yy154;
		goto yy148;
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy151;
	} else {
		if (yych <= '\r') goto yy151;
		if (yych == ' ') goto yy151;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_RUN;
}
yy152:
	YYDEBUG(152, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy152;
	} else {
		if (yych <= '\r') goto yy152;
		if (yych == ' ') goto yy152;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_EVAL;
}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy151;
		goto yy148;
	} else {
		if (yych <= '\r') goto yy151;
		if (yych == ' ') goto yy151;
		goto yy148;
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy154;
	} else {
		if (yych <= '\r') goto yy154;
		if (yych == ' ') goto yy154;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_SHELL;
}
}

}
