//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end
#include "switches.h"
#include "log.h"

// ================================================================
// This static variable allows the header version
// to be queried at runtime.
// ================================================================
namespace {
  char ccdoc_rcsid[] = "$Id: help.cc,v 1.29 2004/09/30 04:16:01 jlinoff Exp $";
}

// ================================================================
// Help
// ================================================================
void ccdoc::switches::help() const {
  ccdoc::s_log << version() << "\n";
  ccdoc::s_log
    //@help_begin
    << "ccdoc help 2004/09/29\n"
    << "Copyright (C) 1998-2004 by Joe Linoff.\n"
    << "\n"
    << "For more information see http://ccdoc.sourceforge.net or\n"
    << "http://www.joelinoff.com/ccdoc.\n"
    << "\n"
    << "  Table of Contents\n"
    << "\n"
    << "  Introduction ......................................  1\n"
    << "  Phase Independent Switches ........................  2\n"
    << "  Parse Phase .......................................  3\n"
    << "  Index Phase .......................................  4\n"
    << "  Output Phase ......................................  5\n"
    << "  Running the Program ...............................  6\n"
    << "  Comment Directives ................................  7\n"
    << "  Comment Format ....................................  8\n"
    << "  Package Help ......................................  9\n"
    << "\n"
    ;
  ccdoc::s_log
    << "1 Introduction\n"
    << "\n"
    << "  This program analyzes C++ declarations and produces HTML\n"
    << "  documentation.\n"
    << "\n"
    << "  It has three basic operating phases: Parse, Index and Output. Each\n"
    << "  phase is described in more detail below.\n"
    << "\n"
    << "    Phase   Description\n"
    << "    ======  ==========================================\n"
    << "    Parse   Parse C++ declarations and ccdoc comments.\n"
    << "    Index   Generate cross references.\n"
    << "    Output  Generate HTML output.\n"
    << "\n"
    << "  Phases are defined by the switches that are used on the command\n"
    << "  line. Multiple phases can be specified in a single run. The phases\n"
    << "  are described in the following sections. Each section describes the\n"
    << "  phase specific switches and presents some usage examples.\n"
    << "\n"
    << "  After the phases have been discussed there is a section on flow\n"
    << "  which describes different usage models and, following that, there is\n"
    << "  a summary of the ccdoc comment directives.\n"
    << "\n"
    ;
  ccdoc::s_log
    << "2 Phase Independent Switches\n"
    << "\n"
    << "  This section presents the switches that can be used in any phase or,\n"
    << "  as is the case with -h, no phase.\n"
    << "\n"
    << "  Switch        Description\n"
    << "  ============  ======================================================\n"
    << "  -args         Dump the command line arguments. This is enabled\n"
    << "                automatically in verbose (-v) mode.\n"
    << "\n"
    << "  -cid          Deprecated. Same as -verbose.\n"
    << "\n"
    << "  -ctf <file>   Deprecated. Same as -db.\n"
    << "\n"
    << "  -db <file>    The name of the ccdoc database.\n"
    << "\n"
    << "  -h,-help      Displays the extensive on-line help and exits.\n"
    << "                The on-line covers the different program phases, the\n"
    << "                comment directives and the program switches.\n"
    << "\n"
    << "  -log <file>   All information output by the program is also sent\n"
    << "                to the specified log file. Multiple log files can be\n"
    << "                specified. By default all output is sent to cout.\n"
    << "\n"
    << "  -nocout       Turn off output to cout. This is used to test the\n"
    << "                help output without displaying anything to the\n"
    << "                console.\n"
    << "\n"
    << "  -putenv <env> Set an environment variable from the command line.\n"
    << "                This is useful for setting up regression tests in\n"
    << "                scripts on various platforms.\n"
    << "\n"
    << "  -[no]v        Turn verbose mode on or off. The default is off.\n"
    << "\n"
    << "  -version      Report the program version. The version contains the\n"
    << "                program name, the version, the revision, the release\n"
    << "                date and the compilation id. Here is an example of\n"
    << "                what -version reports:\n"
    << "                  % ccdoc -version\n"
    << "                  ccdoc v08r41 2004/09/29 bin_opt_msvc_MSWin32-multi-thread-4.0\n"
    << "\n"
    << "  -[no]vf       Turn db verbose format mode on or off. The default is\n"
    << "                on because it speeds up the writing significantly and\n"
    << "                is only slightly larger. This switch enables verbose\n"
    << "                mode in the database file to make things easier to\n"
    << "                read for debugging.\n"
    << "\n"
    << "  -[no]warn     Turn warnings on or off. The default is on.\n"
    << "  ============  ======================================================\n"
    << "\n"
    << "  Here is an example that shows how to output this help information to\n"
    << "  a log file:\n"
    << "\n"
    << "    % ccdoc -log help.log -h\n"
    << "\n"
    ;
  ccdoc::s_log
    << "3 Parse Phase\n"
    << "\n"
    << "  During the parse phase C++ files are parsed to find declarations and\n"
    << "  ccdoc comments. These entities are tokenized and stored into the\n"
    << "  database specified by the -db switch. The parse phase is specified\n"
    << "  by the -pkg switch or the presence of source files on the command\n"
    << "  line.\n"
    << "\n"
    << "  When new files are parsed, the indexing information from previous\n"
    << "  runs is lost.\n"
    << "\n"
    << "  Switch              Description\n"
    << "  ==================  ==================================================\n"
    << "  -[no]cdsm           Turn on or off the creation of default special\n"
    << "                      members for classes. Specifically this tells ccdoc\n"
    << "                      to create (or not create) entries for default\n"
    << "                      constructors, copy constructors, destructors and\n"
    << "                      copy operators if they were not explicitly defined\n"
    << "                      in the class. The default is -cdsm.\n"
    << "\n"
    << "  -db <file>          The name of the ccdoc database.\n"
    << "\n"
    << "  -D<name>[=<value>]  Define a macro and, optionally, define its value.\n"
    << "\n"
    << "  -[no]doxygen        Enable limited doxygen compatibility mode.\n"
    << "                      The default is -doxygen.\n"
    << "                      This switch specifies that @file\n"
    << "                      blocks are ignored.\n"
    << "\n"
    << "                      Some other doxygen compatible syntax is already\n"
    << "                      supported whether this switch is specified or\n"
    << "                      not, namely: the @endlink directive, the single\n"
    << "                      line suffix comment forms (//!< and ///<) and\n"
    << "                      the multiple line suffix comment forms (/*!< and\n"
    << "                      /**<).\n"
    << "\n"
    << "                      This allows users more flexibility in converting\n"
    << "                      between doxygen and ccdoc.\n"
    << "\n"
    << "  -files <list>       Designates a file that contains the list of files\n"
    << "                      to parse.\n"
    << "\n"
    << "  -[no]jdsds          Enable javadoc short description syntax. This\n"
    << "                      causes ccdoc to conform to the javadoc\n"
    << "                      specification for processing short descriptions.\n"
    << "\n"
    << "                      This is the new default behavior as of r24.\n"
    << "\n"
    << "                      A javadoc short description is terminated by a\n"
    << "                      period followed by a space, tab, newline or tag\n"
    << "                      (directive).\n"
    << "\n"
    << "                      If -nojdsds is specified, the old-style ccdoc\n"
    << "                      short description handling is enabled. That is,\n"
    << "                      short descriptions are terminated by a blank\n"
    << "                      line.\n"
    << "\n"
    << "  -pkg <name>         Define the package name for the entities in the\n"
    << "                      source files. If no package is specified a\n"
    << "                      default name is used or the @pkg <name>\n"
    << "                      directive in the ccdoc comment is used. Children\n"
    << "                      (like class methods) inherit the package from\n"
    << "                      their parent.\n"
    << "\n"
    << "  -[no]tcms           Turn on or off the processing of template class\n"
    << "                      methods that are defined outside of the class\n"
    << "                      declaration.\n"
    << "\n"
    << "  -U<name>            Undefine a macro.\n"
    << "  ==================  ==================================================\n"
    << "\n"
    << "  Here is an example that shows how multiple header files are parsed\n"
    << "  from different source directories into a common database.\n"
    << "\n"
    << "    ccdoc -db /tmp/ccdoc.db -pkg Utilities project/utils/export/*.h\n"
    << "    ccdoc -db /tmp/ccdoc.db -pkg Parser project/parser/export/*.h\n"
    << "\n"
    ;
  ccdoc::s_log
    << "4 Index Phase\n"
    << "\n"
    << "  During the index phase ccdoc analyzes the database to find\n"
    << "  associations between related entities. For example, if class Child\n"
    << "  derives from class Parent, this phase will find Parent and link it\n"
    << "  to the Child record so that a link can be generated during the\n"
    << "  output phase. The index phase is specified by the -index switch.\n"
    << "\n"
    << "  If the index phase is not run, the output will contain no links.\n"
    << "\n"
    << "\n"
    << "  Switch          Description\n"
    << "  ==============  ===============================\n"
    << "  -db <file>      The name of the ccdoc database.\n"
    << "\n"
    << "  -index          Generate the indices.\n"
    << "  ==============  ===============================\n"
    << "\n"
    << "  Here is a use-case that shows how generate an index for a database.\n"
    << "\n"
    << "    ccdoc -db /tmp/ccdoc.db -index\n"
    << "\n"
    ;
  ccdoc::s_log
    << "5 Output Phase\n"
    << "\n"
    << "  During the output phase, ccdoc generates HTML from the database.\n"
    << "  This phase is optional. A user could develop their db reader and\n"
    << "  output any another format (like XML). The output phase is specified\n"
    << "  by the -htm or the -html switch.\n"
    << "\n"
    << "  After this phase is run, a top level file called\n"
    << "  ccdoc.<root>.pkg.html will exist in the specified html path.\n"
    << "\n"
    << "  Switch              Description\n"
    << "  ==================  ======================================================\n"
    << "  -bg <color>         The background color. The default is the default for\n"
    << "                      the browser.\n"
    << "\n"
    << "  -db <file>          The name of the ccdoc database.\n"
    << "\n"
    << "  -dospaths           The file paths contain backslashes that need to be\n"
    << "                      converted to forwards slashes for HTML.\n"
    << "\n"
    << "  -htm <prefix>,\n"
    << "  -html <prefix>      The HTML path prefix. This is used to designate the \n"
    << "                      path where the HTML files will be stored. The directory\n"
    << "                      suffix must be included if this is a directory path.\n"
    << "                      Always use a forward slash to separate directories,\n"
    << "                      even when you are running under a DOS window, because\n"
    << "                      the HTTP path hierarchy separator is a forward slash.\n"
    << "\n"
    << "  -fg <color>         Same as -fgtext.\n"
    << "\n"
    << "  -fgtext <color>     The foreground text color. The default is the default\n"
    << "                      for the browser.\n"
    << "\n"
    << "  -fglink <color>     The foreground link color. The default is the default\n"
    << "                      for the browser.\n"
    << "\n"
    << "  -fgvlink <color>    The foreground vlink color. The default is the default\n"
    << "                      for the browser. These are used links.\n"
    << "\n"
    << "  -header <file>      The HTML used for the customized header just after\n"
    << "                      the <body> stmt. This is where clients insert their own\n"
    << "                      custom information on each page. See the -meta command\n"
    << "                      for information on how to insert meta variables in\n"
    << "                      the <head> section.\n"
    << "\n"
    << "  -imageurl <URL>, \n"
    << "  -imgurl <URL>       The URL that describes of the GIF images. This\n"
    << "                      version of ccdoc does not use images so this switch\n"
    << "                      has no effect.\n"
    << "\n"
    << "  -[no]macros         Deprecated. Same as -[no]rptmac.\n"
    << "\n"
    << "  -maxpathlen <num>   Maximum file path size. The default is 128. When the\n"
    << "                      file path size exceeds the limit, the file name\n"
    << "                      is truncated and a checksum is added to guarantee\n"
    << "                      that the file name is unique. If maxpathlen is set\n"
    << "                      to zero, no limit checking is performed.\n"
    << "\n"
    << "  -meta <file>        The HTML used for the customized header just after\n"
    << "                      the <head> stmt. This is where clients insert their own\n"
    << "                      custom information for meta variables on each page.\n"
    << "                      If -meta is specified, ccdoc will not generate the\n"
    << "                      the http-equiv meta variable for HTML 4.01 compliance\n"
    << "                      and it will ignore the -rptctcs.\n"
    << "\n"
    << "  -[no]private        Deprecated. Same as -[no]rptpri.\n"
    << "\n"
    << "  -[no]protected      Deprecated. Same as -[no]rptpro.\n"
    << "\n"
    << "  -[no]public         Deprecated. Same as -[no]rptpub.\n"
    << "\n"
    << "  -root <name>        Change the name of the root package from 'root' to\n"
    << "                      something else.\n"
    << "\n"
    << "  -rootfile <name>    Change the top level output file name from\n"
    << "                      <prefix>ccdoc.root.pkg.html to whatever the user\n"
    << "                      wants. This can be used to create the ccdoc.index.html\n"
    << "                      file by specifying: -rootfile ccdoc.index.html.\n"
    << "                      This switch allows you to completely specify the\n"
    << "                      path. The -html prefix is ignored.\n"
    << "\n"
    << "  -rootpurl <URL>\n"
    << "  -rooturl <URL>      The hyperlink for the parent of the root package.\n"
    << "                      Setting this allows the generated HTML to seamlessly\n"
    << "                      integrate to a higher level document by providing a back \n"
    << "                      link to the users parent page.\n"
    << "\n"
    << "  -[no]rptcfuns       Report comments for undocumented namespaces. When\n"
    << "                      -rptcfuns is specified, all related namespaces\n"
    << "                      comments are reported. This includes namespaces\n"
    << "                      that do not contain ccdoc comments which can be\n"
    << "                      somewhat busy. When -norptcfuns is specified, only\n"
    << "                      related namespaces with ccdoc comments are reported.\n"
    << "                      The only exception is when none of the namespaces\n"
    << "                      have ccdoc comments. In that case, only the first\n"
    << "                      undocumented namespace is reported (for backward\n"
    << "                      compatibility). The default is -norptcfuns.\n"
    << "\n"
    << "  -[no]rptcsd         Report class summary details. When -rptcsd is\n"
    << "                      specified, the class summary page reports type, access\n"
    << "                      and short description information. When -norptcsd\n"
    << "                      is specified the class summary page only reports the\n"
    << "                      names. The default is -rptcsd.\n"
    << "\n"
    << "  -[no]rptcsi <num>   The class summary indent switch. Define the indent \n"
    << "                      level of each entry in the class summary report and\n"
    << "                      the contents column. The default indent level is 4.\n"
    << "\n"
    << "  -rptctcs <string>   Allow the user to specify the Content-Type char set.\n"
    << "                      This allows international languages to be supported.\n"
    << "                      The default char set is \"iso-8859-1\".\n"
    << "                      This switch is ignored if the -meta switch is specified.\n"
    << "\n"
    << "  -rptdefa <string>   Set the default string for the author field in\n"
    << "                      top level entities. The default is \"unascribed\".\n"
    << "\n"
    << "  -rptdefasd <string> Set the default string for the automatically generated\n"
    << "                      short description field in top level entities. The\n"
    << "                      default is \"automatically generated\".\n"
    << "\n"
    << "  -rptdefsd <string>  Set the default string for the short description\n"
    << "                      field in top level entities. The default is\n"
    << "                      \"undocumented\".\n"
    << "\n"
    << "  -rptdefv <string>   Set the default string for the version field in\n"
    << "                      top level entities. The default is \"unknown\".\n"
    << "\n"
    << "  -[no]rptdpa         If the package author is not specified, report the\n"
    << "                      author as unascribed. The default is -norptdpa which\n"
    << "                      tells ccdoc to ignore authors on packages unless they\n"
    << "                      are explicitly specified.\n"
    << "\n"
    << "  -[no]rptdpd         If the package description is not specified, report the\n"
    << "                      description as unknown. The default is -norptdpd which\n"
    << "                      tells ccdoc to ignore descriptions on packages unless\n"
    << "                      they are explicitly specified.\n"
    << "\n"
    << "  -[no]rptdpv         If the package version is not specified, report the\n"
    << "                      version as unknown. The default is -norptdpv which\n"
    << "                      tells ccdoc to ignore version on packages unless they\n"
    << "                      are explicitly specified.\n"
    << "\n"
    << "  -[no]rptfwcf        The fixed width code font switch. Use a fixed width \n"
    << "                      font when reporting code fragments. The default is\n"
    << "                      -norptfwcf.\n"
    << "\n"
    << "  -[no]rpthpc         Report package contents hierarchically like the\n"
    << "                      the class summary page. The default is -rpthpc.\n"
    << "\n"
    << "  -[no]rptim          Report all inherited methods as though they were\n"
    << "                      defined locally. The default is -rptim.\n"
    << "\n"
    << "  -[no]rptmac         Report macros. Default is -norptmac because there can be\n"
    << "                      large numbers of guards in header files. If a system is\n"
    << "                      designed with ccdoc in mind, the header guards can be\n"
    << "                      surrounded by ccdoc guards (#ifndef __ccdoc__) which\n"
    << "                      would make this data more useful.\n"
    << "\n"
    << "  -[no]rptmac1        Report macros heuristically. This means that ccdoc\n"
    << "                      attempts to filter out header guards and windows\n"
    << "                      DLLIMPORT/DLLEXPORT macros by filtering out macro\n"
    << "                      names with the prefixes: dll_, DLL_, include_, INCLUDE_,\n"
    << "                      included_, INCLUDED_ and the suffixes: dll, _DLL,\n"
    << "                      _h, _H, _hh, _HH, _include, _INCLUDE, _included,\n"
    << "                      _INCLUDED, _included_, _INCLUDED_.\n"
    << "\n"
    << "                      The default is -norptmac1.\n"
    << "                      When this switch is enabled, it also enables -rptmac.\n"
    << "                      This is a better choice than -rptmac.\n"
    << "\n"
    << "  -rptmlci <num>      Maximum length of the content ids. This switch is\n"
    << "                      used to avoid strange looking tables of content\n"
    << "                      when the id is very long. \n"
    << "\n"
    << "                      When the string exceeds this length, only the\n"
    << "                      first <num> characters are printed followed by\n"
    << "                      .. to indicate truncation.\n"
    << "\n"
    << "                      The default length is 32. A value of zero means\n"
    << "                      don't impose the limit. If no inherited from column\n"
    << "                      exists, the value of the -rptmlcifi is added to make\n"
    << "                      this field bigger.\n"
    << "\n"
    << "  -rptmlcifi <num>    Maximum length of the contents \"inherited from\"\n"
    << "                      column id. This switch is used to avoid strange\n"
    << "                      looking tables of content when the parent id is\n"
    << "                      very long.\n"
    << "\n"
    << "                      When the string exceeds this length, only the\n"
    << "                      first <num> characters are printed followed by\n"
    << "                      .. to indicate truncation.\n"
    << "\n"
    << "                      The default length is 32. A value of zero means\n"
    << "                      don't impose the limit.\n"
    << "\n"
    << "  -[no]rptpri         Report private items. The default is -norptpri.\n"
    << "\n"
    << "  -[no]rptpro         Report protected items. The default is -norptpro.\n"
    << "\n"
    << "  -[no]rptpub         Report public items. The default is -rptpub.\n"
    << "\n"
    << "  -[no]rptsci         Report the class information in sorted order. The\n"
    << "                      default is -rptsci. If -norptsci is specified\n"
    << "                      the class contents and details are not sorted.\n"
    << "\n"
    << "  -[no]rptsrc         Report the source information for each entity\n"
    << "                      in the table of contents. This causes an additional\n"
    << "                      column to be added to the table. The default is\n"
    << "                      -norptsrc because this information is already\n"
    << "                      reported for each entity in its description. It\n"
    << "                      exists to provide debugging support for when no\n"
    << "                      description is generated.\n"
    << "\n"
    << "  -[no]rpttyp         Report typedefs. Default is -rpttyp.\n"
    << "\n"
    << "  -[no]rptun          Report unions. Default is -rptun.\n"
    << "\n"
    << "  -sourceurl <URL>,\n"
    << "  -srcurl <URL>       The URL where the source files can be found. If this\n"
    << "                      is specified, hyperlinks are created for Source entries.\n"
    << "\n"
    << "  -trailer <file>     The HTML used for the customized trailer.\n"
    << "\n"
    << "  -[no]typedefs       Deprecated. Same as -[no]rpttyp.\n"
    << "\n"
    << "  -[no]unions         Deprecated. Same as -[no]rptun.\n"
    << "  ==================  ======================================================\n"
    << "\n"
    << "  Here is a use case that shows how to generate HTML:\n"
    << "\n"
    << "    ccdoc -db ccdoc.db -html webdocs/ -imgurl images/ \\ -trailer\n"
    << "    custom_trailer.html \\ -root MyProject -rooturl myproj.htm\n"
    << "\n"
    ;
  ccdoc::s_log
    << "6 Running the Program\n"
    << "\n"
    << "  This section presents some example flows to help you understand how\n"
    << "  to use the program more effectively.\n"
    << "\n"
    << "  6.1 Simple Flow\n"
    << "\n"
    << "  This is the simplest flow. You run all three phases at the same time.\n"
    << "\n"
    << "    % ## UNIX:\n"
    << "    % ccdoc \\\n"
    << "        -db webdocs/ccdoc.db \\\n"
    << "        -pkg simple \\\n"
    << "        *.h \\\n"
    << "        -index \\\n"
    << "        -rootfile webdocs/index.html \\\n"
    << "        -html webdocs/\n"
    << "\n"
    << "    > REM DOS\n"
    << "    > ccdoc -db webdocs/ccdoc.db -pkg simple *.h -index -rootfile webdocs/index.html -html webdocs/\n"
    << "\n"
    << "  Note that it forces the top level html file to be named index.html which\n"
    << "  is convenient for most browsers.\n"
    << "\n"
    << "  6.2 Typical Flow\n"
    << "\n"
    << "  This is the typical for a usage for a system with multiple packages.\n"
    << "  Each phase is run separately.\n"
    << "\n"
    << "    % ### Phase 1a - Parse\n"
    << "    % ccdoc -db typical.db -pkg typical.utils work/utils/src/*.h\n"
    << "    % # Don't report missing default constructors.\n"
    << "    % ccdoc -db typical.db -pkg -nocdsm typical.liba work/liba/src/*.h\n"
    << "    % # Define a macro that is used for my documentation.\n"
    << "    % ccdoc -db typical.db -pkg \\\n"
    << "        -DMY_CCDOC_EXTERNAL typical.libb \\\n"
    << "        work/libb/src/*.h\n"
    << "\n"
    << "    % ### Phase 1b - Parse root level documentation\n"
    << "    % ccdoc -db typical.db -pkg typical typical.txt\n"
    << "\n"
    << "    % ### Phase 2 - Index\n"
    << "    % ccdoc -db typical.db -index\n"
    << "\n"
    << "    % ### Phase 3 - Output\n"
    << "    %ccdoc \\\n"
    << "       -db typical.db \\\n"
    << "       -html webdocs/ \\\n"
    << "       -rootfile webdocs/index.html \\\n"
    << "       -srcurl work/ \\\n"
    << "       -trailer custom.htm\n"
    << "\n"
    ;
  ccdoc::s_log
    << "7 Comment Directives\n"
    << "\n"
    << "  This section presents a brief overview of the ccdoc comment syntax.\n"
    << "\n"
    << "  The directives are summarized in the table below.\n"
    << "\n"
    << "    Id  Directive      Quick Summary\n"
    << "    ==  =============  =====================================================\n"
    << "     1 /** .. */       Encloses a javadoc style ccdoc comment.\n"
    << "     2 /**< .. */      Encloses a doxygen style suffix ccdoc comment.\n"
    << "     3 /*!< .. */      Encloses a doxygen style suffix ccdoc comment.\n"
    << "     4 //@{ .. //@}    Encloses a ccdoc comment for C++ style line comments.\n"
    << "     5 //@-            Single line suffix C++ style comment form.\n"
    << "     6 ///<            Same as //@- (doxygen compatible).\n"
    << "     7 //!<            Same as //@- (doxygen compatible).\n"
    << "     8 /**@#-*/        Turn off ccdoc token parsing.\n"
    << "     9 /**@#+*/        Turn on ccdoc token parsing.\n"
    << "    10 /**@#=<ch>*/    Insert <ch> into the input stream.\n"
    << "    11 {@link...}      The in-line link specification.\n"
    << "    12 @@              Translate HTML special characters for code fragments.\n"
    << "    13 @$              Same @link.\n"
    << "    14 @author         Specify an author.\n"
    << "    15 @deprecated     Describes the alternatives to use.\n"
    << "    16 @exception      Deprecated, same as @throws.\n"
    << "    17 @link,@endlink  Generate a hyperlink to a ccdoc entity.\n"
    << "    18 @param          Document a function or class method parameter.\n"
    << "    19 @pkg            Specifies the name of a package.\n"
    << "    20 @pkgdoc         This comment documents a specific package.\n"
    << "    21 @pkgdoctid      Redefine the output title id for a pkgdoc.\n"
    << "    22 @return         Deprecated, same as @returns.\n"
    << "    23 @returns        Documents the return value from a method or function.\n"
    << "    24 @see            Add a hyperlink entry to the See section.\n"
    << "    25 @since          When this became available.\n"
    << "    26 @suffix         This is a suffix comment.\n"
    << "    27 @throws         Document an exception.\n"
    << "    28 @todo           Describes todo information.\n"
    << "    29 @version        The entity version.\n"
    << "\n"
    << "  Each directive is described in more detail in the following\n"
    << "  subsections.\n"
    << "\n"
    << "  7.1 /** .. */\n"
    << "\n"
    << "    Indicates javadoc style ccdoc comment that is associated with the\n"
    << "    next C++ statement (prefix style comment).\n"
    << "\n"
    << "    A simple example is shown below:\n"
    << "\n"
    << "      /**\n"
    << "       * This is the brief description that shows up in the table\n"
    << "       * of contents.\n"
    << "       * This is where the longer description starts.\n"
    << "       * @author A. Programmer\n"
    << "       * @version 1.0\n"
    << "       */\n"
    << "      void function(int a);\n"
    << "\n"
    << "  7.2 /**< .. */\n"
    << "\n"
    << "    Indicates the beginning of a ccdoc style comment that is\n"
    << "    associated with the previous C++ statement (suffix style comment).\n"
    << "\n"
    << "    A simple example is shown below:\n"
    << "\n"
    << "      void function(int a);\n"
    << "        /**<\n"
    << "         * This is the brief description that shows up in the table\n"
    << "         * of contents.\n"
    << "         * This is where the longer description starts.\n"
    << "         * @author A. Programmer\n"
    << "         * @version 1.0\n"
    << "         */\n"
    << "\n"
    << "  7.3 /*!< .. */\n"
    << "\n"
    << "    Indicates the beginning of a ccdoc style comment that is\n"
    << "    associated with the previous C++ statement (suffix style comment).\n"
    << "\n"
    << "    A simple example is shown below:\n"
    << "\n"
    << "      void function(int a);\n"
    << "        /*!<\n"
    << "         * This is the brief description that shows up in the table\n"
    << "         * of contents.\n"
    << "         * This is where the longer description starts.\n"
    << "         * @author A. Programmer\n"
    << "         * @version 1.0\n"
    << "         */\n"
    << "\n"
    << "  7.4 //@{ .. //@}\n"
    << "\n"
    << "    Specifies that a ccdoc comment is being specified using the '//'\n"
    << "    comment form as shown below:\n"
    << "\n"
    << "      // ================================================\n"
    << "      //@{\n"
    << "      // This is a ccdoc comment.\n"
    << "      //@}\n"
    << "      // ================================================\n"
    << "      int foo();\n"
    << "\n"
    << "    This pragma must exist by itself on the line.\n"
    << "\n"
    << "  7.5 //@-\n"
    << "\n"
    << "    Specifies the single line suffix C++ style comment form. This for\n"
    << "    is useful for abbreviated comments. Here is an example:\n"
    << "\n"
    << "      class Point3D {\n"
    << "      public:\n"
    << "        int p1; //@- The x coordinate.\n"
    << "        int p2; //@- The y coordinate.\n"
    << "        int p3; //@- The z coordinate.\n"
    << "      };\n"
    << "\n"
    << "    You can only specify a single line so directives other than\n"
    << "    \"{@link .. }\" and \"@link .. @endlink\" are not supported.\n"
    << "\n"
    << "  7.6 ///<\n"
    << "\n"
    << "    Specifies the single line suffix C++ style comment form that is\n"
    << "    compatible with doxygen. This for is useful for abbreviated\n"
    << "    comments. Here is an example:\n"
    << "\n"
    << "      class Point3D {\n"
    << "      public:\n"
    << "        int p1; ///< The x coordinate.\n"
    << "        int p2; ///< The y coordinate.\n"
    << "        int p3; ///< The z coordinate.\n"
    << "      };\n"
    << "\n"
    << "    You can only specify a single line so directives other than\n"
    << "    \"{@link .. }\" and \"@link .. @endlink\" are not supported.\n"
    << "\n"
    << "  7.7 //!<\n"
    << "\n"
    << "    Specifies the single line suffix C++ style comment form that is\n"
    << "    compatible with doxygen. This for is useful for abbreviated\n"
    << "    comments. Here is an example:\n"
    << "\n"
    << "      class Point3D {\n"
    << "      public:\n"
    << "        int p1; //!< The x coordinate.\n"
    << "        int p2; //!< The y coordinate.\n"
    << "        int p3; //!< The z coordinate.\n"
    << "      };\n"
    << "\n"
    << "    You can only specify a single line so directives other than\n"
    << "    \"{@link .. }\" and \"@link .. @endlink\" are not supported.\n"
    << "\n"
    << "  7.8 /**@#-*/\n"
    << "\n"
    << "    Turn off ccdoc token parsing. Unlike #ifndef __ccdoc__ this\n"
    << "    directive can be inserted anywhere. It is especially useful for\n"
    << "    excluding portions of code that confuse ccdoc.  Here is an example\n"
    << "    of how to use it:\n"
    << "\n"
    << "      /**@#-*/\n"
    << "      #ifndef FOO\n"
    << "      insert random junk to generate a compiler error.\n"
    << "      #endif\n"
    << "      /**@#+*/\n"
    << "\n"
    << "    This could also be done using the #ifndef pragma as follows:\n"
    << "\n"
    << "      #ifndef __ccdoc__\n"
    << "      #ifndef FOO\n"
    << "      insert random junk to generate a compiler error.\n"
    << "      #endif\n"
    << "      #endif\n"
    << "\n"
    << "  7.9 /**@#+*/\n"
    << "\n"
    << "    Turn ccdoc token processing back on. See 7.10 for usage details.\n"
    << "\n"
    << "  7.10 /**@#=<ch>*/\n"
    << "\n"
    << "    Insert a token into the ccdoc input stream to make parsing easier\n"
    << "    without affecting the source code. This directive is typically\n"
    << "    used to \"fix\" macro instantiations that are not terminated by\n"
    << "    semi-colons as shown in the following example:\n"
    << "\n"
    << "      7.10.1 This will confuse ccdoc.\n"
    << "        #define M(a) a=1;\n"
    << "        M\n"
    << "        M\n"
    << "        class XX;\n"
    << "\n"
    << "      7.10.2 This will not confuse ccdoc because we insert semi-colons.\n"
    << "        #define M(a) a=1;\n"
    << "        M /**@#=;*/\n"
    << "        M /**@#=;*/\n"
    << "        class XX;\n"
    << "\n"
    << "      7.10.3 Neither will this because we prep it out.\n"
    << "        #define M(a) a=1;\n"
    << "        #ifdef __ccdoc__\n"
    << "        M\n"
    << "        M\n"
    << "        #endif\n"
    << "        class XX;\n"
    << "\n"
    << "      7.10.4 Or this because we put in redundant semi-colons.\n"
    << "        #define M(a) a=1;\n"
    << "        M;\n"
    << "        M;\n"
    << "        class XX;\n"
    << "\n"
    << "  7.11 {@link <entity> <name>}\n"
    << "\n"
    << "    This is very similar to the @link directive except that it can be\n"
    << "    embedded inside comment lines. Like @link, it tells ccdoc to\n"
    << "    generate a hyperlink to a ccdoc entity. Unlike @link the arguments\n"
    << "    are not optional.\n"
    << "\n"
    << "    You must specify both the entity and the link name.\n"
    << "\n"
    << "    You must not embed white space in the '{@link' specification. For\n"
    << "    example, '{ @ link' is not valid.\n"
    << "\n"
    << "    Any number of link specifications are allowed on a single line.\n"
    << "\n"
    << "    Invalid {@link...} specifications are output as simple text.\n"
    << "\n"
    << "    The example below shows how it is used:\n"
    << "\n"
    << "      /**\n"
    << "       * Look at {@link #fct this} for more information,\n"
    << "       * you can also look at {@link #fct1 this} or {@link #fct2 this}.\n"
    << "       */\n"
    << "      void fct3();\n"
    << "\n"
    << "    The <entity> is the ccdoc entity to link to. The <name> is the\n"
    << "    user name of the link. It can consist of one or more tokens.\n"
    << "    Leading white space is ignored.\n"
    << "\n"
    << "    There is a special case for operators. The example below shows how\n"
    << "    to specify an {@link ..} directive for an operator.\n"
    << "\n"
    << "      /**\n"
    << "       * This is the same as the {@link #operator== equals operator}\n"
    << "       * for this class.\n"
    << "       * @param obj The object to compare to for equality.\n"
    << "       * @returns True if they are equal or false otherwise.\n"
    << "       * @see #operator==\n"
    << "       */\n"
    << "      bool is_equal(const Class& obj) const;\n"
    << "\n"
    << "    Note that there are no spaces between the operator keyword and the\n"
    << "    operator tokens.\n"
    << "\n"
    << "  7.12 @@ <line>\n"
    << "\n"
    << "    Translate HTML special characters for creating code fragments.\n"
    << "\n"
    << "    Convert '<' to \"&lt;\" , '>' to \"&gt;\" and '&' to\n"
    << "    \"&amp;\". This is useful for inserting code fragments. Here is an\n"
    << "    example of how you would use this directive in a comment:\n"
    << "\n"
    << "      /**\n"
    << "       * Here is an example of how to use this directive.\n"
    << "       *<blockquote>\n"
    << "       *<pre>\n"
    << "       *@@ for(int i=0;i<10 && j>3;++i,--j) {\n"
    << "       *@@   cout << j << \" \" << i << endl;\n"
    << "       *@@ }\n"
    << "       *</pre>\n"
    << "       *</blockquote>\n"
    << "       */\n"
    << "\n"
    << "  7.13 @$ <entity> [<name>]\n"
    << "\n"
    << "     Same as @link. See section 7.20 for detailed information.\n"
    << "\n"
    << "  7.14 @author <name>\n"
    << "\n"
    << "    Specifies the author. To specify multiple authors add multiple\n"
    << "    directives as shown below.\n"
    << "\n"
    << "      /**\n"
    << "       * There are numerous authors.\n"
    << "       * @author Foo Bar\n"
    << "       * @author Spam Wombat\n"
    << "       */\n"
    << "\n"
    << "    If an author is not specified for a package or a class, an entry\n"
    << "    is generated to an \"unascribed\" author.\n"
    << "\n"
    << "    If there is more than one author, the best practice is to list\n"
    << "    them chronologically from most recent to earliest.\n"
    << "\n"
    << "  7.15 @deprecated <description>\n"
    << "\n"
    << "    Specifies that this interface has been deprecated. You should\n"
    << "    specify what to use as an alternative. The example below shows\n"
    << "    how to use this directive.\n"
    << "\n"
    << "      /**\n"
    << "       * Get the system time.\n"
    << "       * @returns The system time.\n"
    << "       * @deprecated Use get_time_as_string to avoid memory bloat.\n"
    << "       */\n"
    << "      const char* get_time();\n"
    << "\n"
    << "  7.16 @exception <name> <description>\n"
    << "\n"
    << "    Deprecated. See @throws for usage information.\n"
    << "\n"
    << "  7.17 @link <entity> [<name>] .. [@endlink]\n"
    << "\n"
    << "    Generate a hyperlink to a ccdoc entity anywhere in the the code\n"
    << "    without generating an entry in the See section.\n"
    << "\n"
    << "    Here is an example of how it is used:\n"
    << "\n"
    << "      /**\n"
    << "        * This class is closely associated with\n"
    << "        * @link Utils::Foo my class\n"
    << "        * and with this @link Utils::Spam my class @endlink and\n"
    << "        * with @link Utils::Wombat link to wombat\n"
    << "        * because they both do bar stuff.\n"
    << "        */\n"
    << "\n"
    << "    The <entity> is the ccdoc entity to link to. The <name> is the\n"
    << "    user name of the link. It can consist of one or more tokens.\n"
    << "    Leading white space is ignored.\n"
    << "\n"
    << "    If the link name is not specified, the <entity> name is used.\n"
    << "\n"
    << "    The @endlink is optional. Note that in the wombat case, the string\n"
    << "    \"link to wombat\" is the link text.\n"
    << "\n"
    << "  7.18 @param <name> <description>\n"
    << "\n"
    << "    Describes a parameter to a function. There should be one @param\n"
    << "    directive for each argument. The example below shows how to use\n"
    << "    this.\n"
    << "\n"
    << "      /**\n"
    << "       * This function does stuff.\n"
    << "       * @param name The name of the object. The description\n"
    << "       * will span multiple lines until another directive or\n"
    << "       * the end of the comment is found.\n"
    << "       * @param aname Another name.\n"
    << "       */\n"
    << "      void do_something(const char* name,const char* x);\n"
    << "\n"
    << "    Beware! Ccdoc does not verify that the parameters are valid so it\n"
    << "    is possible to input invalid parameters. Ccdoc does not verify\n"
    << "    that the parameter names are the same either as in the example\n"
    << "    above: aname should be x (or vice-versa).\n"
    << "\n"
    << "    The contents of an @param directive can span multiple lines.  All\n"
    << "    lines following an @param directive are included until another\n"
    << "    ccdoc directive (other than @link and @@) is encountered.  The\n"
    << "    example below shows how this works:\n"
    << "\n"
    << "      /**\n"
    << "       * This shows how @param can span multiple lines.\n"
    << "       * @param p1 This parameter can have a\n"
    << "       *@@         value < 10 and > 0. If the value\n"
    << "       *           is out of range, an exception is thrown.\n"
    << "       * @returns The associated record.\n"
    << "       */\n"
    << "\n"
    << "  7.19 @pkg <name>\n"
    << "\n"
    << "    Specifies the name of the current package. All entities in the\n"
    << "    file from the directive onward are associated with the package.\n"
    << "    This pragma can be overridden from the command line by the -pkg\n"
    << "    switch.\n"
    << "\n"
    << "    There is a special package called @null that can be used to\n"
    << "    specify that the contents of a file are not associated with any\n"
    << "    package. This is typically used in the file (or files) that\n"
    << "    contain the package documentation. Typically these are not C++\n"
    << "    header files.\n"
    << "\n"
    << "    The example below shows how to define the package directive.\n"
    << "\n"
    << "      /**@pkg Stuff.Utils */\n"
    << "\n"
    << "      /**@pkg Stuff::Utils */\n"
    << "\n"
    << "      // This file is not part of any package.\n"
    << "      /**@pkg @null*/\n"
    << "\n"
    << "    Dots '.' or double colons '::' are used to separate hierarchical\n"
    << "    sub-packages.\n"
    << "\n"
    << "    Package documentation is generated using the @pkgdoc directive as\n"
    << "    shown in the next section.\n"
    << "\n"
    << "  7.20 @pkgdoc <path> [<url>]\n"
    << "\n"
    << "    Specifies that the current ccdoc comment is associated with a\n"
    << "    package NOT a C++ entity.\n"
    << "\n"
    << "    This directive can be used to define the documentation in the top\n"
    << "    package by specifying '@top' as the <name>. The old form: [ROOT]\n"
    << "    is still accepted.\n"
    << "\n"
    << "    Dots '.' or double colons '::' are used to separate hierarchical\n"
    << "    sub-packages.\n"
    << "\n"
    << "    If the <url> argument is specified, ccdoc uses that as the link.\n"
    << "    This is useful for inserting custom pages into the ccdoc document\n"
    << "    hierarchy but it puts a significant burden on the user to make\n"
    << "    sure that links to other ccdoc generated files are valid.\n"
    << "\n"
    << "    The following example shows how to document several packages.\n"
    << "\n"
    << "      // This file is not part of any package.\n"
    << "      /**@pkg @null*/\n"
    << "\n"
    << "      /**\n"
    << "       * This is the documentation for the top of\n"
    << "       * the documentation tree.\n"
    << "       * @author The Build Team\n"
    << "       * @version 1.1\n"
    << "       * @pkg @top\n"
    << "       */\n"
    << "\n"
    << "      /**\n"
    << "       * This is the top level package for MyProject.\n"
    << "       *\n"
    << "       * It does lots of useful things and contains\n"
    << "       * many other packages.\n"
    << "       * @author Ms. MyProject\n"
    << "       * @version 1.0\n"
    << "       * @pkgdoc MyProject\n"
    << "       */\n"
    << "\n"
    << "      /**\n"
    << "       * This package contains the I/O utilities for\n"
    << "       * MyProject.\n"
    << "       *\n"
    << "       * This is the detailed information about the\n"
    << "       * I/O utilities package.\n"
    << "       * @author Mr. IO_Utilities\n"
    << "       * @version 1.1\n"
    << "       * @pkgdoc MyProject::IO_Utilities\n"
    << "       */\n"
    << "\n"
    << "      /**\n"
    << "       * This package contains the string utilities for\n"
    << "       * MyProject.\n"
    << "       *\n"
    << "       * This is the detailed information about the\n"
    << "       * string utilities package.\n"
    << "       * @author Mr. String_Utilities\n"
    << "       * @version 1.2\n"
    << "       * @pkgdoc MyProject.String_Utilities http://mysite/String_Utilities.html\n"
    << "       */\n"
    << "\n"
    << "    It is important to note that the implicit top level package is\n"
    << "    implied for @pkgdoc paths.\n"
    << "\n"
    << "  7.21 @pkgdoctid <name>\n"
    << "\n"
    << "    This directive must be specified after @pkgdoc. If it isn't a\n"
    << "    warning will be generated and the directive will be ignored.\n"
    << "\n"
    << "    It allows you to redefine the pkgdoc title id. Normally when a\n"
    << "    package name is specified the title on the page is \"package\n"
    << "    <name>\". With this directive you can change the \"package\"\n"
    << "    string to anything you like.\n"
    << "\n"
    << "    It was added because some users would like to define different\n"
    << "    semantics for different packages, for example: some package might\n"
    << "    be subsystems, others might be modules and still others might\n"
    << "    really be packages. With this directive you can change the name in\n"
    << "    the generated HTML file to better reflect package semantics in\n"
    << "    your environment.\n"
    << "\n"
    << "    The example below shows how to define three packages: A, B and C.\n"
    << "    A is the top level, B and C are children. A will be reported as a\n"
    << "    \"system\", B will be reported as a \"module\" and C will be\n"
    << "    reported as a \"subsystem\".\n"
    << "\n"
    << "      /**\n"
    << "       * @pkgdoc A ../doc/A.html\n"
    << "       * @pkgdoctid system\n"
    << "       */\n"
    << "      /**\n"
    << "       * @pkgdoc A::B ../doc/A.B.html\n"
    << "       * @pkgdoctid module\n"
    << "       */\n"
    << "      /**\n"
    << "       * @pkgdoc A::C ../doc/A.C.html\n"
    << "       * @pkgdoctid subsystem\n"
    << "       */\n"
    << "\n"
    << "  7.22 @return <description>\n"
    << "\n"
    << "    Deprecated, same as @returns.\n"
    << "\n"
    << "  7.23 @returns <description>\n"
    << "\n"
    << "    Describes the return value from a function. If there is no return\n"
    << "    value, do not use @returns. Ccdoc does not verify that you\n"
    << "    documented the return value correctly. Here is an example of how\n"
    << "    it is used.\n"
    << "\n"
    << "      /**\n"
    << "       * Get the global value.\n"
    << "       * @returns The global value.\n"
    << "       */\n"
    << "       static int get_global_value();\n"
    << "\n"
    << "    The contents of an @returns directive can span multiple lines.\n"
    << "    All lines following an @returns directive are included until\n"
    << "    another ccdoc directive (other than @link and @@) is encountered.\n"
    << "    The example below shows how this works:\n"
    << "\n"
    << "      /**\n"
    << "       * This shows how @returns can span multiple lines.\n"
    << "       * @returns\n"
    << "       *@@ Return true if the value is < max or false if the value is >= max.\n"
    << "       * For more information about the value click\n"
    << "       *@link utils::value here @endlink .\n"
    << "       */\n"
    << "\n"
    << "  7.24 @see <entity> [<number>]\n"
    << "\n"
    << "    Associate an entity in the ccdoc database with the entity\n"
    << "    currently being described.\n"
    << "\n"
    << "    It tells ccdoc to generate a hyperlink to a named entity in the\n"
    << "    database. If there are multiple entities with the same name, as is\n"
    << "    the case with overloaded functions, specify the number of the one\n"
    << "    that you want ccdoc to use. The number should be between 0 and the\n"
    << "    number of duplicate entities minus 1. If no number is specified,\n"
    << "    the first occurrence is used. The example below shows how to use\n"
    << "    this directive.\n"
    << "\n"
    << "    There is an alternate form that allows the user to specify a url\n"
    << "    for the entity. This allows hyperlinks to objects that ccdoc\n"
    << "    doesn't know about. It is useful for adding links to documents.\n"
    << "\n"
    << "    There is another alternative form that allows the user to specify\n"
    << "    in the current scope using a '#' prefix. This is convenient for\n"
    << "    describing method relations within a class.\n"
    << "\n"
    << "    Packages are not specified in the @see <entity> specification\n"
    << "    because they can be changed at run-time. Ccdoc searchs for all C++\n"
    << "    entities that match the specification in all packages.\n"
    << "\n"
    << "      /**\n"
    << "       * Generate three links, one to the class named Foo,\n"
    << "       * the second to the second overloaded method\n"
    << "       * Spam in the Bar class and the third to a document\n"
    << "       * called wombat at the specified URL.\n"
    << "       * @see Foo\n"
    << "       * @see Bar::Spam 2\n"
    << "       * @see <a href=wombat.html>wombat</a>\n"
    << "       */\n"
    << "\n"
    << "    There is a special case for operators. The example below shows how\n"
    << "    to specify an @see link to an operator.\n"
    << "\n"
    << "      /**\n"
    << "       * This is the same as the {@link #operator== equals operator}\n"
    << "       * for this class.\n"
    << "       * @param obj The object to compare to for equality.\n"
    << "       * @returns True if they are equal or false otherwise.\n"
    << "       * @see #operator==\n"
    << "       */\n"
    << "      bool is_equal(const Class& obj) const;\n"
    << "\n"
    << "    Note that there are no spaces between the operator keyword and the\n"
    << "    operator tokens.\n"
    << "\n"
    << "  7.25 @since <version>\n"
    << "\n"
    << "    This is entity has only been available since the specified\n"
    << "    version.  Ccdoc does not impose any syntax requirements on the\n"
    << "    version string so you can use anything you want.\n"
    << "\n"
    << "    The example below shows how to use this directive.\n"
    << "\n"
    << "      /**\n"
    << "       * This is a new function.\n"
    << "       * It does really new stuff.\n"
    << "       * @author Foo Bar\n"
    << "       * @version 1.0\n"
    << "       * @since v1.2 Built: 2001/10/01\n"
    << "       */\n"
    << "      void fct();\n"
    << "\n"
    << "  7.26 @suffix\n"
    << "\n"
    << "    This is a suffix style comment, that is, it is attached to the\n"
    << "    preceding statement rather than the following statement as shown\n"
    << "    in the example below:\n"
    << "\n"
    << "      class Foo {\n"
    << "      public:\n"
    << "        /**\n"
    << "         * This is the traditional prefix comment form.\n"
    << "         */\n"
    << "        void traditional_comment_form();\n"
    << "\n"
    << "        //@{\n"
    << "        // This is an alternate prefix comment form.\n"
    << "        //@}\n"
    << "        void alt_prefix_comment_form();\n"
    << "\n"
    << "        void traditional_suffix_comment_form();\n"
    << "          //@{\n"
    << "          // This is the new suffix comment\n"
    << "          // form that some folks have requested.\n"
    << "          // @suffix\n"
    << "          //@}\n"
    << "\n"
    << "        void alt1_suffix_comment_form();\n"
    << "          /**<\n"
    << "           * This is a doxygen compatible suffix comment\n"
    << "           * form that some folks have requested.\n"
    << "           */\n"
    << "\n"
    << "        void alt2_suffix_comment_form();\n"
    << "          /*!<\n"
    << "           * This is a doxygen compatible suffix comment\n"
    << "           * form that some folks have requested.\n"
    << "           */\n"
    << "\n"
    << "        void alt3_suffix_comment_form(); //@- Short comment.\n"
    << "        void alt4_suffix_comment_form(); ///< Short comment.\n"
    << "        void alt5_suffix_comment_form(); //!< Short comment.\n"
    << "      };\n"
    << "\n"
    << "    The alternative forms (1,2,4,5) are generally preferred for \n"
    << "    doxygen compatibility.\n"
    << "\n"
    << "  7.27 @throws <name> <description>\n"
    << "\n"
    << "    Specifies that this exception can be thrown by the method. If the\n"
    << "    <name> specifies a class in the ccdoc databse, a hyperlink is\n"
    << "    added. The example below shows hows to this directive.\n"
    << "\n"
    << "      /**\n"
    << "       * This function does stuff.\n"
    << "       *\n"
    << "       * Here is more detail about the stuff\n"
    << "       * it does.\n"
    << "       * @param name The name of the object.\n"
    << "       * @returns The object.\n"
    << "       * @exception Exception_NullParameter Is thrown\n"
    << "       * if name is NULL.\n"
    << "       */\n"
    << "      SomeObject GetObject(const char* name);\n"
    << "\n"
    << "    The contents of an @exception directive can span multiple lines.\n"
    << "    All lines following an @exception directive are included until\n"
    << "    another ccdoc directive (other than @link and @@) is encountered.\n"
    << "    The example below shows how this works:\n"
    << "\n"
    << "      /**\n"
    << "       * This shows how @exception can span multiple lines.\n"
    << "       * @exception Port::Exception Is thrown when the program\n"
    << "       * runs out of disk space.\n"
    << "       */\n"
    << "      void use_disk_space();\n"
    << "\n"
    << "  7.28 @todo <description>\n"
    << "\n"
    << "    Specifies that there are additional things things to be done to\n"
    << "    this interface or its implementation. The example below shows\n"
    << "    how to use this directive.\n"
    << "\n"
    << "      /**\n"
    << "       * Get the full file by name if it exists.\n"
    << "       * @param out The output file name.\n"
    << "       * @param in The input file name.\n"
    << "       * @returns The full file name of the first file that matches\n"
    << "       *          the name parameter. If no match is found, an empty\n"
    << "       *          string is returned.\n"
    << "       * @author Foo\n"
    << "       * @version 1.0\n"
    << "       * @todo Support wild cards in the input name.\n"
    << "       */\n"
    << "       void get_full_file_name(string& out,const string& in);\n"
    << "\n"
    << "  7.29 @version <id>\n"
    << "\n"
    << "    Specifies the version of the entity. If this directive is not\n"
    << "    specified for classes, functions or packages, \"unknown\" is reported.\n"
    << "\n"
    ;
  ccdoc::s_log
    << "8 Comment Format\n"
    << "\n"
    << "  The basic comment format is as follows:\n"
    << "\n"
    << "    Format                    Description\n"
    << "    ========================  ===================================\n"
    << "    /**                       Start of comment.\n"
    << "     * <brief description>    The brief description is terminated\n"
    << "     *                        by a period followed by a tab, space\n"
    << "     *                        or newline or it is termined by a\n"
    << "     *                        directive. This complies with the\n"
    << "     *                        javadoc syntax.\n"
    << "     *\n"
    << "     *                        In older versions of ccdoc the brief\n"
    << "     *                        description was termined by a blank\n"
    << "     *                        line. This behavior can be re-enabled\n"
    << "     *                        by specifying the phase 1 -nojdsds\n"
    << "     *                        switch.\n"
    << "     *                        First blank (all w/s) line.\n"
    << "     *\n"
    << "     * <full description>     Any number of lines with blanks.\n"
    << "     */                       End of comment.\n"
    << "    <C++ entity>              The entity that the comment is\n"
    << "                              associated with (unless it is\n"
    << "                              a pkgdoc comment).\n"
    << "    ========================  ===================================\n"
    << "\n"
    << "  Each blank line, other than the first one, is treated as a an HTML\n"
    << "  paragraph (<p>). The first blank line separates the brief\n"
    << "  description from the full description in -nojdsds mode otherwise it\n"
    << "  is ignored.\n"
    << "\n"
    << "  Ccdoc directives can be embedded anywhere in either description but\n"
    << "  they must be the first entity on the line.\n"
    << "\n"
    << "  The full description is optional.\n"
    << "\n"
    << "  The leading asterisk on each line is optional.\n"
    << "\n"
    << "  8.1 The simplest possible comment\n"
    << "\n"
    << "    The example below shows the simplest possible comment forms.\n"
    << "\n"
    << "      /**Get the age of an employee.*/\n"
    << "      unsigned int age(const char* name);\n"
    << "\n"
    << "      //@{ Get the birthdate of an employee. //@}\n"
    << "      unsigned int birthdate(const char* name);\n"
    << "\n"
    << "      unsigned num_items(); //@- The number of items.\n"
    << "      unsigned num_items1(); ///< The number of items.\n"
    << "      unsigned num_items2(); //!< The number of items.\n"
    << "      unsigned num_items3(); /**< The number of items. */\n"
    << "      unsigned num_items4(); /*!< The number of items. */\n"
    << "\n"
    << "  8.2 A more reasonable example.\n"
    << "\n"
    << "    The example below shows a more complete example for the function\n"
    << "    in 8.1. As you can see, it assumes that age is part of a class or\n"
    << "    a namespace called Employee.\n"
    << "\n"
    << "      /**\n"
    << "       * Get an employees age.\n"
    << "       * This function is not thread safe because it\n"
    << "       * uses statically initialized data.\n"
    << "       *\n"
    << "       * If the age of the employee is not known, return\n"
    << "       * the value 0. The example below shows how to use\n"
    << "       * this function.\n"
    << "       * <blockquote>\n"
    << "       * <pre>\n"
    << "       *@@ #include <iostream>\n"
    << "       *@@ #include \"Employee.h\"\n"
    << "       *@@ int main(int,char**) {\n"
    << "       *@@   cout << \"John Doe's age is\" \n"
    << "       *@@        << Employee::age(\"John Doe\")\n"
    << "       *@@        << endl;\n"
    << "       *@@   return 0;\n"
    << "       *@@ }\n"
    << "       * </pre>\n"
    << "       * </blockquote>\n"
    << "       * @param name The name of the employee.\n"
    << "       * @returns The age of the employee or zero if the\n"
    << "       *          age if the employee is not known.\n"
    << "       * @see Employee\n"
    << "       * @throws MyExceptions::NullArgException\n"
    << "       *         if the name argument is NULL.\n"
    << "       * @todo Modify this function to accept a std::string\n"
    << "       *       reference argument to avoid having to check\n"
    << "       *       for a NULL argument.\n"
    << "       */\n"
    << "       unsigned int age(const char* name);\n"
    << "      \n"
    << "  8.3 Alternative comment form 1\n"
    << "\n"
    << "    Ccdoc allows you to use the C++ single line comment form in\n"
    << "    several ways. In this form you specify the beginning and ending of\n"
    << "    a comment by using the standard form and prepending the '//'s as\n"
    << "    shown below:\n"
    << "\n"
    << "      ///**\n"
    << "      // * This is a simple comment.\n"
    << "      // */\n"
    << "      int simple;\n"
    << "\n"
    << "  8.4 Alternative comment form 2\n"
    << "\n"
    << "    This form allows you do away with the multi-line comment form\n"
    << "    entirely by specifying the ccdoc comments using begin and end\n"
    << "    directives as shown in the example below:\n"
    << "\n"
    << "      // ================================================\n"
    << "      //@{\n"
    << "      // This is a simple comment for foo that uses the\n"
    << "      // new single line comment form.\n"
    << "      //@}\n"
    << "      // ================================================\n"
    << "      int foo();\n"
    << "\n"
    << "  8.5 Alternative comment form 3 (suffix)\n"
    << "\n"
    << "    This form allows you to specify complex ccdoc comments for the\n"
    << "    previous C++ statement as shown in the example below:\n"
    << "\n"
    << "      int foo();\n"
    << "        //@{\n"
    << "        // This is a simple comment for foo().\n"
    << "        // @suffix\n"
    << "        //@}\n"
    << "\n"
    << "      int foo1();\n"
    << "        /**<\n"
    << "         * This is a simple comment for foo1().\n"
    << "         */\n"
    << "\n"
    << "      int foo2();\n"
    << "        /*!<\n"
    << "         * This is a simple comment for foo2().\n"
    << "         */\n"
    << "\n"
    << "  8.6 Alternative comment form 4 (single line, suffix)\n"
    << "\n"
    << "    Specifies the single line suffix C++ style comment form. This for\n"
    << "    is useful for abbreviated comments. Here is an example:\n"
    << "\n"
    << "      class Point3D {\n"
    << "      public:\n"
    << "        int p1; //@- The x coordinate.\n"
    << "        int p2; ///< The y coordinate.\n"
    << "        int p3; //!< The z coordinate.\n"
    << "      };\n"
    << "\n"
    << "    You can only specify a single line so most directives are not\n"
    << "    supported. The only supported directives are {@link .. } and\n"
    << "    @link .. @endlink.\n"
    << "\n"
    ;
  ccdoc::s_log
    << "9 Package Help\n"
    << "\n"
    << "  This section describes how to link to ccdoc comments from your\n"
    << "  documentation tree. The root level file is ccdoc.root.pkg.html. The\n"
    << "  'root' package name can be changed using the -root <name> switch.\n"
    << "\n"
    << "  In the previous system the root level file was called\n"
    << "  ccdoc.index.html. That behavior can be mimic'ed by using the\n"
    << "  -rootfile ccdoc.index.html switch.\n"
    << "\n"
    << "  Here is an example that shows how to create documentation for a\n"
    << "  system:\n"
    << "\n"
    << "    % cat src/rootdoc.txt <<END\n"
    << "    /**\n"
    << "     * This is the root level documentation.\n"
    << "     * @author The Team\n"
    << "     * @version 1.2\n"
    << "     * @pkgdoc @root\n"
    << "     */\n"
    << "    END\n"
    << "    % ccdoc -db sys.db \\\n"
    << "         -pkg system \\\n"
    << "         -html web/ \\\n"
    << "         -rooturl http://system/index.html \\\n"
    << "         -srcurl http://system/src/ \\\n"
    << "         src/rootdoc.txt \\\n"
    << "         src/*.h\n"
    << "\n"
    << "  Here is another example that shows how to create documentation for a\n"
    << "  system with a ccdoc.index.html root file:\n"
    << "\n"
    << "    % cat src/rootdoc.txt <<END\n"
    << "    /**\n"
    << "     * This is the root level documentation.\n"
    << "     * @author The Team\n"
    << "     * @version 1.2\n"
    << "     * @pkgdoc @root\n"
    << "     */\n"
    << "    END\n"
    << "    % ccdoc -db sys.db \\\n"
    << "         -pkg system \\\n"
    << "         -html web/ \\\n"
    << "         -rootfile web/ccdoc.index.html \\\n"
    << "         -rooturl http://system/index.html \\\n"
    << "         -srcurl http://system/src/ \\\n"
    << "         src/rootdoc.txt \\\n"
    << "         src/*.h\n"
    << "\n"
    << "  Note that the root file: \"http://system/index.html\" is NOT\n"
    << "  generated by ccdoc.\n"
    << "\n"
    << "  Also note that the -srcurl tells the browser where to find the\n"
    << "  source code.\n"
    << "\n"
    << "  Each generated documentation file will have a link named 'Home' to\n"
    << "  the root url 'http://system/index.html'.\n"
    << "\n"
    << "  The http://system/index.html can have a link to\n"
    << "  web/ccdoc.root.pkg.html to access the ccdoc documentation.\n"
    << "\n"
    << "************************************************************************\n"
    << "**                           HELPFUL HINTS                            **\n"
    << "**                                                                    **\n"
    << "**  To capture this message in an output file called help.log,        **\n"
    << "**  run this command as:                                              **\n"
    << "**                                                                    **\n"
    << "**    ccdoc -log help.log -nocout -h                                  **\n"
    << "**                                                                    **\n"
    << "**  If you just want to know how to run ccdoc, see section 6 of this  **\n"
    << "**  help message.                                                     **\n"
    << "**                                                                    **\n"
    << "**  If you just want to see some comment examples, see section 8 of   **\n"
    << "**  this help message.                                                **\n"
    << "**                                                                    **\n"
    << "************************************************************************\n"
    //@help_end
    ;
  ccdoc::s_log.flush();
}
