#!perl
# $Id: file_sizes.pl,v 1.3 2004/09/30 07:34:13 jlinoff Exp $
#
# Report the size of a file in a formatted form.
#
use strict;

&Main;

# ================================================
# MAIN
# ================================================
sub Main
{
    my $n1 = 32;
    my $n2 = 10;
    my $p = "";
    my @files = ();
    while( $#ARGV >= 0 ) {
	my $arg = shift @ARGV;
	if( $arg eq "-n1" ) {
	    $n1 = shift @ARGV;
	}
	elsif( $arg eq "-n2" ) {
	    $n2 = shift @ARGV;
	}
	elsif( $arg eq "-p" ) {
	    $p = shift @ARGV;
	}
	else {
	    if( -e $arg ) {
		push @files,$arg;
	    }
	    else {
		print STDERR "WARNING: File $arg does not exist.\n";	    }
	}
    }
    my $file;
    foreach $file ( @files ) {
	my @info = stat($file);
	my $sz = $info[7];
	my $kb = $sz/1024;
	my $mb = $kb/1024;
	my $fmt = "$p%-${n1}s %${n2}s %${n2}sKb %${n2}sMb\n";
	printf $fmt, $file, &fmtnum($sz), &fmtnum($kb), &fmtnum($mb);
	
	#($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	#    $atime,$mtime,$ctime,$blksize,$blocks)
	#        = stat($file);
    }
}
# ================================================
# Format number.
# ================================================
sub fmtnum
{
    my $num = shift;
    my $fmt = $num;
    my $frac = "";
    if( $num =~ /\./ ) {
	$frac = $num;
	$frac =~ s/[0-9]*\.//;
    }
    $fmt =~ s/\..*$//;
    $fmt =~ s/(.........)$/,\1/ if( length($fmt) > 9 );
    $fmt =~ s/(......)$/,\1/ if( length($fmt) > 6 );
    $fmt =~ s/(...)$/,\1/ if( length($fmt) > 3 );
    if( $frac > 0 ) {
	if( $frac >= 1000 ) {
	    $frac =~ s/^(...).*$/\1/;
	}
	$fmt = "${fmt}.${frac}";
    }
    return $fmt;
}
