#!perl
# $Id: fix_help.pl,v 1.3 2004/09/30 07:34:13 jlinoff Exp $
#
# Fix up the help source file by inserting breaks every
# so often to avoid very long compile times for gcc when
# it tries to verify the format arguments.
#
use strict;
&Main;

# ================================================
# MAIN
# ================================================
sub Main
{
    # Open the help.cc file.
    my $ifile = "help.cc";
    my $ofile = "help-tmp.cc";
    if( ! -e $ifile ) {
	print STDERR "ERROR: Cannot read '$ifile'.\n";
	exit 1;
    }
    open IFILE,"$ifile" || die "ERROR: Cannot read '$ifile'.\n";
    open OFILE,">$ofile" || die "ERROR: Cannot ofile '$ofile'.\n";
    my $prev;
    while( <IFILE> ) {
	chop;
	if( /^    << \"[0-9].*$/ ) {
	    #print "DEBUG: prev = $prev\n";
	    if( $prev !~ /ccdoc::s_log/ ) {
		# Allow this script to be re-entrant.
		print OFILE "    ;\n";
		print OFILE "  ccdoc::s_log\n";
	    }
	}
	print OFILE "$_\n";
	$prev = $_;
    }
    close OFILE;
    close IFILE;
    rename $ofile, $ifile;
    exit 0;
}
