/* gca-scrollbar-marker.c generated by valac 0.27.1, the Vala compiler
 * generated from gca-scrollbar-marker.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <cairo.h>
#include <src/gca-utils-c.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define GCA_TYPE_SCROLLBAR_MARKER (gca_scrollbar_marker_get_type ())
#define GCA_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarker))
#define GCA_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))
#define GCA_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))

typedef struct _GcaScrollbarMarker GcaScrollbarMarker;
typedef struct _GcaScrollbarMarkerClass GcaScrollbarMarkerClass;
typedef struct _GcaScrollbarMarkerPrivate GcaScrollbarMarkerPrivate;

#define GCA_SCROLLBAR_MARKER_TYPE_MARKER (gca_scrollbar_marker_marker_get_type ())
#define GCA_SCROLLBAR_MARKER_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_SCROLLBAR_MARKER_TYPE_MARKER, GcaScrollbarMarkerMarker))
#define GCA_SCROLLBAR_MARKER_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_SCROLLBAR_MARKER_TYPE_MARKER, GcaScrollbarMarkerMarkerClass))
#define GCA_SCROLLBAR_MARKER_IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_SCROLLBAR_MARKER_TYPE_MARKER))
#define GCA_SCROLLBAR_MARKER_IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_SCROLLBAR_MARKER_TYPE_MARKER))
#define GCA_SCROLLBAR_MARKER_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_SCROLLBAR_MARKER_TYPE_MARKER, GcaScrollbarMarkerMarkerClass))

typedef struct _GcaScrollbarMarkerMarker GcaScrollbarMarkerMarker;
typedef struct _GcaScrollbarMarkerMarkerClass GcaScrollbarMarkerMarkerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCA_TYPE_SOURCE_RANGE (gca_source_range_get_type ())

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;
typedef struct _GcaSourceRange GcaSourceRange;
#define _gca_scrollbar_marker_marker_unref0(var) ((var == NULL) ? NULL : (var = (gca_scrollbar_marker_marker_unref (var), NULL)))
typedef struct _GcaScrollbarMarkerMarkerPrivate GcaScrollbarMarkerMarkerPrivate;
typedef struct _GcaScrollbarMarkerParamSpecMarker GcaScrollbarMarkerParamSpecMarker;
typedef struct _GcaParamSpecScrollbarMarker GcaParamSpecScrollbarMarker;

struct _GcaScrollbarMarker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcaScrollbarMarkerPrivate * priv;
};

struct _GcaScrollbarMarkerClass {
	GTypeClass parent_class;
	void (*finalize) (GcaScrollbarMarker *self);
};

struct _GcaScrollbarMarkerPrivate {
	GtkScrollbar* d_scrollbar;
	GeeHashMap* d_markers;
	gint d_spacing;
	gint d_maxline;
	gint d_border;
	gint d_width;
	guint d_mergeId;
};

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _GcaSourceRange {
	GcaSourceLocation start;
	GcaSourceLocation end;
};

struct _GcaScrollbarMarkerMarker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcaScrollbarMarkerMarkerPrivate * priv;
};

struct _GcaScrollbarMarkerMarkerClass {
	GTypeClass parent_class;
	void (*finalize) (GcaScrollbarMarkerMarker *self);
};

struct _GcaScrollbarMarkerMarkerPrivate {
	GdkRGBA d_color;
	GcaSourceRange d_range;
};

struct _GcaScrollbarMarkerParamSpecMarker {
	GParamSpec parent_instance;
};

struct _GcaParamSpecScrollbarMarker {
	GParamSpec parent_instance;
};


static gpointer gca_scrollbar_marker_parent_class = NULL;
static gpointer gca_scrollbar_marker_marker_parent_class = NULL;

gpointer gca_scrollbar_marker_ref (gpointer instance);
void gca_scrollbar_marker_unref (gpointer instance);
GParamSpec* gca_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gca_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gca_value_get_scrollbar_marker (const GValue* value);
GType gca_scrollbar_marker_get_type (void) G_GNUC_CONST;
static gpointer gca_scrollbar_marker_marker_ref (gpointer instance);
static void gca_scrollbar_marker_marker_unref (gpointer instance);
static GParamSpec* gca_scrollbar_marker_param_spec_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gca_scrollbar_marker_value_set_marker (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gca_scrollbar_marker_value_take_marker (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gca_scrollbar_marker_value_get_marker (const GValue* value) G_GNUC_UNUSED;
static GType gca_scrollbar_marker_marker_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GCA_SCROLLBAR_MARKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerPrivate))
enum  {
	GCA_SCROLLBAR_MARKER_DUMMY_PROPERTY
};
static gboolean gca_scrollbar_marker_on_scrollbar_draw (GcaScrollbarMarker* self, cairo_t* ctx);
static gboolean _gca_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
GcaScrollbarMarker* gca_scrollbar_marker_new (GtkScrollbar* scrollbar);
GcaScrollbarMarker* gca_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar);
static void gca_scrollbar_marker_on_style_updated (GcaScrollbarMarker* self);
static void _gca_scrollbar_marker_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self);
static void gca_scrollbar_marker_update_spacing (GcaScrollbarMarker* self);
guint gca_scrollbar_marker_new_merge_id (GcaScrollbarMarker* self);
GType gca_source_range_get_type (void) G_GNUC_CONST;
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self);
void gca_source_range_free (GcaSourceRange* self);
void gca_scrollbar_marker_add_with_id (GcaScrollbarMarker* self, guint id, GcaSourceRange* range, GdkRGBA* color);
static GcaScrollbarMarkerMarker* gca_scrollbar_marker_marker_new (GcaSourceRange* range, GdkRGBA* color);
static GcaScrollbarMarkerMarker* gca_scrollbar_marker_marker_construct (GType object_type, GcaSourceRange* range, GdkRGBA* color);
void gca_scrollbar_marker_remove (GcaScrollbarMarker* self, guint id);
static void gca_scrollbar_marker_draw_marker (GcaScrollbarMarker* self, cairo_t* ctx, GdkRectangle* rect, GcaScrollbarMarkerMarker* marker);
static void gca_scrollbar_marker_marker_get_range (GcaScrollbarMarkerMarker* self, GcaSourceRange* result);
static void gca_scrollbar_marker_marker_get_color (GcaScrollbarMarkerMarker* self, GdkRGBA* result);
gint gca_scrollbar_marker_get_max_line (GcaScrollbarMarker* self);
void gca_scrollbar_marker_set_max_line (GcaScrollbarMarker* self, gint value);
GtkScrollbar* gca_scrollbar_marker_get_scrollbar (GcaScrollbarMarker* self);
#define GCA_SCROLLBAR_MARKER_MARKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_SCROLLBAR_MARKER_TYPE_MARKER, GcaScrollbarMarkerMarkerPrivate))
enum  {
	GCA_SCROLLBAR_MARKER_MARKER_DUMMY_PROPERTY
};
static void gca_scrollbar_marker_marker_finalize (GcaScrollbarMarkerMarker* obj);
static void gca_scrollbar_marker_finalize (GcaScrollbarMarker* obj);


static gboolean _gca_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gca_scrollbar_marker_on_scrollbar_draw ((GcaScrollbarMarker*) self, cr);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gca_scrollbar_marker_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self) {
	gca_scrollbar_marker_on_style_updated ((GcaScrollbarMarker*) self);
}


GcaScrollbarMarker* gca_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar) {
	GcaScrollbarMarker* self = NULL;
	GtkScrollbar* _tmp0_ = NULL;
	GtkScrollbar* _tmp1_ = NULL;
	GtkScrollbar* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GtkScrollbar* _tmp4_ = NULL;
	g_return_val_if_fail (scrollbar != NULL, NULL);
	self = (GcaScrollbarMarker*) g_type_create_instance (object_type);
	_tmp0_ = scrollbar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_scrollbar);
	self->priv->d_scrollbar = _tmp1_;
	_tmp2_ = self->priv->d_scrollbar;
	g_signal_connect_after ((GtkWidget*) _tmp2_, "draw", (GCallback) _gca_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw, self);
	_tmp3_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_markers);
	self->priv->d_markers = _tmp3_;
	self->priv->d_maxline = 0;
	_tmp4_ = self->priv->d_scrollbar;
	g_signal_connect ((GtkWidget*) _tmp4_, "style-updated", (GCallback) _gca_scrollbar_marker_on_style_updated_gtk_widget_style_updated, self);
	gca_scrollbar_marker_update_spacing (self);
	return self;
}


GcaScrollbarMarker* gca_scrollbar_marker_new (GtkScrollbar* scrollbar) {
	return gca_scrollbar_marker_construct (GCA_TYPE_SCROLLBAR_MARKER, scrollbar);
}


static void gca_scrollbar_marker_update_spacing (GcaScrollbarMarker* self) {
	GtkStyleContext* ctx = NULL;
	GtkScrollbar* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	gint stepper_size = 0;
	gint _tmp3_ = 0;
	gint stepper_spacing = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_scrollbar;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	_tmp3_ = gca_utils_c_get_style_property_int (ctx, "stepper-size");
	stepper_size = _tmp3_;
	_tmp4_ = gca_utils_c_get_style_property_int (ctx, "stepper-spacing");
	stepper_spacing = _tmp4_;
	_tmp5_ = gca_utils_c_get_style_property_int (ctx, "trough-border");
	self->priv->d_border = _tmp5_;
	_tmp6_ = gca_utils_c_get_style_property_int (ctx, "slider-width");
	self->priv->d_width = _tmp6_;
	self->priv->d_spacing = (stepper_size + stepper_spacing) + 2;
	_g_object_unref0 (ctx);
}


static void gca_scrollbar_marker_on_style_updated (GcaScrollbarMarker* self) {
	g_return_if_fail (self != NULL);
	gca_scrollbar_marker_update_spacing (self);
}


guint gca_scrollbar_marker_new_merge_id (GcaScrollbarMarker* self) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->d_mergeId;
	self->priv->d_mergeId = _tmp0_ + 1;
	_tmp1_ = self->priv->d_mergeId;
	result = _tmp1_;
	return result;
}


void gca_scrollbar_marker_add_with_id (GcaScrollbarMarker* self, guint id, GcaSourceRange* range, GdkRGBA* color) {
	GcaScrollbarMarkerMarker* marker = NULL;
	GcaSourceRange _tmp0_ = {0};
	GdkRGBA _tmp1_ = {0};
	GcaScrollbarMarkerMarker* _tmp2_ = NULL;
	GeeLinkedList* lst = NULL;
	GeeHashMap* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	GeeLinkedList* _tmp13_ = NULL;
	GcaScrollbarMarkerMarker* _tmp14_ = NULL;
	GtkScrollbar* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = *range;
	_tmp1_ = *color;
	_tmp2_ = gca_scrollbar_marker_marker_new (&_tmp0_, &_tmp1_);
	marker = _tmp2_;
	_tmp3_ = self->priv->d_markers;
	_tmp4_ = id;
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) _tmp4_));
	if (_tmp5_) {
		GeeHashMap* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		gpointer _tmp8_ = NULL;
		_tmp6_ = self->priv->d_markers;
		_tmp7_ = id;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, (gpointer) ((guintptr) _tmp7_));
		_g_object_unref0 (lst);
		lst = (GeeLinkedList*) _tmp8_;
	} else {
		GeeLinkedList* _tmp9_ = NULL;
		GeeHashMap* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		GeeLinkedList* _tmp12_ = NULL;
		_tmp9_ = gee_linked_list_new (GCA_SCROLLBAR_MARKER_TYPE_MARKER, (GBoxedCopyFunc) gca_scrollbar_marker_marker_ref, gca_scrollbar_marker_marker_unref, NULL, NULL, NULL);
		_g_object_unref0 (lst);
		lst = _tmp9_;
		_tmp10_ = self->priv->d_markers;
		_tmp11_ = id;
		_tmp12_ = lst;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, (gpointer) ((guintptr) _tmp11_), _tmp12_);
	}
	_tmp13_ = lst;
	_tmp14_ = marker;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->d_scrollbar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp15_);
	_g_object_unref0 (lst);
	_gca_scrollbar_marker_marker_unref0 (marker);
}


void gca_scrollbar_marker_remove (GcaScrollbarMarker* self, guint id) {
	GeeHashMap* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GtkScrollbar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_markers;
	_tmp1_ = id;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) _tmp1_));
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->d_markers;
	_tmp4_ = id;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) _tmp4_), NULL);
	_tmp5_ = self->priv->d_scrollbar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp5_);
}


static void gca_scrollbar_marker_draw_marker (GcaScrollbarMarker* self, cairo_t* ctx, GdkRectangle* rect, GcaScrollbarMarkerMarker* marker) {
	GcaSourceRange range = {0};
	GcaScrollbarMarkerMarker* _tmp0_ = NULL;
	GcaSourceRange _tmp1_ = {0};
	GcaSourceRange _tmp2_ = {0};
	guint height = 0U;
	GcaSourceRange _tmp3_ = {0};
	GcaSourceLocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	GcaSourceRange _tmp6_ = {0};
	GcaSourceLocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	gdouble scale = 0.0;
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gdouble y = 0.0;
	GdkRectangle _tmp12_ = {0};
	gint _tmp13_ = 0;
	GcaSourceRange _tmp14_ = {0};
	GcaSourceLocation _tmp15_ = {0};
	gint _tmp16_ = 0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble dy = 0.0;
	guint _tmp19_ = 0U;
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	cairo_t* _tmp23_ = NULL;
	GcaScrollbarMarkerMarker* _tmp24_ = NULL;
	GdkRGBA _tmp25_ = {0};
	GdkRGBA _tmp26_ = {0};
	cairo_t* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (rect != NULL);
	g_return_if_fail (marker != NULL);
	_tmp0_ = marker;
	gca_scrollbar_marker_marker_get_range (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	range = _tmp2_;
	_tmp3_ = range;
	_tmp4_ = _tmp3_.end;
	_tmp5_ = _tmp4_.line;
	_tmp6_ = range;
	_tmp7_ = _tmp6_.start;
	_tmp8_ = _tmp7_.line;
	height = (guint) ((_tmp5_ - _tmp8_) + 1);
	_tmp9_ = *rect;
	_tmp10_ = _tmp9_.height;
	_tmp11_ = self->priv->d_maxline;
	scale = ((gdouble) _tmp10_) / ((gdouble) _tmp11_);
	_tmp12_ = *rect;
	_tmp13_ = _tmp12_.y;
	_tmp14_ = range;
	_tmp15_ = _tmp14_.start;
	_tmp16_ = _tmp15_.line;
	_tmp17_ = scale;
	_tmp18_ = round ((_tmp13_ + ((_tmp16_ - 1) * _tmp17_)) - 0.5);
	y = _tmp18_ + 0.5;
	_tmp19_ = height;
	_tmp20_ = scale;
	_tmp21_ = round (_tmp19_ * _tmp20_);
	_tmp22_ = fmax ((gdouble) 1, _tmp21_);
	dy = _tmp22_;
	_tmp23_ = ctx;
	_tmp24_ = marker;
	gca_scrollbar_marker_marker_get_color (_tmp24_, &_tmp25_);
	_tmp26_ = _tmp25_;
	gdk_cairo_set_source_rgba (_tmp23_, &_tmp26_);
	_tmp27_ = ctx;
	cairo_set_line_width (_tmp27_, (gdouble) 1);
	_tmp28_ = dy;
	if (_tmp28_ > 1.5) {
		cairo_t* _tmp29_ = NULL;
		GdkRectangle _tmp30_ = {0};
		gint _tmp31_ = 0;
		gdouble _tmp32_ = 0.0;
		GdkRectangle _tmp33_ = {0};
		gint _tmp34_ = 0;
		gdouble _tmp35_ = 0.0;
		cairo_t* _tmp36_ = NULL;
		_tmp29_ = ctx;
		_tmp30_ = *rect;
		_tmp31_ = _tmp30_.x;
		_tmp32_ = y;
		_tmp33_ = *rect;
		_tmp34_ = _tmp33_.width;
		_tmp35_ = dy;
		cairo_rectangle (_tmp29_, _tmp31_ + 0.5, _tmp32_, (gdouble) (_tmp34_ - 1), _tmp35_);
		_tmp36_ = ctx;
		cairo_fill (_tmp36_);
	} else {
		cairo_t* _tmp37_ = NULL;
		GdkRectangle _tmp38_ = {0};
		gint _tmp39_ = 0;
		gdouble _tmp40_ = 0.0;
		cairo_t* _tmp41_ = NULL;
		GdkRectangle _tmp42_ = {0};
		gint _tmp43_ = 0;
		GdkRectangle _tmp44_ = {0};
		gint _tmp45_ = 0;
		gdouble _tmp46_ = 0.0;
		cairo_t* _tmp47_ = NULL;
		_tmp37_ = ctx;
		_tmp38_ = *rect;
		_tmp39_ = _tmp38_.x;
		_tmp40_ = y;
		cairo_move_to (_tmp37_, _tmp39_ + 0.5, _tmp40_);
		_tmp41_ = ctx;
		_tmp42_ = *rect;
		_tmp43_ = _tmp42_.x;
		_tmp44_ = *rect;
		_tmp45_ = _tmp44_.width;
		_tmp46_ = y;
		cairo_line_to (_tmp41_, ((_tmp43_ + 0.5) + _tmp45_) - 1, _tmp46_);
		_tmp47_ = ctx;
		cairo_stroke (_tmp47_);
	}
}


static gboolean gca_scrollbar_marker_on_scrollbar_draw (GcaScrollbarMarker* self, cairo_t* ctx) {
	gboolean result = FALSE;
	GdkRectangle range = {0};
	GtkScrollbar* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->d_scrollbar;
	gca_utils_c_get_range_rect ((GtkRange*) _tmp0_, &_tmp1_);
	range = _tmp1_;
	_tmp2_ = range.x;
	_tmp3_ = self->priv->d_border;
	range.x = _tmp2_ + _tmp3_;
	_tmp4_ = self->priv->d_width;
	range.width = _tmp4_;
	_tmp5_ = range.y;
	_tmp6_ = self->priv->d_spacing;
	range.y = _tmp5_ + _tmp6_;
	_tmp7_ = range.height;
	_tmp8_ = self->priv->d_spacing;
	range.height = _tmp7_ - (2 * _tmp8_);
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp9_ = NULL;
		GeeSet* _tmp10_ = NULL;
		GeeSet* _tmp11_ = NULL;
		GeeSet* _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
		_tmp9_ = self->priv->d_markers;
		_tmp10_ = gee_abstract_map_get_keys ((GeeMap*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_key_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			guint key = 0U;
			GeeIterator* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			GeeLinkedList* lst = NULL;
			GeeHashMap* _tmp19_ = NULL;
			guint _tmp20_ = 0U;
			gpointer _tmp21_ = NULL;
			_tmp15_ = _key_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _key_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			key = (guint) ((guintptr) _tmp18_);
			_tmp19_ = self->priv->d_markers;
			_tmp20_ = key;
			_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, (gpointer) ((guintptr) _tmp20_));
			lst = (GeeLinkedList*) _tmp21_;
			{
				GeeLinkedList* _marker_list = NULL;
				GeeLinkedList* _tmp22_ = NULL;
				GeeLinkedList* _tmp23_ = NULL;
				gint _marker_size = 0;
				GeeLinkedList* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _marker_index = 0;
				_tmp22_ = lst;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_marker_list = _tmp23_;
				_tmp24_ = _marker_list;
				_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
				_tmp26_ = _tmp25_;
				_marker_size = _tmp26_;
				_marker_index = -1;
				while (TRUE) {
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					GcaScrollbarMarkerMarker* marker = NULL;
					GeeLinkedList* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gpointer _tmp32_ = NULL;
					cairo_t* _tmp33_ = NULL;
					GdkRectangle _tmp34_ = {0};
					GcaScrollbarMarkerMarker* _tmp35_ = NULL;
					_tmp27_ = _marker_index;
					_marker_index = _tmp27_ + 1;
					_tmp28_ = _marker_index;
					_tmp29_ = _marker_size;
					if (!(_tmp28_ < _tmp29_)) {
						break;
					}
					_tmp30_ = _marker_list;
					_tmp31_ = _marker_index;
					_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
					marker = (GcaScrollbarMarkerMarker*) _tmp32_;
					_tmp33_ = ctx;
					_tmp34_ = range;
					_tmp35_ = marker;
					gca_scrollbar_marker_draw_marker (self, _tmp33_, &_tmp34_, _tmp35_);
					_gca_scrollbar_marker_marker_unref0 (marker);
				}
				_g_object_unref0 (_marker_list);
			}
			_g_object_unref0 (lst);
		}
		_g_object_unref0 (_key_it);
	}
	result = FALSE;
	return result;
}


gint gca_scrollbar_marker_get_max_line (GcaScrollbarMarker* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->d_maxline;
	result = _tmp0_;
	return result;
}


void gca_scrollbar_marker_set_max_line (GcaScrollbarMarker* self, gint value) {
	gint _tmp0_ = 0;
	GtkScrollbar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->d_maxline = _tmp0_;
	_tmp1_ = self->priv->d_scrollbar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}


GtkScrollbar* gca_scrollbar_marker_get_scrollbar (GcaScrollbarMarker* self) {
	GtkScrollbar* result;
	GtkScrollbar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_scrollbar;
	result = _tmp0_;
	return result;
}


static GcaScrollbarMarkerMarker* gca_scrollbar_marker_marker_construct (GType object_type, GcaSourceRange* range, GdkRGBA* color) {
	GcaScrollbarMarkerMarker* self = NULL;
	GdkRGBA _tmp0_ = {0};
	GcaSourceRange _tmp1_ = {0};
	g_return_val_if_fail (range != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	self = (GcaScrollbarMarkerMarker*) g_type_create_instance (object_type);
	_tmp0_ = *color;
	self->priv->d_color = _tmp0_;
	_tmp1_ = *range;
	self->priv->d_range = _tmp1_;
	return self;
}


static GcaScrollbarMarkerMarker* gca_scrollbar_marker_marker_new (GcaSourceRange* range, GdkRGBA* color) {
	return gca_scrollbar_marker_marker_construct (GCA_SCROLLBAR_MARKER_TYPE_MARKER, range, color);
}


static void gca_scrollbar_marker_marker_get_range (GcaScrollbarMarkerMarker* self, GcaSourceRange* result) {
	GcaSourceRange _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_range;
	*result = _tmp0_;
	return;
}


static void gca_scrollbar_marker_marker_get_color (GcaScrollbarMarkerMarker* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_color;
	*result = _tmp0_;
	return;
}


static void gca_scrollbar_marker_value_marker_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gca_scrollbar_marker_value_marker_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gca_scrollbar_marker_marker_unref (value->data[0].v_pointer);
	}
}


static void gca_scrollbar_marker_value_marker_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gca_scrollbar_marker_marker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gca_scrollbar_marker_value_marker_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gca_scrollbar_marker_value_marker_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcaScrollbarMarkerMarker* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gca_scrollbar_marker_marker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gca_scrollbar_marker_value_marker_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcaScrollbarMarkerMarker** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gca_scrollbar_marker_marker_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gca_scrollbar_marker_param_spec_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcaScrollbarMarkerParamSpecMarker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCA_SCROLLBAR_MARKER_TYPE_MARKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gca_scrollbar_marker_value_get_marker (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_SCROLLBAR_MARKER_TYPE_MARKER), NULL);
	return value->data[0].v_pointer;
}


static void gca_scrollbar_marker_value_set_marker (GValue* value, gpointer v_object) {
	GcaScrollbarMarkerMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_SCROLLBAR_MARKER_TYPE_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCA_SCROLLBAR_MARKER_TYPE_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gca_scrollbar_marker_marker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gca_scrollbar_marker_marker_unref (old);
	}
}


static void gca_scrollbar_marker_value_take_marker (GValue* value, gpointer v_object) {
	GcaScrollbarMarkerMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_SCROLLBAR_MARKER_TYPE_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCA_SCROLLBAR_MARKER_TYPE_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gca_scrollbar_marker_marker_unref (old);
	}
}


static void gca_scrollbar_marker_marker_class_init (GcaScrollbarMarkerMarkerClass * klass) {
	gca_scrollbar_marker_marker_parent_class = g_type_class_peek_parent (klass);
	((GcaScrollbarMarkerMarkerClass *) klass)->finalize = gca_scrollbar_marker_marker_finalize;
	g_type_class_add_private (klass, sizeof (GcaScrollbarMarkerMarkerPrivate));
}


static void gca_scrollbar_marker_marker_instance_init (GcaScrollbarMarkerMarker * self) {
	self->priv = GCA_SCROLLBAR_MARKER_MARKER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gca_scrollbar_marker_marker_finalize (GcaScrollbarMarkerMarker* obj) {
	GcaScrollbarMarkerMarker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_SCROLLBAR_MARKER_TYPE_MARKER, GcaScrollbarMarkerMarker);
	g_signal_handlers_destroy (self);
}


static GType gca_scrollbar_marker_marker_get_type (void) {
	static volatile gsize gca_scrollbar_marker_marker_type_id__volatile = 0;
	if (g_once_init_enter (&gca_scrollbar_marker_marker_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gca_scrollbar_marker_value_marker_init, gca_scrollbar_marker_value_marker_free_value, gca_scrollbar_marker_value_marker_copy_value, gca_scrollbar_marker_value_marker_peek_pointer, "p", gca_scrollbar_marker_value_marker_collect_value, "p", gca_scrollbar_marker_value_marker_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GcaScrollbarMarkerMarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_scrollbar_marker_marker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaScrollbarMarkerMarker), 0, (GInstanceInitFunc) gca_scrollbar_marker_marker_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gca_scrollbar_marker_marker_type_id;
		gca_scrollbar_marker_marker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcaScrollbarMarkerMarker", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gca_scrollbar_marker_marker_type_id__volatile, gca_scrollbar_marker_marker_type_id);
	}
	return gca_scrollbar_marker_marker_type_id__volatile;
}


static gpointer gca_scrollbar_marker_marker_ref (gpointer instance) {
	GcaScrollbarMarkerMarker* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gca_scrollbar_marker_marker_unref (gpointer instance) {
	GcaScrollbarMarkerMarker* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCA_SCROLLBAR_MARKER_MARKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gca_value_scrollbar_marker_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gca_value_scrollbar_marker_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gca_scrollbar_marker_unref (value->data[0].v_pointer);
	}
}


static void gca_value_scrollbar_marker_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gca_scrollbar_marker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gca_value_scrollbar_marker_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gca_value_scrollbar_marker_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcaScrollbarMarker* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gca_scrollbar_marker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gca_value_scrollbar_marker_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcaScrollbarMarker** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gca_scrollbar_marker_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gca_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcaParamSpecScrollbarMarker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCA_TYPE_SCROLLBAR_MARKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gca_value_get_scrollbar_marker (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_TYPE_SCROLLBAR_MARKER), NULL);
	return value->data[0].v_pointer;
}


void gca_value_set_scrollbar_marker (GValue* value, gpointer v_object) {
	GcaScrollbarMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_TYPE_SCROLLBAR_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCA_TYPE_SCROLLBAR_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gca_scrollbar_marker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gca_scrollbar_marker_unref (old);
	}
}


void gca_value_take_scrollbar_marker (GValue* value, gpointer v_object) {
	GcaScrollbarMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_TYPE_SCROLLBAR_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCA_TYPE_SCROLLBAR_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gca_scrollbar_marker_unref (old);
	}
}


static void gca_scrollbar_marker_class_init (GcaScrollbarMarkerClass * klass) {
	gca_scrollbar_marker_parent_class = g_type_class_peek_parent (klass);
	((GcaScrollbarMarkerClass *) klass)->finalize = gca_scrollbar_marker_finalize;
	g_type_class_add_private (klass, sizeof (GcaScrollbarMarkerPrivate));
}


static void gca_scrollbar_marker_instance_init (GcaScrollbarMarker * self) {
	self->priv = GCA_SCROLLBAR_MARKER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gca_scrollbar_marker_finalize (GcaScrollbarMarker* obj) {
	GcaScrollbarMarker * self;
	GtkScrollbar* _tmp0_ = NULL;
	GtkScrollbar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarker);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->d_scrollbar;
	if (_tmp0_ == NULL) {
		goto _return;
	}
	_tmp1_ = self->priv->d_scrollbar;
	g_signal_parse_name ("draw", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gca_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw, self);
	_return:
	_g_object_unref0 (self->priv->d_scrollbar);
	_g_object_unref0 (self->priv->d_markers);
}


GType gca_scrollbar_marker_get_type (void) {
	static volatile gsize gca_scrollbar_marker_type_id__volatile = 0;
	if (g_once_init_enter (&gca_scrollbar_marker_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gca_value_scrollbar_marker_init, gca_value_scrollbar_marker_free_value, gca_value_scrollbar_marker_copy_value, gca_value_scrollbar_marker_peek_pointer, "p", gca_value_scrollbar_marker_collect_value, "p", gca_value_scrollbar_marker_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GcaScrollbarMarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_scrollbar_marker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaScrollbarMarker), 0, (GInstanceInitFunc) gca_scrollbar_marker_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gca_scrollbar_marker_type_id;
		gca_scrollbar_marker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcaScrollbarMarker", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gca_scrollbar_marker_type_id__volatile, gca_scrollbar_marker_type_id);
	}
	return gca_scrollbar_marker_type_id__volatile;
}


gpointer gca_scrollbar_marker_ref (gpointer instance) {
	GcaScrollbarMarker* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gca_scrollbar_marker_unref (gpointer instance) {
	GcaScrollbarMarker* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCA_SCROLLBAR_MARKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



