/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.30 from the
 * contents of SSLeay.xs. Do not edit this file, edit SSLeay.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SSLeay.xs"
/* SSLeay.xs - Perl module for using Eric Young's implementation of SSL
 *
 * Copyright (c) 1996-2002 Sampo Kellomaki <sampo@iki.fi>
 * Copyright (C) 2005 Florian Ragwitz <rafl@debian.org>
 * Copyright (C) 2005 Mike McCauley <mikem@airspayce.com>
 * 
 * All Rights Reserved.
 *
 * Change data removed. See Changes
 *
 * $Id: SSLeay.xs 456 2015-09-21 21:51:26Z mikem-guest $
 * 
 * The distribution and use of this module are subject to the conditions
 * listed in LICENSE file at the root of the Net-SSLeay
 * distribution (i.e. same license as Perl itself).
 */

/* ####
 * #### PLEASE READ THE FOLLOWING RULES BEFORE YOU START EDITING THIS FILE! ####
 * ####
 *
 * Function naming conventions:
 *
 * 1/ never change the already existing function names (all calling convention) in a way
 *    that may cause backward incompatibility (e.g. add ALIAS with old name if necessary)
 *
 * 2/ it is recommended to keep the original openssl function names for functions that are:
 *
 *    1:1 wrappers to the original openssl functions
 *    see for example: X509_get_issuer_name(cert) >> Net::SSLeay::X509_get_issuer_name($cert)
 *
 *    nearly 1:1 wrappers implementing only necessary "glue" e.g. buffer handling
 *    see for example: RAND_seed(buf,len) >> Net::SSLeay::RAND_seed($buf)
 *
 * 3/ OpenSSL functions starting with "SSL_" are added into SSLeay.xs with "SLL_" prefix
 *    (e.g. SSL_CTX_new) but keep in mind that they will be available in Net::SSLeay without
 *    "SSL_" prefix (e.g. Net::SSLeay::CTX_new) - keep this for all new functions
 *
 * 4/ The names of functions which do not fit rule 2/ (which means they implement some non
 *    trivial code around original openssl function or do more complex tasks) should be
 *    prefixed with "P_" - see for example: P_ASN1_TIME_set_isotime
 *
 * 5/ Exceptions from rules above:
 *    functions that are part or wider set of already existing function not following this rule
 *    for example: there already exists: PEM_get_string_X509_CRL + PEM_get_string_X509_REQ and you want
 *    to add PEM_get_string_SOMETHING - then no need to follow 3/ (do not prefix with "P_")
 *
 * Support for different openssl versions, different platforms, different compilers:
 *
 * 1/ SSleay.xs is expected to build/pass test suite
 *    - with openssl 0.9.6 and newer versions
 *    - with perl 5.8 and newer versions
 *
 * 2/ Fix all compiler warnings - we expect 100% clean build
 *
 * 3/ If you add a function which is available since certain openssl version
 *    use proper #ifdefs to assure that SSLeay.xs will compile also with older versions
 *    which are missing this function
 *
 * 4/ Even warnings arising from different use of "const" in different openssl versions
 *    needs to be hanled with #ifdefs - see for example: X509_NAME_add_entry_by_txt
 *
 * 5/ avoid using global C variables (it is very likely to break thread-safetyness)
 *    use rather global MY_CXT structure
 *
 * 6/ avoid using any UNIX/POSIX specific functions, keep in mind that SSLeay.xs must
 *    compile also on non-UNIX platforms like MS Windows and others
 *
 * 7/ avoid using c++ comments "//" (or other c++ features accepted by some c compiler)
 *    even if your compiler can handle them without warnings
 *
 * Passing test suite:
 *
 * 1/ any changes to SSLeay.xs must not introduce a failure of existing test suite
 *
 * 2/ it is strongly recommended to create test(s) for newly added function(s), especially
 *    when the new function is not only a 1:1 wrapper but contains a complex code
 *
 * 3/ it is mandatory to add a documentation for all newly added functions into SSLeay.pod
 *    otherwise t/local/02_pod_coverage.t fail (and you will be asked to add some doc into
 *    your patch)
 *
 * Preferred code layout:
 *
 * 1/ for simple 1:1 XS wrappers use:
 *
 *    a/ functions with short "signature" (short list of args):
 *
 *    long
 *    SSL_set_tmp_dh(SSL *ssl,DH *dh)
 *
 *    b/ functions with long "signature" (long list of args):
 *       simply when approach a/ does not fit to 120 columns
 *
 *    void
 *    SSL_any_functions(library_flag,function_name,reason,file_name,line)
 *            int library_flag
 *            int function_name
 *            int reason
 *            char *file_name
 *            int line
 *
 * 2/ for XS functions with full implementation use identation like this:
 *
 *    int
 *    RAND_bytes(buf, num)
 *            SV *buf
 *            int num
 *        PREINIT:
 *            int rc;
 *            unsigned char *random;
 *        CODE:
 *            / * some code here * /
 *            RETVAL = rc;
 *        OUTPUT:
 *            RETVAL
 *
 *
 * Runtime debugging:
 *
 * with TRACE(level,fmt,...) you can output debug messages.
 * it behaves the same as
 *   warn sprintf($msg,...) if $Net::SSLeay::trace>=$level
 * would do in Perl (e.g. it is using also the $Net::SSLeay::trace variable)
 *
 *
 * THE LAST RULE:
 *
 * The fact that some parts of SSLeay.xs do not follow the rules above is not 
 * a reason why any new code can also break these rules in the same way
 *
 */

/* Prevent warnings about strncpy from Windows compilers */
#define _CRT_SECURE_NO_DEPRECATE

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <stdarg.h>
#define NEED_newRV_noinc
#define NEED_sv_2pv_flags
#define NEED_my_snprintf
#include "ppport.h"
#ifdef __cplusplus
}
#endif

/* OpenSSL-0.9.3a has some strange warning about this in
 *    openssl/des.h
 */
#undef _

/* Sigh: openssl 1.0 has
 typedef void *BLOCK;
which conflicts with perls
 typedef struct block BLOCK;
*/
#define BLOCK OPENSSL_BLOCK
#include <openssl/err.h>
#include <openssl/lhash.h>
#include <openssl/rand.h>
#include <openssl/buffer.h>
#include <openssl/ssl.h>
#include <openssl/pkcs12.h>
#include <openssl/comp.h>    /* openssl-0.9.6a forgets to include this */
#ifndef OPENSSL_NO_MD2
#include <openssl/md2.h>
#endif
#ifndef OPENSSL_NO_MD4
#include <openssl/md4.h>
#endif
#ifndef OPENSSL_NO_MD5
#include <openssl/md5.h>     /* openssl-SNAP-20020227 does not automatically include this */
#endif
#if OPENSSL_VERSION_NUMBER >= 0x00905000L
#include <openssl/ripemd.h>
#endif
#include <openssl/x509.h>
#include <openssl/x509v3.h>
#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
/* requires 0.9.7+ */
#include <openssl/engine.h>
#endif
#ifdef OPENSSL_FIPS
#include <openssl/fips.h>
#endif
#if OPENSSL_VERSION_NUMBER >= 0x10000000L
#include <openssl/ocsp.h>
#endif
#undef BLOCK

/* Debugging output - to enable use:
 *
 * perl Makefile.PL DEFINE=-DSHOW_XS_DEBUG
 * make
 *
 */

#ifdef SHOW_XS_DEBUG
#define PR1(s) fprintf(stderr,s);
#define PR2(s,t) fprintf(stderr,s,t);
#define PR3(s,t,u) fprintf(stderr,s,t,u);
#define PR4(s,t,u,v) fprintf(stderr,s,t,u,v);
#else
#define PR1(s)
#define PR2(s,t)
#define PR3(s,t,u)
#define PR4(s,t,u,v)
#endif

static void TRACE(int level,char *msg,...) {
    va_list args;
    SV *trace = get_sv("Net::SSLeay::trace",0);
    if (trace && SvIOK(trace) && SvIV(trace)>=level) {
	char buf[4096];
	va_start(args,msg);
	vsnprintf(buf,4095,msg,args);
	warn("%s",buf);
    }
}

#include "constants.c"

/* ============= thread-safety related stuff ============== */

#define MY_CXT_KEY "Net::SSLeay::_guts" XS_VERSION

typedef struct {
    HV* global_cb_data;
    UV tid;
} my_cxt_t;
START_MY_CXT

#ifdef USE_ITHREADS
static perl_mutex LIB_init_mutex;
static perl_mutex *GLOBAL_openssl_mutex = NULL;
#endif
static int LIB_initialized;

UV get_my_thread_id(void) /* returns threads->tid() value */
{
    dSP;
    UV tid = 0;
    int count = 0;

#ifdef USE_ITHREADS
    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSVpv("threads", 0)));
    PUTBACK;
    count = call_method("tid", G_SCALAR|G_EVAL);
    SPAGAIN;
    if (SvTRUE(ERRSV) || count != 1)
       /* if threads not loaded or an error occurs return 0 */
       tid = 0;
    else
       tid = (UV)POPi;
    PUTBACK;
    FREETMPS;
    LEAVE;
#endif

    return tid;
}

/* IMPORTANT NOTE:
 * openssl locking was implemented according to http://www.openssl.org/docs/crypto/threads.html
 * we implement both static and dynamic locking as described on URL above
 * locking is supported when OPENSSL_THREADS macro is defined which means openssl-0.9.7 or newer
 * we intentionally do not implement cleanup of openssl's threading as it causes troubles
 * with apache-mpm-worker+mod_perl+mod_ssl+net-ssleay
 */
#if defined(USE_ITHREADS) && defined(OPENSSL_THREADS)

static void openssl_locking_function(int mode, int type, const char *file, int line)
{
    PR3("openssl_locking_function %d %d\n", mode, type);

    if (!GLOBAL_openssl_mutex) return;
    if (mode & CRYPTO_LOCK)
      MUTEX_LOCK(&GLOBAL_openssl_mutex[type]);
    else
      MUTEX_UNLOCK(&GLOBAL_openssl_mutex[type]);
}

#if OPENSSL_VERSION_NUMBER < 0x10000000L
static unsigned long openssl_threadid_func(void)
{
    dMY_CXT;
    return (unsigned long)(MY_CXT.tid);
}
#else
void openssl_threadid_func(CRYPTO_THREADID *id)
{
    dMY_CXT;
    CRYPTO_THREADID_set_numeric(id, (unsigned long)(MY_CXT.tid));
}
#endif

struct CRYPTO_dynlock_value
{
    perl_mutex mutex;
};

struct CRYPTO_dynlock_value * openssl_dynlocking_create_function (const char *file, int line)
{
    struct CRYPTO_dynlock_value *retval;
    New(0, retval, 1, struct CRYPTO_dynlock_value);
    if (!retval) return NULL;
    MUTEX_INIT(&retval->mutex);
    return retval;
}

void openssl_dynlocking_lock_function (int mode, struct CRYPTO_dynlock_value *l, const char *file, int line)
{
    if (!l) return;
    if (mode & CRYPTO_LOCK)
      MUTEX_LOCK(&l->mutex);
    else
      MUTEX_UNLOCK(&l->mutex);
}

void openssl_dynlocking_destroy_function (struct CRYPTO_dynlock_value *l, const char *file, int line)
{
    if (!l) return;
    MUTEX_DESTROY(&l->mutex);
    Safefree(l);
}

void openssl_threads_init(void)
{
    int i;

    PR1("STARTED: openssl_threads_init\n");

    /* initialize static locking */
    if ( !CRYPTO_get_locking_callback() ) {
#if OPENSSL_VERSION_NUMBER < 0x10000000L
        if ( !CRYPTO_get_id_callback() ) {
#else
        if ( !CRYPTO_THREADID_get_callback() ) {
#endif
            PR2("openssl_threads_init static locking %d\n", CRYPTO_num_locks());
            New(0, GLOBAL_openssl_mutex, CRYPTO_num_locks(), perl_mutex);
            if (!GLOBAL_openssl_mutex) return;
            for (i=0; i<CRYPTO_num_locks(); i++) MUTEX_INIT(&GLOBAL_openssl_mutex[i]);
            CRYPTO_set_locking_callback((void (*)(int,int,const char *,int))openssl_locking_function);

#ifndef WIN32
            /* no need for threadid_func() on Win32 */
#if OPENSSL_VERSION_NUMBER < 0x10000000L
            CRYPTO_set_id_callback(openssl_threadid_func);
#else
            CRYPTO_THREADID_set_callback(openssl_threadid_func);
#endif
#endif
        }
    }

    /* initialize dynamic locking */
    if ( !CRYPTO_get_dynlock_create_callback() &&
         !CRYPTO_get_dynlock_lock_callback() &&
         !CRYPTO_get_dynlock_destroy_callback() ) {
        PR1("openssl_threads_init dynamic locking\n");
        CRYPTO_set_dynlock_create_callback(openssl_dynlocking_create_function);
        CRYPTO_set_dynlock_lock_callback(openssl_dynlocking_lock_function);
        CRYPTO_set_dynlock_destroy_callback(openssl_dynlocking_destroy_function);
    }
}

#endif

/* ============= typedefs to agument TYPEMAP ============== */

typedef void callback_no_ret(void);
typedef RSA * cb_ssl_int_int_ret_RSA(SSL * ssl,int is_export, int keylength);
typedef DH * cb_ssl_int_int_ret_DH(SSL * ssl,int is_export, int keylength);

typedef STACK_OF(X509_NAME) X509_NAME_STACK;

typedef int perl_filehandle_t;

/* ======= special handler used by EVP_MD_do_all_sorted ======= */

#if OPENSSL_VERSION_NUMBER >= 0x1000000fL
static void handler_list_md_fn(const EVP_MD *m, const char *from, const char *to, void *arg)
{
  /* taken from apps/dgst.c */
  const char *mname;
  if (!m) return;                                           /* Skip aliases */
  mname = OBJ_nid2ln(EVP_MD_type(m));
  if (strcmp(from, mname)) return;                          /* Skip shortnames */
  if (EVP_MD_flags(m) & EVP_MD_FLAG_PKEY_DIGEST) return;    /* Skip clones */
  if (strchr(mname, ' ')) mname= EVP_MD_name(m);
  av_push(arg, newSVpv(mname,0));
}
#endif

/* ============= callbacks - basic info =============
 *
 * PLEASE READ THIS BEFORE YOU ADD ANY NEW CALLBACK!!
 *
 * There are basically 2 types of callbacks used in SSLeay:
 *
 * 1/ "one-time" callbacks - these are created+used+destroyed within one perl function implemented in XS
 *    these callbacks use a cpecial C structupe simple_cb_data_t to pass necessary data
 *    there are 2 related helper functions: simple_cb_data_new() + simple_cb_data_free
 *    for example see implementation of these functions:
 *    - RSA_generate_key
 *    - PEM_read_bio_PrivateKey
 *
 * 2/ "advanced" callbacks - these are setup/destroyed by one function but used by another function; these
 *    callbacks use global hash MY_CXT.global_cb_data to store perl functions + data to be uset at callback time
 *    there are 2 related helper functions: cb_data_advanced_put() + cb_data_advanced_get for manipulating
 *    global hash MY_CXT.global_cb_data which work like this:
 *        cb_data_advanced_put(<pointer>, "data_name", dataSV)
 *        >>>
 *        global_cb_data->{"ptr_<pointer>"}->{"data_name"} = dataSV)
 *    or
 *        data = cb_data_advanced_get(<pointer>, "data_name")
 *        >>>
 *        my $data = global_cb_data->{"ptr_<pointer>"}->{"data_name"}
 *    for example see implementation of these functions:
 *    - SSL_CTX_set_verify
 *    - SSL_set_verify
 *    - SSL_CTX_set_cert_verify_callback
 *    - SSL_CTX_set_default_passwd_cb
 *    - SSL_CTX_set_default_passwd_cb_userdata
 *    - SSL_set_session_secret_cb
 *
 * If you want to add a new callback:
 * - you very likely need a new function "your_callback_name_invoke()"
 * - decide whether your case fits case 1/ or 2/ (and implement likewise existing functions)
 * - try to avoid adding a new style of callback implementation (or ask Net::SSLeay maintainers before)
 *
 */

/* ============= callback stuff - generic functions============== */

struct _ssleay_cb_t {
    SV* func;
    SV* data;
};
typedef struct _ssleay_cb_t simple_cb_data_t;

simple_cb_data_t* simple_cb_data_new(SV* func, SV* data)
{
    simple_cb_data_t* cb;
    New(0, cb, 1, simple_cb_data_t);
    if (cb) {
        SvREFCNT_inc(func);
        SvREFCNT_inc(data);
        cb->func = func;
        cb->data = (data == &PL_sv_undef) ? NULL : data;
    }
    return cb;
}

void simple_cb_data_free(simple_cb_data_t* cb)
{
    if (cb) {
        if (cb->func) {
            SvREFCNT_dec(cb->func);
            cb->func = NULL;
        }
        if (cb->data) {
            SvREFCNT_dec(cb->data);
            cb->data = NULL;
        }
    }
    Safefree(cb);
}

int cb_data_advanced_put(void *ptr, const char* data_name, SV* data)
{
    HV * L2HV;
    SV ** svtmp;
    int len;
    char key_name[500];
    dMY_CXT;

    len = my_snprintf(key_name, sizeof(key_name), "ptr_%p", ptr);
    if (len == sizeof(key_name)) return 0; /* error  - key_name too short*/

    /* get or create level-2 hash */
    svtmp = hv_fetch(MY_CXT.global_cb_data, key_name, strlen(key_name), 0);
    if (svtmp == NULL) {
        L2HV = newHV();
        hv_store(MY_CXT.global_cb_data, key_name, strlen(key_name), newRV_noinc((SV*)L2HV), 0);
    }
    else {
        if (!SvOK(*svtmp) || !SvROK(*svtmp)) return 0;
#if defined(MUTABLE_PTR)
        L2HV = (HV*)MUTABLE_PTR(SvRV(*svtmp));
#else
        L2HV = (HV*)(SvRV(*svtmp));
#endif
    }

    /* first delete already stored value */
    hv_delete(L2HV, data_name, strlen(data_name), G_DISCARD);
    if (data!=NULL)
        if (SvOK(data))
            hv_store(L2HV, data_name, strlen(data_name), data, 0);

    return 1;
}

SV* cb_data_advanced_get(void *ptr, const char* data_name)
{
    HV * L2HV;
    SV ** svtmp;
    int len;
    char key_name[500];
    dMY_CXT;

    len = my_snprintf(key_name, sizeof(key_name), "ptr_%p", ptr);
    if (len == sizeof(key_name)) return &PL_sv_undef; /* return undef on error - key_name too short*/

    /* get level-2 hash */
    svtmp = hv_fetch(MY_CXT.global_cb_data, key_name, strlen(key_name), 0);
    if (svtmp == NULL)  return &PL_sv_undef;
    if (!SvOK(*svtmp))  return &PL_sv_undef;
    if (!SvROK(*svtmp)) return &PL_sv_undef;
#if defined(MUTABLE_PTR)
    L2HV = (HV*)MUTABLE_PTR(SvRV(*svtmp));
#else
    L2HV = (HV*)(SvRV(*svtmp));
#endif

    /* get stored data */
    svtmp = hv_fetch(L2HV, data_name, strlen(data_name), 0);
    if (svtmp == NULL) return &PL_sv_undef;
    if (!SvOK(*svtmp)) return &PL_sv_undef;

    return *svtmp;
}

int cb_data_advanced_drop(void *ptr)
{
    int len;
    char key_name[500];
    dMY_CXT;

    len = my_snprintf(key_name, sizeof(key_name), "ptr_%p", ptr);
    if (len == sizeof(key_name)) return 0; /* error  - key_name too short*/

    hv_delete(MY_CXT.global_cb_data, key_name, strlen(key_name), G_DISCARD);
    return 1;
}

/* ============= callback stuff - invoke functions ============== */

static int ssleay_verify_callback_invoke (int ok, X509_STORE_CTX* x509_store)
{
    dSP;
    SSL* ssl;
    int count = -1, res;
    SV *cb_func;

    PR1("STARTED: ssleay_verify_callback_invoke\n");
    ssl = X509_STORE_CTX_get_ex_data(x509_store, SSL_get_ex_data_X509_STORE_CTX_idx());
    cb_func = cb_data_advanced_get(ssl, "ssleay_verify_callback!!func");
    
    if (!SvOK(cb_func)) {
        SSL_CTX* ssl_ctx = SSL_get_SSL_CTX(ssl);
        cb_func = cb_data_advanced_get(ssl_ctx, "ssleay_verify_callback!!func");
     }
 
    if (!SvOK(cb_func))
        croak("Net::SSLeay: verify_callback called, but not set to point to any perl function.\n");

    ENTER;
    SAVETMPS;

    PR2("verify callback glue ok=%d\n", ok);

    PUSHMARK(sp);
    EXTEND( sp, 2 );
    PUSHs( sv_2mortal(newSViv(ok)) );
    PUSHs( sv_2mortal(newSViv(PTR2IV(x509_store))) );
    PUTBACK;

    PR1("About to call verify callback.\n");
    count = call_sv(cb_func, G_SCALAR);
    PR1("Returned from verify callback.\n");

    SPAGAIN;

    if (count != 1)
        croak ( "Net::SSLeay: verify_callback perl function did not return a scalar.\n");

    res = POPi;

    PUTBACK;
    FREETMPS;
    LEAVE;

    return res;
}

static int ssleay_ctx_passwd_cb_invoke(char *buf, int size, int rwflag, void *userdata)
{
    dSP;
    int count = -1;
    char *res;
    SV *cb_func, *cb_data;

    PR1("STARTED: ssleay_ctx_passwd_cb_invoke\n");
    cb_func = cb_data_advanced_get(userdata, "ssleay_ctx_passwd_cb!!func");
    cb_data = cb_data_advanced_get(userdata, "ssleay_ctx_passwd_cb!!data");

    if(!SvOK(cb_func))
        croak ("Net::SSLeay: ssleay_ctx_passwd_cb_invoke called, but not set to point to any perl function.\n");

    ENTER;
    SAVETMPS;

    PUSHMARK(sp);
    XPUSHs(sv_2mortal(newSViv(rwflag)));
    XPUSHs(sv_2mortal(newSVsv(cb_data)));
    PUTBACK;

    count = call_sv( cb_func, G_SCALAR );

    SPAGAIN;

    if (count != 1)
        croak("Net::SSLeay: ssleay_ctx_passwd_cb_invoke perl function did not return a scalar.\n");

    res = POPp;

    if (res == NULL) {
        *buf = '\0';
    } else {
        strncpy(buf, res, size);
        buf[size - 1] = '\0';
    }

    PUTBACK;
    FREETMPS;
    LEAVE;

    return strlen(buf);
}

int ssleay_ctx_cert_verify_cb_invoke(X509_STORE_CTX* x509_store_ctx, void* data)
{
    dSP;
    int count = -1;
    int res;
    SV * cb_func, *cb_data;
    void *ptr;
    SSL *ssl;

    PR1("STARTED: ssleay_ctx_cert_verify_cb_invoke\n");
#if OPENSSL_VERSION_NUMBER < 0x0090700fL
    ssl = X509_STORE_CTX_get_ex_data(x509_store_ctx, SSL_get_ex_data_X509_STORE_CTX_idx());
    ptr = (void*) SSL_get_SSL_CTX(ssl);
#else
    ssl = NULL;
    ptr = (void*) data;
#endif

    cb_func = cb_data_advanced_get(ptr, "ssleay_ctx_cert_verify_cb!!func");
    cb_data = cb_data_advanced_get(ptr, "ssleay_ctx_cert_verify_cb!!data");

    if(!SvOK(cb_func))
        croak ("Net::SSLeay: ssleay_ctx_cert_verify_cb_invoke called, but not set to point to any perl function.\n");

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(PTR2IV(x509_store_ctx))));
    XPUSHs(sv_2mortal(newSVsv(cb_data)));
    PUTBACK;

    count = call_sv(cb_func, G_SCALAR);

    SPAGAIN;

    if (count != 1)
        croak("Net::SSLeay: ssleay_ctx_cert_verify_cb_invoke perl function did not return a scalar.\n");

    res = POPi;

    PUTBACK;
    FREETMPS;
    LEAVE;

    return res;
}

#if OPENSSL_VERSION_NUMBER >= 0x0090806fL && !defined(OPENSSL_NO_TLSEXT)

int tlsext_servername_callback_invoke(SSL *ssl, int *ad, void *arg)
{
    dSP;
    int count = -1;
    int res;
    SV * cb_func, *cb_data;

    PR1("STARTED: tlsext_servername_callback_invoke\n");

    cb_func = cb_data_advanced_get(arg, "tlsext_servername_callback!!func");
    cb_data = cb_data_advanced_get(arg, "tlsext_servername_callback!!data");

    if(!SvOK(cb_func))
        croak ("Net::SSLeay: tlsext_servername_callback_invoke called, but not set to point to any perl function.\n");

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(PTR2IV(ssl))));
    XPUSHs(sv_2mortal(newSVsv(cb_data)));
    PUTBACK;

    count = call_sv(cb_func, G_SCALAR);

    SPAGAIN;

    if (count != 1)
        croak("Net::SSLeay: tlsext_servername_callback_invoke perl function did not return a scalar.\n");

    res = POPi;

    PUTBACK;
    FREETMPS;
    LEAVE;

    return res;
}

#endif

#if OPENSSL_VERSION_NUMBER >= 0x10000000L && !defined(OPENSSL_NO_TLSEXT)

int tlsext_status_cb_invoke(SSL *ssl, void *arg)
{
    dSP;
    SV *cb_func, *cb_data;
    SSL_CTX *ctx = SSL_get_SSL_CTX(ssl);
    int len,res,nres = -1;
    const unsigned char *p = NULL;
    OCSP_RESPONSE *ocsp_response = NULL;

    cb_func = cb_data_advanced_get(ctx, "tlsext_status_cb!!func");
    cb_data = cb_data_advanced_get(ctx, "tlsext_status_cb!!data");

    if ( ! SvROK(cb_func) || (SvTYPE(SvRV(cb_func)) != SVt_PVCV))
	croak ("Net::SSLeay: tlsext_status_cb_invoke called, but not set to point to any perl function.\n");

    len = SSL_get_tlsext_status_ocsp_resp(ssl, &p);
    if (p) ocsp_response = d2i_OCSP_RESPONSE(NULL, &p, len);

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(PTR2IV(ssl))));
    PUSHs( sv_2mortal(newSViv(PTR2IV(ocsp_response))) );
    XPUSHs(sv_2mortal(newSVsv(cb_data)));
    PUTBACK;

    nres = call_sv(cb_func, G_SCALAR);
    OCSP_RESPONSE_free(ocsp_response);

    SPAGAIN;

    if (nres != 1)
	croak("Net::SSLeay: tlsext_status_cb_invoke perl function did not return a scalar.\n");

    res = POPi;

    PUTBACK;
    FREETMPS;
    LEAVE;

    return res;
}

#endif

#if defined(SSL_F_SSL_SET_HELLO_EXTENSION) || defined(SSL_F_SSL_SET_SESSION_TICKET_EXT)

int ssleay_session_secret_cb_invoke(SSL* s, void* secret, int *secret_len,
                                    STACK_OF(SSL_CIPHER) *peer_ciphers,
                                    SSL_CIPHER **cipher, void *arg)
{
    dSP;
    int count = -1, res, i;
    AV *ciphers = newAV();
    SV *pref_cipher = sv_newmortal();
    SV * cb_func, *cb_data;

    PR1("STARTED: ssleay_session_secret_cb_invoke\n");
    cb_func = cb_data_advanced_get(arg, "ssleay_session_secret_cb!!func");
    cb_data = cb_data_advanced_get(arg, "ssleay_session_secret_cb!!data");

    if(!SvOK(cb_func))
        croak ("Net::SSLeay: ssleay_ctx_passwd_cb_invoke called, but not set to point to any perl function.\n");

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);

    XPUSHs( sv_2mortal( newSVpv(secret, *secret_len)) );
    for (i=0; i<sk_SSL_CIPHER_num(peer_ciphers); i++) {
        SSL_CIPHER *c = sk_SSL_CIPHER_value(peer_ciphers,i);
        av_store(ciphers, i, sv_2mortal(newSVpv(SSL_CIPHER_get_name(c), 0)));
    }
    XPUSHs(sv_2mortal(newRV_inc((SV*)ciphers)));
    XPUSHs(sv_2mortal(newRV_inc(pref_cipher)));
    XPUSHs(sv_2mortal(newSVsv(cb_data)));

    PUTBACK;

    count = call_sv( cb_func, G_SCALAR );

    SPAGAIN;

    if (count != 1)
        croak ("Net::SSLeay: ssleay_session_secret_cb_invoke perl function did not return a scalar.\n");

    res = POPi;
    if (res) {
        /* See if there is a preferred cipher selected, if so it is an index into the stack */
        if (SvIOK(pref_cipher))
            *cipher = sk_SSL_CIPHER_value(peer_ciphers, SvIV(pref_cipher));
    }

    PUTBACK;
    FREETMPS;
    LEAVE;

    return res;
}

#endif

#if OPENSSL_VERSION_NUMBER >= 0x10001000L && !defined(OPENSSL_NO_NEXTPROTONEG)

int next_proto_helper_AV2protodata(AV * list, unsigned char *out)
{
    int i, last_index, ptr = 0;
    last_index = av_len(list);
    if (last_index<0) return 0;
    for(i=0; i<=last_index; i++) {
        char *p = SvPV_nolen(*av_fetch(list, i, 0));
        size_t len = strlen(p);
        if (len>255) return 0;
        if (out) {
            /* if out == NULL we only calculate the length of output */
            out[ptr] = (unsigned char)len;
            strncpy((char*)out+ptr+1, p, len);
        }
        ptr += strlen(p) + 1;
    }
    return ptr;
}

int next_proto_helper_protodata2AV(AV * list, const unsigned char *in, unsigned int inlen)
{
    unsigned int i = 0;
    unsigned char il;
    if (!list || inlen<2) return 0;   
    while (i<inlen) {
        il = in[i++];
        if (i+il > inlen) return 0;
        av_push(list, newSVpv((const char*)in+i, il));
        i += il;
    }
    return 1;
}

int next_proto_select_cb_invoke(SSL *ssl, unsigned char **out, unsigned char *outlen,
                                const unsigned char *in, unsigned int inlen, void *arg)
{
    SV *cb_func, *cb_data;
    unsigned char *next_proto_data;
    size_t next_proto_len;
    int next_proto_status;
    SSL_CTX *ctx = SSL_get_SSL_CTX(ssl);
    /* this n_a is required for building with old perls: */
    STRLEN n_a;

    PR1("STARTED: next_proto_select_cb_invoke\n");
    cb_func = cb_data_advanced_get(ctx, "next_proto_select_cb!!func");
    cb_data = cb_data_advanced_get(ctx, "next_proto_select_cb!!data");
    /* clear last_status value = store undef */
    cb_data_advanced_put(ssl, "next_proto_select_cb!!last_status", NULL);
    cb_data_advanced_put(ssl, "next_proto_select_cb!!last_negotiated", NULL);

    if (SvROK(cb_func) && (SvTYPE(SvRV(cb_func)) == SVt_PVCV)) {
        int count = -1;
        AV *list = newAV();
        SV *tmpsv;
        dSP;
        
        if (!next_proto_helper_protodata2AV(list, in, inlen)) return SSL_TLSEXT_ERR_ALERT_FATAL;

        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
        XPUSHs(sv_2mortal(newSViv(PTR2IV(ssl))));
        XPUSHs(sv_2mortal(newRV_inc((SV*)list)));
        XPUSHs(sv_2mortal(newSVsv(cb_data)));
        PUTBACK;
        count = call_sv( cb_func, G_ARRAY );
        SPAGAIN;
        if (count != 2)
            croak ("Net::SSLeay: next_proto_select_cb_invoke perl function did not return 2 values.\n");
        next_proto_data = (unsigned char*)POPpx;
        next_proto_status = POPi;

        next_proto_len = strlen((const char*)next_proto_data);
        if (next_proto_len<=255) {
          /* store last_status + last_negotiated into global hash */
          cb_data_advanced_put(ssl, "next_proto_select_cb!!last_status", newSViv(next_proto_status));
          tmpsv = newSVpv((const char*)next_proto_data, next_proto_len);
          cb_data_advanced_put(ssl, "next_proto_select_cb!!last_negotiated", tmpsv);
          *out = (unsigned char *)SvPVX(tmpsv);
          *outlen = next_proto_len;
        }

        PUTBACK;
        FREETMPS;
        LEAVE;

        return next_proto_len>255 ? SSL_TLSEXT_ERR_ALERT_FATAL : SSL_TLSEXT_ERR_OK;
    }
    else if (SvROK(cb_data) && (SvTYPE(SvRV(cb_data)) == SVt_PVAV)) {
        next_proto_len = next_proto_helper_AV2protodata((AV*)SvRV(cb_data), NULL);
        Newx(next_proto_data, next_proto_len, unsigned char);
        if (!next_proto_data) return SSL_TLSEXT_ERR_ALERT_FATAL;
        next_proto_len = next_proto_helper_AV2protodata((AV*)SvRV(cb_data), next_proto_data);

        next_proto_status = SSL_select_next_proto(out, outlen, in, inlen, next_proto_data, next_proto_len);

        /* store last_status + last_negotiated into global hash */
        cb_data_advanced_put(ssl, "next_proto_select_cb!!last_status", newSViv(next_proto_status));
        cb_data_advanced_put(ssl, "next_proto_select_cb!!last_negotiated", newSVpv((const char*)*out, *outlen));
        Safefree(next_proto_data);
        return SSL_TLSEXT_ERR_OK;
    }
    return SSL_TLSEXT_ERR_ALERT_FATAL;
}

int next_protos_advertised_cb_invoke(SSL *ssl, const unsigned char **out, unsigned int *outlen, void *arg_unused)
{
    SV *cb_func, *cb_data;
    unsigned char *protodata = NULL;
    unsigned short protodata_len = 0;
    SV *tmpsv;
    AV *tmpav;
    SSL_CTX *ctx = SSL_get_SSL_CTX(ssl);

    PR1("STARTED: next_protos_advertised_cb_invoke");
    cb_func = cb_data_advanced_get(ctx, "next_protos_advertised_cb!!func");
    cb_data = cb_data_advanced_get(ctx, "next_protos_advertised_cb!!data");

    if (SvROK(cb_func) && (SvTYPE(SvRV(cb_func)) == SVt_PVCV)) {
        int count = -1;
        dSP;
        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
        XPUSHs(sv_2mortal(newSViv(PTR2IV(ssl))));
        XPUSHs(sv_2mortal(newSVsv(cb_data)));
        PUTBACK;
        count = call_sv( cb_func, G_SCALAR );
        SPAGAIN;
        if (count != 1)
            croak ("Net::SSLeay: next_protos_advertised_cb_invoke perl function did not return scalar value.\n");
        tmpsv = POPs;
        if (SvOK(tmpsv) && SvROK(tmpsv) && (SvTYPE(SvRV(tmpsv)) == SVt_PVAV)) {
            tmpav = (AV*)SvRV(tmpsv);
            protodata_len = next_proto_helper_AV2protodata(tmpav, NULL);
            Newx(protodata, protodata_len, unsigned char);
            if (protodata) next_proto_helper_AV2protodata(tmpav, protodata);
        }
        PUTBACK;
        FREETMPS;
        LEAVE;
    }
    else if (SvROK(cb_data) && (SvTYPE(SvRV(cb_data)) == SVt_PVAV)) {
        tmpav = (AV*)SvRV(cb_data);
        protodata_len = next_proto_helper_AV2protodata(tmpav, NULL);
        Newx(protodata, protodata_len, unsigned char);
        if (protodata) next_proto_helper_AV2protodata(tmpav, protodata);
    }    
    if (protodata) {
        tmpsv = newSVpv((const char*)protodata, protodata_len);
        Safefree(protodata);
        cb_data_advanced_put(ssl, "next_protos_advertised_cb!!last_advertised", tmpsv);
        *out = (unsigned char *)SvPVX(tmpsv);
        *outlen = protodata_len;
        return SSL_TLSEXT_ERR_OK;
    }
    return SSL_TLSEXT_ERR_ALERT_FATAL;
}

#endif

#if OPENSSL_VERSION_NUMBER >= 0x10002000L && !defined(OPENSSL_NO_TLSEXT)

int alpn_select_cb_invoke(SSL *ssl, const unsigned char **out, unsigned char *outlen,
                                const unsigned char *in, unsigned int inlen, void *arg)
{
    SV *cb_func, *cb_data;
    unsigned char *alpn_data;
    size_t alpn_len;
    SSL_CTX *ctx = SSL_get_SSL_CTX(ssl);

    PR1("STARTED: alpn_select_cb_invoke\n");
    cb_func = cb_data_advanced_get(ctx, "alpn_select_cb!!func");
    cb_data = cb_data_advanced_get(ctx, "alpn_select_cb!!data");

    if (SvROK(cb_func) && (SvTYPE(SvRV(cb_func)) == SVt_PVCV)) {
        int count = -1;
        AV *list = newAV();
        SV *tmpsv;
        SV *alpn_data_sv;
        dSP;

        if (!next_proto_helper_protodata2AV(list, in, inlen)) return SSL_TLSEXT_ERR_ALERT_FATAL;

        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
        XPUSHs(sv_2mortal(newSViv(PTR2IV(ssl))));
        XPUSHs(sv_2mortal(newRV_inc((SV*)list)));
        XPUSHs(sv_2mortal(newSVsv(cb_data)));
        PUTBACK;
        count = call_sv( cb_func, G_ARRAY );
        SPAGAIN;
        if (count != 1)
            croak ("Net::SSLeay: alpn_select_cb perl function did not return exactly 1 value.\n");
        alpn_data_sv = POPs;
        if (SvOK(alpn_data_sv)) {
          alpn_data = (unsigned char*)SvPV_nolen(alpn_data_sv);
          alpn_len = strlen((const char*)alpn_data);
          if (alpn_len <= 255) {
            tmpsv = newSVpv((const char*)alpn_data, alpn_len);
            *out = (unsigned char *)SvPVX(tmpsv);
            *outlen = alpn_len;
          }
        } else {
          alpn_data = NULL;
          alpn_len = 0;
        }
        PUTBACK;
        FREETMPS;
        LEAVE;

        if (alpn_len>255) return SSL_TLSEXT_ERR_ALERT_FATAL;
        return alpn_data ? SSL_TLSEXT_ERR_OK : SSL_TLSEXT_ERR_NOACK;
    }
    else if (SvROK(cb_data) && (SvTYPE(SvRV(cb_data)) == SVt_PVAV)) {
        int status;

        alpn_len = next_proto_helper_AV2protodata((AV*)SvRV(cb_data), NULL);
        Newx(alpn_data, alpn_len, unsigned char);
        if (!alpn_data) return SSL_TLSEXT_ERR_ALERT_FATAL;
        alpn_len = next_proto_helper_AV2protodata((AV*)SvRV(cb_data), alpn_data);

        /* This is the same function that is used for NPN. */
        status = SSL_select_next_proto((unsigned char **)out, outlen, in, inlen, alpn_data, alpn_len);
        Safefree(alpn_data);
        return status == OPENSSL_NPN_NEGOTIATED ? SSL_TLSEXT_ERR_OK : SSL_TLSEXT_ERR_NOACK;
    }
    return SSL_TLSEXT_ERR_ALERT_FATAL;
}

#endif

int pem_password_cb_invoke(char *buf, int bufsize, int rwflag, void *data) {
    dSP;
    char *str;
    int count = -1;
    size_t str_len = 0;
    simple_cb_data_t* cb = (simple_cb_data_t*)data;
    /* this n_a is required for building with old perls: */
    STRLEN n_a;

    PR1("STARTED: pem_password_cb_invoke\n");
    if (cb->func && SvOK(cb->func)) {
        ENTER;
        SAVETMPS;

        PUSHMARK(sp);

        XPUSHs(sv_2mortal( newSViv(bufsize-1) ));
        XPUSHs(sv_2mortal( newSViv(rwflag) ));
        if (cb->data) XPUSHs( cb->data );

        PUTBACK;

        count = call_sv( cb->func, G_SCALAR );

        SPAGAIN;

        buf[0] = 0; /* start with an empty password */
        if (count != 1) {
            croak("Net::SSLeay: pem_password_cb_invoke perl function did not return a scalar.\n");
        }
        else {
            str = POPpx;
            str_len = strlen(str);
            if (str_len+1 < bufsize) {
                strcpy(buf, str);
            }
            else {
                str_len = 0;
                warn("Net::SSLeay: pem_password_cb_invoke password too long\n");
            }
        }

        PUTBACK;
        FREETMPS;
        LEAVE;
    }
    return str_len;
}

void ssleay_RSA_generate_key_cb_invoke(int i, int n, void* data)
{
    dSP;
    int count = -1;
    simple_cb_data_t* cb = (simple_cb_data_t*)data;

    /* PR1("STARTED: ssleay_RSA_generate_key_cb_invoke\n"); / * too noisy */
    if (cb->func && SvOK(cb->func)) {
        ENTER;
        SAVETMPS;

        PUSHMARK(sp);

        XPUSHs(sv_2mortal( newSViv(i) ));
        XPUSHs(sv_2mortal( newSViv(n) ));
        if (cb->data) XPUSHs( cb->data );

        PUTBACK;

        count = call_sv( cb->func, G_VOID|G_DISCARD );

        if (count != 0)
            croak ("Net::SSLeay: ssleay_RSA_generate_key_cb_invoke "
                   "perl function did return something in void context.\n");

        SPAGAIN;
        FREETMPS;
        LEAVE;
    }
}

void ssleay_info_cb_invoke(const SSL *ssl, int where, int ret)
{
    dSP;
    SV *cb_func, *cb_data;

    cb_func = cb_data_advanced_get((void*)ssl, "ssleay_info_cb!!func");
    cb_data = cb_data_advanced_get((void*)ssl, "ssleay_info_cb!!data");

    if ( ! SvROK(cb_func) || (SvTYPE(SvRV(cb_func)) != SVt_PVCV))
	croak ("Net::SSLeay: ssleay_info_cb_invoke called, but not set to point to any perl function.\n");

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(PTR2IV(ssl))));
    XPUSHs(sv_2mortal(newSViv(where)) );
    XPUSHs(sv_2mortal(newSViv(ret)) );
    XPUSHs(sv_2mortal(newSVsv(cb_data)));
    PUTBACK;

    call_sv(cb_func, G_VOID);

    SPAGAIN;
    PUTBACK;
    FREETMPS;
    LEAVE;
}

void ssleay_ctx_info_cb_invoke(const SSL *ssl, int where, int ret)
{
    dSP;
    SV *cb_func, *cb_data;
    SSL_CTX *ctx = SSL_get_SSL_CTX(ssl);

    cb_func = cb_data_advanced_get(ctx, "ssleay_ctx_info_cb!!func");
    cb_data = cb_data_advanced_get(ctx, "ssleay_ctx_info_cb!!data");

    if ( ! SvROK(cb_func) || (SvTYPE(SvRV(cb_func)) != SVt_PVCV))
	croak ("Net::SSLeay: ssleay_ctx_info_cb_invoke called, but not set to point to any perl function.\n");

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(PTR2IV(ssl))));
    XPUSHs(sv_2mortal(newSViv(where)) );
    XPUSHs(sv_2mortal(newSViv(ret)) );
    XPUSHs(sv_2mortal(newSVsv(cb_data)));
    PUTBACK;

    call_sv(cb_func, G_VOID);

    SPAGAIN;
    PUTBACK;
    FREETMPS;
    LEAVE;
}


/* ============= end of callback stuff, begin helper functions ============== */

time_t ASN1_TIME_timet(ASN1_TIME *asn1t) {
    struct tm t;
    const char *p = (const char*) asn1t->data;
    size_t msec = 0, tz = 0, i, l;
    time_t result;
    int adj = 0;

    if (asn1t->type == V_ASN1_UTCTIME) {
	if (asn1t->length<12 || asn1t->length>17) return 0;
	if (asn1t->length>12) tz = 12;
    } else {
	if (asn1t->length<14) return 0;
	if (asn1t->length>14) {
	    if (p[14] == '.') {
		msec = 14;
		for(i=msec+1;i<asn1t->length && p[i]>='0' && p[i]<='9';i++) ;
		if (i<asn1t->length) tz = i;
	    } else {
		tz = 14;
	    }
	}
    }

    l = msec ? msec : tz ? tz : asn1t->length;
    for(i=0;i<l;i++) {
	if (p[i]<'0' || p[i]>'9') return 0;
    }

    /* extract data and time */
    memset(&t,0,sizeof(t));
    if (asn1t->type == V_ASN1_UTCTIME) { /* YY - two digit year */
	t.tm_year = (p[0]-'0')*10 + (p[1]-'0');
	if (t.tm_year < 70) t.tm_year += 100;
	i=2;
    } else { /* YYYY */
	t.tm_year = (p[0]-'0')*1000 + (p[1]-'0')*100 + (p[2]-'0')*10 + p[3]-'0';
	t.tm_year -= 1900;
	i=4;
    }
    t.tm_mon  = (p[i+0]-'0')*10 + (p[i+1]-'0') -1; /* MM, starts with 0 in tm */
    t.tm_mday = (p[i+2]-'0')*10 + (p[i+3]-'0');    /* DD */
    t.tm_hour = (p[i+4]-'0')*10 + (p[i+5]-'0');    /* hh */
    t.tm_min  = (p[i+6]-'0')*10 + (p[i+7]-'0');    /* mm */
    t.tm_sec  = (p[i+8]-'0')*10 + (p[i+9]-'0');    /* ss */

    /* skip msec, because time_t does not support it */

    if (tz) {
	/* TZ is 'Z' or [+-]DDDD and after TZ the string must stop*/
	if (p[tz] == 'Z') {
	    if (asn1t->length>tz+1 ) return 0;
	} else if (asn1t->length<tz+5 || (p[tz]!='-' && p[tz]!='+')) {
	    return 0;
	} else {
	    if (asn1t->length>tz+5 ) return 0;
	    for(i=tz+1;i<tz+5;i++) {
		if (p[i]<'0' || p[i]>'9') return 0;
	    }
	    adj = ((p[tz+1]-'0')*10 + (p[tz+2]-'0'))*3600
		+ ((p[tz+3]-'0')*10 + (p[tz+4]-'0'))*60;
	    if (p[tz]=='+') adj*= -1; /* +0500: subtract 5 hours to get UTC */
	}
    }

    result = mktime(&t);
    if (result == -1) return 0; /* broken time */
    return result + adj + ( t.tm_isdst ? 3600:0 );
}

X509 * find_issuer(X509 *cert,X509_STORE *store, STACK_OF(X509) *chain) {
    int i;
    X509 *issuer = NULL;

    /* search first in the chain */
    if (chain) {
	for(i=0;i<sk_X509_num(chain);i++) {
	    if ( X509_check_issued(sk_X509_value(chain,i),cert) == X509_V_OK ) {
		TRACE(2,"found issuer in chain");
		issuer = sk_X509_value(chain,i);
	    }
	}
    }
    /* if not in the chain it might be in the store */
    if ( !issuer && store ) {
	X509_STORE_CTX *stx = X509_STORE_CTX_new();
	if (stx && X509_STORE_CTX_init(stx,store,cert,NULL)) {
	    int ok = X509_STORE_CTX_get1_issuer(&issuer,stx,cert);
	    if (ok<0) {
		int err = ERR_get_error();
		if(err) {
		    TRACE(2,"failed to get issuer: %s",ERR_error_string(err,NULL));
		} else {
		    TRACE(2,"failed to get issuer: unknown error");
		}
	    } else if (ok == 0 ) {
		TRACE(2,"failed to get issuer(0)");
	    } else {
		TRACE(2,"got issuer");
	    }
	}
	if (stx) X509_STORE_CTX_free(stx);
    }
    return issuer;
}

/* ============= end of helper functions ============== */

#line 1344 "SSLeay.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1488 "SSLeay.c"

XS_EUPXS(XS_Net__SSLeay_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CLONE)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 1362 "SSLeay.xs"
    MY_CXT_CLONE;
    /* reset all callback related data as we want to prevent 
     * cross-thread callbacks
     * TODO: later somebody can make the global hash MY_CXT.global_cb_data
     * somehow shared between threads
     */
    MY_CXT.global_cb_data = newHV();
    MY_CXT.tid = get_my_thread_id();
    PR3("CLONE: tid=%d my_perl=0x%p\n", MY_CXT.tid, my_perl);
#line 1506 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	char *	name = (char *)SvPV_nolen(ST(0))
;
	double	RETVAL;
	dXSTARG;
#line 1376 "SSLeay.xs"
        errno = 0;
        RETVAL = constant(name, strlen(name));
#line 1526 "SSLeay.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_hello); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_hello)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1384 "SSLeay.xs"
        PR1("\tSSLeay Hello World!\n");
        RETVAL = 1;
#line 1545 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define REM0 "============= version related functions =============="

XS_EUPXS(XS_Net__SSLeay_SSLeay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SSLeay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	unsigned long	RETVAL;
	dXSTARG;

	RETVAL = SSLeay();
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SSLeay_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SSLeay_version)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "type=0");
    {
	int	type;
	const char *	RETVAL;
	dXSTARG;

	if (items < 1)
	    type = 0;
	else {
	    type = (int)SvIV(ST(0))
;
	}

	RETVAL = SSLeay_version(type);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#define REM1 "============= SSL CONTEXT functions =============="

XS_EUPXS(XS_Net__SSLeay_CTX_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1403 "SSLeay.xs"
     RETVAL = SSL_CTX_new (SSLv23_method());
#line 1607 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#ifndef OPENSSL_NO_SSL2
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Net__SSLeay_CTX_v2_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_v2_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1412 "SSLeay.xs"
     RETVAL = SSL_CTX_new (SSLv2_method());
#line 1628 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#ifndef OPENSSL_NO_SSL3
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Net__SSLeay_CTX_v3_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_v3_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1423 "SSLeay.xs"
     RETVAL = SSL_CTX_new (SSLv3_method());
#line 1650 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_CTX_v23_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_v23_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1432 "SSLeay.xs"
     RETVAL = SSL_CTX_new (SSLv23_method());
#line 1669 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_tlsv1_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_tlsv1_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1439 "SSLeay.xs"
     RETVAL = SSL_CTX_new (TLSv1_method());
#line 1687 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#ifdef SSL_TXT_TLSV1_1
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Net__SSLeay_CTX_tlsv1_1_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_tlsv1_1_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1448 "SSLeay.xs"
     RETVAL = SSL_CTX_new (TLSv1_1_method());
#line 1708 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#ifdef SSL_TXT_TLSV1_2
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Net__SSLeay_CTX_tlsv1_2_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_tlsv1_2_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1459 "SSLeay.xs"
     RETVAL = SSL_CTX_new (TLSv1_2_method());
#line 1730 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_CTX_new_with_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_new_with_method)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "meth");
    {
	SSL_METHOD *	meth = INT2PTR(SSL_METHOD *,SvIV(ST(0)))
;
	SSL_CTX *	RETVAL;
	dXSTARG;
#line 1469 "SSLeay.xs"
     RETVAL = SSL_CTX_new (meth);
#line 1751 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
#line 1477 "SSLeay.xs"
        cb_data_advanced_drop(ctx); /* clean callback related data from global hash */
        SSL_CTX_free(ctx);
#line 1770 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_add_session); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_add_session)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, ses");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_add_session(ctx, ses);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_remove_session); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_remove_session)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, ses");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_remove_session(ctx, ses);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_flush_sessions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_flush_sessions)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, tm");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	tm = (long)SvIV(ST(1))
;

	SSL_CTX_flush_sessions(ctx, tm);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_default_verify_paths); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_default_verify_paths)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_default_verify_paths(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_load_verify_locations); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_load_verify_locations)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, CAfile, CApath");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	char *	CAfile = (char *)SvPV_nolen(ST(1))
;
	char *	CApath = (char *)SvPV_nolen(ST(2))
;
	int	RETVAL;
	dXSTARG;
#line 1505 "SSLeay.xs"
     RETVAL = SSL_CTX_load_verify_locations (ctx,
					     CAfile?(*CAfile?CAfile:NULL):NULL,
					     CApath?(*CApath?CApath:NULL):NULL
					     );
#line 1875 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_verify)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, mode, callback=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	mode = (int)SvIV(ST(1))
;
	SV *	callback;

	if (items < 3)
	    callback = &PL_sv_undef;
	else {
	    callback = ST(2)
;
	}
#line 1519 "SSLeay.xs"
    /* Former versions of SSLeay checked if the callback was a true boolean value
     * and didn't call it if it was false. Therefor some people set the callback
     * to '0' if they don't want to use it (IO::Socket::SSL for example). Therefor
     * we don't execute the callback if it's value isn't something true to retain
     * backwards compatibility.
     */

    if (callback==NULL || !SvOK(callback) || !SvTRUE(callback)) {
        SSL_CTX_set_verify(ctx, mode, NULL);
        cb_data_advanced_put(ctx, "ssleay_verify_callback!!func", NULL);
    } else {
        cb_data_advanced_put(ctx, "ssleay_verify_callback!!func", newSVsv(callback));
        SSL_CTX_set_verify(ctx, mode, &ssleay_verify_callback_invoke);
    }
#line 1916 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_get_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_error)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, ret");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	ret = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_error(s, ret);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define REM10 "============= SSL functions =============="

XS_EUPXS(XS_Net__SSLeay_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SSL *	RETVAL;
	dXSTARG;

	RETVAL = SSL_new(ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
#line 1549 "SSLeay.xs"
        cb_data_advanced_drop(s); /* clean callback related data from global hash */
        SSL_free(s);
#line 1975 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#if 0 /* this seems to be gone in 0.9.0 */
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Net__SSLeay_debug); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_debug)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "file");
    {
	char *	file = (char *)SvPV_nolen(ST(0))
;

	SSL_debug(file);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Net__SSLeay_accept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_accept)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_accept(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_clear)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;

	SSL_clear(s);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_connect)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_connect(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if defined(WIN32)
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Net__SSLeay_set_fd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_fd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, fd");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	perl_filehandle_t	fd;
	int	RETVAL;
	dXSTARG;

	if (ST(1) && SvOK(ST(1)) && SvROK(ST(1))) {
		fd = (perl_filehandle_t)PerlIO_fileno( IoIFP( sv_2io(SvRV(ST(1))) ) );
	} else {
		fd = (perl_filehandle_t)SvIV(ST(1));
	}
;
#line 1579 "SSLeay.xs"
     RETVAL = SSL_set_fd(s,_get_osfhandle(fd));
#line 2079 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_rfd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_rfd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, fd");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	perl_filehandle_t	fd;
	int	RETVAL;
	dXSTARG;

	if (ST(1) && SvOK(ST(1)) && SvROK(ST(1))) {
		fd = (perl_filehandle_t)PerlIO_fileno( IoIFP( sv_2io(SvRV(ST(1))) ) );
	} else {
		fd = (perl_filehandle_t)SvIV(ST(1));
	}
;
#line 1588 "SSLeay.xs"
     RETVAL = SSL_set_rfd(s,_get_osfhandle(fd));
#line 2107 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_wfd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_wfd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, fd");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	perl_filehandle_t	fd;
	int	RETVAL;
	dXSTARG;

	if (ST(1) && SvOK(ST(1)) && SvROK(ST(1))) {
		fd = (perl_filehandle_t)PerlIO_fileno( IoIFP( sv_2io(SvRV(ST(1))) ) );
	} else {
		fd = (perl_filehandle_t)SvIV(ST(1));
	}
;
#line 1597 "SSLeay.xs"
     RETVAL = SSL_set_wfd(s,_get_osfhandle(fd));
#line 2135 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Net__SSLeay_set_fd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_fd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, fd");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	perl_filehandle_t	fd;
	int	RETVAL;
	dXSTARG;

	if (ST(1) && SvOK(ST(1)) && SvROK(ST(1))) {
		fd = (perl_filehandle_t)PerlIO_fileno( IoIFP( sv_2io(SvRV(ST(1))) ) );
	} else {
		fd = (perl_filehandle_t)SvIV(ST(1));
	}
;

	RETVAL = SSL_set_fd(s, fd);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_rfd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_rfd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, fd");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	perl_filehandle_t	fd;
	int	RETVAL;
	dXSTARG;

	if (ST(1) && SvOK(ST(1)) && SvROK(ST(1))) {
		fd = (perl_filehandle_t)PerlIO_fileno( IoIFP( sv_2io(SvRV(ST(1))) ) );
	} else {
		fd = (perl_filehandle_t)SvIV(ST(1));
	}
;

	RETVAL = SSL_set_rfd(s, fd);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_wfd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_wfd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, fd");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	perl_filehandle_t	fd;
	int	RETVAL;
	dXSTARG;

	if (ST(1) && SvOK(ST(1)) && SvROK(ST(1))) {
		fd = (perl_filehandle_t)PerlIO_fileno( IoIFP( sv_2io(SvRV(ST(1))) ) );
	} else {
		fd = (perl_filehandle_t)SvIV(ST(1));
	}
;

	RETVAL = SSL_set_wfd(s, fd);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_get_fd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_fd)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_fd(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_read)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, max=32768");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	max;
#line 1629 "SSLeay.xs"
	char *buf;
	int got;
#line 2261 "SSLeay.c"
	AV *	RETVAL;

	if (items < 2)
	    max = 32768;
	else {
	    max = (int)SvIV(ST(1))
;
	}
#line 1632 "SSLeay.xs"
	New(0, buf, max, char);
	got = SSL_read(s, buf, max);

	/* If in list context, return 2-item list:
	 *   first return value:  data gotten, or undef on error (got<0)
	 *   second return value: result from SSL_read()
	 */
	if (GIMME_V==G_ARRAY) {
	    EXTEND(SP, 2);
	    PUSHs(sv_2mortal(got>=0 ? newSVpvn(buf, got) : newSV(0)));
	    PUSHs(sv_2mortal(newSViv(got)));

	/* If in scalar or void context, return data gotten, or undef on error. */
	} else {
	    EXTEND(SP, 1);
	    PUSHs(sv_2mortal(got>=0 ? newSVpvn(buf, got) : newSV(0)));
	}

	Safefree(buf);
#line 2290 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_peek); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_peek)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, max=32768");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	max;
#line 1657 "SSLeay.xs"
	char *buf;
	int got;
#line 2312 "SSLeay.c"

	if (items < 2)
	    max = 32768;
	else {
	    max = (int)SvIV(ST(1))
;
	}
#line 1660 "SSLeay.xs"
	New(0, buf, max, char);

	got = SSL_peek(s, buf, max);

	/* If in list context, return 2-item list:
	 *   first return value:  data gotten, or undef on error (got<0)
	 *   second return value: result from SSL_peek()
	 */
	if (GIMME_V==G_ARRAY) {
	    EXTEND(SP, 2);
	    PUSHs(sv_2mortal(got>=0 ? newSVpvn(buf, got) : newSV(0)));
	    PUSHs(sv_2mortal(newSViv(got)));

	    /* If in scalar or void context, return data gotten, or undef on error. */
	} else {
	    EXTEND(SP, 1);
	    PUSHs(sv_2mortal(got>=0 ? newSVpvn(buf, got) : newSV(0)));
	}
	Safefree(buf);
#line 2340 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_write)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, buf");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
#line 1684 "SSLeay.xs"
     STRLEN len;
#line 2358 "SSLeay.c"
	char *	buf = SvPV( ST(1), len);
	int	RETVAL;
	dXSTARG;
#line 1688 "SSLeay.xs"
     RETVAL = SSL_write (s, buf, (int)len);
#line 2364 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_write_partial); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_write_partial)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "s, from, count, buf");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	from = (int)SvIV(ST(1))
;
	int	count = (int)SvIV(ST(2))
;
#line 1698 "SSLeay.xs"
     STRLEN ulen;
     IV len;
#line 2387 "SSLeay.c"
	char *	buf = SvPV( ST(3), ulen);
	int	RETVAL;
	dXSTARG;
#line 1703 "SSLeay.xs"
      /*
     if (SvROK( ST(3) )) {
       SV* t = SvRV( ST(3) );
       buf = SvPV( t, len);
     } else
       buf = SvPV( ST(3), len);
       */
     PR4("write_partial from=%d count=%d len=%ul\n",from,count,ulen);
     /*PR2("buf='%s'\n",&buf[from]); / * too noisy */
     len = (IV)ulen;
     len -= from;
     if (len < 0) {
       croak("from beyound end of buffer");
       RETVAL = -1;
     } else
       RETVAL = SSL_write (s, &(buf[from]), (count<=len)?count:len);
#line 2408 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_RSAPrivateKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_RSAPrivateKey)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, rsa");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	RSA *	rsa = INT2PTR(RSA *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_RSAPrivateKey(s, rsa);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_RSAPrivateKey_ASN1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_RSAPrivateKey_ASN1)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, d, len");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	unsigned char *	d = (unsigned char *)SvPV_nolen(ST(1))
;
	long	len = (long)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_RSAPrivateKey_ASN1(s, d, len);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_RSAPrivateKey_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_RSAPrivateKey_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, file, type");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_RSAPrivateKey_file(s, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_RSAPrivateKey_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_RSAPrivateKey_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, file, type");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_use_RSAPrivateKey_file(ctx, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_PrivateKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_PrivateKey)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, pkey");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_PrivateKey(s, pkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_PrivateKey_ASN1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_PrivateKey_ASN1)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "pk, s, d, len");
    {
	int	pk = (int)SvIV(ST(0))
;
	SSL *	s = INT2PTR(SSL *,SvIV(ST(1)))
;
	unsigned char *	d = (unsigned char *)SvPV_nolen(ST(2))
;
	long	len = (long)SvIV(ST(3))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_PrivateKey_ASN1(pk, s, d, len);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_PrivateKey_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_PrivateKey_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, file, type");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_PrivateKey_file(s, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_PrivateKey_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_PrivateKey_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, file, type");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_use_PrivateKey_file(ctx, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_certificate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_certificate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, x");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_certificate(s, x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_certificate_ASN1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_certificate_ASN1)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, d, len");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	unsigned char *	d = (unsigned char *)SvPV_nolen(ST(1))
;
	long	len = (long)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_certificate_ASN1(s, d, len);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_use_certificate_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_use_certificate_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, file, type");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_use_certificate_file(s, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_certificate_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_certificate_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, file, type");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_use_certificate_file(ctx, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_state_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_state_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_state_string(s);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_rstate_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_rstate_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_rstate_string(s);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_state_string_long); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_state_string_long)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_state_string_long(s);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_rstate_string_long); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_rstate_string_long)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_rstate_string_long(s);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_time)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ses");
    {
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_time(ses);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_time)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ses, t");
    {
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	t = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_time(ses, t);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_timeout)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ses");
    {
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_timeout(ses);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_timeout)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ses, t");
    {
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	t = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_timeout(ses, t);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_copy_session_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_copy_session_id)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "to, from");
    {
	SSL *	to = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL *	from = INT2PTR(SSL *,SvIV(ST(1)))
;

	SSL_copy_session_id(to, from);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_read_ahead); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_read_ahead)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, yes=1");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	yes;

	if (items < 2)
	    yes = 1;
	else {
	    yes = (int)SvIV(ST(1))
;
	}

	SSL_set_read_ahead(s, yes);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_get_read_ahead); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_read_ahead)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_read_ahead(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_pending); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_pending)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_pending(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_cipher_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_cipher_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, str");
    {
	SSL_CTX *	s = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	char *	str = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_cipher_list(s, str);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_cipher_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_cipher_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, n");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	n = (int)SvIV(ST(1))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_cipher_list(s, n);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_cipher_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_cipher_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, str");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	char *	str = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_cipher_list(s, str);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_cipher); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_cipher)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_cipher(s);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_shared_ciphers); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_shared_ciphers)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "s, ignored_param1=0, ignored_param2=0");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	ignored_param1;
	int	ignored_param2;
#line 1870 "SSLeay.xs"
        char buf[8192];
#line 3018 "SSLeay.c"

	if (items < 2)
	    ignored_param1 = 0;
	else {
	    ignored_param1 = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    ignored_param2 = 0;
	else {
	    ignored_param2 = (int)SvIV(ST(2))
;
	}
#line 1872 "SSLeay.xs"
        ST(0) = sv_newmortal();   /* undef to start with */
        if(SSL_get_shared_ciphers(s, buf, sizeof(buf)))
            sv_setpvn(ST(0), buf, strlen(buf));
#line 3037 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_peer_certificate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_peer_certificate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	X509 *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_peer_certificate(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_peer_cert_chain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_peer_cert_chain)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
#line 1884 "SSLeay.xs"
        STACK_OF(X509) *chain = NULL;
        X509 *x;
	int i;
#line 3077 "SSLeay.c"
#line 1888 "SSLeay.xs"
	chain = SSL_get_peer_cert_chain(s);
	if( chain == NULL ) {
	    XSRETURN_EMPTY;
	}
	for (i=0; i<sk_X509_num(chain); i++) {
	    x = sk_X509_value(chain, i);
	    XPUSHs(sv_2mortal(newSViv(PTR2IV(x))));
	}
#line 3087 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_set_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_verify)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, mode, callback");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	mode = (int)SvIV(ST(1))
;
	SV *	callback = ST(2)
;
#line 1903 "SSLeay.xs"
        if (callback==NULL || !SvOK(callback)) {
            SSL_set_verify(s, mode, NULL);
            cb_data_advanced_put(s, "ssleay_verify_callback!!func", NULL);
        }
        else {
            cb_data_advanced_put(s, "ssleay_verify_callback!!func", newSVsv(callback));
            SSL_set_verify(s, mode, &ssleay_verify_callback_invoke);
        }
#line 3116 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_bio); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_bio)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, rbio, wbio");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	BIO *	rbio = INT2PTR(BIO *,SvIV(ST(1)))
;
	BIO *	wbio = INT2PTR(BIO *,SvIV(ST(2)))
;

	SSL_set_bio(s, rbio, wbio);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_get_rbio); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_rbio)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	BIO *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_rbio(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_wbio); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_wbio)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	BIO *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_wbio(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SSL_SESSION *	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_print); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_print)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "fp, ses");
    {
	BIO *	fp = INT2PTR(BIO *,SvIV(ST(0)))
;
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_print(fp, ses);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ses");
    {
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;

	SSL_SESSION_free(ses);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_i2d_SSL_SESSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_i2d_SSL_SESSION)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "in, pp");
    {
	SSL_SESSION *	in = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	unsigned char *	pp = (unsigned char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = i2d_SSL_SESSION(in, &pp);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_session); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_session)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "to, ses");
    {
	SSL *	to = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_session(to, ses);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER < 0x0090707fL
#define REM3 "NOTE: before 0.9.7g"
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_Net__SSLeay_d2i_SSL_SESSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_d2i_SSL_SESSION)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "a, pp, length");
    {
	SSL_SESSION *	a = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	unsigned char *	pp = (unsigned char *)SvPV_nolen(ST(1))
;
	long	length = (long)SvIV(ST(2))
;
	SSL_SESSION *	RETVAL;
	dXSTARG;

	RETVAL = d2i_SSL_SESSION(&a, &pp, length);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAI 1


XS_EUPXS(XS_Net__SSLeay_d2i_SSL_SESSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_d2i_SSL_SESSION)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "a, pp, length");
    {
	SSL_SESSION *	a = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	const unsigned char *	pp = (const unsigned char *)SvPV_nolen(ST(1))
;
	long	length = (long)SvIV(ST(2))
;
	SSL_SESSION *	RETVAL;
	dXSTARG;

	RETVAL = d2i_SSL_SESSION(&a, &pp, length);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#define REM30 "SSLeay-0.9.0 defines these as macros. I expand them here for safety's sake"

XS_EUPXS(XS_Net__SSLeay_get_session); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_session)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL_SESSION *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_session(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get1_session); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get1_session)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL_SESSION *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get1_session(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_certificate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_certificate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	X509 *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_certificate(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090806fL
#define REM18 "NOTE: requires 0.9.8f+"
#define XSubPPtmpAAAJ 1


XS_EUPXS(XS_Net__SSLeay_get_SSL_CTX); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_SSL_CTX)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL_CTX *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_SSL_CTX(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_SSL_CTX); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_SSL_CTX)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, ctx");
    {
	SSL_CTX *	RETVAL;
	dXSTARG;
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL_CTX*	ctx = INT2PTR(SSL_CTX *,SvIV(ST(1)))
;

	RETVAL = SSL_set_SSL_CTX(ssl, ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ctrl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ctrl)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "ssl, cmd, larg, parg");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	cmd = (int)SvIV(ST(1))
;
	long	larg = (long)SvIV(ST(2))
;
	char *	parg = (char *)SvPV_nolen(ST(3))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_ctrl(ssl, cmd, larg, parg);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_CTX_ctrl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_ctrl)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "ctx, cmd, larg, parg");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	cmd = (int)SvIV(ST(1))
;
	long	larg = (long)SvIV(ST(2))
;
	char *	parg = (char *)SvPV_nolen(ST(3))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_ctrl(ctx, cmd, larg, parg);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_options)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_options(ssl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_options)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, op");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	op = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_options(ssl, op);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_options)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_options(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_options)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, op");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	op = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_options(ctx, op);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x10000000L
#define XSubPPtmpAAAK 1


XS_EUPXS(XS_Net__SSLeay_CTX_sessions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sessions)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	struct lhash_st_SSL_SESSION *	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sessions(ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAL 1


XS_EUPXS(XS_Net__SSLeay_CTX_sessions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sessions)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	LHASH *	RETVAL;
	dXSTARG;
#line 2039 "SSLeay.xs"
    /* NOTE: This should be deprecated. Corresponding macro was removed from ssl.h as of 0.9.2 */
     if (ctx == NULL) croak("NULL SSL context passed as argument.");
     RETVAL = ctx -> sessions;
#line 3604 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_CTX_sess_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	unsigned long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_number(ctx);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_connect)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_connect(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_connect_good); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_connect_good)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_connect_good(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_connect_renegotiate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_connect_renegotiate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_connect_renegotiate(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_accept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_accept)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_accept(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_accept_renegotiate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_accept_renegotiate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_accept_renegotiate(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_accept_good); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_accept_good)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_accept_good(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_hits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_hits)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_hits(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_cb_hits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_cb_hits)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_cb_hits(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_misses); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_misses)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_misses(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_timeouts); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_timeouts)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_timeouts(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_cache_full); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_cache_full)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_cache_full(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_get_cache_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_get_cache_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_get_cache_size(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_sess_set_cache_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_sess_set_cache_size)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, size");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	size = (int)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_sess_set_cache_size(ctx, size);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_want); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_want)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_want(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_state)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_state(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090806fL && !defined(OPENSSL_NO_TLSEXT)
#define XSubPPtmpAAAM 1


XS_EUPXS(XS_Net__SSLeay_set_tlsext_host_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_tlsext_host_name)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, name");
    {
	long	RETVAL;
	dXSTARG;
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	const char *	name = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = SSL_set_tlsext_host_name(ssl, name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_servername); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_servername)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, type=TLSEXT_NAMETYPE_host_name");
    {
	const char *	RETVAL;
	dXSTARG;
	const SSL *	s = INT2PTR(const SSL *,SvIV(ST(0)))
;
	int	type;

	if (items < 2)
	    type = TLSEXT_NAMETYPE_host_name;
	else {
	    type = (int)SvIV(ST(1))
;
	}

	RETVAL = SSL_get_servername(s, type);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_servername_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_servername_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	int	RETVAL;
	dXSTARG;
	const SSL *	s = INT2PTR(const SSL *,SvIV(ST(0)))
;

	RETVAL = SSL_get_servername_type(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_tlsext_servername_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_tlsext_servername_callback)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "ctx, callback=&PL_sv_undef, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback;
	SV *	data;

	if (items < 2)
	    callback = &PL_sv_undef;
	else {
	    callback = ST(1)
;
	}

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 2129 "SSLeay.xs"
    if (callback==NULL || !SvOK(callback)) {
        SSL_CTX_set_tlsext_servername_callback(ctx, NULL);
        SSL_CTX_set_tlsext_servername_arg(ctx, NULL);
        cb_data_advanced_put(ctx, "tlsext_servername_callback!!data", NULL);
        cb_data_advanced_put(ctx, "tlsext_servername_callback!!func", NULL);
    } else {
        cb_data_advanced_put(ctx, "tlsext_servername_callback!!data", newSVsv(data));
        cb_data_advanced_put(ctx, "tlsext_servername_callback!!func", newSVsv(callback));
        SSL_CTX_set_tlsext_servername_callback(ctx, &tlsext_servername_callback_invoke);
        SSL_CTX_set_tlsext_servername_arg(ctx, (void*)ctx);
    }
#line 4025 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Net__SSLeay_BIO_f_ssl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_f_ssl)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	BIO_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = BIO_f_ssl();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_s_mem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_s_mem)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	BIO_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = BIO_s_mem();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ERR_get_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_get_error)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	unsigned long	RETVAL;
	dXSTARG;

	RETVAL = ERR_get_error();
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ERR_peek_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_peek_error)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	unsigned long	RETVAL;
	dXSTARG;

	RETVAL = ERR_peek_error();
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ERR_put_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_put_error)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "lib, func, reason, file, line");
    {
	int	lib = (int)SvIV(ST(0))
;
	int	func = (int)SvIV(ST(1))
;
	int	reason = (int)SvIV(ST(2))
;
	char *	file = (char *)SvPV_nolen(ST(3))
;
	int	line = (int)SvIV(ST(4))
;

	ERR_put_error(lib, func, reason, file, line);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ERR_clear_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_clear_error)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	ERR_clear_error();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ERR_error_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_error_string)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "error, buf=NULL");
    {
	unsigned long	error = (unsigned long)SvUV(ST(0))
;
	char *	buf;
	char *	RETVAL;
	dXSTARG;

	if (items < 2)
	    buf = NULL;
	else {
	    buf = (char *)SvPV_nolen(ST(1))
;
	}
#line 2171 "SSLeay.xs"
     RETVAL = ERR_error_string(error,buf);
#line 4159 "SSLeay.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_load_error_strings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_load_error_strings)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	SSL_load_error_strings();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ERR_load_crypto_strings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_load_crypto_strings)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	ERR_load_crypto_strings();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_FIPS_mode_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_FIPS_mode_set)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "onoff");
    {
	int	RETVAL;
	dXSTARG;
	int	onoff = (int)SvIV(ST(0))
;
#line 2184 "SSLeay.xs"
#ifdef USE_ITHREADS
               MUTEX_LOCK(&LIB_init_mutex);
#endif
#ifdef OPENSSL_FIPS
               RETVAL = FIPS_mode_set(onoff);
               if (!RETVAL) 
	       {
		   ERR_load_crypto_strings();
		   ERR_print_errors_fp(stderr);
               }
#else
               RETVAL = 1;
               fprintf(stderr, "SSL_FIPS_mode_set not available: OpenSSL not compiled with FIPS support\n");
#endif
#ifdef USE_ITHREADS
               MUTEX_UNLOCK(&LIB_init_mutex);
#endif
#line 4223 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_library_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_library_init)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2212 "SSLeay.xs"
#ifdef USE_ITHREADS
		MUTEX_LOCK(&LIB_init_mutex);
#endif
		RETVAL = 0;
		if (!LIB_initialized) {
			RETVAL = SSL_library_init();
			LIB_initialized = 1;
		}
#ifdef USE_ITHREADS
		MUTEX_UNLOCK(&LIB_init_mutex);
#endif
#line 4252 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define REM5 "NOTE: requires 0.9.7+"
#define XSubPPtmpAAAN 1


XS_EUPXS(XS_Net__SSLeay_ENGINE_load_builtin_engines); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ENGINE_load_builtin_engines)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	ENGINE_load_builtin_engines();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ENGINE_register_all_complete); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ENGINE_register_all_complete)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	ENGINE_register_all_complete();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ENGINE_by_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ENGINE_by_id)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	char *	id = (char *)SvPV_nolen(ST(0))
;
	ENGINE *	RETVAL;
	dXSTARG;

	RETVAL = ENGINE_by_id(id);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ENGINE_set_default); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ENGINE_set_default)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "e, flags");
    {
	ENGINE *	e = INT2PTR(ENGINE *,SvIV(ST(0)))
;
	int	flags = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = ENGINE_set_default(e, flags);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_ERR_load_SSL_strings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_load_SSL_strings)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	ERR_load_SSL_strings();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ERR_load_RAND_strings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ERR_load_RAND_strings)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	ERR_load_RAND_strings();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_RAND_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_bytes)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "buf, num");
    {
	SV *	buf = ST(0)
;
	int	num = (int)SvIV(ST(1))
;
#line 2257 "SSLeay.xs"
        int rc;
        unsigned char *random;
#line 4374 "SSLeay.c"
	int	RETVAL;
	dXSTARG;
#line 2260 "SSLeay.xs"
        New(0, random, num, unsigned char);
        rc = RAND_bytes(random, num);
        sv_setpvn(buf, (const char*)random, num);
        Safefree(random);
        RETVAL = rc;
#line 4383 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_RAND_pseudo_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_pseudo_bytes)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "buf, num");
    {
	SV *	buf = ST(0)
;
	int	num = (int)SvIV(ST(1))
;
#line 2273 "SSLeay.xs"
        int rc;
        unsigned char *random;
#line 4404 "SSLeay.c"
	int	RETVAL;
	dXSTARG;
#line 2276 "SSLeay.xs"
        New(0, random, num, unsigned char);
        rc = RAND_pseudo_bytes(random, num);
        sv_setpvn(buf, (const char*)random, num);
        Safefree(random);
        RETVAL = rc;
#line 4413 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_RAND_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_add)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "buf, num, entropy");
    {
	SV *	buf = ST(0)
;
	int	num = (int)SvIV(ST(1))
;
	double	entropy = (double)SvNV(ST(2))
;
#line 2290 "SSLeay.xs"
        STRLEN len;
#line 4435 "SSLeay.c"
#line 2292 "SSLeay.xs"
        RAND_add((const void *)SvPV(buf, len), num, entropy);
#line 4438 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_RAND_poll); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_poll)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = RAND_poll();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_RAND_status); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_status)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = RAND_status();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_RAND_file_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_file_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "num");
    {
	size_t	num = (size_t)SvUV(ST(0))
;
#line 2304 "SSLeay.xs"
        char *buf;
#line 4489 "SSLeay.c"
	SV *	RETVAL;
#line 2306 "SSLeay.xs"
        New(0, buf, num, char);
        if (!RAND_file_name(buf, num)) {
            Safefree(buf);
            XSRETURN_UNDEF;
        }
        RETVAL = newSVpv(buf, 0);
        Safefree(buf);
#line 4499 "SSLeay.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_RAND_seed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_seed)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "buf");
    {
#line 2319 "SSLeay.xs"
     STRLEN len;
#line 4516 "SSLeay.c"
	char *	buf = SvPV( ST(1), len);
#line 2323 "SSLeay.xs"
     RAND_seed (buf, (int)len);
#line 4520 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_RAND_cleanup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_cleanup)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	RAND_cleanup();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_RAND_load_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_load_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "file_name, how_much");
    {
	char *	file_name = (char *)SvPV_nolen(ST(0))
;
	int	how_much = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = RAND_load_file(file_name, how_much);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_RAND_write_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RAND_write_file)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "file_name");
    {
	char *	file_name = (char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = RAND_write_file(file_name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define REM40 "Minimal X509 stuff..., this is a bit ugly and should be put in its own modules Net::SSLeay::X509.pm"
#if OPENSSL_VERSION_NUMBER >= 0x1000200fL && !defined(LIBRESSL_VERSION_NUMBER)
#define XSubPPtmpAAAO 1


XS_EUPXS(XS_Net__SSLeay_X509_check_host); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_check_host)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "cert, name, flags= 0, peername= &PL_sv_undef");
    {
#line 2344 "SSLeay.xs"
        char *c_peername = NULL;
#line 4593 "SSLeay.c"
	int	RETVAL;
	dXSTARG;
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	const char *	name = (const char *)SvPV_nolen(ST(1))
;
	unsigned int	flags;
	SV *	peername;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (unsigned int)SvUV(ST(2))
;
	}

	if (items < 4)
	    peername = &PL_sv_undef;
	else {
	    peername = ST(3)
;
	}
#line 2346 "SSLeay.xs"
        RETVAL = X509_check_host(cert, name, 0, flags, (items == 4) ? &c_peername : NULL);
        if (items == 4)
            sv_setpv(peername, c_peername);
#line 4620 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
#line 2352 "SSLeay.xs"
        if (c_peername)
            OPENSSL_free(c_peername);
#line 4625 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_check_email); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_check_email)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "cert, address, flags= 0");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	const char *	address = (const char *)SvPV_nolen(ST(1))
;
	unsigned int	flags;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (unsigned int)SvUV(ST(2))
;
	}
#line 2358 "SSLeay.xs"
        RETVAL = X509_check_email(cert, address, 0, flags);
#line 4654 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_check_ip); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_check_ip)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "cert, address, flags= 0");
    {
#line 2365 "SSLeay.xs"
        unsigned char *c_address;
        size_t addresslen;
#line 4671 "SSLeay.c"
	int	RETVAL;
	dXSTARG;
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	SV *	address = ST(1)
;
	unsigned int	flags;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (unsigned int)SvUV(ST(2))
;
	}
#line 2368 "SSLeay.xs"
        c_address = (unsigned char *)SvPV(address, addresslen);
        RETVAL = X509_check_ip(cert, c_address, addresslen, flags);
#line 4689 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_check_ip_asc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_check_ip_asc)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "cert, address, flags= 0");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	const char *	address = (const char *)SvPV_nolen(ST(1))
;
	unsigned int	flags;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (unsigned int)SvUV(ST(2))
;
	}

	RETVAL = X509_check_ip_asc(cert, address, flags);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_X509_get_issuer_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_issuer_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	X509_NAME *	RETVAL;
	dXSTARG;

	RETVAL = X509_get_issuer_name(cert);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_subject_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_subject_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	X509_NAME *	RETVAL;
	dXSTARG;

	RETVAL = X509_get_subject_name(cert);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_set_issuer_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_set_issuer_name)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, name");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(1)))
;

	RETVAL = X509_set_issuer_name(x, name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_set_subject_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_set_subject_name)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, name");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(1)))
;

	RETVAL = X509_set_subject_name(x, name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_set_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_set_version)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, version");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	long	version = (long)SvIV(ST(1))
;

	RETVAL = X509_set_version(x, version);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_set_pubkey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_set_pubkey)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, pkey");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;

	RETVAL = X509_set_pubkey(x, pkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_version)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	long	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;

	RETVAL = X509_get_version(x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_pubkey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_pubkey)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	EVP_PKEY *	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;

	RETVAL = X509_get_pubkey(x);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_serialNumber); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_serialNumber)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	ASN1_INTEGER *	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;

	RETVAL = X509_get_serialNumber(x);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_set_serialNumber); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_set_serialNumber)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, serial");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	ASN1_INTEGER *	serial = INT2PTR(ASN1_INTEGER *,SvIV(ST(1)))
;

	RETVAL = X509_set_serialNumber(x, serial);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_certificate_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_certificate_type)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "x, pubkey=NULL");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	EVP_PKEY *	pubkey;

	if (items < 2)
	    pubkey = NULL;
	else {
	    pubkey = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;
	}

	RETVAL = X509_certificate_type(x, pubkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_sign)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "x, pkey, md");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;
	const EVP_MD *	md = INT2PTR(const EVP_MD *,SvIV(ST(2)))
;

	RETVAL = X509_sign(x, pkey, md);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_verify)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, r");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	EVP_PKEY *	r = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;

	RETVAL = X509_verify(x, r);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	X509_NAME *	RETVAL;
	dXSTARG;

	RETVAL = X509_NAME_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	unsigned long	RETVAL;
	dXSTARG;
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;

	RETVAL = X509_NAME_hash(name);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_oneline); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_oneline)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;
#line 2429 "SSLeay.xs"
	char * buf;
#line 5044 "SSLeay.c"
#line 2431 "SSLeay.xs"
	ST(0) = sv_newmortal();   /* Undefined to start with */
	if ((buf = X509_NAME_oneline(name, NULL, 0))) {
		sv_setpvn( ST(0), buf, strlen(buf));
		OPENSSL_free(buf); /* mem was allocated by openssl */
	}
#line 5051 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_print_ex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_print_ex)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "name, flags=XN_FLAG_RFC2253, utf8_decode=0");
    {
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;
	unsigned long	flags;
	int	utf8_decode;
#line 2443 "SSLeay.xs"
        char * buf;
        BIO * bp;
        int n, i, ident=0;
#line 5072 "SSLeay.c"

	if (items < 2)
	    flags = XN_FLAG_RFC2253;
	else {
	    flags = (unsigned long)SvUV(ST(1))
;
	}

	if (items < 3)
	    utf8_decode = 0;
	else {
	    utf8_decode = (int)SvIV(ST(2))
;
	}
#line 2447 "SSLeay.xs"
        ST(0) = sv_newmortal(); /* undef to start with */
        bp = BIO_new(BIO_s_mem());
        if (bp) {
            if (X509_NAME_print_ex(bp, name, ident, flags)) {
                n = BIO_ctrl_pending(bp);
                New(0, buf, n, char);
                if (buf) {
                    i = BIO_read(bp,buf,n);
                    if (i>=0 && i<=n) {
                        sv_setpvn(ST(0), buf, i);
                        if (utf8_decode) sv_utf8_decode(ST(0));
                    }
                    Safefree(buf);
                }
            }
            BIO_free(bp);
        }
#line 5105 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_get_text_by_NID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_get_text_by_NID)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, nid");
    {
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;
	int	nid = (int)SvIV(ST(1))
;
#line 2470 "SSLeay.xs"
	char* buf;
	int length;
#line 5125 "SSLeay.c"
#line 2473 "SSLeay.xs"
	ST(0) = sv_newmortal();   /* Undefined to start with */
	length = X509_NAME_get_text_by_NID(name, nid, NULL, 0);

       if (length>=0) {
               New(0, buf, length+1, char);
               if (X509_NAME_get_text_by_NID(name, nid, buf, length + 1)>=0)
                       sv_setpvn( ST(0), buf, length);
               Safefree(buf);
       }
#line 5136 "SSLeay.c"
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090500fL
#define REM17 "requires 0.9.5+"
#define XSubPPtmpAAAP 1


XS_EUPXS(XS_Net__SSLeay_X509_NAME_add_entry_by_NID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_add_entry_by_NID)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 6)
       croak_xs_usage(cv,  "name, nid, type, bytes, loc=-1, set=0");
    {
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;
	int	nid = (int)SvIV(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	loc;
	int	set;
#line 2494 "SSLeay.xs"
        STRLEN len;
#line 5163 "SSLeay.c"
	unsigned char *	bytes = (unsigned char *)SvPV(ST(3), len);
	int	RETVAL;
	dXSTARG;

	if (items < 5)
	    loc = -1;
	else {
	    loc = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    set = 0;
	else {
	    set = (int)SvIV(ST(5))
;
	}
#line 2498 "SSLeay.xs"
        RETVAL = X509_NAME_add_entry_by_NID(name,nid,type,bytes,len,loc,set);
#line 5183 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_add_entry_by_OBJ); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_add_entry_by_OBJ)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 6)
       croak_xs_usage(cv,  "name, obj, type, bytes, loc=-1, set=0");
    {
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;
	ASN1_OBJECT *	obj = INT2PTR(ASN1_OBJECT *,SvIV(ST(1)))
;
	int	type = (int)SvIV(ST(2))
;
	int	loc;
	int	set;
#line 2510 "SSLeay.xs"
        STRLEN len;
#line 5207 "SSLeay.c"
	unsigned char *	bytes = (unsigned char *)SvPV(ST(3), len);
	int	RETVAL;
	dXSTARG;

	if (items < 5)
	    loc = -1;
	else {
	    loc = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    set = 0;
	else {
	    set = (int)SvIV(ST(5))
;
	}
#line 2514 "SSLeay.xs"
        RETVAL = X509_NAME_add_entry_by_OBJ(name,obj,type,bytes,len,loc,set);
#line 5227 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_add_entry_by_txt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_add_entry_by_txt)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 6)
       croak_xs_usage(cv,  "name, field, type, bytes, loc=-1, set=0");
    {
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;
	char *	field = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	loc;
	int	set;
#line 2526 "SSLeay.xs"
        STRLEN len;
#line 5251 "SSLeay.c"
	unsigned char *	bytes = (unsigned char *)SvPV(ST(3), len);
	int	RETVAL;
	dXSTARG;

	if (items < 5)
	    loc = -1;
	else {
	    loc = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    set = 0;
	else {
	    set = (int)SvIV(ST(5))
;
	}
#line 2530 "SSLeay.xs"
        RETVAL = X509_NAME_add_entry_by_txt(name,field,type,bytes,len,loc,set);
#line 5271 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_X509_NAME_cmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_cmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	int	RETVAL;
	dXSTARG;
	const X509_NAME *	a = INT2PTR(const X509_NAME *,SvIV(ST(0)))
;
	const X509_NAME *	b = INT2PTR(const X509_NAME *,SvIV(ST(1)))
;

	RETVAL = X509_NAME_cmp(a, b);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_entry_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_entry_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	int	RETVAL;
	dXSTARG;
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;

	RETVAL = X509_NAME_entry_count(name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_get_entry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_get_entry)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, loc");
    {
	X509_NAME_ENTRY *	RETVAL;
	dXSTARG;
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(0)))
;
	int	loc = (int)SvIV(ST(1))
;

	RETVAL = X509_NAME_get_entry(name, loc);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_ENTRY_get_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_ENTRY_get_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ne");
    {
	ASN1_STRING *	RETVAL;
	dXSTARG;
	X509_NAME_ENTRY *	ne = INT2PTR(X509_NAME_ENTRY *,SvIV(ST(0)))
;

	RETVAL = X509_NAME_ENTRY_get_data(ne);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_ENTRY_get_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_ENTRY_get_object)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ne");
    {
	ASN1_OBJECT *	RETVAL;
	dXSTARG;
	X509_NAME_ENTRY *	ne = INT2PTR(X509_NAME_ENTRY *,SvIV(ST(0)))
;

	RETVAL = X509_NAME_ENTRY_get_object(ne);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;

	X509_CRL_free(x);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	X509_CRL *	RETVAL;
	dXSTARG;

	RETVAL = X509_CRL_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define REM19 "requires 0.9.7+"
#define XSubPPtmpAAAQ 1


XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_version)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, version");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	long	version = (long)SvIV(ST(1))
;

	RETVAL = X509_CRL_set_version(x, version);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_issuer_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_issuer_name)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, name");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(1)))
;

	RETVAL = X509_CRL_set_issuer_name(x, name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_lastUpdate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_lastUpdate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, tm");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	ASN1_TIME *	tm = INT2PTR(ASN1_TIME *,SvIV(ST(1)))
;

	RETVAL = X509_CRL_set_lastUpdate(x, tm);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_nextUpdate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_set_nextUpdate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, tm");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	ASN1_TIME *	tm = INT2PTR(ASN1_TIME *,SvIV(ST(1)))
;

	RETVAL = X509_CRL_set_nextUpdate(x, tm);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_sort); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_sort)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;

	RETVAL = X509_CRL_sort(x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_version)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	long	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;

	RETVAL = X509_CRL_get_version(x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_issuer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_issuer)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	X509_NAME *	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;

	RETVAL = X509_CRL_get_issuer(x);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_lastUpdate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_lastUpdate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	ASN1_TIME *	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;

	RETVAL = X509_CRL_get_lastUpdate(x);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_nextUpdate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_nextUpdate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	ASN1_TIME *	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;

	RETVAL = X509_CRL_get_nextUpdate(x);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_verify)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, r");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	a = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	EVP_PKEY *	r = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;

	RETVAL = X509_CRL_verify(a, r);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_sign)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "x, pkey, md");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;
	const EVP_MD *	md = INT2PTR(const EVP_MD *,SvIV(ST(2)))
;

	RETVAL = X509_CRL_sign(x, pkey, md);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define REM20 "requires 0.9.7+"
#define XSubPPtmpAAAR 1


XS_EUPXS(XS_Net__SSLeay_P_X509_CRL_set_serial); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_CRL_set_serial)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "crl, crl_number");
    {
	X509_CRL *	crl = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	ASN1_INTEGER *	crl_number = INT2PTR(ASN1_INTEGER *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;
#line 2603 "SSLeay.xs"
        RETVAL = 0;
        if (crl && crl_number)
            if (X509_CRL_add1_ext_i2d(crl, NID_crl_number, crl_number, 0, 0)) RETVAL = 1;
#line 5660 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_X509_CRL_get_serial); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_CRL_get_serial)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "crl");
    {
	X509_CRL *	crl = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	ASN1_INTEGER *	RETVAL;
	dXSTARG;
#line 2613 "SSLeay.xs"
        int i;
#line 5680 "SSLeay.c"
#line 2615 "SSLeay.xs"
        RETVAL = (ASN1_INTEGER *)X509_CRL_get_ext_d2i(crl, NID_crl_number, &i, NULL);
        if (!RETVAL || i==-1) XSRETURN_UNDEF;
#line 5684 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_X509_CRL_add_revoked_serial_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_CRL_add_revoked_serial_hex)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "crl, serial_hex, rev_time, reason_code=0, comp_time=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509_CRL *	crl = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	char *	serial_hex = (char *)SvPV_nolen(ST(1))
;
	ASN1_TIME *	rev_time = INT2PTR(ASN1_TIME *,SvIV(ST(2)))
;
	long	reason_code;
	ASN1_TIME *	comp_time;
#line 2628 "SSLeay.xs"
        BIGNUM *bn = NULL;
        ASN1_INTEGER *sn;
        X509_REVOKED *rev;
        ASN1_ENUMERATED *rsn = NULL;
        int rv;
#line 5714 "SSLeay.c"

	if (items < 4)
	    reason_code = 0;
	else {
	    reason_code = (long)SvIV(ST(3))
;
	}

	if (items < 5)
	    comp_time = NULL;
	else {
	    comp_time = INT2PTR(ASN1_TIME *,SvIV(ST(4)))
;
	}
#line 2634 "SSLeay.xs"
        rv=0;
        rev = X509_REVOKED_new();
        if (rev) {
            if (BN_hex2bn(&bn, serial_hex)) {
                sn = BN_to_ASN1_INTEGER(bn, NULL);
                if (sn) {
                    X509_REVOKED_set_serialNumber(rev, sn);
                    ASN1_INTEGER_free(sn);
                    rv = 1;
                }
                BN_free(bn);
            }
        }
        if (!rv) XSRETURN_IV(0);

        if (!rev_time) XSRETURN_IV(0);
        if (!X509_REVOKED_set_revocationDate(rev, rev_time)) XSRETURN_IV(0);

        if(reason_code) {
            rv = 0;
            rsn = ASN1_ENUMERATED_new();
            if (rsn) {
                if (ASN1_ENUMERATED_set(rsn, reason_code))
                    if (X509_REVOKED_add1_ext_i2d(rev, NID_crl_reason, rsn, 0, 0))
                        rv=1;
                ASN1_ENUMERATED_free(rsn);
            }
            if (!rv) XSRETURN_IV(0);
        }

        if(comp_time) {
            X509_REVOKED_add1_ext_i2d(rev, NID_invalidity_date, comp_time, 0, 0);
        }

        if(!X509_CRL_add0_revoked(crl, rev)) XSRETURN_IV(0);
        XSRETURN_IV(1);
#line 5766 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Net__SSLeay_X509_REQ_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	X509_REQ *	RETVAL;
	dXSTARG;

	RETVAL = X509_REQ_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;

	X509_REQ_free(x);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_subject_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_subject_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	X509_NAME *	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;

	RETVAL = X509_REQ_get_subject_name(x);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_set_subject_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_set_subject_name)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, name");
    {
	int	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	X509_NAME *	name = INT2PTR(X509_NAME *,SvIV(ST(1)))
;

	RETVAL = X509_REQ_set_subject_name(x, name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_set_pubkey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_set_pubkey)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, pkey");
    {
	int	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;

	RETVAL = X509_REQ_set_pubkey(x, pkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_pubkey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_pubkey)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	EVP_PKEY *	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;

	RETVAL = X509_REQ_get_pubkey(x);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_sign)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "x, pk, md");
    {
	int	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	EVP_PKEY *	pk = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;
	const EVP_MD *	md = INT2PTR(const EVP_MD *,SvIV(ST(2)))
;

	RETVAL = X509_REQ_sign(x, pk, md);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_verify)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, r");
    {
	int	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	EVP_PKEY *	r = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;

	RETVAL = X509_REQ_verify(x, r);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_set_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_set_version)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, version");
    {
	int	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	long	version = (long)SvIV(ST(1))
;

	RETVAL = X509_REQ_set_version(x, version);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_version)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	long	RETVAL;
	dXSTARG;
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;

	RETVAL = X509_REQ_get_version(x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_attr_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_attr_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "req");
    {
	int	RETVAL;
	dXSTARG;
	const X509_REQ *	req = INT2PTR(const X509_REQ *,SvIV(ST(0)))
;

	RETVAL = X509_REQ_get_attr_count(req);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_attr_by_NID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_attr_by_NID)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "req, nid, lastpos=-1");
    {
	int	RETVAL;
	dXSTARG;
	const X509_REQ *	req = INT2PTR(const X509_REQ *,SvIV(ST(0)))
;
	int	nid = (int)SvIV(ST(1))
;
	int	lastpos;

	if (items < 3)
	    lastpos = -1;
	else {
	    lastpos = (int)SvIV(ST(2))
;
	}

	RETVAL = X509_REQ_get_attr_by_NID(req, nid, lastpos);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_attr_by_OBJ); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_get_attr_by_OBJ)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "req, obj, lastpos=-1");
    {
	int	RETVAL;
	dXSTARG;
	const X509_REQ *	req = INT2PTR(const X509_REQ *,SvIV(ST(0)))
;
	ASN1_OBJECT *	obj = INT2PTR(ASN1_OBJECT *,SvIV(ST(1)))
;
	int	lastpos;

	if (items < 3)
	    lastpos = -1;
	else {
	    lastpos = (int)SvIV(ST(2))
;
	}

	RETVAL = X509_REQ_get_attr_by_OBJ(req, obj, lastpos);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_add1_attr_by_NID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_add1_attr_by_NID)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "req, nid, type, bytes");
    {
	X509_REQ *	req = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	int	nid = (int)SvIV(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
#line 2718 "SSLeay.xs"
        STRLEN len;
#line 6063 "SSLeay.c"
	unsigned char *	bytes = (unsigned char *)SvPV(ST(3), len);
	int	RETVAL;
	dXSTARG;
#line 2722 "SSLeay.xs"
        RETVAL = X509_REQ_add1_attr_by_NID(req,nid,type,bytes,len);
#line 6069 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define REM21 "requires 0.9.7+"
#define XSubPPtmpAAAS 1


XS_EUPXS(XS_Net__SSLeay_P_X509_REQ_get_attr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_REQ_get_attr)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "req, n");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509_REQ *	req = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	int	n = (int)SvIV(ST(1))
;
#line 2734 "SSLeay.xs"
        X509_ATTRIBUTE * att;
        int count, i;
        ASN1_STRING * s;
#line 6097 "SSLeay.c"
#line 2738 "SSLeay.xs"
        att = X509_REQ_get_attr(req,n);
        if (att->single) {
            s = (att->value.single->value.asn1_string);
            XPUSHs(sv_2mortal(newSViv(PTR2IV(s))));
        }
        else {
            count = sk_ASN1_TYPE_num(att->value.set);
            for (i=0; i<count; i++) {
                s = (sk_ASN1_TYPE_value(att->value.set, i)->value.asn1_string);
                XPUSHs(sv_2mortal(newSViv(PTR2IV(s))));
            }
        }
#line 6111 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Net__SSLeay_P_X509_REQ_add_extensions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_REQ_add_extensions)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "x, ...");
    {
	X509_REQ *	x = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
#line 2757 "SSLeay.xs"
        int i=1;
        int nid;
        char *data;
        X509_EXTENSION *ex;
        STACK_OF(X509_EXTENSION) *stack;
#line 6134 "SSLeay.c"
	int	RETVAL;
	dXSTARG;
#line 2763 "SSLeay.xs"
        if (items>1) {
            RETVAL = 1;
            stack = sk_X509_EXTENSION_new_null();
            while(i+1<items) {
                nid = SvIV(ST(i));
                data = SvPV_nolen(ST(i+1));
                i+=2;
                ex = X509V3_EXT_conf_nid(NULL, NULL, nid, data);
                if (ex)
                    sk_X509_EXTENSION_push(stack, ex);
                else
                    RETVAL = 0;
            }
            X509_REQ_add_extensions(x, stack);
            sk_X509_EXTENSION_pop_free(stack, X509_EXTENSION_free);
        }
        else
            RETVAL = 0;
#line 6156 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_X509_add_extensions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_add_extensions)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "x, ca_cert, ...");
    {
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	X509 *	ca_cert = INT2PTR(X509 *,SvIV(ST(1)))
;
#line 2789 "SSLeay.xs"
        int i=2;
        int nid;
        char *data;
        X509_EXTENSION *ex;
        X509V3_CTX ctx;
#line 6180 "SSLeay.c"
	int	RETVAL;
	dXSTARG;
#line 2795 "SSLeay.xs"
        if (items>1) {
            RETVAL = 1;
            while(i+1<items) {
                nid = SvIV(ST(i));
                data = SvPV_nolen(ST(i+1));
                i+=2;
                X509V3_set_ctx(&ctx, ca_cert, x, NULL, NULL, 0);
                ex = X509V3_EXT_conf_nid(NULL, &ctx, nid, data);
                if (ex) {
                    X509_add_ext(x,ex,-1);
                    X509_EXTENSION_free(ex);
                }
                else {
                    warn("failure during X509V3_EXT_conf_nid() for nid=%d\n", nid);
                    ERR_print_errors_fp(stderr);
                    RETVAL = 0;
                }
            }
        }
        else
            RETVAL = 0;
#line 6205 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_X509_copy_extensions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_copy_extensions)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "x509_req, x509, override=1");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509_REQ *	x509_req = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
	X509 *	x509 = INT2PTR(X509 *,SvIV(ST(1)))
;
	int	override;
#line 2825 "SSLeay.xs"
        STACK_OF(X509_EXTENSION) *exts = NULL;
        X509_EXTENSION *ext, *tmpext;
        ASN1_OBJECT *obj;
        int i, idx, ret = 1;
#line 6231 "SSLeay.c"

	if (items < 3)
	    override = 1;
	else {
	    override = (int)SvIV(ST(2))
;
	}
#line 2830 "SSLeay.xs"
        if (!x509 || !x509_req) XSRETURN_IV(0);
        exts = X509_REQ_get_extensions(x509_req);
        for(i = 0; i < sk_X509_EXTENSION_num(exts); i++) {
            ext = sk_X509_EXTENSION_value(exts, i);
            obj = X509_EXTENSION_get_object(ext);
            idx = X509_get_ext_by_OBJ(x509, obj, -1);
            /* Does extension exist? */
            if (idx != -1) {
                if (override) continue; /* don't override existing extension */
                /* Delete all extensions of same type */
                do {
                    tmpext = X509_get_ext(x509, idx);
                    X509_delete_ext(x509, idx);
                    X509_EXTENSION_free(tmpext);
                    idx = X509_get_ext_by_OBJ(x509, obj, -1);
                } while (idx != -1);
            }
            if (!X509_add_ext(x509, ext, -1)) ret = 0;
        }
        sk_X509_EXTENSION_pop_free(exts, X509_EXTENSION_free);
        XSRETURN_IV(ret);
#line 6261 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_current_cert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_current_cert)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x509_store_ctx");
    {
	X509_STORE_CTX *	x509_store_ctx = INT2PTR(X509_STORE_CTX *,SvIV(ST(0)))
;
	X509 *	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_CTX_get_current_cert(x509_store_ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_ex_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x509_store_ctx, idx");
    {
	X509_STORE_CTX *	x509_store_ctx = INT2PTR(X509_STORE_CTX *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_CTX_get_ex_data(x509_store_ctx, idx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_fingerprint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_fingerprint)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cert, type");
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	char *	type = (char *)SvPV_nolen(ST(1))
;
#line 2866 "SSLeay.xs"
		const EVP_MD *digest_tp = NULL;
		unsigned char digest[EVP_MAX_MD_SIZE];
		unsigned int dsz, k = 0;
		char text[EVP_MAX_MD_SIZE * 3 + 1];
#line 6324 "SSLeay.c"
#line 2871 "SSLeay.xs"
#ifndef OPENSSL_NO_MD5
		if (!k && !strcmp(type,"md5")) {
		 	k = 1; digest_tp = EVP_md5();
		}
#endif
		if (!k && !strcmp(type,"sha1")) {
			k = 1; digest_tp = EVP_sha1();
		}
#if OPENSSL_VERSION_NUMBER >= 0x0090800fL
#ifndef OPENSSL_NO_SHA256
		if (!k && !strcmp(type,"sha256")) {
			k = 1; digest_tp = EVP_sha256();
		}
#endif
#endif
		if (!k && !strcmp(type,"ripemd160")) {
			k = 1; digest_tp = EVP_ripemd160();
		}
		if (!k)	/* Default digest */
			digest_tp = EVP_sha1();
		if ( digest_tp == NULL ) {
			/* Out of memory */
			XSRETURN_UNDEF;
		}
		if (!X509_digest(cert, digest_tp, digest, &dsz)) {
			/* Out of memory */
			XSRETURN_UNDEF;
		}
		text[0] = '\0';
		for(k=0; k<dsz; k++) {
			sprintf(&text[strlen(text)], "%02X:", digest[k]);
		}
		text[strlen(text)-1] = '\0';
		ST(0) = sv_newmortal();   /* Undefined to start with */
		sv_setpvn( ST(0), text, strlen(text));
#line 6361 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_subjectAltNames); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_subjectAltNames)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
#line 2911 "SSLeay.xs"
	int                    i, j, count = 0;
	X509_EXTENSION         *subjAltNameExt = NULL;
	STACK_OF(GENERAL_NAME) *subjAltNameDNs = NULL;
	GENERAL_NAME           *subjAltNameDN  = NULL;
	int                    num_gnames;
	if (  (i = X509_get_ext_by_NID(cert, NID_subject_alt_name, -1)) >= 0
		&& (subjAltNameExt = X509_get_ext(cert, i))
		&& (subjAltNameDNs = X509V3_EXT_d2i(subjAltNameExt)))
	{
		num_gnames = sk_GENERAL_NAME_num(subjAltNameDNs);

		for (j = 0; j < num_gnames; j++)
                {
		     subjAltNameDN = sk_GENERAL_NAME_value(subjAltNameDNs, j);

                     switch (subjAltNameDN->type)
                     {
                     case GEN_OTHERNAME:
                         EXTEND(SP, 2);
                         count++;
                         PUSHs(sv_2mortal(newSViv(subjAltNameDN->type)));
                         PUSHs(sv_2mortal(newSVpv((const char*)ASN1_STRING_data(subjAltNameDN->d.otherName->value->value.utf8string), ASN1_STRING_length(subjAltNameDN->d.otherName->value->value.utf8string))));
                         break;

                     case GEN_EMAIL:
                     case GEN_DNS:
                     case GEN_URI:
                         EXTEND(SP, 2);
                         count++;
                         PUSHs(sv_2mortal(newSViv(subjAltNameDN->type)));
                         PUSHs(sv_2mortal(newSVpv((const char*)ASN1_STRING_data(subjAltNameDN->d.ia5), ASN1_STRING_length(subjAltNameDN->d.ia5))));
                         break;

                     case GEN_DIRNAME:
                         {
                         char * buf = X509_NAME_oneline(subjAltNameDN->d.dirn, NULL, 0);
                         EXTEND(SP, 2);
                         count++;
                         PUSHs(sv_2mortal(newSViv(subjAltNameDN->type)));
                         PUSHs(sv_2mortal(newSVpv((buf), strlen((buf)))));
                         break;
                         }

                     case GEN_IPADD:
                         EXTEND(SP, 2);
                         count++;
                         PUSHs(sv_2mortal(newSViv(subjAltNameDN->type)));
                         PUSHs(sv_2mortal(newSVpv((const char*)subjAltNameDN->d.ip->data, subjAltNameDN->d.ip->length)));
                         break;

                     }
		}
	}
	XSRETURN(count * 2);
#line 6433 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define XSubPPtmpAAAT 1


XS_EUPXS(XS_Net__SSLeay_P_X509_get_crl_distribution_points); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_get_crl_distribution_points)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
#line 2972 "SSLeay.xs"
        GENERAL_NAMES *gnames;
        GENERAL_NAME *gn;
        STACK_OF(DIST_POINT) *points;
        DIST_POINT *p;
        int i, j;
#line 6460 "SSLeay.c"
#line 2978 "SSLeay.xs"
        points = X509_get_ext_d2i(cert, NID_crl_distribution_points, NULL, NULL);
        if (points)
        for (i = 0; i < sk_DIST_POINT_num(points); i++) {
            p = sk_DIST_POINT_value(points, i);
            if (!p->distpoint)
                continue;
            if (p->distpoint->type == 0) {
                /* full name */
                gnames = p->distpoint->name.fullname;
                for (j = 0; j < sk_GENERAL_NAME_num(gnames); j++) {
                    gn = sk_GENERAL_NAME_value(gnames, j);

                    if (gn->type == GEN_URI) {
                        XPUSHs(sv_2mortal(newSVpv((char*)ASN1_STRING_data(gn->d.ia5),ASN1_STRING_length(gn->d.ia5))));
                    }
                }
            }
            else {
                /* relative name - not supported */
                /* XXX-TODO: the code below is just an idea; do not enable it without proper test case
                BIO *bp;
                char *buf;
                int n;
                X509_NAME ntmp;
                ntmp.entries = p->distpoint->name.relativename;
                bp = BIO_new(BIO_s_mem());
                if (bp) {
                    X509_NAME_print_ex(bp, &ntmp, 0, XN_FLAG_RFC2253);
                    n = BIO_ctrl_pending(bp);
                    New(0, buf, n, char);
                    if (buf) {
                        j = BIO_read(bp,buf,n);
                        if (j>=0 && j<=n) XPUSHs(sv_2mortal(newSVpvn(buf,j)));
                        Safefree(buf);
                    }
                    BIO_free(bp);
                }
                */
            }
        }
#line 6502 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_X509_get_ocsp_uri); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_get_ocsp_uri)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
#line 3023 "SSLeay.xs"
	AUTHORITY_INFO_ACCESS *info;
	int i;
	info = X509_get_ext_d2i(cert, NID_info_access, NULL, NULL);
	if (!info) XSRETURN_UNDEF;

	for (i = 0; i < sk_ACCESS_DESCRIPTION_num(info); i++) {
	    ACCESS_DESCRIPTION *ad = sk_ACCESS_DESCRIPTION_value(info, i);
	    if (OBJ_obj2nid(ad->method) == NID_ad_OCSP
		&& ad->location->type == GEN_URI) {
		XPUSHs(sv_2mortal(newSVpv(
		    (char*)ASN1_STRING_data(ad->location->d.uniformResourceIdentifier),
		    ASN1_STRING_length(ad->location->d.uniformResourceIdentifier)
		)));
		if (GIMME == G_SCALAR) break; /* get only first */
	    }
	}
#line 6537 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_X509_get_ext_key_usage); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_get_ext_key_usage)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "cert, format=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	int	format;
#line 3046 "SSLeay.xs"
        EXTENDED_KEY_USAGE *extusage;
        int i, nid;
        char buffer[100]; /* openssl doc: a buffer length of 80 should be more than enough to handle any OID encountered in practice */
        ASN1_OBJECT *o;
#line 6561 "SSLeay.c"

	if (items < 2)
	    format = 0;
	else {
	    format = (int)SvIV(ST(1))
;
	}
#line 3051 "SSLeay.xs"
        extusage = X509_get_ext_d2i(cert, NID_ext_key_usage, NULL, NULL);
        for(i = 0; i < sk_ASN1_OBJECT_num(extusage); i++) {
           o = sk_ASN1_OBJECT_value(extusage,i);
           nid = OBJ_obj2nid(o);
           OBJ_obj2txt(buffer, sizeof(buffer)-1, o, 1);
           if(format==0)
               XPUSHs(sv_2mortal(newSVpv(buffer,0)));          /* format 0: oid */
           else if(format==1 && nid>0)
               XPUSHs(sv_2mortal(newSViv(nid)));               /* format 1: nid */
           else if(format==2 && nid>0)
               XPUSHs(sv_2mortal(newSVpv(OBJ_nid2sn(nid),0))); /* format 2: shortname */
           else if(format==3 && nid>0)
               XPUSHs(sv_2mortal(newSVpv(OBJ_nid2ln(nid),0))); /* format 3: longname */
        }
#line 6584 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Net__SSLeay_P_X509_get_key_usage); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_get_key_usage)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
#line 3072 "SSLeay.xs"
        ASN1_BIT_STRING * u;
#line 6605 "SSLeay.c"
#line 3074 "SSLeay.xs"
        u = X509_get_ext_d2i(cert, NID_key_usage, NULL, NULL);
        if (u) {
            if (ASN1_BIT_STRING_get_bit(u,0)) XPUSHs(sv_2mortal(newSVpv("digitalSignature",0)));
            if (ASN1_BIT_STRING_get_bit(u,1)) XPUSHs(sv_2mortal(newSVpv("nonRepudiation",0)));
            if (ASN1_BIT_STRING_get_bit(u,2)) XPUSHs(sv_2mortal(newSVpv("keyEncipherment",0)));
            if (ASN1_BIT_STRING_get_bit(u,3)) XPUSHs(sv_2mortal(newSVpv("dataEncipherment",0)));
            if (ASN1_BIT_STRING_get_bit(u,4)) XPUSHs(sv_2mortal(newSVpv("keyAgreement",0)));
            if (ASN1_BIT_STRING_get_bit(u,5)) XPUSHs(sv_2mortal(newSVpv("keyCertSign",0)));
            if (ASN1_BIT_STRING_get_bit(u,6)) XPUSHs(sv_2mortal(newSVpv("cRLSign",0)));
            if (ASN1_BIT_STRING_get_bit(u,7)) XPUSHs(sv_2mortal(newSVpv("encipherOnly",0)));
            if (ASN1_BIT_STRING_get_bit(u,8)) XPUSHs(sv_2mortal(newSVpv("decipherOnly",0)));
        }
#line 6619 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_X509_get_netscape_cert_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_get_netscape_cert_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
#line 3091 "SSLeay.xs"
        ASN1_BIT_STRING * u;
#line 6639 "SSLeay.c"
#line 3093 "SSLeay.xs"
        u = X509_get_ext_d2i(cert, NID_netscape_cert_type, NULL, NULL);
        if (u) {
            if (ASN1_BIT_STRING_get_bit(u,0)) XPUSHs(sv_2mortal(newSVpv("client",0)));
            if (ASN1_BIT_STRING_get_bit(u,1)) XPUSHs(sv_2mortal(newSVpv("server",0)));
            if (ASN1_BIT_STRING_get_bit(u,2)) XPUSHs(sv_2mortal(newSVpv("email",0)));
            if (ASN1_BIT_STRING_get_bit(u,3)) XPUSHs(sv_2mortal(newSVpv("objsign",0)));
            if (ASN1_BIT_STRING_get_bit(u,4)) XPUSHs(sv_2mortal(newSVpv("reserved",0)));
            if (ASN1_BIT_STRING_get_bit(u,5)) XPUSHs(sv_2mortal(newSVpv("sslCA",0)));
            if (ASN1_BIT_STRING_get_bit(u,6)) XPUSHs(sv_2mortal(newSVpv("emailCA",0)));
            if (ASN1_BIT_STRING_get_bit(u,7)) XPUSHs(sv_2mortal(newSVpv("objCA",0)));
        }
#line 6652 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_X509_get_ext_by_NID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_ext_by_NID)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "x, nid, loc=-1");
    {
	X509*	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	int	nid = (int)SvIV(ST(1))
;
	int	loc;
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    loc = -1;
	else {
	    loc = (int)SvIV(ST(2))
;
	}

	RETVAL = X509_get_ext_by_NID(x, nid, loc);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_ext); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_ext)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, loc");
    {
	X509*	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	int	loc = (int)SvIV(ST(1))
;
	X509_EXTENSION *	RETVAL;
	dXSTARG;

	RETVAL = X509_get_ext(x, loc);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_EXTENSION_get_critical); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_EXTENSION_get_critical)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ex");
    {
	int	RETVAL;
	dXSTARG;
	X509_EXTENSION *	ex = INT2PTR(X509_EXTENSION *,SvIV(ST(0)))
;

	RETVAL = X509_EXTENSION_get_critical(ex);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_EXTENSION_get_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_EXTENSION_get_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ne");
    {
	ASN1_OCTET_STRING *	RETVAL;
	dXSTARG;
	X509_EXTENSION *	ne = INT2PTR(X509_EXTENSION *,SvIV(ST(0)))
;

	RETVAL = X509_EXTENSION_get_data(ne);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_EXTENSION_get_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_EXTENSION_get_object)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ex");
    {
	ASN1_OBJECT *	RETVAL;
	dXSTARG;
	X509_EXTENSION *	ex = INT2PTR(X509_EXTENSION *,SvIV(ST(0)))
;

	RETVAL = X509_EXTENSION_get_object(ex);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_ext_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_ext_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	int	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;

	RETVAL = X509_get_ext_count(x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_ext_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_ext_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	int	RETVAL;
	dXSTARG;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;

	RETVAL = X509_CRL_get_ext_count(x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_ext_by_NID); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_ext_by_NID)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "x, ni, loc=-1");
    {
	X509_CRL*	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	int	ni = (int)SvIV(ST(1))
;
	int	loc;
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    loc = -1;
	else {
	    loc = (int)SvIV(ST(2))
;
	}

	RETVAL = X509_CRL_get_ext_by_NID(x, ni, loc);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_ext); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_get_ext)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, loc");
    {
	X509_CRL*	x = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
	int	loc = (int)SvIV(ST(1))
;
	X509_EXTENSION *	RETVAL;
	dXSTARG;

	RETVAL = X509_CRL_get_ext(x, loc);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509V3_EXT_print); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509V3_EXT_print)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "ext, flags=0, utf8_decode=0");
    {
	X509_EXTENSION *	ext = INT2PTR(X509_EXTENSION *,SvIV(ST(0)))
;
	unsigned long	flags;
	int	utf8_decode;
#line 3148 "SSLeay.xs"
        BIO * bp;
        char * buf;
        int i, n;
        int indent=0;
#line 6870 "SSLeay.c"

	if (items < 2)
	    flags = 0;
	else {
	    flags = (unsigned long)SvUV(ST(1))
;
	}

	if (items < 3)
	    utf8_decode = 0;
	else {
	    utf8_decode = (int)SvIV(ST(2))
;
	}
#line 3153 "SSLeay.xs"
        ST(0) = sv_newmortal(); /* undef to start with */
        bp = BIO_new(BIO_s_mem());
        if (bp) {
            if(X509V3_EXT_print(bp,ext,flags,indent)) {
                n = BIO_ctrl_pending(bp);
                New(0, buf, n, char);
                if (buf) {
                    i = BIO_read(bp,buf,n);
                    if (i>=0 && i<=n) {
                        sv_setpvn(ST(0), buf, i);
                        if (utf8_decode) sv_utf8_decode(ST(0));
                    }
                    Safefree(buf);
                }
            }
            BIO_free(bp);
        }
#line 6903 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509V3_EXT_d2i); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509V3_EXT_d2i)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ext");
    {
	X509_EXTENSION *	ext = INT2PTR(X509_EXTENSION *,SvIV(ST(0)))
;
	void *	RETVAL;
	dXSTARG;

	RETVAL = X509V3_EXT_d2i(ext);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_error)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x509_store_ctx");
    {
	X509_STORE_CTX *	x509_store_ctx = INT2PTR(X509_STORE_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_CTX_get_error(x509_store_ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_error_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_get_error_depth)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x509_store_ctx");
    {
	X509_STORE_CTX *	x509_store_ctx = INT2PTR(X509_STORE_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_CTX_get_error_depth(x509_store_ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_set_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_set_ex_data)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "x509_store_ctx, idx, data");
    {
	X509_STORE_CTX *	x509_store_ctx = INT2PTR(X509_STORE_CTX *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	data = INT2PTR(void *,SvIV(ST(2)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_CTX_set_ex_data(x509_store_ctx, idx, data);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_set_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_set_error)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x509_store_ctx, s");
    {
	X509_STORE_CTX *	x509_store_ctx = INT2PTR(X509_STORE_CTX *,SvIV(ST(0)))
;
	int	s = (int)SvIV(ST(1))
;

	X509_STORE_CTX_set_error(x509_store_ctx, s);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_set_cert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_CTX_set_cert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x509_store_ctx, x");
    {
	X509_STORE_CTX *	x509_store_ctx = INT2PTR(X509_STORE_CTX *,SvIV(ST(0)))
;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(1)))
;

	X509_STORE_CTX_set_cert(x509_store_ctx, x);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_add_cert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_add_cert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, x");
    {
	X509_STORE *	ctx = INT2PTR(X509_STORE *,SvIV(ST(0)))
;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_add_cert(ctx, x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_add_crl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_add_crl)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, x");
    {
	X509_STORE *	ctx = INT2PTR(X509_STORE *,SvIV(ST(0)))
;
	X509_CRL *	x = INT2PTR(X509_CRL *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_add_crl(ctx, x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090800fL
#define XSubPPtmpAAAU 1


XS_EUPXS(XS_Net__SSLeay_X509_STORE_set_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_set_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, flags");
    {
	X509_STORE *	ctx = INT2PTR(X509_STORE *,SvIV(ST(0)))
;
	long	flags = (long)SvIV(ST(1))
;

	X509_STORE_set_flags(ctx, flags);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_set_purpose); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_set_purpose)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, purpose");
    {
	X509_STORE *	ctx = INT2PTR(X509_STORE *,SvIV(ST(0)))
;
	int	purpose = (int)SvIV(ST(1))
;

	X509_STORE_set_purpose(ctx, purpose);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_set_trust); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_set_trust)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, trust");
    {
	X509_STORE *	ctx = INT2PTR(X509_STORE *,SvIV(ST(0)))
;
	int	trust = (int)SvIV(ST(1))
;

	X509_STORE_set_trust(ctx, trust);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_STORE_set1_param); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_STORE_set1_param)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, pm");
    {
	X509_STORE *	ctx = INT2PTR(X509_STORE *,SvIV(ST(0)))
;
	X509_VERIFY_PARAM *	pm = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_STORE_set1_param(ctx, pm);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_X509_load_cert_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_load_cert_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, file, type");
    {
	X509_LOOKUP *	ctx = INT2PTR(X509_LOOKUP *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_load_cert_file(ctx, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_load_crl_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_load_crl_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, file, type");
    {
	X509_LOOKUP *	ctx = INT2PTR(X509_LOOKUP *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_load_crl_file(ctx, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_load_cert_crl_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_load_cert_crl_file)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, file, type");
    {
	X509_LOOKUP *	ctx = INT2PTR(X509_LOOKUP *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	int	type = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_load_cert_crl_file(ctx, file, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_verify_cert_error_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_verify_cert_error_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "n");
    {
	long	n = (long)SvIV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = X509_verify_cert_error_string(n);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	ASN1_INTEGER *	RETVAL;
	dXSTARG;

	RETVAL = ASN1_INTEGER_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    {
	ASN1_INTEGER *	i = INT2PTR(ASN1_INTEGER *,SvIV(ST(0)))
;

	ASN1_INTEGER_free(i);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_set)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "i, val");
    {
	int	RETVAL;
	dXSTARG;
	ASN1_INTEGER *	i = INT2PTR(ASN1_INTEGER *,SvIV(ST(0)))
;
	long	val = (long)SvIV(ST(1))
;

	RETVAL = ASN1_INTEGER_set(i, val);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_INTEGER_get)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "a");
    {
	long	RETVAL;
	dXSTARG;
	ASN1_INTEGER *	a = INT2PTR(ASN1_INTEGER *,SvIV(ST(0)))
;

	RETVAL = ASN1_INTEGER_get(a);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_set_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_set_hex)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "i, str");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	ASN1_INTEGER *	i = INT2PTR(ASN1_INTEGER *,SvIV(ST(0)))
;
	char *	str = (char *)SvPV_nolen(ST(1))
;
#line 3272 "SSLeay.xs"
        BIGNUM *bn;
        int rv = 1;
#line 7323 "SSLeay.c"
#line 3275 "SSLeay.xs"
        bn = BN_new();
        if (!BN_hex2bn(&bn, str)) XSRETURN_IV(0);
        if (!BN_to_ASN1_INTEGER(bn, i)) rv = 0;
        BN_free(bn);
        XSRETURN_IV(rv);
#line 7330 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_set_dec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_set_dec)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "i, str");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	ASN1_INTEGER *	i = INT2PTR(ASN1_INTEGER *,SvIV(ST(0)))
;
	char *	str = (char *)SvPV_nolen(ST(1))
;
#line 3286 "SSLeay.xs"
        BIGNUM *bn;
        int rv = 1;
#line 7353 "SSLeay.c"
#line 3289 "SSLeay.xs"
        bn = BN_new();
        if (!BN_dec2bn(&bn, str)) XSRETURN_IV(0);
        if (!BN_to_ASN1_INTEGER(bn, i)) rv = 0;
        BN_free(bn);
        XSRETURN_IV(rv);
#line 7360 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_get_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_get_hex)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	ASN1_INTEGER *	i = INT2PTR(ASN1_INTEGER *,SvIV(ST(0)))
;
#line 3299 "SSLeay.xs"
        BIGNUM *bn;
        char *result;
#line 7381 "SSLeay.c"
#line 3302 "SSLeay.xs"
        bn = BN_new();
        if (!bn) XSRETURN_UNDEF;
        ASN1_INTEGER_to_BN(i, bn);
        result = BN_bn2hex(bn);
        BN_free(bn);
        if (!result) XSRETURN_UNDEF;
        XPUSHs(sv_2mortal(newSVpv((const char*)result, strlen(result))));
        OPENSSL_free(result);
#line 7391 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_get_dec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_INTEGER_get_dec)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	ASN1_INTEGER *	i = INT2PTR(ASN1_INTEGER *,SvIV(ST(0)))
;
#line 3315 "SSLeay.xs"
        BIGNUM *bn;
        char *result;
#line 7412 "SSLeay.c"
#line 3318 "SSLeay.xs"
        bn = BN_new();
        if (!bn) XSRETURN_UNDEF;
        ASN1_INTEGER_to_BN(i, bn);
        result = BN_bn2dec(bn);
        BN_free(bn);
        if (!result) XSRETURN_UNDEF;
        XPUSHs(sv_2mortal(newSVpv((const char*)result, strlen(result))));
        OPENSSL_free(result);
#line 7422 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_ASN1_STRING_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_STRING_get)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, utf8_decode=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	ASN1_STRING *	s = INT2PTR(ASN1_STRING *,SvIV(ST(0)))
;
	int	utf8_decode;
#line 3332 "SSLeay.xs"
        SV * u8;
#line 7443 "SSLeay.c"

	if (items < 2)
	    utf8_decode = 0;
	else {
	    utf8_decode = (int)SvIV(ST(1))
;
	}
#line 3334 "SSLeay.xs"
        u8 = newSVpv((const char*)ASN1_STRING_data(s), ASN1_STRING_length(s));
        if (utf8_decode) sv_utf8_decode(u8);
        XPUSHs(sv_2mortal(u8));
#line 7455 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_X509_get_notBefore); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_notBefore)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	ASN1_TIME *	RETVAL;
	dXSTARG;

	RETVAL = X509_get_notBefore(cert);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_get_notAfter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_get_notAfter)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cert");
    {
	X509 *	cert = INT2PTR(X509 *,SvIV(ST(0)))
;
	ASN1_TIME *	RETVAL;
	dXSTARG;

	RETVAL = X509_get_notAfter(cert);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_gmtime_adj); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_gmtime_adj)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, adj");
    {
	ASN1_TIME *	s = INT2PTR(ASN1_TIME *,SvIV(ST(0)))
;
	long	adj = (long)SvIV(ST(1))
;
	ASN1_TIME *	RETVAL;
	dXSTARG;

	RETVAL = X509_gmtime_adj(s, adj);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_set)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, t");
    {
	ASN1_TIME *	s = INT2PTR(ASN1_TIME *,SvIV(ST(0)))
;
	time_t	t = (time_t)SvNV(ST(1))
;
	ASN1_TIME *	RETVAL;
	dXSTARG;

	RETVAL = ASN1_TIME_set(s, t);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	ASN1_TIME *	s = INT2PTR(ASN1_TIME *,SvIV(ST(0)))
;

	ASN1_TIME_free(s);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_timet); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_timet)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	ASN1_TIME *	s = INT2PTR(ASN1_TIME *,SvIV(ST(0)))
;
	time_t	RETVAL;
	dXSTARG;

	RETVAL = ASN1_TIME_timet(s);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_ASN1_TIME_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	ASN1_TIME *	RETVAL;
	dXSTARG;

	RETVAL = ASN1_TIME_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_ASN1_TIME_put2string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_TIME_put2string)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "tm");
    {
	ASN1_TIME *	tm = INT2PTR(ASN1_TIME *,SvIV(ST(0)))
;
#line 3371 "SSLeay.xs"
     BIO *bp=NULL;
     int i=0;
     char buffer[256];
#line 7608 "SSLeay.c"
#line 3377 "SSLeay.xs"
     ST(0) = sv_newmortal(); /* undef retval to start with */
     if (tm) {
         bp = BIO_new(BIO_s_mem());
         if (bp) {
             ASN1_TIME_print(bp,tm);
             i = BIO_read(bp,buffer,255);
             buffer[i] = '\0';
             if (i>0)
                 sv_setpvn(ST(0), buffer, i);
             BIO_free(bp);
         }
     }
#line 7622 "SSLeay.c"
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090705f
#define REM15 "NOTE: requires 0.9.7e+"
#define XSubPPtmpAAAV 1


XS_EUPXS(XS_Net__SSLeay_P_ASN1_TIME_get_isotime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_TIME_get_isotime)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tm");
    {
	ASN1_TIME *	tm = INT2PTR(ASN1_TIME *,SvIV(ST(0)))
;
#line 3397 "SSLeay.xs"
     ASN1_GENERALIZEDTIME *tmp = NULL;
     char buf[256];
#line 7644 "SSLeay.c"
#line 3400 "SSLeay.xs"
     buf[0] = '\0';
     /* ASN1_TIME_to_generalizedtime is buggy on pre-0.9.7e */
     ASN1_TIME_to_generalizedtime(tm,&tmp);
     if (tmp) {
       if (ASN1_GENERALIZEDTIME_check(tmp)) {
         if (strlen((char*)tmp->data)>=14 && strlen((char*)tmp->data)<200) {
           strcpy (buf,"yyyy-mm-ddThh:mm:ss");
           strncpy(buf,   (char*)tmp->data,   4);
           strncpy(buf+5, (char*)tmp->data+4, 2);
           strncpy(buf+8, (char*)tmp->data+6, 2);
           strncpy(buf+11,(char*)tmp->data+8, 2);
           strncpy(buf+14,(char*)tmp->data+10,2);
           strncpy(buf+17,(char*)tmp->data+12,2);
           if (strlen((char*)tmp->data)>14) strcat(buf+19,(char*)tmp->data+14);
         }
       }
       ASN1_GENERALIZEDTIME_free(tmp);
     }
     ST(0) = sv_newmortal();
     sv_setpv(ST(0), buf);
#line 7666 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_ASN1_TIME_set_isotime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_ASN1_TIME_set_isotime)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "tm, str");
    {
	ASN1_TIME *	tm = INT2PTR(ASN1_TIME *,SvIV(ST(0)))
;
	const char *	str = (const char *)SvPV_nolen(ST(1))
;
#line 3426 "SSLeay.xs"
     ASN1_TIME t;
     char buf[256];
     int i,rv;
#line 7687 "SSLeay.c"
#line 3430 "SSLeay.xs"
     if (!tm) XSRETURN_UNDEF;
     /* we support only "2012-03-22T23:55:33" or "2012-03-22T23:55:33Z" or "2012-03-22T23:55:33<timezone>" */
     if (strlen(str) < 19) XSRETURN_UNDEF;
     for (i=0;  i<4;  i++) if ((str[i] > '9') || (str[i] < '0')) XSRETURN_UNDEF;
     for (i=5;  i<7;  i++) if ((str[i] > '9') || (str[i] < '0')) XSRETURN_UNDEF;
     for (i=8;  i<10; i++) if ((str[i] > '9') || (str[i] < '0')) XSRETURN_UNDEF;
     for (i=11; i<13; i++) if ((str[i] > '9') || (str[i] < '0')) XSRETURN_UNDEF;
     for (i=14; i<16; i++) if ((str[i] > '9') || (str[i] < '0')) XSRETURN_UNDEF;
     for (i=17; i<19; i++) if ((str[i] > '9') || (str[i] < '0')) XSRETURN_UNDEF;
     strncpy(buf,    str,    4);
     strncpy(buf+4,  str+5,  2);
     strncpy(buf+6,  str+8,  2);
     strncpy(buf+8,  str+11, 2);
     strncpy(buf+10, str+14, 2);
     strncpy(buf+12, str+17, 2);
     buf[14] = '\0';
     if (strlen(str)>19 && strlen(str)<200) strcat(buf,str+19);

     /* WORKAROUND: ASN1_TIME_set_string() not available in 0.9.8 !!!*/
     /* in 1.0.0 we would simply: rv = ASN1_TIME_set_string(tm,buf); */
     t.length = strlen(buf);
     t.data = (unsigned char *)buf;
     t.flags = 0;
     t.type = V_ASN1_UTCTIME;
     if (!ASN1_TIME_check(&t)) {
        t.type = V_ASN1_GENERALIZEDTIME;
        if (!ASN1_TIME_check(&t)) XSRETURN_UNDEF;
     }
     tm->type = t.type;
     tm->flags = t.flags;
     if (!ASN1_STRING_set(tm,t.data,t.length)) XSRETURN_UNDEF;
     rv = 1;

     /* end of ASN1_TIME_set_string() reimplementation */

     ST(0) = sv_newmortal();
     sv_setiv(ST(0), rv); /* 1 = success, undef = failure */
#line 7726 "SSLeay.c"
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_copy_parameters); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_copy_parameters)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "to, from");
    {
	EVP_PKEY *	to = INT2PTR(EVP_PKEY *,SvIV(ST(0)))
;
	EVP_PKEY *	from = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = EVP_PKEY_copy_parameters(to, from);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	EVP_PKEY *	RETVAL;
	dXSTARG;

	RETVAL = EVP_PKEY_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pkey");
    {
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(0)))
;

	EVP_PKEY_free(pkey);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_assign_RSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_assign_RSA)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pkey, key");
    {
	int	RETVAL;
	dXSTARG;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(0)))
;
	RSA *	key = INT2PTR(RSA *,SvIV(ST(1)))
;

	RETVAL = EVP_PKEY_assign_RSA(pkey, key);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_bits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_bits)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pkey");
    {
	int	RETVAL;
	dXSTARG;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(0)))
;

	RETVAL = EVP_PKEY_bits(pkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pkey");
    {
	int	RETVAL;
	dXSTARG;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(0)))
;

	RETVAL = EVP_PKEY_size(pkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x1000000fL
#define XSubPPtmpAAAW 1


XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_PKEY_id)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pkey");
    {
	int	RETVAL;
	dXSTARG;
	const EVP_PKEY *	pkey = INT2PTR(const EVP_PKEY *,SvIV(ST(0)))
;

	RETVAL = EVP_PKEY_id(pkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_PEM_get_string_X509); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_get_string_X509)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x509");
    {
	X509 *	x509 = INT2PTR(X509 *,SvIV(ST(0)))
;
#line 3501 "SSLeay.xs"
        BIO *bp;
        int i, n;
        char *buf;
#line 7882 "SSLeay.c"
#line 3505 "SSLeay.xs"
        ST(0) = sv_newmortal(); /* undef to start with */
        bp = BIO_new(BIO_s_mem());
        if (bp && x509) {
            PEM_write_bio_X509(bp,x509);
            n = BIO_ctrl_pending(bp);
            New(0, buf, n, char);
            if (buf) {
                i = BIO_read(bp,buf,n);
                if (i>=0 && i<=n) sv_setpvn(ST(0), buf, i);
                Safefree(buf);
            }
            BIO_free(bp);
        }
#line 7897 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_get_string_X509_REQ); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_get_string_X509_REQ)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x509_req");
    {
	X509_REQ *	x509_req = INT2PTR(X509_REQ *,SvIV(ST(0)))
;
#line 3523 "SSLeay.xs"
        BIO *bp;
        int i, n;
        char *buf;
#line 7916 "SSLeay.c"
#line 3527 "SSLeay.xs"
        ST(0) = sv_newmortal(); /* undef to start with */
        bp = BIO_new(BIO_s_mem());
        if (bp && x509_req) {
            PEM_write_bio_X509_REQ(bp,x509_req);
            n = BIO_ctrl_pending(bp);
            New(0, buf, n, char);
            if (buf) {
                i = BIO_read(bp,buf,n);
                if (i>=0 && i<=n) sv_setpvn(ST(0), buf, i);
                Safefree(buf);
            }
            BIO_free(bp);
        }
#line 7931 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_get_string_X509_CRL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_get_string_X509_CRL)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x509_crl");
    {
	X509_CRL *	x509_crl = INT2PTR(X509_CRL *,SvIV(ST(0)))
;
#line 3545 "SSLeay.xs"
        BIO *bp;
        int i, n;
        char *buf;
#line 7950 "SSLeay.c"
#line 3549 "SSLeay.xs"
        ST(0) = sv_newmortal(); /* undef to start with */
        bp = BIO_new(BIO_s_mem());
        if (bp && x509_crl) {
            PEM_write_bio_X509_CRL(bp,x509_crl);
            n = BIO_ctrl_pending(bp);
            New(0, buf, n, char);
            if (buf) {
                i = BIO_read(bp,buf,n);
                if (i>=0 && i<=n) sv_setpvn(ST(0), buf, i);
                Safefree(buf);
            }
            BIO_free(bp);
        }
#line 7965 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_get_string_PrivateKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_get_string_PrivateKey)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "pk, passwd=NULL, enc_alg=NULL");
    {
	EVP_PKEY *	pk = INT2PTR(EVP_PKEY *,SvIV(ST(0)))
;
	char *	passwd;
	const EVP_CIPHER *	enc_alg;
#line 3569 "SSLeay.xs"
        BIO *bp;
        int i, n;
        char *buf;
        size_t passwd_len = 0;
        pem_password_cb * cb = NULL;
        void * u = NULL;
#line 7989 "SSLeay.c"

	if (items < 2)
	    passwd = NULL;
	else {
	    passwd = (char *)SvPV_nolen(ST(1))
;
	}

	if (items < 3)
	    enc_alg = NULL;
	else {
	    enc_alg = INT2PTR(const EVP_CIPHER *,SvIV(ST(2)))
;
	}
#line 3576 "SSLeay.xs"
        ST(0) = sv_newmortal(); /* undef to start with */
        bp = BIO_new(BIO_s_mem());
        if (bp && pk) {
            if (passwd) passwd_len = strlen(passwd);
            if (passwd_len>0) {
                /* encrypted key */
                if (!enc_alg)
                    PEM_write_bio_PrivateKey(bp,pk,EVP_des_cbc(),(unsigned char *)passwd,passwd_len,cb,u);
                else
                    PEM_write_bio_PrivateKey(bp,pk,enc_alg,(unsigned char *)passwd,passwd_len,cb,u);
            }
            else {
                /* unencrypted key */
                PEM_write_bio_PrivateKey(bp,pk,NULL,(unsigned char *)passwd,passwd_len,cb,u);
            }
            n = BIO_ctrl_pending(bp);
            New(0, buf, n, char);
            if (buf) {
                i = BIO_read(bp,buf,n);
                if (i>=0 && i<=n) sv_setpvn(ST(0), buf, i);
                Safefree(buf);
            }
            BIO_free(bp);
        }
#line 8029 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_PKCS12_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_PKCS12_file)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, file, password=NULL");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	char *	file = (char *)SvPV_nolen(ST(1))
;
	char *	password;
#line 3607 "SSLeay.xs"
        PKCS12 *p12;
        EVP_PKEY *private_key;
        X509 *certificate;
        FILE *fp;
#line 8052 "SSLeay.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    password = NULL;
	else {
	    password = (char *)SvPV_nolen(ST(2))
;
	}
#line 3612 "SSLeay.xs"
        RETVAL = 0;
        if ((fp = fopen (file, "rb"))) {
#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
            OPENSSL_add_all_algorithms_noconf();
#else
            OpenSSL_add_all_algorithms();
#endif
            if ((p12 = d2i_PKCS12_fp(fp, NULL))) {
                if (PKCS12_parse(p12, password, &private_key, &certificate, NULL)) {
                    if (private_key) {
                        if (SSL_CTX_use_PrivateKey(ctx, private_key)) RETVAL = 1;
                        EVP_PKEY_free(private_key);
                    }
                    if (certificate) {
                        if (SSL_CTX_use_certificate(ctx, certificate)) RETVAL = 1;
                        X509_free(certificate);
                    }
                }
                PKCS12_free(p12);
            }
            if (!RETVAL) ERR_print_errors_fp(stderr);
            fclose(fp);
        }
#line 8086 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_PKCS12_load_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_PKCS12_load_file)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "file, load_chain=0, password=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	file = (char *)SvPV_nolen(ST(0))
;
	int	load_chain;
	char *	password;
#line 3644 "SSLeay.xs"
        PKCS12 *p12;
        EVP_PKEY *private_key = NULL;
        X509 *certificate = NULL;
        STACK_OF(X509) *cachain = NULL;
        X509 *x;
        FILE *fp;
        int i, result;
#line 8114 "SSLeay.c"

	if (items < 2)
	    load_chain = 0;
	else {
	    load_chain = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    password = NULL;
	else {
	    password = (char *)SvPV_nolen(ST(2))
;
	}
#line 3652 "SSLeay.xs"
        if ((fp = fopen (file, "rb"))) {
#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
            OPENSSL_add_all_algorithms_noconf();
#else
            OpenSSL_add_all_algorithms();
#endif
            if ((p12 = d2i_PKCS12_fp(fp, NULL))) {
                if(load_chain)
                    result= PKCS12_parse(p12, password, &private_key, &certificate, &cachain);
                else
                    result= PKCS12_parse(p12, password, &private_key, &certificate, NULL);
                if (result) {
                    if (private_key)
                        XPUSHs(sv_2mortal(newSViv(PTR2IV(private_key))));
                    else
                        XPUSHs(sv_2mortal(newSVpv(NULL,0))); /* undef */
                    if (certificate)
                        XPUSHs(sv_2mortal(newSViv(PTR2IV(certificate))));
                    else
                        XPUSHs(sv_2mortal(newSVpv(NULL,0))); /* undef */
                    if (cachain) {
                        for (i=0; i<sk_X509_num(cachain); i++) {
                            x = sk_X509_value(cachain, i);
                            XPUSHs(sv_2mortal(newSViv(PTR2IV(x))));
                        }
                        sk_X509_free(cachain);
                    }
                }
                PKCS12_free(p12);
            }
            fclose(fp);
        }
#line 8162 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#ifndef OPENSSL_NO_MD2
#define XSubPPtmpAAAX 1


XS_EUPXS(XS_Net__SSLeay_MD2); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_MD2)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    {
#line 3690 "SSLeay.xs"
	STRLEN len;
	unsigned char md[MD2_DIGEST_LENGTH];
	unsigned char * ret;
#line 8183 "SSLeay.c"
	unsigned char*	data = (unsigned char *) SvPV( ST(0), len);
#line 3696 "SSLeay.xs"
	ret = MD2(data,len,md);
	if (ret!=NULL) {
		XSRETURN_PVN((char *) md, MD2_DIGEST_LENGTH);
	} else {
		XSRETURN_UNDEF;
	}
#line 8192 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifndef OPENSSL_NO_MD4
#define XSubPPtmpAAAY 1


XS_EUPXS(XS_Net__SSLeay_MD4); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_MD4)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    {
#line 3710 "SSLeay.xs"
	STRLEN len;
	unsigned char md[MD4_DIGEST_LENGTH];
#line 8212 "SSLeay.c"
	unsigned char*	data = (unsigned char *) SvPV( ST(0), len );
#line 3715 "SSLeay.xs"
	if (MD4(data,len,md)) {
		XSRETURN_PVN((char *) md, MD4_DIGEST_LENGTH);
	} else {
		XSRETURN_UNDEF;
	}
#line 8220 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifndef OPENSSL_NO_MD5
#define XSubPPtmpAAAZ 1


XS_EUPXS(XS_Net__SSLeay_MD5); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_MD5)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    {
#line 3728 "SSLeay.xs"
     STRLEN len;
     unsigned char md[MD5_DIGEST_LENGTH];
#line 8240 "SSLeay.c"
	unsigned char *	data = (unsigned char *) SvPV( ST(0), len);
#line 3733 "SSLeay.xs"
     if (MD5(data,len,md)) {
	  XSRETURN_PVN((char *) md, MD5_DIGEST_LENGTH);
     } else {
	  XSRETURN_UNDEF;
     }
#line 8248 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if OPENSSL_VERSION_NUMBER >= 0x00905000L
#define XSubPPtmpAABA 1


XS_EUPXS(XS_Net__SSLeay_RIPEMD160); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RIPEMD160)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    {
#line 3746 "SSLeay.xs"
     STRLEN len;
     unsigned char md[RIPEMD160_DIGEST_LENGTH];
#line 8268 "SSLeay.c"
	unsigned char *	data = (unsigned char *) SvPV( ST(0), len);
#line 3751 "SSLeay.xs"
     if (RIPEMD160(data,len,md)) {
	  XSRETURN_PVN((char *) md, RIPEMD160_DIGEST_LENGTH);
     } else {
	  XSRETURN_UNDEF;
     }
#line 8276 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if !defined(OPENSSL_NO_SHA)
#define XSubPPtmpAABB 1


XS_EUPXS(XS_Net__SSLeay_SHA1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SHA1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    {
#line 3764 "SSLeay.xs"
     STRLEN len;
     unsigned char md[SHA_DIGEST_LENGTH];
#line 8296 "SSLeay.c"
	unsigned char *	data = (unsigned char *) SvPV( ST(0), len);
#line 3769 "SSLeay.xs"
     if (SHA1(data,len,md)) {
	  XSRETURN_PVN((char *) md, SHA_DIGEST_LENGTH);
     } else {
	  XSRETURN_UNDEF;
     }
#line 8304 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if !defined(OPENSSL_NO_SHA256) && OPENSSL_VERSION_NUMBER >= 0x0090800fL
#define XSubPPtmpAABC 1


XS_EUPXS(XS_Net__SSLeay_SHA256); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SHA256)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    {
#line 3781 "SSLeay.xs"
     STRLEN len;
     unsigned char md[SHA256_DIGEST_LENGTH];
#line 8324 "SSLeay.c"
	unsigned char *	data = (unsigned char *) SvPV( ST(0), len);
#line 3786 "SSLeay.xs"
     if (SHA256(data,len,md)) {
	  XSRETURN_PVN((char *) md, SHA256_DIGEST_LENGTH);
     } else {
	  XSRETURN_UNDEF;
     }
#line 8332 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if !defined(OPENSSL_NO_SHA512) && OPENSSL_VERSION_NUMBER >= 0x0090800fL
#define XSubPPtmpAABD 1


XS_EUPXS(XS_Net__SSLeay_SHA512); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SHA512)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    {
#line 3798 "SSLeay.xs"
     STRLEN len;
     unsigned char md[SHA512_DIGEST_LENGTH];
#line 8352 "SSLeay.c"
	unsigned char *	data = (unsigned char *) SvPV( ST(0), len);
#line 3803 "SSLeay.xs"
     if (SHA512(data,len,md)) {
	  XSRETURN_PVN((char *) md, SHA512_DIGEST_LENGTH);
     } else {
	  XSRETURN_UNDEF;
     }
#line 8360 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifndef OPENSSL_NO_SSL2
#if OPENSSL_VERSION_NUMBER < 0x10000000L
#define XSubPPtmpAABE 1


XS_EUPXS(XS_Net__SSLeay_SSLv2_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SSLv2_method)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const SSL_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = SSLv2_method();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#endif
#ifndef OPENSSL_NO_SSL3
#if OPENSSL_VERSION_NUMBER < 0x10002000L
#define XSubPPtmpAABF 1


XS_EUPXS(XS_Net__SSLeay_SSLv3_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SSLv3_method)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const SSL_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = SSLv3_method();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#endif

XS_EUPXS(XS_Net__SSLeay_TLSv1_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_TLSv1_method)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const SSL_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = TLSv1_method();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#ifdef SSL_TXT_TLSV1_1
#define XSubPPtmpAABG 1


XS_EUPXS(XS_Net__SSLeay_TLSv1_1_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_TLSv1_1_method)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const SSL_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = TLSv1_1_method();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#ifdef SSL_TXT_TLSV1_2
#define XSubPPtmpAABH 1


XS_EUPXS(XS_Net__SSLeay_TLSv1_2_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_TLSv1_2_method)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const SSL_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = TLSv1_2_method();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#if OPENSSL_VERSION_NUMBER < 0x10000000L
#define XSubPPtmpAABI 1


XS_EUPXS(XS_Net__SSLeay_set_ssl_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_ssl_method)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, method");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL_METHOD *	method = INT2PTR(SSL_METHOD *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_ssl_method(ssl, method);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAABJ 1


XS_EUPXS(XS_Net__SSLeay_set_ssl_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_ssl_method)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, method");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	const SSL_METHOD *	method = INT2PTR(const SSL_METHOD *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_ssl_method(ssl, method);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_get_ssl_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_ssl_method)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	const SSL_METHOD *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_ssl_method(ssl);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#define REM_AUTOMATICALLY_GENERATED_1_09

XS_EUPXS(XS_Net__SSLeay_BIO_new_buffer_ssl_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_new_buffer_ssl_connect)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	BIO *	RETVAL;
	dXSTARG;

	RETVAL = BIO_new_buffer_ssl_connect(ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_new_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_new_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "filename, mode");
    {
	char *	filename = (char *)SvPV_nolen(ST(0))
;
	char *	mode = (char *)SvPV_nolen(ST(1))
;
	BIO *	RETVAL;
	dXSTARG;

	RETVAL = BIO_new_file(filename, mode);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_new_ssl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_new_ssl)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, client");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	client = (int)SvIV(ST(1))
;
	BIO *	RETVAL;
	dXSTARG;

	RETVAL = BIO_new_ssl(ctx, client);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_new_ssl_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_new_ssl_connect)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	BIO *	RETVAL;
	dXSTARG;

	RETVAL = BIO_new_ssl_connect(ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	BIO_METHOD *	type = INT2PTR(BIO_METHOD *,SvIV(ST(0)))
;
	BIO *	RETVAL;
	dXSTARG;

	RETVAL = BIO_new(type);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "bio");
    {
	BIO *	bio = INT2PTR(BIO *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = BIO_free(bio);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_read)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, max=32768");
    {
	BIO *	s = INT2PTR(BIO *,SvIV(ST(0)))
;
	int	max;
#line 3900 "SSLeay.xs"
	char *buf = NULL;
	int got;
#line 8672 "SSLeay.c"

	if (items < 2)
	    max = 32768;
	else {
	    max = (int)SvIV(ST(1))
;
	}
#line 3903 "SSLeay.xs"
	New(0, buf, max, char);
	ST(0) = sv_newmortal();   /* Undefined to start with */
	if ((got = BIO_read(s, buf, max)) >= 0)
		sv_setpvn( ST(0), buf, got);
	Safefree(buf);
#line 8686 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_write)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, buf");
    {
	BIO *	s = INT2PTR(BIO *,SvIV(ST(0)))
;
#line 3913 "SSLeay.xs"
     STRLEN len;
#line 8703 "SSLeay.c"
	char *	buf = SvPV( ST(1), len);
	int	RETVAL;
	dXSTARG;
#line 3917 "SSLeay.xs"
     RETVAL = BIO_write (s, buf, (int)len);
#line 8709 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_eof); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_eof)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	BIO *	s = INT2PTR(BIO *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = BIO_eof(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_pending); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_pending)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	BIO *	s = INT2PTR(BIO *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = BIO_pending(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_wpending); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_wpending)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	BIO *	s = INT2PTR(BIO *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = BIO_wpending(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_ssl_copy_session_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_ssl_copy_session_id)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "to, from");
    {
	BIO *	to = INT2PTR(BIO *,SvIV(ST(0)))
;
	BIO *	from = INT2PTR(BIO *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = BIO_ssl_copy_session_id(to, from);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_BIO_ssl_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_BIO_ssl_shutdown)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl_bio");
    {
	BIO *	ssl_bio = INT2PTR(BIO *,SvIV(ST(0)))
;

	BIO_ssl_shutdown(ssl_bio);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_add_client_CA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_add_client_CA)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, x");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_add_client_CA(ssl, x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_alert_desc_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_alert_desc_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	int	value = (int)SvIV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_alert_desc_string(value);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_alert_desc_string_long); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_alert_desc_string_long)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	int	value = (int)SvIV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_alert_desc_string_long(value);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_alert_type_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_alert_type_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	int	value = (int)SvIV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_alert_type_string(value);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_alert_type_string_long); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_alert_type_string_long)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	int	value = (int)SvIV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_alert_type_string_long(value);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_callback_ctrl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_callback_ctrl)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ssl, i, fp");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	i = (int)SvIV(ST(1))
;
	callback_no_ret *	fp = INT2PTR(callback_no_ret *,SvIV(ST(2)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_callback_ctrl(ssl, i, fp);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_check_private_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_check_private_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL *	ctx = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_check_private_key(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER < 0x009080dfL
#define REM8 "NOTE: before 0.9.8m"
#define XSubPPtmpAABK 1


XS_EUPXS(XS_Net__SSLeay_CIPHER_description); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CIPHER_description)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cipher, buf, size");
    {
	SSL_CIPHER *	cipher = INT2PTR(SSL_CIPHER *,SvIV(ST(0)))
;
	char *	buf = (char *)SvPV_nolen(ST(1))
;
	int	size = (int)SvIV(ST(2))
;
	char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_CIPHER_description(cipher, buf, size);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAABL 1


XS_EUPXS(XS_Net__SSLeay_CIPHER_description); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CIPHER_description)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cipher, buf, size");
    {
	const SSL_CIPHER *	cipher = INT2PTR(const SSL_CIPHER *,SvIV(ST(0)))
;
	char *	buf = (char *)SvPV_nolen(ST(1))
;
	int	size = (int)SvIV(ST(2))
;
	char *	RETVAL;
	dXSTARG;

	RETVAL = SSL_CIPHER_description(cipher, buf, size);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#endif
#if OPENSSL_VERSION_NUMBER < 0x0090707fL
#define REM9 "NOTE: before 0.9.7g"
#define XSubPPtmpAABM 1


XS_EUPXS(XS_Net__SSLeay_CIPHER_get_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CIPHER_get_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "c");
    {
	const char *	RETVAL;
	dXSTARG;
	SSL_CIPHER *	c = INT2PTR(SSL_CIPHER *,SvIV(ST(0)))
;

	RETVAL = SSL_CIPHER_get_name(c);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CIPHER_get_bits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CIPHER_get_bits)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "c, alg_bits=NULL");
    {
	SSL_CIPHER *	c = INT2PTR(SSL_CIPHER *,SvIV(ST(0)))
;
	int *	alg_bits;
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    alg_bits = NULL;
	else {
	    alg_bits = INT2PTR(int *,SvIV(ST(1)))
;
	}

	RETVAL = SSL_CIPHER_get_bits(c, alg_bits);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAABN 1


XS_EUPXS(XS_Net__SSLeay_CIPHER_get_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CIPHER_get_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "c");
    {
	const char *	RETVAL;
	dXSTARG;
	const SSL_CIPHER *	c = INT2PTR(const SSL_CIPHER *,SvIV(ST(0)))
;

	RETVAL = SSL_CIPHER_get_name(c);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CIPHER_get_bits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CIPHER_get_bits)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "c, alg_bits=NULL");
    {
	const SSL_CIPHER *	c = INT2PTR(const SSL_CIPHER *,SvIV(ST(0)))
;
	int *	alg_bits;
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    alg_bits = NULL;
	else {
	    alg_bits = INT2PTR(int *,SvIV(ST(1)))
;
	}

	RETVAL = SSL_CIPHER_get_bits(c, alg_bits);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_COMP_add_compression_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_COMP_add_compression_method)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "id, cm");
    {
	int	id = (int)SvIV(ST(0))
;
	COMP_METHOD *	cm = INT2PTR(COMP_METHOD *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_COMP_add_compression_method(id, cm);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_add_client_CA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_add_client_CA)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, x");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_add_client_CA(ctx, x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_callback_ctrl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_callback_ctrl)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, i, fp");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	i = (int)SvIV(ST(1))
;
	callback_no_ret *	fp = INT2PTR(callback_no_ret *,SvIV(ST(2)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_callback_ctrl(ctx, i, fp);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_check_private_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_check_private_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_check_private_key(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_ex_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, idx");
    {
	SSL_CTX *	ssl = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_ex_data(ssl, idx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_quiet_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_quiet_shutdown)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_quiet_shutdown(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_timeout)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_timeout(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_verify_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_verify_depth)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_verify_depth(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_verify_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_verify_mode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_verify_mode(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_cert_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_cert_store)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, store");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509_STORE *	store = INT2PTR(X509_STORE *,SvIV(ST(1)))
;

	SSL_CTX_set_cert_store(ctx, store);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_cert_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_cert_store)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509_STORE *	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_cert_store(ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_cert_verify_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_cert_verify_callback)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, callback, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback = ST(1)
;
	SV *	data;

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 4071 "SSLeay.xs"
        if (callback==NULL || !SvOK(callback)) {
            SSL_CTX_set_cert_verify_callback(ctx, NULL, NULL);
            cb_data_advanced_put(ctx, "ssleay_ctx_cert_verify_cb!!func", NULL);
            cb_data_advanced_put(ctx, "ssleay_ctx_cert_verify_cb!!data", NULL);
        }
        else {
            cb_data_advanced_put(ctx, "ssleay_ctx_cert_verify_cb!!func", newSVsv(callback));
            cb_data_advanced_put(ctx, "ssleay_ctx_cert_verify_cb!!data", newSVsv(data));
#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
            SSL_CTX_set_cert_verify_callback(ctx, ssleay_ctx_cert_verify_cb_invoke, ctx);
#else
            SSL_CTX_set_cert_verify_callback(ctx, ssleay_ctx_cert_verify_cb_invoke, (char*)ctx);
#endif
        }
#line 9355 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_client_CA_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_client_CA_list)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509_NAME_STACK *	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_client_CA_list(ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_client_CA_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_client_CA_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, list");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509_NAME_STACK *	list = INT2PTR(X509_NAME_STACK *,SvIV(ST(1)))
;

	SSL_CTX_set_client_CA_list(ctx, list);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_default_passwd_cb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_default_passwd_cb)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "ctx, callback=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback;

	if (items < 2)
	    callback = &PL_sv_undef;
	else {
	    callback = ST(1)
;
	}
#line 4100 "SSLeay.xs"
        if (callback==NULL || !SvOK(callback)) {
            SSL_CTX_set_default_passwd_cb(ctx, NULL);
            SSL_CTX_set_default_passwd_cb_userdata(ctx, NULL);
            cb_data_advanced_put(ctx, "ssleay_ctx_passwd_cb!!func", NULL);
        }
        else {
            cb_data_advanced_put(ctx, "ssleay_ctx_passwd_cb!!func", newSVsv(callback));
            SSL_CTX_set_default_passwd_cb_userdata(ctx, (void*)ctx);
            SSL_CTX_set_default_passwd_cb(ctx, &ssleay_ctx_passwd_cb_invoke);
        }
#line 9426 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_default_passwd_cb_userdata); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_default_passwd_cb_userdata)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "ctx, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	data;

	if (items < 2)
	    data = &PL_sv_undef;
	else {
	    data = ST(1)
;
	}
#line 4116 "SSLeay.xs"
        /* SSL_CTX_set_default_passwd_cb_userdata is set in SSL_CTX_set_default_passwd_cb */
        if (data==NULL || !SvOK(data)) {
            cb_data_advanced_put(ctx, "ssleay_ctx_passwd_cb!!data", NULL);
        }
        else {
            cb_data_advanced_put(ctx, "ssleay_ctx_passwd_cb!!data", newSVsv(data));
        }
#line 9457 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_ex_data)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ssl, idx, data");
    {
	SSL_CTX *	ssl = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	data = INT2PTR(void *,SvIV(ST(2)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_ex_data(ssl, idx, data);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_purpose); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_purpose)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, purpose");
    {
	SSL_CTX *	s = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	purpose = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_purpose(s, purpose);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_quiet_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_quiet_shutdown)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, mode");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	mode = (int)SvIV(ST(1))
;

	SSL_CTX_set_quiet_shutdown(ctx, mode);
    }
    XSRETURN_EMPTY;
}

#if OPENSSL_VERSION_NUMBER < 0x10000000L
#define XSubPPtmpAABO 1


XS_EUPXS(XS_Net__SSLeay_CTX_set_ssl_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_ssl_version)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, meth");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SSL_METHOD *	meth = INT2PTR(SSL_METHOD *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_ssl_version(ctx, meth);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAABP 1


XS_EUPXS(XS_Net__SSLeay_CTX_set_ssl_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_ssl_version)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, meth");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	const SSL_METHOD *	meth = INT2PTR(const SSL_METHOD *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_ssl_version(ctx, meth);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_CTX_set_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_timeout)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, t");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	t = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_timeout(ctx, t);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_trust); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_trust)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, trust");
    {
	SSL_CTX *	s = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	trust = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_trust(s, trust);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_verify_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_verify_depth)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, depth");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	int	depth = (int)SvIV(ST(1))
;

	SSL_CTX_set_verify_depth(ctx, depth);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_certificate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_certificate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, x");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_use_certificate(ctx, x);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_certificate_chain_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_certificate_chain_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, file");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	const char *	file = (const char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_use_certificate_chain_file(ctx, file);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_PrivateKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_PrivateKey)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, pkey");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	EVP_PKEY *	pkey = INT2PTR(EVP_PKEY *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_use_PrivateKey(ctx, pkey);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_use_RSAPrivateKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_use_RSAPrivateKey)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, rsa");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	RSA *	rsa = INT2PTR(RSA *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_use_RSAPrivateKey(ctx, rsa);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_do_handshake); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_do_handshake)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_do_handshake(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_dup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_dup)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	SSL *	RETVAL;
	dXSTARG;

	RETVAL = SSL_dup(ssl);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_current_cipher); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_current_cipher)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	const SSL_CIPHER *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_current_cipher(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_default_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_default_timeout)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_default_timeout(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_ex_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, idx");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_ex_data(ssl, idx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_finished); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_finished)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, buf, count");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	void *	buf = INT2PTR(void *,SvIV(ST(1)))
;
	size_t	count = (size_t)SvUV(ST(2))
;
	size_t	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_finished(s, buf, count);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_peer_finished); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_peer_finished)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, buf, count");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	void *	buf = INT2PTR(void *,SvIV(ST(1)))
;
	size_t	count = (size_t)SvUV(ST(2))
;
	size_t	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_peer_finished(s, buf, count);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_quiet_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_quiet_shutdown)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_quiet_shutdown(ssl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_shutdown)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_shutdown(ssl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_verify_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_verify_depth)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_verify_depth(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_verify_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_verify_mode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_verify_mode(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_verify_result); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_verify_result)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_verify_result(ssl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_renegotiate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_renegotiate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_renegotiate(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER < 0x10000000L
#define XSubPPtmpAABQ 1


XS_EUPXS(XS_Net__SSLeay_SESSION_cmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_cmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	SSL_SESSION *	a = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	SSL_SESSION *	b = INT2PTR(SSL_SESSION *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_cmp(a, b);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_SESSION_get_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_get_ex_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ss, idx");
    {
	SSL_SESSION *	ss = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_get_ex_data(ss, idx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_get_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_get_time)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL_SESSION *	s = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_get_time(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_get_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_get_timeout)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL_SESSION *	s = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_get_timeout(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_print_fp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_print_fp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "fp, ses");
    {
	FILE *	fp = PerlIO_findFILE(IoIFP(sv_2io(ST(0))))
;
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_print_fp(fp, ses);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_set_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_set_ex_data)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ss, idx, data");
    {
	SSL_SESSION *	ss = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	data = INT2PTR(void *,SvIV(ST(2)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_set_ex_data(ss, idx, data);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_set_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_set_time)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, t");
    {
	SSL_SESSION *	s = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	t = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_set_time(s, t);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_set_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_set_timeout)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, t");
    {
	SSL_SESSION *	s = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	long	t = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_set_timeout(s, t);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_accept_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_accept_state)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;

	SSL_set_accept_state(s);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_sk_X509_NAME_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_sk_X509_NAME_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sk");
    {
	X509_NAME_STACK *	sk = INT2PTR(X509_NAME_STACK *,SvIV(ST(0)))
;

	sk_X509_NAME_free(sk);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_sk_X509_NAME_num); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_sk_X509_NAME_num)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sk");
    {
	X509_NAME_STACK *	sk = INT2PTR(X509_NAME_STACK *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = sk_X509_NAME_num(sk);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_sk_X509_NAME_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_sk_X509_NAME_value)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sk, i");
    {
	X509_NAME_STACK *	sk = INT2PTR(X509_NAME_STACK *,SvIV(ST(0)))
;
	int	i = (int)SvIV(ST(1))
;
	X509_NAME *	RETVAL;
	dXSTARG;

	RETVAL = sk_X509_NAME_value(sk, i);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_client_CA_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_client_CA_list)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	X509_NAME_STACK *	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_client_CA_list(s);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_client_CA_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_client_CA_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, list");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	X509_NAME_STACK *	list = INT2PTR(X509_NAME_STACK *,SvIV(ST(1)))
;

	SSL_set_client_CA_list(s, list);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_connect_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_connect_state)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;

	SSL_set_connect_state(s);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_ex_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_ex_data)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ssl, idx, data");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	idx = (int)SvIV(ST(1))
;
	void *	data = INT2PTR(void *,SvIV(ST(2)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_ex_data(ssl, idx, data);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_info_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_info_callback)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ssl, callback, data=&PL_sv_undef");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	SV *	callback = ST(1)
;
	SV *	data;

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 4334 "SSLeay.xs"
        if (callback==NULL || !SvOK(callback)) {
            SSL_set_info_callback(ssl, NULL);
            cb_data_advanced_put(ssl, "ssleay_info_cb!!func", NULL);
            cb_data_advanced_put(ssl, "ssleay_info_cb!!data", NULL);
        } else {
            cb_data_advanced_put(ssl, "ssleay_info_cb!!func", newSVsv(callback));
            cb_data_advanced_put(ssl, "ssleay_info_cb!!data", newSVsv(data));
            SSL_set_info_callback(ssl, ssleay_info_cb_invoke);
        }
#line 10322 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_info_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_info_callback)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, callback, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback = ST(1)
;
	SV *	data;

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 4350 "SSLeay.xs"
        if (callback==NULL || !SvOK(callback)) {
            SSL_CTX_set_info_callback(ctx, NULL);
            cb_data_advanced_put(ctx, "ssleay_ctx_info_cb!!func", NULL);
            cb_data_advanced_put(ctx, "ssleay_ctx_info_cb!!data", NULL);
        } else {
            cb_data_advanced_put(ctx, "ssleay_ctx_info_cb!!func", newSVsv(callback));
            cb_data_advanced_put(ctx, "ssleay_ctx_info_cb!!data", newSVsv(data));
            SSL_CTX_set_info_callback(ctx, ssleay_ctx_info_cb_invoke);
        }
#line 10357 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_purpose); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_purpose)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, purpose");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	purpose = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_purpose(s, purpose);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_quiet_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_quiet_shutdown)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, mode");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	mode = (int)SvIV(ST(1))
;

	SSL_set_quiet_shutdown(ssl, mode);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_shutdown)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, mode");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	mode = (int)SvIV(ST(1))
;

	SSL_set_shutdown(ssl, mode);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_trust); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_trust)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, trust");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	trust = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_trust(s, trust);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_verify_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_verify_depth)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, depth");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	depth = (int)SvIV(ST(1))
;

	SSL_set_verify_depth(s, depth);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_verify_result); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_verify_result)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, v");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	v = (long)SvIV(ST(1))
;

	SSL_set_verify_result(ssl, v);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_shutdown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_shutdown)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_shutdown(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_version)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_version(ssl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define REM_MANUALLY_ADDED_1_09

XS_EUPXS(XS_Net__SSLeay_load_client_CA_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_load_client_CA_file)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "file");
    {
	const char *	file = (const char *)SvPV_nolen(ST(0))
;
	X509_NAME_STACK *	RETVAL;
	dXSTARG;

	RETVAL = SSL_load_client_CA_file(file);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_add_file_cert_subjects_to_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_add_file_cert_subjects_to_stack)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "stackCAs, file");
    {
	X509_NAME_STACK *	stackCAs = INT2PTR(X509_NAME_STACK *,SvIV(ST(0)))
;
	const char *	file = (const char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_add_file_cert_subjects_to_stack(stackCAs, file);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifndef WIN32
#ifndef VMS
#ifndef MAC_OS_pre_X
#define XSubPPtmpAABR 1


XS_EUPXS(XS_Net__SSLeay_add_dir_cert_subjects_to_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_add_dir_cert_subjects_to_stack)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "stackCAs, dir");
    {
	X509_NAME_STACK *	stackCAs = INT2PTR(X509_NAME_STACK *,SvIV(ST(0)))
;
	const char *	dir = (const char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_add_dir_cert_subjects_to_stack(stackCAs, dir);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#endif
#endif

XS_EUPXS(XS_Net__SSLeay_CTX_get_ex_new_index); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_ex_new_index)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "argl, argp, new_func, dup_func, free_func");
    {
	long	argl = (long)SvIV(ST(0))
;
	void *	argp = INT2PTR(void *,SvIV(ST(1)))
;
	CRYPTO_EX_new *	new_func = INT2PTR(CRYPTO_EX_new *,SvIV(ST(2)))
;
	CRYPTO_EX_dup *	dup_func = INT2PTR(CRYPTO_EX_dup *,SvIV(ST(3)))
;
	CRYPTO_EX_free *	free_func = INT2PTR(CRYPTO_EX_free *,SvIV(ST(4)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_get_ex_new_index(argl, argp, new_func, dup_func, free_func);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_session_id_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_session_id_context)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, sid_ctx, sid_ctx_len");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	const unsigned char *	sid_ctx = (const unsigned char *)SvPV_nolen(ST(1))
;
	unsigned int	sid_ctx_len = (unsigned int)SvUV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_session_id_context(ctx, sid_ctx, sid_ctx_len);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_session_id_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_session_id_context)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ssl, sid_ctx, sid_ctx_len");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	const unsigned char *	sid_ctx = (const unsigned char *)SvPV_nolen(ST(1))
;
	unsigned int	sid_ctx_len = (unsigned int)SvUV(ST(2))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_session_id_context(ssl, sid_ctx, sid_ctx_len);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_rsa_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_rsa_callback)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, cb");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	cb_ssl_int_int_ret_RSA *	cb = INT2PTR(cb_ssl_int_int_ret_RSA *,SvIV(ST(1)))
;

	SSL_CTX_set_tmp_rsa_callback(ctx, cb);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_tmp_rsa_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_tmp_rsa_callback)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, cb");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	cb_ssl_int_int_ret_RSA *	cb = INT2PTR(cb_ssl_int_int_ret_RSA *,SvIV(ST(1)))
;

	SSL_set_tmp_rsa_callback(ssl, cb);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_dh_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_dh_callback)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, dh");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	cb_ssl_int_int_ret_DH *	dh = INT2PTR(cb_ssl_int_int_ret_DH *,SvIV(ST(1)))
;

	SSL_CTX_set_tmp_dh_callback(ctx, dh);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_set_tmp_dh_callback); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_tmp_dh_callback)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, dh");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	cb_ssl_int_int_ret_DH *	dh = INT2PTR(cb_ssl_int_int_ret_DH *,SvIV(ST(1)))
;

	SSL_set_tmp_dh_callback(ssl, dh);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_get_ex_new_index); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_ex_new_index)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "argl, argp, new_func, dup_func, free_func");
    {
	long	argl = (long)SvIV(ST(0))
;
	void *	argp = INT2PTR(void *,SvIV(ST(1)))
;
	CRYPTO_EX_new *	new_func = INT2PTR(CRYPTO_EX_new *,SvIV(ST(2)))
;
	CRYPTO_EX_dup *	dup_func = INT2PTR(CRYPTO_EX_dup *,SvIV(ST(3)))
;
	CRYPTO_EX_free *	free_func = INT2PTR(CRYPTO_EX_free *,SvIV(ST(4)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_get_ex_new_index(argl, argp, new_func, dup_func, free_func);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_get_ex_new_index); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_get_ex_new_index)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "argl, argp, new_func, dup_func, free_func");
    {
	long	argl = (long)SvIV(ST(0))
;
	void *	argp = INT2PTR(void *,SvIV(ST(1)))
;
	CRYPTO_EX_new *	new_func = INT2PTR(CRYPTO_EX_new *,SvIV(ST(2)))
;
	CRYPTO_EX_dup *	dup_func = INT2PTR(CRYPTO_EX_dup *,SvIV(ST(3)))
;
	CRYPTO_EX_free *	free_func = INT2PTR(CRYPTO_EX_free *,SvIV(ST(4)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_SESSION_get_ex_new_index(argl, argp, new_func, dup_func, free_func);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define REM_SEMIAUTOMATIC_MACRO_GEN_1_09

XS_EUPXS(XS_Net__SSLeay_clear_num_renegotiations); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_clear_num_renegotiations)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4484 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_CLEAR_NUM_RENEGOTIATIONS,0,NULL);
#line 10798 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_add_extra_chain_cert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_add_extra_chain_cert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, x509");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509 *	x509 = INT2PTR(X509 *,SvIV(ST(1)))
;
	long	RETVAL;
	dXSTARG;
#line 4493 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_EXTRA_CHAIN_CERT,0,(char*)x509);
#line 10820 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_app_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_app_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	void *	RETVAL;
	dXSTARG;
#line 4501 "SSLeay.xs"
  RETVAL = SSL_CTX_get_ex_data(ctx,0);
#line 10840 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_mode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4509 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_MODE,0,NULL);
#line 10860 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_read_ahead); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_read_ahead)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4517 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_GET_READ_AHEAD,0,NULL);
#line 10880 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_get_session_cache_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_get_session_cache_mode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4525 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_GET_SESS_CACHE_MODE,0,NULL);
#line 10900 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_need_tmp_RSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_need_tmp_RSA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4533 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_NEED_TMP_RSA,0,NULL);
#line 10920 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_app_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_app_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, arg");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	char *	arg = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;
#line 4542 "SSLeay.xs"
  RETVAL = SSL_CTX_set_ex_data(ctx,0,arg);
#line 10942 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_mode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, op");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	op = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;
#line 4551 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_MODE,op,NULL);
#line 10964 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_read_ahead); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_read_ahead)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, m");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	m = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;
#line 4560 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_SET_READ_AHEAD,m,NULL);
#line 10986 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_session_cache_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_session_cache_mode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, m");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	long	m = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;
#line 4569 "SSLeay.xs"
  RETVAL = SSL_CTX_ctrl(ctx,SSL_CTRL_SET_SESS_CACHE_MODE,m,NULL);
#line 11008 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_dh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_dh)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, dh");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	DH *	dh = INT2PTR(DH *,SvIV(ST(1)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_tmp_dh(ctx, dh);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_rsa); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_rsa)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, rsa");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	RSA *	rsa = INT2PTR(RSA *,SvIV(ST(1)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_tmp_rsa(ctx, rsa);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER > 0x10000000L && !defined OPENSSL_NO_EC
#define XSubPPtmpAABS 1


XS_EUPXS(XS_Net__SSLeay_EC_KEY_new_by_curve_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EC_KEY_new_by_curve_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "nid");
    {
	int	nid = (int)SvIV(ST(0))
;
	EC_KEY *	RETVAL;
	dXSTARG;

	RETVAL = EC_KEY_new_by_curve_name(nid);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EC_KEY_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EC_KEY_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "key");
    {
	EC_KEY *	key = INT2PTR(EC_KEY *,SvIV(ST(0)))
;

	EC_KEY_free(key);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_ecdh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_tmp_ecdh)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, ecdh");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	EC_KEY *	ecdh = INT2PTR(EC_KEY *,SvIV(ST(1)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set_tmp_ecdh(ctx, ecdh);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_get_app_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_app_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	void *	RETVAL;
	dXSTARG;
#line 4604 "SSLeay.xs"
  RETVAL = SSL_get_ex_data(s,0);
#line 11130 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_cipher_bits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_cipher_bits)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, np=NULL");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int *	np;
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    np = NULL;
	else {
	    np = INT2PTR(int *,SvIV(ST(1)))
;
	}
#line 4613 "SSLeay.xs"
  RETVAL = SSL_CIPHER_get_bits(SSL_get_current_cipher(s),np);
#line 11158 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_mode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4621 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_MODE,0,NULL);
#line 11178 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_state)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;
#line 4629 "SSLeay.xs"
  RETVAL = SSL_state(ssl);
#line 11198 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_state)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, state");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	state = (int)SvIV(ST(1))
;
#line 4638 "SSLeay.xs"
#ifdef OPENSSL_NO_SSL_INTERN
   SSL_set_state(ssl,state);
#else
  ssl->state = state;
#endif
#line 11222 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_need_tmp_RSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_need_tmp_RSA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4648 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_NEED_TMP_RSA,0,NULL);
#line 11241 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_num_renegotiations); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_num_renegotiations)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4656 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_GET_NUM_RENEGOTIATIONS,0,NULL);
#line 11261 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_get_app_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_get_app_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ses");
    {
	SSL_SESSION *	ses = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	void *	RETVAL;
	dXSTARG;
#line 4664 "SSLeay.xs"
  RETVAL = SSL_SESSION_get_ex_data(ses,0);
#line 11281 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_session_reused); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_session_reused)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4672 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_GET_SESSION_REUSED,0,NULL);
#line 11301 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_set_app_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_set_app_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, a");
    {
	SSL_SESSION *	s = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
	void *	a = INT2PTR(void *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;
#line 4681 "SSLeay.xs"
  RETVAL = SSL_SESSION_set_ex_data(s,0,(char *)a);
#line 11323 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_app_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_app_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, arg");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	void *	arg = INT2PTR(void *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;
#line 4690 "SSLeay.xs"
  RETVAL = SSL_set_ex_data(s,0,(char *)arg);
#line 11345 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_mode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, op");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	op = (long)SvIV(ST(1))
;
	long	RETVAL;
	dXSTARG;
#line 4699 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_MODE,op,NULL);
#line 11367 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_pref_cipher); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_pref_cipher)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, n");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	const char *	n = (const char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;
#line 4708 "SSLeay.xs"
  RETVAL = SSL_set_cipher_list(s,n);
#line 11389 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_tmp_dh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_tmp_dh)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, dh");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	DH *	dh = INT2PTR(DH *,SvIV(ST(1)))
;
	long	RETVAL;
	dXSTARG;

	RETVAL = SSL_set_tmp_dh(ssl, dh);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_tmp_rsa); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_tmp_rsa)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, rsa");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	char *	rsa = (char *)SvPV_nolen(ST(1))
;
	long	RETVAL;
	dXSTARG;
#line 4722 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_SET_TMP_RSA,0,(char *)rsa);
#line 11432 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __ANDROID__
#define XSubPPtmpAABT 1


XS_EUPXS(XS_Net__SSLeay_RSA_generate_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RSA_generate_key)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "bits, ee, perl_cb=&PL_sv_undef, perl_data=&PL_sv_undef");
    {
	int	bits = (int)SvIV(ST(0))
;
	unsigned long	ee = (unsigned long)SvUV(ST(1))
;
	SV*	perl_cb;
	SV*	perl_data;
#line 4736 "SSLeay.xs"
        simple_cb_data_t* cb_data = NULL;
#line 11457 "SSLeay.c"
	RSA *	RETVAL;
	dXSTARG;

	if (items < 3)
	    perl_cb = &PL_sv_undef;
	else {
	    perl_cb = ST(2)
;
	}

	if (items < 4)
	    perl_data = &PL_sv_undef;
	else {
	    perl_data = ST(3)
;
	}
#line 4738 "SSLeay.xs"
       /* Android does not have RSA_generate_key. This equivalent is contributed by Brian Fraser for Android */
       /* but is not portable to old OpenSSLs where RSA_generate_key_ex is not available */
       int rc;
       RSA * ret;
       BIGNUM *e;
       e = BN_new();
       BN_set_word(e, ee);
       cb_data = simple_cb_data_new(perl_cb, perl_data);
       BN_GENCB new_cb;
       BN_GENCB_set_old(&new_cb, ssleay_RSA_generate_key_cb_invoke, cb_data);

       ret = RSA_new();
       rc = RSA_generate_key_ex(ret, bits, e, &new_cb);

       if (rc == -1 || ret == NULL)
           croak("Couldn't generate RSA key");
       simple_cb_data_free(cb_data);
       BN_free(e);
       e = NULL;
       RETVAL = ret;
#line 11495 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAABU 1


XS_EUPXS(XS_Net__SSLeay_RSA_generate_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RSA_generate_key)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "bits, e, perl_cb=&PL_sv_undef, perl_data=&PL_sv_undef");
    {
	int	bits = (int)SvIV(ST(0))
;
	unsigned long	e = (unsigned long)SvUV(ST(1))
;
	SV*	perl_cb;
	SV*	perl_data;
#line 4770 "SSLeay.xs"
        simple_cb_data_t* cb = NULL;
#line 11520 "SSLeay.c"
	RSA *	RETVAL;
	dXSTARG;

	if (items < 3)
	    perl_cb = &PL_sv_undef;
	else {
	    perl_cb = ST(2)
;
	}

	if (items < 4)
	    perl_data = &PL_sv_undef;
	else {
	    perl_data = ST(3)
;
	}
#line 4772 "SSLeay.xs"
        cb = simple_cb_data_new(perl_cb, perl_data);
        RETVAL = RSA_generate_key(bits, e, ssleay_RSA_generate_key_cb_invoke, cb);
        simple_cb_data_free(cb);
#line 11541 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_RSA_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_RSA_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "r");
    {
	RSA *	r = INT2PTR(RSA *,SvIV(ST(0)))
;

	RSA_free(r);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	X509 *	RETVAL;
	dXSTARG;

	RETVAL = X509_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "a");
    {
	X509 *	a = INT2PTR(X509 *,SvIV(ST(0)))
;

	X509_free(a);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_d2i_X509_CRL_bio); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_d2i_X509_CRL_bio)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "bp, unused=NULL");
    {
	X509_CRL *	RETVAL;
	dXSTARG;
	BIO *	bp = INT2PTR(BIO *,SvIV(ST(0)))
;
	void *	unused;

	if (items < 2)
	    unused = NULL;
	else {
	    unused = INT2PTR(void *,SvIV(ST(1)))
;
	}

	RETVAL = d2i_X509_CRL_bio(bp, unused);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_d2i_X509_REQ_bio); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_d2i_X509_REQ_bio)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "bp, unused=NULL");
    {
	X509_REQ *	RETVAL;
	dXSTARG;
	BIO *	bp = INT2PTR(BIO *,SvIV(ST(0)))
;
	void *	unused;

	if (items < 2)
	    unused = NULL;
	else {
	    unused = INT2PTR(void *,SvIV(ST(1)))
;
	}

	RETVAL = d2i_X509_REQ_bio(bp, unused);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_d2i_X509_bio); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_d2i_X509_bio)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "bp, unused=NULL");
    {
	X509 *	RETVAL;
	dXSTARG;
	BIO *	bp = INT2PTR(BIO *,SvIV(ST(0)))
;
	void *	unused;

	if (items < 2)
	    unused = NULL;
	else {
	    unused = INT2PTR(void *,SvIV(ST(1)))
;
	}

	RETVAL = d2i_X509_bio(bp, unused);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_DHparams); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_DHparams)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 4)
       croak_xs_usage(cv,  "bio, x=NULL, cb=NULL, u=NULL");
    {
	BIO *	bio = INT2PTR(BIO *,SvIV(ST(0)))
;
	void *	x;
	pem_password_cb *	cb;
	void *	u;
	DH *	RETVAL;
	dXSTARG;

	if (items < 2)
	    x = NULL;
	else {
	    x = INT2PTR(void *,SvIV(ST(1)))
;
	}

	if (items < 3)
	    cb = NULL;
	else {
	    cb = INT2PTR(pem_password_cb *,SvIV(ST(2)))
;
	}

	if (items < 4)
	    u = NULL;
	else {
	    u = INT2PTR(void *,SvIV(ST(3)))
;
	}

	RETVAL = PEM_read_bio_DHparams(bio, x, cb, u);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_X509_CRL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_X509_CRL)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 4)
       croak_xs_usage(cv,  "bio, x=NULL, cb=NULL, u=NULL");
    {
	BIO *	bio = INT2PTR(BIO *,SvIV(ST(0)))
;
	void *	x;
	pem_password_cb *	cb;
	void *	u;
	X509_CRL *	RETVAL;
	dXSTARG;

	if (items < 2)
	    x = NULL;
	else {
	    x = INT2PTR(void *,SvIV(ST(1)))
;
	}

	if (items < 3)
	    cb = NULL;
	else {
	    cb = INT2PTR(pem_password_cb *,SvIV(ST(2)))
;
	}

	if (items < 4)
	    u = NULL;
	else {
	    u = INT2PTR(void *,SvIV(ST(3)))
;
	}

	RETVAL = PEM_read_bio_X509_CRL(bio, x, cb, u);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_X509); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_X509)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 4)
       croak_xs_usage(cv,  "bio, x=NULL, cb=NULL, u=NULL");
    {
	X509 *	RETVAL;
	dXSTARG;
	BIO *	bio = INT2PTR(BIO *,SvIV(ST(0)))
;
	void *	x;
	void *	cb;
	void *	u;

	if (items < 2)
	    x = NULL;
	else {
	    x = INT2PTR(void *,SvIV(ST(1)))
;
	}

	if (items < 3)
	    cb = NULL;
	else {
	    cb = INT2PTR(void *,SvIV(ST(2)))
;
	}

	if (items < 4)
	    u = NULL;
	else {
	    u = INT2PTR(void *,SvIV(ST(3)))
;
	}

	RETVAL = PEM_read_bio_X509(bio, x, cb, u);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_X509_REQ); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_X509_REQ)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 4)
       croak_xs_usage(cv,  "bio, x=NULL, cb=NULL, u=NULL");
    {
	X509_REQ *	RETVAL;
	dXSTARG;
	BIO *	bio = INT2PTR(BIO *,SvIV(ST(0)))
;
	void *	x;
	pem_password_cb *	cb;
	void *	u;

	if (items < 2)
	    x = NULL;
	else {
	    x = INT2PTR(void *,SvIV(ST(1)))
;
	}

	if (items < 3)
	    cb = NULL;
	else {
	    cb = INT2PTR(pem_password_cb *,SvIV(ST(2)))
;
	}

	if (items < 4)
	    u = NULL;
	else {
	    u = INT2PTR(void *,SvIV(ST(3)))
;
	}

	RETVAL = PEM_read_bio_X509_REQ(bio, x, cb, u);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_PrivateKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_PEM_read_bio_PrivateKey)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "bio, perl_cb=&PL_sv_undef, perl_data=&PL_sv_undef");
    {
	BIO *	bio = INT2PTR(BIO *,SvIV(ST(0)))
;
	SV*	perl_cb;
	SV*	perl_data;
#line 4826 "SSLeay.xs"
        simple_cb_data_t* cb = NULL;
#line 11864 "SSLeay.c"
	EVP_PKEY *	RETVAL;
	dXSTARG;

	if (items < 2)
	    perl_cb = &PL_sv_undef;
	else {
	    perl_cb = ST(1)
;
	}

	if (items < 3)
	    perl_data = &PL_sv_undef;
	else {
	    perl_data = ST(2)
;
	}
#line 4828 "SSLeay.xs"
        RETVAL = 0;
        if (SvOK(perl_cb)) {
            /* setup our callback */
            cb = simple_cb_data_new(perl_cb, perl_data);
            RETVAL = PEM_read_bio_PrivateKey(bio, NULL, pem_password_cb_invoke, (void*)cb);
            simple_cb_data_free(cb);
        }
        else if (!SvOK(perl_cb) && SvOK(perl_data) && SvPOK(perl_data)) {
            /* use perl_data as the password */
            RETVAL = PEM_read_bio_PrivateKey(bio, NULL, NULL, SvPVX(perl_data));
        }
        else if (!SvOK(perl_cb) && !SvOK(perl_data)) {
            /* will trigger default password callback */
            RETVAL = PEM_read_bio_PrivateKey(bio, NULL, NULL, NULL);
        }
#line 11897 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_DH_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_DH_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dh");
    {
	DH *	dh = INT2PTR(DH *,SvIV(ST(0)))
;

	DH_free(dh);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_total_renegotiations); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_total_renegotiations)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ssl");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	long	RETVAL;
	dXSTARG;
#line 4854 "SSLeay.xs"
  RETVAL = SSL_ctrl(ssl,SSL_CTRL_GET_TOTAL_RENEGOTIATIONS,0,NULL);
#line 11933 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_get_master_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_get_master_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL_SESSION *	s = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
#line 4862 "SSLeay.xs"
     ST(0) = sv_newmortal();   /* Undefined to start with */
     sv_setpvn(ST(0), (const char*)s->master_key, s->master_key_length);
#line 11952 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_SESSION_set_master_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_SESSION_set_master_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, key");
    {
	SSL_SESSION *	s = INT2PTR(SSL_SESSION *,SvIV(ST(0)))
;
#line 4869 "SSLeay.xs"
     STRLEN len;
#line 11969 "SSLeay.c"
	char *	key = SvPV(ST(1), len);
#line 4873 "SSLeay.xs"
     memcpy(s->master_key, key, len);
     s->master_key_length = len;
#line 11974 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_get_client_random); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_client_random)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
#line 4880 "SSLeay.xs"
     ST(0) = sv_newmortal();   /* Undefined to start with */
     sv_setpvn(ST(0), (const char*)s->s3->client_random, SSL3_RANDOM_SIZE);
#line 11992 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_server_random); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_server_random)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
#line 4887 "SSLeay.xs"
     ST(0) = sv_newmortal();   /* Undefined to start with */
     sv_setpvn(ST(0), (const char*)s->s3->server_random, SSL3_RANDOM_SIZE);
#line 12010 "SSLeay.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_get_keyblock_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_get_keyblock_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;
#line 4894 "SSLeay.xs"
     if (s == NULL ||
	 s->enc_read_ctx == NULL ||
	 s->enc_read_ctx->cipher == NULL ||
	 s->read_hash == NULL)
     {
	RETVAL = -1;
     }
     else
     {
	const EVP_CIPHER *c;
	const EVP_MD *h;
	int md_size = -1;
	c = s->enc_read_ctx->cipher;
#if OPENSSL_VERSION_NUMBER >= 0x10001000L
	if (s->s3)
	    md_size = s->s3->tmp.new_mac_secret_size;
#elif OPENSSL_VERSION_NUMBER >= 0x00909000L
	h = EVP_MD_CTX_md(s->read_hash);
	md_size = EVP_MD_size(h);
#else
	h = s->read_hash;
	md_size = EVP_MD_size(h);
#endif
	RETVAL = (md_size > 0) ? (2 * (EVP_CIPHER_key_length(c) +
				       md_size +
				       EVP_CIPHER_iv_length(c)))
			       : -1;
     }
#line 12056 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if defined(SSL_F_SSL_SET_HELLO_EXTENSION)
#define XSubPPtmpAABV 1


XS_EUPXS(XS_Net__SSLeay_set_hello_extension); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_hello_extension)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, type, data");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	type = (int)SvIV(ST(1))
;
#line 4933 "SSLeay.xs"
     STRLEN len;
#line 12079 "SSLeay.c"
	char *	data = SvPV( ST(2), len);
	int	RETVAL;
	dXSTARG;
#line 4937 "SSLeay.xs"
     RETVAL = SSL_set_hello_extension(s, type, data, len);
#line 12085 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#if defined(SSL_F_SSL_SET_HELLO_EXTENSION) || defined(SSL_F_SSL_SET_SESSION_TICKET_EXT)
#define XSubPPtmpAABW 1


XS_EUPXS(XS_Net__SSLeay_set_session_secret_cb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_session_secret_cb)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "s, callback=&PL_sv_undef, data=&PL_sv_undef");
    {
	SSL *	s = INT2PTR(SSL *,SvIV(ST(0)))
;
	SV *	callback;
	SV *	data;

	if (items < 2)
	    callback = &PL_sv_undef;
	else {
	    callback = ST(1)
;
	}

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 4951 "SSLeay.xs"
        if (callback==NULL || !SvOK(callback)) {
            SSL_set_session_secret_cb(s, NULL, NULL);
            cb_data_advanced_put(s, "ssleay_session_secret_cb!!func", NULL);
            cb_data_advanced_put(s, "ssleay_session_secret_cb!!data", NULL);
        }
        else {
            cb_data_advanced_put(s, "ssleay_session_secret_cb!!func", newSVsv(callback));
            cb_data_advanced_put(s, "ssleay_session_secret_cb!!data", newSVsv(data));
            SSL_set_session_secret_cb(s, (int (*)(SSL *s, void *secret, int *secret_len,
                STACK_OF(SSL_CIPHER) *peer_ciphers,
                SSL_CIPHER **cipher, void *arg))&ssleay_session_secret_cb_invoke, s);
        }
#line 12134 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if OPENSSL_VERSION_NUMBER < 0x0090700fL
#define REM11 "NOTE: before 0.9.7"
#define XSubPPtmpAABX 1


XS_EUPXS(XS_Net__SSLeay_EVP_add_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_add_digest)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "digest");
    {
	int	RETVAL;
	dXSTARG;
	EVP_MD *	digest = INT2PTR(EVP_MD *,SvIV(ST(0)))
;

	RETVAL = EVP_add_digest(digest);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAABY 1


XS_EUPXS(XS_Net__SSLeay_EVP_add_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_add_digest)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "digest");
    {
	int	RETVAL;
	dXSTARG;
	const EVP_MD *	digest = INT2PTR(const EVP_MD *,SvIV(ST(0)))
;

	RETVAL = EVP_add_digest(digest);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#ifndef OPENSSL_NO_SHA
#define XSubPPtmpAABZ 1


XS_EUPXS(XS_Net__SSLeay_EVP_sha1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_sha1)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;
	dXSTARG;

	RETVAL = EVP_sha1();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#if !defined(OPENSSL_NO_SHA256) && OPENSSL_VERSION_NUMBER >= 0x0090800fL
#define XSubPPtmpAACA 1


XS_EUPXS(XS_Net__SSLeay_EVP_sha256); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_sha256)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;
	dXSTARG;

	RETVAL = EVP_sha256();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#if !defined(OPENSSL_NO_SHA512) && OPENSSL_VERSION_NUMBER >= 0x0090800fL
#define XSubPPtmpAACB 1


XS_EUPXS(XS_Net__SSLeay_EVP_sha512); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_sha512)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;
	dXSTARG;

	RETVAL = EVP_sha512();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_OpenSSL_add_all_digests); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OpenSSL_add_all_digests)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	OpenSSL_add_all_digests();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_EVP_get_digestbyname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_get_digestbyname)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	const EVP_MD *	RETVAL;
	dXSTARG;
	const char *	name = (const char *)SvPV_nolen(ST(0))
;

	RETVAL = EVP_get_digestbyname(name);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_MD_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_MD_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "md");
    {
	int	RETVAL;
	dXSTARG;
	const EVP_MD *	md = INT2PTR(const EVP_MD *,SvIV(ST(0)))
;

	RETVAL = EVP_MD_type(md);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_MD_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_MD_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "md");
    {
	int	RETVAL;
	dXSTARG;
	const EVP_MD *	md = INT2PTR(const EVP_MD *,SvIV(ST(0)))
;

	RETVAL = EVP_MD_size(md);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x1000000fL
#define XSubPPtmpAACC 1


XS_EUPXS(XS_Net__SSLeay_P_EVP_MD_list_all); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_EVP_MD_list_all)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 5005 "SSLeay.xs"
        AV * results;
#line 12334 "SSLeay.c"
#line 5007 "SSLeay.xs"
        results = (AV *)sv_2mortal((SV *)newAV());
        EVP_MD_do_all_sorted(handler_list_md_fn, results);
        RETVAL = newRV((SV *)results);
#line 12339 "SSLeay.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#endif
#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define REM16 "NOTE: requires 0.9.7+"
#define XSubPPtmpAACD 1


XS_EUPXS(XS_Net__SSLeay_EVP_MD_CTX_md); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_MD_CTX_md)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	const EVP_MD *	RETVAL;
	dXSTARG;
	const EVP_MD_CTX *	ctx = INT2PTR(const EVP_MD_CTX *,SvIV(ST(0)))
;

	RETVAL = EVP_MD_CTX_md(ctx);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_MD_CTX_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_MD_CTX_create)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	EVP_MD_CTX *	RETVAL;
	dXSTARG;

	RETVAL = EVP_MD_CTX_create();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_DigestInit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_DigestInit)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, type");
    {
	int	RETVAL;
	dXSTARG;
	EVP_MD_CTX *	ctx = INT2PTR(EVP_MD_CTX *,SvIV(ST(0)))
;
	const EVP_MD *	type = INT2PTR(const EVP_MD *,SvIV(ST(1)))
;

	RETVAL = EVP_DigestInit(ctx, type);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_DigestInit_ex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_DigestInit_ex)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "ctx, type, impl");
    {
	int	RETVAL;
	dXSTARG;
	EVP_MD_CTX *	ctx = INT2PTR(EVP_MD_CTX *,SvIV(ST(0)))
;
	const EVP_MD *	type = INT2PTR(const EVP_MD *,SvIV(ST(1)))
;
	ENGINE *	impl = INT2PTR(ENGINE *,SvIV(ST(2)))
;

	RETVAL = EVP_DigestInit_ex(ctx, type, impl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_EVP_MD_CTX_destroy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_MD_CTX_destroy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	EVP_MD_CTX *	ctx = INT2PTR(EVP_MD_CTX *,SvIV(ST(0)))
;

	EVP_MD_CTX_destroy(ctx);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_EVP_DigestUpdate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_DigestUpdate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, data");
    {
#line 5031 "SSLeay.xs"
     STRLEN len;
#line 12457 "SSLeay.c"
	EVP_MD_CTX *	ctx = INT2PTR(EVP_MD_CTX *, SvIV(ST(0)));
	unsigned char *	data = (unsigned char *) SvPV(ST(1), len);
#line 5036 "SSLeay.xs"
     XSRETURN_IV(EVP_DigestUpdate(ctx,data,len));
#line 12462 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_EVP_DigestFinal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_DigestFinal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	EVP_MD_CTX *	ctx = INT2PTR(EVP_MD_CTX *,SvIV(ST(0)))
;
#line 5042 "SSLeay.xs"
     unsigned char md[EVP_MAX_MD_SIZE];
     unsigned int md_size;
#line 12480 "SSLeay.c"
#line 5045 "SSLeay.xs"
     if (EVP_DigestFinal(ctx,md,&md_size))
         XSRETURN_PVN((char *)md, md_size);
     else
         XSRETURN_UNDEF;
#line 12486 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_EVP_DigestFinal_ex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_DigestFinal_ex)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	EVP_MD_CTX *	ctx = INT2PTR(EVP_MD_CTX *,SvIV(ST(0)))
;
#line 5054 "SSLeay.xs"
     unsigned char md[EVP_MAX_MD_SIZE];
     unsigned int md_size;
#line 12504 "SSLeay.c"
#line 5057 "SSLeay.xs"
     if (EVP_DigestFinal_ex(ctx,md,&md_size))
         XSRETURN_PVN((char *)md, md_size);
     else
         XSRETURN_UNDEF;
#line 12510 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_EVP_Digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_Digest)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 5065 "SSLeay.xs"
     STRLEN len;
     unsigned char md[EVP_MAX_MD_SIZE];
     unsigned int md_size;
#line 12526 "SSLeay.c"
	unsigned char *	data = (unsigned char *) SvPV(ST(0), len);
	EVP_MD *	type = INT2PTR(EVP_MD *, SvIV(ST(1)));
	ENGINE *	impl = (items>2 && SvOK(ST(2))) ? INT2PTR(ENGINE *, SvIV(ST(2))) : NULL;
#line 5073 "SSLeay.xs"
     if (EVP_Digest(data,len,md,&md_size,type,impl))
         XSRETURN_PVN((char *)md, md_size);
     else
         XSRETURN_UNDEF;
#line 12535 "SSLeay.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Net__SSLeay_EVP_get_cipherbyname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_EVP_get_cipherbyname)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	const EVP_CIPHER *	RETVAL;
	dXSTARG;
	const char *	name = (const char *)SvPV_nolen(ST(0))
;

	RETVAL = EVP_get_cipherbyname(name);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OpenSSL_add_all_algorithms); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OpenSSL_add_all_algorithms)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	OpenSSL_add_all_algorithms();
    }
    XSRETURN_EMPTY;
}

#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define XSubPPtmpAACE 1


XS_EUPXS(XS_Net__SSLeay_OPENSSL_add_all_algorithms_noconf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OPENSSL_add_all_algorithms_noconf)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	OPENSSL_add_all_algorithms_noconf();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_OPENSSL_add_all_algorithms_conf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OPENSSL_add_all_algorithms_conf)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	OPENSSL_add_all_algorithms_conf();
    }
    XSRETURN_EMPTY;
}

#endif
#if OPENSSL_VERSION_NUMBER >= 0x10000000L
#define XSubPPtmpAACF 1


XS_EUPXS(XS_Net__SSLeay_CTX_set1_param); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set1_param)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, vpm");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	X509_VERIFY_PARAM *	vpm = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_CTX_set1_param(ctx, vpm);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set1_param); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set1_param)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, vpm");
    {
	SSL *	ctx = INT2PTR(SSL *,SvIV(ST(0)))
;
	X509_VERIFY_PARAM *	vpm = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = SSL_set1_param(ctx, vpm);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#if OPENSSL_VERSION_NUMBER >= 0x0090800fL
#define XSubPPtmpAACG 1


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	X509_VERIFY_PARAM *	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_new();
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "param");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;

	X509_VERIFY_PARAM_free(param);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_inherit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_inherit)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "to, from");
    {
	X509_VERIFY_PARAM *	to = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	X509_VERIFY_PARAM *	from = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_inherit(to, from);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set1)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "to, from");
    {
	X509_VERIFY_PARAM *	to = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	X509_VERIFY_PARAM *	from = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_set1(to, from);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set1_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set1_name)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, name");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	const char *	name = (const char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_set1_name(param, name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, flags");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	unsigned long	flags = (unsigned long)SvUV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_set_flags(param, flags);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090801fL
#define REM13 "NOTE: requires 0.9.8a+"
#define XSubPPtmpAACH 1


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_clear_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_clear_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, flags");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	unsigned long	flags = (unsigned long)SvUV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_clear_flags(param, flags);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_get_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_get_flags)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "param");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	unsigned long	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_get_flags(param);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_purpose); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_purpose)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, purpose");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	int	purpose = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_set_purpose(param, purpose);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_trust); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_trust)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, trust");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	int	trust = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_set_trust(param, trust);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_depth)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, depth");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	int	depth = (int)SvIV(ST(1))
;

	X509_VERIFY_PARAM_set_depth(param, depth);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set_time)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, t");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	time_t	t = (time_t)SvNV(ST(1))
;

	X509_VERIFY_PARAM_set_time(param, t);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_add0_policy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_add0_policy)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, policy");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	ASN1_OBJECT *	policy = INT2PTR(ASN1_OBJECT *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_add0_policy(param, policy);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set1_policies); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_set1_policies)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "param, policies");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	STACK_OF(ASN1_OBJECT) *	policies = INT2PTR(STACK_OF(ASN1_OBJECT) *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_set1_policies(param, policies);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_get_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_get_depth)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "param");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_get_depth(param);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_add0_table); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_add0_table)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "param");
    {
	X509_VERIFY_PARAM *	param = INT2PTR(X509_VERIFY_PARAM *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_add0_table(param);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_lookup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_lookup)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	const char *	name = (const char *)SvPV_nolen(ST(0))
;
	const X509_VERIFY_PARAM *	RETVAL;
	dXSTARG;

	RETVAL = X509_VERIFY_PARAM_lookup(name);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_table_cleanup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_VERIFY_PARAM_table_cleanup)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	X509_VERIFY_PARAM_table_cleanup();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tree");
    {
	X509_POLICY_TREE *	tree = INT2PTR(X509_POLICY_TREE *,SvIV(ST(0)))
;

	X509_policy_tree_free(tree);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_level_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_level_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tree");
    {
	X509_POLICY_TREE *	tree = INT2PTR(X509_POLICY_TREE *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_tree_level_count(tree);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_get0_level); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_get0_level)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "tree, i");
    {
	X509_POLICY_TREE *	tree = INT2PTR(X509_POLICY_TREE *,SvIV(ST(0)))
;
	int	i = (int)SvIV(ST(1))
;
	X509_POLICY_LEVEL *	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_tree_get0_level(tree, i);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_get0_policies); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_get0_policies)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tree");
    {
	X509_POLICY_TREE *	tree = INT2PTR(X509_POLICY_TREE *,SvIV(ST(0)))
;
	STACK_OF(X509_POLICY_NODE) *	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_tree_get0_policies(tree);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_get0_user_policies); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_tree_get0_user_policies)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tree");
    {
	X509_POLICY_TREE *	tree = INT2PTR(X509_POLICY_TREE *,SvIV(ST(0)))
;
	STACK_OF(X509_POLICY_NODE) *	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_tree_get0_user_policies(tree);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_level_node_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_level_node_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "level");
    {
	X509_POLICY_LEVEL *	level = INT2PTR(X509_POLICY_LEVEL *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_level_node_count(level);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_level_get0_node); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_level_get0_node)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "level, i");
    {
	X509_POLICY_LEVEL *	level = INT2PTR(X509_POLICY_LEVEL *,SvIV(ST(0)))
;
	int	i = (int)SvIV(ST(1))
;
	X509_POLICY_NODE *	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_level_get0_node(level, i);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_node_get0_policy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_node_get0_policy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "node");
    {
	const X509_POLICY_NODE *	node = INT2PTR(const X509_POLICY_NODE *,SvIV(ST(0)))
;
	const ASN1_OBJECT *	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_node_get0_policy(node);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_node_get0_qualifiers); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_node_get0_qualifiers)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "node");
    {
	X509_POLICY_NODE *	node = INT2PTR(X509_POLICY_NODE *,SvIV(ST(0)))
;
	STACK_OF(POLICYQUALINFO) *	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_node_get0_qualifiers(node);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_policy_node_get0_parent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_policy_node_get0_parent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "node");
    {
	const X509_POLICY_NODE *	node = INT2PTR(const X509_POLICY_NODE *,SvIV(ST(0)))
;
	const X509_POLICY_NODE *	RETVAL;
	dXSTARG;

	RETVAL = X509_policy_node_get0_parent(node);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_OBJ_dup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_dup)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "o");
    {
	ASN1_OBJECT *	o = INT2PTR(ASN1_OBJECT *,SvIV(ST(0)))
;
	ASN1_OBJECT *	RETVAL;
	dXSTARG;

	RETVAL = OBJ_dup(o);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_nid2obj); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_nid2obj)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "n");
    {
	int	n = (int)SvIV(ST(0))
;
	ASN1_OBJECT *	RETVAL;
	dXSTARG;

	RETVAL = OBJ_nid2obj(n);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_nid2ln); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_nid2ln)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "n");
    {
	int	n = (int)SvIV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = OBJ_nid2ln(n);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_nid2sn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_nid2sn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "n");
    {
	int	n = (int)SvIV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = OBJ_nid2sn(n);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_obj2nid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_obj2nid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "o");
    {
	ASN1_OBJECT *	o = INT2PTR(ASN1_OBJECT *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = OBJ_obj2nid(o);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_txt2obj); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_txt2obj)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, no_name=0");
    {
	const char *	s = (const char *)SvPV_nolen(ST(0))
;
	int	no_name;
	ASN1_OBJECT *	RETVAL;
	dXSTARG;

	if (items < 2)
	    no_name = 0;
	else {
	    no_name = (int)SvIV(ST(1))
;
	}

	RETVAL = OBJ_txt2obj(s, no_name);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_obj2txt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_obj2txt)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "a, no_name=0");
    {
	ASN1_OBJECT *	a = INT2PTR(ASN1_OBJECT *,SvIV(ST(0)))
;
	int	no_name;
#line 5272 "SSLeay.xs"
    char buf[100]; /* openssl doc: a buffer length of 80 should be more than enough to handle any OID encountered in practice */
    int  len;
#line 13336 "SSLeay.c"

	if (items < 2)
	    no_name = 0;
	else {
	    no_name = (int)SvIV(ST(1))
;
	}
#line 5275 "SSLeay.xs"
    len = OBJ_obj2txt(buf, sizeof(buf), a, no_name);
    ST(0) = sv_newmortal();
    sv_setpvn(ST(0), buf, len);
#line 13348 "SSLeay.c"
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER < 0x0090700fL
#define REM14 "NOTE: before 0.9.7"
#define XSubPPtmpAACI 1


XS_EUPXS(XS_Net__SSLeay_OBJ_txt2nid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_txt2nid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	char *	s = (char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = OBJ_txt2nid(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAACJ 1


XS_EUPXS(XS_Net__SSLeay_OBJ_txt2nid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_txt2nid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	const char *	s = (const char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = OBJ_txt2nid(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__SSLeay_OBJ_ln2nid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_ln2nid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	const char *	s = (const char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = OBJ_ln2nid(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_sn2nid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_sn2nid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	const char *	s = (const char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = OBJ_sn2nid(s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OBJ_cmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OBJ_cmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	ASN1_OBJECT *	a = INT2PTR(ASN1_OBJECT *,SvIV(ST(0)))
;
	ASN1_OBJECT *	b = INT2PTR(ASN1_OBJECT *,SvIV(ST(1)))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = OBJ_cmp(a, b);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x0090700fL
#define XSubPPtmpAACK 1


XS_EUPXS(XS_Net__SSLeay_X509_pubkey_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_pubkey_digest)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "data, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const X509 *	data = INT2PTR(const X509 *,SvIV(ST(0)))
;
	const EVP_MD *	type = INT2PTR(const EVP_MD *,SvIV(ST(1)))
;
#line 5314 "SSLeay.xs"
        unsigned char md[EVP_MAX_MD_SIZE];
        unsigned int md_size;
#line 13478 "SSLeay.c"
#line 5317 "SSLeay.xs"
        if (X509_pubkey_digest(data,type,md,&md_size))
            XSRETURN_PVN((char *)md, md_size);
        else
            XSRETURN_UNDEF;
#line 13484 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Net__SSLeay_X509_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_digest)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "data, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const X509 *	data = INT2PTR(const X509 *,SvIV(ST(0)))
;
	const EVP_MD *	type = INT2PTR(const EVP_MD *,SvIV(ST(1)))
;
#line 5329 "SSLeay.xs"
        unsigned char md[EVP_MAX_MD_SIZE];
        unsigned int md_size;
#line 13508 "SSLeay.c"
#line 5332 "SSLeay.xs"
        if (X509_digest(data,type,md,&md_size))
            XSRETURN_PVN((char *)md, md_size);
        XSRETURN_UNDEF;
#line 13513 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_X509_CRL_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_CRL_digest)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "data, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const X509_CRL *	data = INT2PTR(const X509_CRL *,SvIV(ST(0)))
;
	const EVP_MD *	type = INT2PTR(const EVP_MD *,SvIV(ST(1)))
;
#line 5341 "SSLeay.xs"
        unsigned char md[EVP_MAX_MD_SIZE];
        unsigned int md_size;
#line 13536 "SSLeay.c"
#line 5344 "SSLeay.xs"
        if (X509_CRL_digest(data,type,md,&md_size))
            XSRETURN_PVN((char *)md, md_size);
        XSRETURN_UNDEF;
#line 13541 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_X509_REQ_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_REQ_digest)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "data, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const X509_REQ *	data = INT2PTR(const X509_REQ *,SvIV(ST(0)))
;
	const EVP_MD *	type = INT2PTR(const EVP_MD *,SvIV(ST(1)))
;
#line 5353 "SSLeay.xs"
        unsigned char md[EVP_MAX_MD_SIZE];
        unsigned int md_size;
#line 13564 "SSLeay.c"
#line 5356 "SSLeay.xs"
        if (X509_REQ_digest(data,type,md,&md_size))
            XSRETURN_PVN((char *)md, md_size);
        XSRETURN_UNDEF;
#line 13569 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_X509_NAME_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_NAME_digest)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "data, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const X509_NAME *	data = INT2PTR(const X509_NAME *,SvIV(ST(0)))
;
	const EVP_MD *	type = INT2PTR(const EVP_MD *,SvIV(ST(1)))
;
#line 5365 "SSLeay.xs"
        unsigned char md[EVP_MAX_MD_SIZE];
        unsigned int md_size;
#line 13592 "SSLeay.c"
#line 5368 "SSLeay.xs"
        if (X509_NAME_digest(data,type,md,&md_size))
            XSRETURN_PVN((char *)md, md_size);
        XSRETURN_UNDEF;
#line 13597 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_X509_subject_name_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_subject_name_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	unsigned long	RETVAL;
	dXSTARG;
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;

	RETVAL = X509_subject_name_hash(x);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_issuer_name_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_issuer_name_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "a");
    {
	unsigned long	RETVAL;
	dXSTARG;
	X509 *	a = INT2PTR(X509 *,SvIV(ST(0)))
;

	RETVAL = X509_issuer_name_hash(a);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_X509_issuer_and_serial_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_X509_issuer_and_serial_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "a");
    {
	unsigned long	RETVAL;
	dXSTARG;
	X509 *	a = INT2PTR(X509 *,SvIV(ST(0)))
;

	RETVAL = X509_issuer_and_serial_hash(a);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_X509_get_signature_alg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_get_signature_alg)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	ASN1_OBJECT *	RETVAL;
	dXSTARG;
#line 5385 "SSLeay.xs"
        RETVAL = (x->cert_info->signature->algorithm);
#line 13674 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_X509_get_pubkey_alg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_X509_get_pubkey_alg)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	X509 *	x = INT2PTR(X509 *,SvIV(ST(0)))
;
	ASN1_OBJECT *	RETVAL;
	dXSTARG;
#line 5393 "SSLeay.xs"
        RETVAL = (x->cert_info->key->algor->algorithm);
#line 13694 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#if OPENSSL_VERSION_NUMBER >= 0x10001000L && !defined(OPENSSL_NO_NEXTPROTONEG)
#define XSubPPtmpAACL 1


XS_EUPXS(XS_Net__SSLeay_CTX_set_next_protos_advertised_cb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_next_protos_advertised_cb)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, callback, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback = ST(1)
;
	SV *	data;
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 5405 "SSLeay.xs"
        RETVAL = 1;
        if (callback==NULL || !SvOK(callback)) {
            SSL_CTX_set_next_protos_advertised_cb(ctx, NULL, NULL);
            cb_data_advanced_put(ctx, "next_protos_advertised_cb!!func", NULL);
            cb_data_advanced_put(ctx, "next_protos_advertised_cb!!data", NULL);
            PR1("SSL_CTX_set_next_protos_advertised_cb - undef\n");
        }
        else if (SvROK(callback) && (SvTYPE(SvRV(callback)) == SVt_PVAV)) {
            /* callback param array ref like ['proto1','proto2'] */
            cb_data_advanced_put(ctx, "next_protos_advertised_cb!!func", NULL);
            cb_data_advanced_put(ctx, "next_protos_advertised_cb!!data", newSVsv(callback));
            SSL_CTX_set_next_protos_advertised_cb(ctx, next_protos_advertised_cb_invoke, ctx);
            PR2("SSL_CTX_set_next_protos_advertised_cb - simple ctx=%p\n",ctx);
        }
        else if (SvROK(callback) && (SvTYPE(SvRV(callback)) == SVt_PVCV)) {
            cb_data_advanced_put(ctx, "next_protos_advertised_cb!!func", newSVsv(callback));
            cb_data_advanced_put(ctx, "next_protos_advertised_cb!!data", newSVsv(data));
            SSL_CTX_set_next_protos_advertised_cb(ctx, next_protos_advertised_cb_invoke, ctx);
            PR2("SSL_CTX_set_next_protos_advertised_cb - advanced ctx=%p\n",ctx);
        }
        else {
            RETVAL = 0;
        }
#line 13749 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_next_proto_select_cb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_next_proto_select_cb)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, callback, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback = ST(1)
;
	SV *	data;
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 5437 "SSLeay.xs"
        RETVAL = 1;
        if (callback==NULL || !SvOK(callback)) {
            SSL_CTX_set_next_proto_select_cb(ctx, NULL, NULL);
            cb_data_advanced_put(ctx, "next_proto_select_cb!!func", NULL);
            cb_data_advanced_put(ctx, "next_proto_select_cb!!data", NULL);
            PR1("SSL_CTX_set_next_proto_select_cb - undef\n");
        }
        else if (SvROK(callback) && (SvTYPE(SvRV(callback)) == SVt_PVAV)) {
            /* callback param array ref like ['proto1','proto2'] */
            cb_data_advanced_put(ctx, "next_proto_select_cb!!func", NULL);
            cb_data_advanced_put(ctx, "next_proto_select_cb!!data", newSVsv(callback));
            SSL_CTX_set_next_proto_select_cb(ctx, next_proto_select_cb_invoke, ctx);
            PR2("SSL_CTX_set_next_proto_select_cb - simple ctx=%p\n",ctx);
        }
        else if (SvROK(callback) && (SvTYPE(SvRV(callback)) == SVt_PVCV)) {
            cb_data_advanced_put(ctx, "next_proto_select_cb!!func", newSVsv(callback));
            cb_data_advanced_put(ctx, "next_proto_select_cb!!data", newSVsv(data));
            SSL_CTX_set_next_proto_select_cb(ctx, next_proto_select_cb_invoke, ctx);
            PR2("SSL_CTX_set_next_proto_select_cb - advanced ctx=%p\n",ctx);
        }
        else {
            RETVAL = 0;
        }
#line 13801 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_next_proto_negotiated); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_next_proto_negotiated)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const SSL *	s = INT2PTR(const SSL *,SvIV(ST(0)))
;
#line 5467 "SSLeay.xs"
        const unsigned char *data;
        unsigned int len;
#line 13822 "SSLeay.c"
#line 5470 "SSLeay.xs"
        SSL_get0_next_proto_negotiated(s, &data, &len);
        XPUSHs(sv_2mortal(newSVpv((char *)data, len)));
#line 13826 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_P_next_proto_last_status); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_next_proto_last_status)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const SSL *	s = INT2PTR(const SSL *,SvIV(ST(0)))
;
#line 5477 "SSLeay.xs"
        XPUSHs(sv_2mortal(newSVsv(cb_data_advanced_get((void*)s, "next_proto_select_cb!!last_status"))));
#line 13846 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif
#if OPENSSL_VERSION_NUMBER >= 0x10000000L
#if !defined(OPENSSL_NO_TLSEXT)
#define XSubPPtmpAACM 1


XS_EUPXS(XS_Net__SSLeay_set_tlsext_status_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_tlsext_status_type)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ssl, cmd");
    {
	int	RETVAL;
	dXSTARG;
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	cmd = (int)SvIV(ST(1))
;

	RETVAL = SSL_set_tlsext_status_type(ssl, cmd);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_tlsext_status_cb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_tlsext_status_cb)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, callback, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback = ST(1)
;
	SV *	data;
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 5494 "SSLeay.xs"
	RETVAL = 1;
	if (callback==NULL || !SvOK(callback)) {
	    SSL_CTX_set_tlsext_status_cb(ctx, NULL);
	    cb_data_advanced_put(ctx, "tlsext_status_cb!!func", NULL);
	    cb_data_advanced_put(ctx, "tlsext_status_cb!!data", NULL);
	} else if (SvROK(callback) && (SvTYPE(SvRV(callback)) == SVt_PVCV)) {
	    cb_data_advanced_put(ctx, "tlsext_status_cb!!func", newSVsv(callback));
	    cb_data_advanced_put(ctx, "tlsext_status_cb!!data", newSVsv(data));
	    SSL_CTX_set_tlsext_status_cb(ctx, tlsext_status_cb_invoke);
	} else {
	    croak("argument must be code reference");
	}
#line 13913 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#define XSubPPtmpAACN 1


XS_EUPXS(XS_Net__SSLeay_d2i_OCSP_RESPONSE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_d2i_OCSP_RESPONSE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pv");
    {
	SV *	pv = ST(0)
;
	OCSP_RESPONSE *	RETVAL;
	dXSTARG;
#line 5515 "SSLeay.xs"
	RETVAL = NULL;
	if (SvPOK(pv)) {
	    const unsigned char *p;
	    STRLEN len;
	    p = (unsigned char*)SvPV(pv,len);
	    RETVAL = d2i_OCSP_RESPONSE(NULL,&p,len);
	}
#line 13942 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_i2d_OCSP_RESPONSE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_i2d_OCSP_RESPONSE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "r");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	OCSP_RESPONSE *	r = INT2PTR(OCSP_RESPONSE *,SvIV(ST(0)))
;
#line 5529 "SSLeay.xs"
	STRLEN len;
	unsigned char *pc,*pi;
	if (!(len = i2d_OCSP_RESPONSE(r,NULL))) croak("invalid OCSP response");
	Newx(pc,len,unsigned char);
	if (!pc) croak("out of memory");
	pi = pc;
	i2d_OCSP_RESPONSE(r,&pi);
	XPUSHs(sv_2mortal(newSVpv((char*)pc,len)));
	Safefree(pc);
#line 13970 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_OCSP_RESPONSE_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_RESPONSE_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "r");
    {
	OCSP_RESPONSE *	r = INT2PTR(OCSP_RESPONSE *,SvIV(ST(0)))
;

	OCSP_RESPONSE_free(r);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_d2i_OCSP_REQUEST); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_d2i_OCSP_REQUEST)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pv");
    {
	SV *	pv = ST(0)
;
	OCSP_REQUEST *	RETVAL;
	dXSTARG;
#line 5548 "SSLeay.xs"
	RETVAL = NULL;
	if (SvPOK(pv)) {
	    const unsigned char *p;
	    STRLEN len;
	    p = (unsigned char*)SvPV(pv,len);
	    RETVAL = d2i_OCSP_REQUEST(NULL,&p,len);
	}
#line 14012 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_i2d_OCSP_REQUEST); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_i2d_OCSP_REQUEST)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "r");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	OCSP_REQUEST *	r = INT2PTR(OCSP_REQUEST *,SvIV(ST(0)))
;
#line 5562 "SSLeay.xs"
	STRLEN len;
	unsigned char *pc,*pi;
	if (!(len = i2d_OCSP_REQUEST(r,NULL))) croak("invalid OCSP request");
	Newx(pc,len,unsigned char);
	if (!pc) croak("out of memory");
	pi = pc;
	i2d_OCSP_REQUEST(r,&pi);
	XPUSHs(sv_2mortal(newSVpv((char*)pc,len)));
	Safefree(pc);
#line 14040 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_OCSP_REQUEST_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_REQUEST_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "r");
    {
	OCSP_REQUEST *	r = INT2PTR(OCSP_REQUEST *,SvIV(ST(0)))
;

	OCSP_REQUEST_free(r);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__SSLeay_OCSP_response_status_str); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_response_status_str)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "status");
    {
	const char *	RETVAL;
	dXSTARG;
	long	status = (long)SvIV(ST(0))
;

	RETVAL = OCSP_response_status_str(status);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OCSP_response_status); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_response_status)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "r");
    {
	long	RETVAL;
	dXSTARG;
	OCSP_RESPONSE *	r = INT2PTR(OCSP_RESPONSE *,SvIV(ST(0)))
;

	RETVAL = OCSP_response_status(r);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OCSP_cert2ids); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_cert2ids)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "ssl, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
#line 5588 "SSLeay.xs"
	SSL_CTX *ctx;
	X509_STORE *store;
	STACK_OF(X509) *chain;
	X509 *cert,*issuer;
	OCSP_CERTID *id;
	int i;
	STRLEN len;
	unsigned char *pc,*pi;

	if (!ssl) croak("not a SSL object");
	ctx = SSL_get_SSL_CTX(ssl);
	if (!ctx) croak("invalid SSL object - no context");
	store = SSL_CTX_get_cert_store(ctx);
	chain = SSL_get_peer_cert_chain(ssl);

	for(i=0;i<items-1;i++) {
	    cert = INT2PTR(X509*,SvIV(ST(i+1)));
	    if (X509_check_issued(cert,cert) == X509_V_OK)
		croak("no OCSP request for self-signed certificate");
	    if (!(issuer = find_issuer(cert,store,chain)))
		croak("cannot find issuer to certificate");
	    if (!(id = OCSP_cert_to_id(EVP_sha1(),cert,issuer)))
		croak("out of memory for generating OCSO certid");
	    if (!(len = i2d_OCSP_CERTID(id,NULL)))
		croak("OCSP certid has no length");
	    Newx(pc,len,unsigned char);
	    if (!pc) croak("out of memory");
	    pi = pc;
	    i2d_OCSP_CERTID(id,&pi);
	    XPUSHs(sv_2mortal(newSVpv((char*)pc,len)));
	    Safefree(pc);
	}
#line 14145 "SSLeay.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Net__SSLeay_OCSP_ids2req); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_ids2req)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
	OCSP_REQUEST *	RETVAL;
	dXSTARG;
#line 5625 "SSLeay.xs"
	OCSP_REQUEST *req;
	OCSP_CERTID *id;
	int i;

	req = OCSP_REQUEST_new();
	if (!req) croak("out of memory");
	OCSP_request_add1_nonce(req,NULL,-1);

	for(i=0;i<items;i++) {
	    STRLEN len;
	    const unsigned char *p = (unsigned char*)SvPV(ST(i),len);
	    id = d2i_OCSP_CERTID(NULL,&p,len);
	    if (!id) {
		OCSP_REQUEST_free(req);
		croak("failed to get OCSP certid from string");
	    }
	    OCSP_request_add0_id(req,id);
	}
	RETVAL = req;
#line 14180 "SSLeay.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OCSP_response_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_response_verify)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "ssl, rsp, svreq=NULL, flags=0");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	OCSP_RESPONSE *	rsp = INT2PTR(OCSP_RESPONSE *,SvIV(ST(1)))
;
	SV *	svreq;
	unsigned long	flags;
#line 5656 "SSLeay.xs"
	SSL_CTX *ctx;
	X509_STORE *store;
	OCSP_BASICRESP *bsr;
	OCSP_REQUEST *req = NULL;
	int i;
#line 14206 "SSLeay.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    svreq = NULL;
	else {
	    svreq = ST(2)
;
	}

	if (items < 4)
	    flags = 0;
	else {
	    flags = (unsigned long)SvUV(ST(3))
;
	}
#line 5662 "SSLeay.xs"
	if (!ssl) croak("not a SSL object");
	ctx = SSL_get_SSL_CTX(ssl);
	if (!ctx) croak("invalid SSL object - no context");

	bsr = OCSP_response_get1_basic(rsp);
	if (!bsr) croak("invalid OCSP response");

	/* if we get a nonce it should match our nonce, if we get no nonce
	 * it was probably pre-signed */
	if (svreq && SvOK(svreq) &&
	    (req = INT2PTR(OCSP_REQUEST*,SvIV(svreq)))) {
	    i = OCSP_check_nonce(req,bsr);
	    if ( i <= 0 ) {
		if (i == -1) {
		    TRACE(2,"SSL_OCSP_response_verify: no nonce in response");
		} else {
		    OCSP_BASICRESP_free(bsr);
		    croak("nonce in OCSP response does not match request");
		}
	    }
	}

	RETVAL = 0;
	if ((store = SSL_CTX_get_cert_store(ctx))) {
	    /* add the SSL uchain to the uchain of the OCSP basic response, this
	     * looks like the easiest way to handle the case where the OCSP
	     * response does not contain the chain up to the trusted root */
	    STACK_OF(X509) *chain = SSL_get_peer_cert_chain(ssl);
	    for(i=0;i<sk_X509_num(chain);i++) {
		if (!bsr->certs) bsr->certs = sk_X509_new_null();
		sk_X509_push(bsr->certs,X509_dup(sk_X509_value(chain,i)));
	    }
	    TRACE(1,"run basic verify");
	    RETVAL = OCSP_basic_verify(bsr, NULL, store, flags);
	    if (!RETVAL) {
		/* some CAs don't add a certificate to their OCSP responses and
		 * openssl does not include the trusted CA which signed the
		 * lowest chain certificate when looking for the signer.
		 * So find this CA ourself and retry verification. */
		X509 *issuer;
		X509 *last = sk_X509_value(chain,sk_X509_num(chain)-1);
		if ( (issuer = find_issuer(last,store,chain))) {
		    sk_X509_push(bsr->certs,X509_dup(issuer));
		    TRACE(1,"run OCSP_basic_verify with issuer for last chain element");
		    RETVAL = OCSP_basic_verify(bsr, NULL, store, flags);
		}
	    }
	}
	OCSP_BASICRESP_free(bsr);
#line 14273 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_OCSP_response_results); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_OCSP_response_results)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "rsp, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	OCSP_RESPONSE *	rsp = INT2PTR(OCSP_RESPONSE *,SvIV(ST(0)))
;
#line 5719 "SSLeay.xs"
	OCSP_BASICRESP *bsr;
	int i,want_array;
	time_t nextupd = 0;
	STACK_OF(OCSP_SINGLERESP) *sks;
	int getall,sksn;

	bsr = OCSP_response_get1_basic(rsp);
	if (!bsr) croak("invalid OCSP response");

	want_array = (GIMME == G_ARRAY);
	getall = (items <= 1);
	sks = bsr->tbsResponseData->responses;
	sksn = sk_OCSP_SINGLERESP_num(sks);

	for(i=0; i < (getall ? sksn : items-1); i++) {
	    const char *error = NULL;
	    OCSP_SINGLERESP *sir = NULL;
	    OCSP_CERTID *certid = NULL;
	    SV *idsv = NULL;

	    if(getall) {
		sir = sk_OCSP_SINGLERESP_value(sks,i);
	    } else {
		int k;
		STRLEN len;
		const unsigned char *p;

		idsv = ST(i+1);
		if (!SvOK(idsv)) croak("undefined certid in arguments");
		p = (unsigned char*)SvPV(idsv,len);
		if (!(certid = d2i_OCSP_CERTID(NULL,&p,len))) {
		    error = "failed to get OCSP certid from string";
		    goto end;
		}
		for(k=0;k<sksn;k++) {
		    if (!OCSP_id_cmp(certid,sk_OCSP_SINGLERESP_value(sks,k)->certId)) {
			sir = sk_OCSP_SINGLERESP_value(sks,k);
			break;
		    }
		}
	    }

	    if (!sir) {
		error = "cannot find entry for certificate in OCSP response";
	    } else if (!OCSP_check_validity(sir->thisUpdate,sir->nextUpdate,0,-1)) {
		error = "response not yet valid or expired";
	    } else if (sir->certStatus->type == V_OCSP_CERTSTATUS_REVOKED) {
		error = "certificate status is revoked";
	    } else if (sir->certStatus->type != V_OCSP_CERTSTATUS_GOOD) {
		error = "certificate status is unknown";
	    }

	    end:
	    if (want_array) {
		AV *idav = newAV();
		if (!idsv) {
		    /* getall: create new SV with OCSP_CERTID */
		    unsigned char *pi,*pc;
		    int len = i2d_OCSP_CERTID(sir->certId,NULL);
		    if(!len) continue;
		    Newx(pc,len,unsigned char);
		    if (!pc) croak("out of memory");
		    pi = pc;
		    i2d_OCSP_CERTID(sir->certId,&pi);
		    idsv = newSVpv((char*)pc,len);
		    Safefree(pc);
		} else {
		    /* reuse idsv from ST(..), but increment refcount */
		    idsv = SvREFCNT_inc(idsv);
		}
		av_push(idav, idsv);
		av_push(idav, error ? newSVpv(error,0) : newSV(0));
		if (sir) {
		    HV *details = newHV();
		    av_push(idav,newRV_noinc((SV*)details));
		    hv_store(details,"statusType",10,
			newSViv(sir->certStatus->type),0);
		    if (sir->nextUpdate) hv_store(details,"nextUpdate",10,
			newSViv(ASN1_TIME_timet(sir->nextUpdate)),0);
		    if (sir->thisUpdate) hv_store(details,"thisUpdate",10,
			newSViv(ASN1_TIME_timet(sir->thisUpdate)),0);
		    if (sir->certStatus->type == V_OCSP_CERTSTATUS_REVOKED) {
			OCSP_REVOKEDINFO *rev = sir->certStatus->value.revoked;
			hv_store(details,"revocationTime",14,newSViv(
			    ASN1_TIME_timet(rev->revocationTime)),0);
			hv_store(details,"revocationReason",16,newSViv(
			    ASN1_ENUMERATED_get(rev->revocationReason)),0);
			hv_store(details,"revocationReason_str",20,newSVpv(
			    OCSP_crl_reason_str(ASN1_ENUMERATED_get(
			    rev->revocationReason)),0),0);
		    }
		}
		XPUSHs(sv_2mortal(newRV_noinc((SV*)idav)));
	    } else if (!error) {
		/* compute lowest nextUpdate */
		time_t nu = ASN1_TIME_timet(sir->nextUpdate);
		if (!nextupd || nextupd>nu) nextupd = nu;
	    }

	    if (certid) OCSP_CERTID_free(certid);
	    if (error && !want_array) {
		OCSP_BASICRESP_free(bsr);
		croak("%s", error);
	    }
	}
	if (!want_array)
	    XPUSHs(sv_2mortal(newSViv(nextupd)));
#line 14399 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif
#if OPENSSL_VERSION_NUMBER >= 0x10002000L && !defined(OPENSSL_NO_TLSEXT)
#define XSubPPtmpAACO 1


XS_EUPXS(XS_Net__SSLeay_CTX_set_alpn_select_cb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_alpn_select_cb)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "ctx, callback, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	callback = ST(1)
;
	SV *	data;
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    data = &PL_sv_undef;
	else {
	    data = ST(2)
;
	}
#line 5839 "SSLeay.xs"
        RETVAL = 1;
        if (callback==NULL || !SvOK(callback)) {
            SSL_CTX_set_alpn_select_cb(ctx, NULL, NULL);
            cb_data_advanced_put(ctx, "alpn_select_cb!!func", NULL);
            cb_data_advanced_put(ctx, "alpn_select_cb!!data", NULL);
            PR1("SSL_CTX_set_alpn_select_cb - undef\n");
        }
        else if (SvROK(callback) && (SvTYPE(SvRV(callback)) == SVt_PVAV)) {
            /* callback param array ref like ['proto1','proto2'] */
            cb_data_advanced_put(ctx, "alpn_select_cb!!func", NULL);
            cb_data_advanced_put(ctx, "alpn_select_cb!!data", newSVsv(callback));
            SSL_CTX_set_alpn_select_cb(ctx, alpn_select_cb_invoke, ctx);
            PR2("SSL_CTX_set_alpn_select_cb - simple ctx=%p\n",ctx);
        }
        else if (SvROK(callback) && (SvTYPE(SvRV(callback)) == SVt_PVCV)) {
            cb_data_advanced_put(ctx, "alpn_select_cb!!func", newSVsv(callback));
            cb_data_advanced_put(ctx, "alpn_select_cb!!data", newSVsv(data));
            SSL_CTX_set_alpn_select_cb(ctx, alpn_select_cb_invoke, ctx);
            PR2("SSL_CTX_set_alpn_select_cb - advanced ctx=%p\n",ctx);
        }
        else {
            RETVAL = 0;
        }
#line 14455 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_CTX_set_alpn_protos); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_CTX_set_alpn_protos)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "ctx, data=&PL_sv_undef");
    {
	SSL_CTX *	ctx = INT2PTR(SSL_CTX *,SvIV(ST(0)))
;
	SV *	data;
#line 5870 "SSLeay.xs"
        unsigned char *alpn_data;
        unsigned char alpn_len;

#line 14476 "SSLeay.c"
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    data = &PL_sv_undef;
	else {
	    data = ST(1)
;
	}
#line 5874 "SSLeay.xs"
        RETVAL = -1;

        if (!SvROK(data) || (SvTYPE(SvRV(data)) != SVt_PVAV))
            croak("Net::SSLeay: CTX_set_alpn_protos needs a single array reference.\n");
        alpn_len = next_proto_helper_AV2protodata((AV*)SvRV(data), NULL);
        Newx(alpn_data, alpn_len, unsigned char);
        if (!alpn_data)
            croak("Net::SSLeay: CTX_set_alpn_protos could not allocate memory.\n");
        alpn_len = next_proto_helper_AV2protodata((AV*)SvRV(data), alpn_data);
        RETVAL = SSL_CTX_set_alpn_protos(ctx, alpn_data, alpn_len);
        Safefree(alpn_data);

#line 14499 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_set_alpn_protos); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_set_alpn_protos)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "ssl, data=&PL_sv_undef");
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	SV *	data;
#line 5894 "SSLeay.xs"
        unsigned char *alpn_data;
        unsigned char alpn_len;

#line 14520 "SSLeay.c"
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    data = &PL_sv_undef;
	else {
	    data = ST(1)
;
	}
#line 5898 "SSLeay.xs"
        RETVAL = -1;

        if (!SvROK(data) || (SvTYPE(SvRV(data)) != SVt_PVAV))
            croak("Net::SSLeay: set_alpn_protos needs a single array reference.\n");
        alpn_len = next_proto_helper_AV2protodata((AV*)SvRV(data), NULL);
        Newx(alpn_data, alpn_len, unsigned char);
        if (!alpn_data)
            croak("Net::SSLeay: set_alpn_protos could not allocate memory.\n");
        alpn_len = next_proto_helper_AV2protodata((AV*)SvRV(data), alpn_data);
        RETVAL = SSL_set_alpn_protos(ssl, alpn_data, alpn_len);
        Safefree(alpn_data);

#line 14543 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__SSLeay_P_alpn_selected); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_P_alpn_selected)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const SSL *	s = INT2PTR(const SSL *,SvIV(ST(0)))
;
#line 5917 "SSLeay.xs"
        const unsigned char *data;
        unsigned int len;
#line 14564 "SSLeay.c"
#line 5920 "SSLeay.xs"
        SSL_get0_alpn_selected(s, &data, &len);
        XPUSHs(sv_2mortal(newSVpv((char *)data, len)));
#line 14568 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif
#if OPENSSL_VERSION_NUMBER >= 0x10001000L
#define XSubPPtmpAACP 1


XS_EUPXS(XS_Net__SSLeay_export_keying_material); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__SSLeay_export_keying_material)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "ssl, outlen, label, p");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SSL *	ssl = INT2PTR(SSL *,SvIV(ST(0)))
;
	int	outlen = (int)SvIV(ST(1))
;
#line 5932 "SSLeay.xs"
        char *  out;
        STRLEN labellen;
        STRLEN plen;
	int ret;
#line 14597 "SSLeay.c"
	char *	label = SvPV( ST(2), labellen);
	char *	p = SvPV( ST(3), plen);
#line 5940 "SSLeay.xs"
	New(0, out, outlen, char);
        ret = SSL_export_keying_material(ssl, (unsigned char*)out, outlen, label, labellen, (unsigned char*)p, plen, plen ? 1 : 0);
        PUSHs(sv_2mortal(ret>=0 ? newSVpvn(out, outlen) : newSV(0)));
        EXTEND(SP, 1);
	Safefree(out);
#line 14606 "SSLeay.c"
	PUTBACK;
	return;
    }
}

#endif
#define REM_EOF "/* EOF - SSLeay.xs */"
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Net__SSLeay); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Net__SSLeay)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Net::SSLeay::CLONE", XS_Net__SSLeay_CLONE, file, ";@");
        (void)newXSproto_portable("Net::SSLeay::constant", XS_Net__SSLeay_constant, file, "$");
        (void)newXSproto_portable("Net::SSLeay::hello", XS_Net__SSLeay_hello, file, "");
        (void)newXSproto_portable("Net::SSLeay::SSLeay", XS_Net__SSLeay_SSLeay, file, "");
        (void)newXSproto_portable("Net::SSLeay::SSLeay_version", XS_Net__SSLeay_SSLeay_version, file, ";$");
        (void)newXSproto_portable("Net::SSLeay::CTX_new", XS_Net__SSLeay_CTX_new, file, "");
#if XSubPPtmpAAAA
        (void)newXSproto_portable("Net::SSLeay::CTX_v2_new", XS_Net__SSLeay_CTX_v2_new, file, "");
#endif
#if XSubPPtmpAAAB
        (void)newXSproto_portable("Net::SSLeay::CTX_v3_new", XS_Net__SSLeay_CTX_v3_new, file, "");
#endif
        (void)newXSproto_portable("Net::SSLeay::CTX_v23_new", XS_Net__SSLeay_CTX_v23_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::CTX_tlsv1_new", XS_Net__SSLeay_CTX_tlsv1_new, file, "");
#if XSubPPtmpAAAC
        (void)newXSproto_portable("Net::SSLeay::CTX_tlsv1_1_new", XS_Net__SSLeay_CTX_tlsv1_1_new, file, "");
#endif
#if XSubPPtmpAAAD
        (void)newXSproto_portable("Net::SSLeay::CTX_tlsv1_2_new", XS_Net__SSLeay_CTX_tlsv1_2_new, file, "");
#endif
        (void)newXSproto_portable("Net::SSLeay::CTX_new_with_method", XS_Net__SSLeay_CTX_new_with_method, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_free", XS_Net__SSLeay_CTX_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_add_session", XS_Net__SSLeay_CTX_add_session, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_remove_session", XS_Net__SSLeay_CTX_remove_session, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_flush_sessions", XS_Net__SSLeay_CTX_flush_sessions, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_default_verify_paths", XS_Net__SSLeay_CTX_set_default_verify_paths, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_load_verify_locations", XS_Net__SSLeay_CTX_load_verify_locations, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_verify", XS_Net__SSLeay_CTX_set_verify, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::get_error", XS_Net__SSLeay_get_error, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::new", XS_Net__SSLeay_new, file, "$");
        (void)newXSproto_portable("Net::SSLeay::free", XS_Net__SSLeay_free, file, "$");
#if XSubPPtmpAAAE
        (void)newXSproto_portable("Net::SSLeay::debug", XS_Net__SSLeay_debug, file, "$");
#endif
        (void)newXSproto_portable("Net::SSLeay::accept", XS_Net__SSLeay_accept, file, "$");
        (void)newXSproto_portable("Net::SSLeay::clear", XS_Net__SSLeay_clear, file, "$");
        (void)newXSproto_portable("Net::SSLeay::connect", XS_Net__SSLeay_connect, file, "$");
#if XSubPPtmpAAAF
        (void)newXSproto_portable("Net::SSLeay::set_fd", XS_Net__SSLeay_set_fd, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_rfd", XS_Net__SSLeay_set_rfd, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_wfd", XS_Net__SSLeay_set_wfd, file, "$$");
#endif
#if XSubPPtmpAAAG
        (void)newXSproto_portable("Net::SSLeay::set_fd", XS_Net__SSLeay_set_fd, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_rfd", XS_Net__SSLeay_set_rfd, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_wfd", XS_Net__SSLeay_set_wfd, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::get_fd", XS_Net__SSLeay_get_fd, file, "$");
        (void)newXSproto_portable("Net::SSLeay::read", XS_Net__SSLeay_read, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::peek", XS_Net__SSLeay_peek, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::write", XS_Net__SSLeay_write, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::write_partial", XS_Net__SSLeay_write_partial, file, "$$$$");
        (void)newXSproto_portable("Net::SSLeay::use_RSAPrivateKey", XS_Net__SSLeay_use_RSAPrivateKey, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::use_RSAPrivateKey_ASN1", XS_Net__SSLeay_use_RSAPrivateKey_ASN1, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::use_RSAPrivateKey_file", XS_Net__SSLeay_use_RSAPrivateKey_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_RSAPrivateKey_file", XS_Net__SSLeay_CTX_use_RSAPrivateKey_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::use_PrivateKey", XS_Net__SSLeay_use_PrivateKey, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::use_PrivateKey_ASN1", XS_Net__SSLeay_use_PrivateKey_ASN1, file, "$$$$");
        (void)newXSproto_portable("Net::SSLeay::use_PrivateKey_file", XS_Net__SSLeay_use_PrivateKey_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_PrivateKey_file", XS_Net__SSLeay_CTX_use_PrivateKey_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::use_certificate", XS_Net__SSLeay_use_certificate, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::use_certificate_ASN1", XS_Net__SSLeay_use_certificate_ASN1, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::use_certificate_file", XS_Net__SSLeay_use_certificate_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_certificate_file", XS_Net__SSLeay_CTX_use_certificate_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::state_string", XS_Net__SSLeay_state_string, file, "$");
        (void)newXSproto_portable("Net::SSLeay::rstate_string", XS_Net__SSLeay_rstate_string, file, "$");
        (void)newXSproto_portable("Net::SSLeay::state_string_long", XS_Net__SSLeay_state_string_long, file, "$");
        (void)newXSproto_portable("Net::SSLeay::rstate_string_long", XS_Net__SSLeay_rstate_string_long, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_time", XS_Net__SSLeay_get_time, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_time", XS_Net__SSLeay_set_time, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_timeout", XS_Net__SSLeay_get_timeout, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_timeout", XS_Net__SSLeay_set_timeout, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::copy_session_id", XS_Net__SSLeay_copy_session_id, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_read_ahead", XS_Net__SSLeay_set_read_ahead, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::get_read_ahead", XS_Net__SSLeay_get_read_ahead, file, "$");
        (void)newXSproto_portable("Net::SSLeay::pending", XS_Net__SSLeay_pending, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_cipher_list", XS_Net__SSLeay_CTX_set_cipher_list, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_cipher_list", XS_Net__SSLeay_get_cipher_list, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_cipher_list", XS_Net__SSLeay_set_cipher_list, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_cipher", XS_Net__SSLeay_get_cipher, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_shared_ciphers", XS_Net__SSLeay_get_shared_ciphers, file, "$;$$");
        (void)newXSproto_portable("Net::SSLeay::get_peer_certificate", XS_Net__SSLeay_get_peer_certificate, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_peer_cert_chain", XS_Net__SSLeay_get_peer_cert_chain, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_verify", XS_Net__SSLeay_set_verify, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::set_bio", XS_Net__SSLeay_set_bio, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::get_rbio", XS_Net__SSLeay_get_rbio, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_wbio", XS_Net__SSLeay_get_wbio, file, "$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_new", XS_Net__SSLeay_SESSION_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::SESSION_print", XS_Net__SSLeay_SESSION_print, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_free", XS_Net__SSLeay_SESSION_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::i2d_SSL_SESSION", XS_Net__SSLeay_i2d_SSL_SESSION, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_session", XS_Net__SSLeay_set_session, file, "$$");
#if XSubPPtmpAAAH
        (void)newXSproto_portable("Net::SSLeay::d2i_SSL_SESSION", XS_Net__SSLeay_d2i_SSL_SESSION, file, "$$$");
#endif
#if XSubPPtmpAAAI
        (void)newXSproto_portable("Net::SSLeay::d2i_SSL_SESSION", XS_Net__SSLeay_d2i_SSL_SESSION, file, "$$$");
#endif
        cv = newXSproto_portable("Net::SSLeay::SSL_get0_session", XS_Net__SSLeay_get_session, file, "$");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("Net::SSLeay::get_session", XS_Net__SSLeay_get_session, file, "$");
        XSANY.any_i32 = 0;
        (void)newXSproto_portable("Net::SSLeay::get1_session", XS_Net__SSLeay_get1_session, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_certificate", XS_Net__SSLeay_get_certificate, file, "$");
#if XSubPPtmpAAAJ
        (void)newXSproto_portable("Net::SSLeay::get_SSL_CTX", XS_Net__SSLeay_get_SSL_CTX, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_SSL_CTX", XS_Net__SSLeay_set_SSL_CTX, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::ctrl", XS_Net__SSLeay_ctrl, file, "$$$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::CTX_ctrl", XS_Net__SSLeay_CTX_ctrl, file, "$$$$");
        (void)newXSproto_portable("Net::SSLeay::get_options", XS_Net__SSLeay_get_options, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_options", XS_Net__SSLeay_set_options, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_options", XS_Net__SSLeay_CTX_get_options, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_options", XS_Net__SSLeay_CTX_set_options, file, "$$");
#if XSubPPtmpAAAK
        (void)newXSproto_portable("Net::SSLeay::CTX_sessions", XS_Net__SSLeay_CTX_sessions, file, "$");
#endif
#if XSubPPtmpAAAL
        (void)newXSproto_portable("Net::SSLeay::CTX_sessions", XS_Net__SSLeay_CTX_sessions, file, "$");
#endif
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_number", XS_Net__SSLeay_CTX_sess_number, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_connect", XS_Net__SSLeay_CTX_sess_connect, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_connect_good", XS_Net__SSLeay_CTX_sess_connect_good, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_connect_renegotiate", XS_Net__SSLeay_CTX_sess_connect_renegotiate, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_accept", XS_Net__SSLeay_CTX_sess_accept, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_accept_renegotiate", XS_Net__SSLeay_CTX_sess_accept_renegotiate, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_accept_good", XS_Net__SSLeay_CTX_sess_accept_good, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_hits", XS_Net__SSLeay_CTX_sess_hits, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_cb_hits", XS_Net__SSLeay_CTX_sess_cb_hits, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_misses", XS_Net__SSLeay_CTX_sess_misses, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_timeouts", XS_Net__SSLeay_CTX_sess_timeouts, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_cache_full", XS_Net__SSLeay_CTX_sess_cache_full, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_get_cache_size", XS_Net__SSLeay_CTX_sess_get_cache_size, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_sess_set_cache_size", XS_Net__SSLeay_CTX_sess_set_cache_size, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::want", XS_Net__SSLeay_want, file, "$");
        (void)newXSproto_portable("Net::SSLeay::state", XS_Net__SSLeay_state, file, "$");
#if XSubPPtmpAAAM
        (void)newXSproto_portable("Net::SSLeay::set_tlsext_host_name", XS_Net__SSLeay_set_tlsext_host_name, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_servername", XS_Net__SSLeay_get_servername, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::get_servername_type", XS_Net__SSLeay_get_servername_type, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_tlsext_servername_callback", XS_Net__SSLeay_CTX_set_tlsext_servername_callback, file, "$;$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::BIO_f_ssl", XS_Net__SSLeay_BIO_f_ssl, file, "");
        (void)newXSproto_portable("Net::SSLeay::BIO_s_mem", XS_Net__SSLeay_BIO_s_mem, file, "");
        (void)newXSproto_portable("Net::SSLeay::ERR_get_error", XS_Net__SSLeay_ERR_get_error, file, "");
        (void)newXSproto_portable("Net::SSLeay::ERR_peek_error", XS_Net__SSLeay_ERR_peek_error, file, "");
        (void)newXSproto_portable("Net::SSLeay::ERR_put_error", XS_Net__SSLeay_ERR_put_error, file, "$$$$$");
        (void)newXSproto_portable("Net::SSLeay::ERR_clear_error", XS_Net__SSLeay_ERR_clear_error, file, "");
        (void)newXSproto_portable("Net::SSLeay::ERR_error_string", XS_Net__SSLeay_ERR_error_string, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::load_error_strings", XS_Net__SSLeay_load_error_strings, file, "");
        (void)newXSproto_portable("Net::SSLeay::ERR_load_crypto_strings", XS_Net__SSLeay_ERR_load_crypto_strings, file, "");
        (void)newXSproto_portable("Net::SSLeay::FIPS_mode_set", XS_Net__SSLeay_FIPS_mode_set, file, "$");
        cv = newXSproto_portable("Net::SSLeay::OpenSSL_add_ssl_algorithms", XS_Net__SSLeay_library_init, file, "");
        XSANY.any_i32 = 2;
        cv = newXSproto_portable("Net::SSLeay::SSLeay_add_ssl_algorithms", XS_Net__SSLeay_library_init, file, "");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("Net::SSLeay::add_ssl_algorithms", XS_Net__SSLeay_library_init, file, "");
        XSANY.any_i32 = 3;
        cv = newXSproto_portable("Net::SSLeay::library_init", XS_Net__SSLeay_library_init, file, "");
        XSANY.any_i32 = 0;
#if XSubPPtmpAAAN
        (void)newXSproto_portable("Net::SSLeay::ENGINE_load_builtin_engines", XS_Net__SSLeay_ENGINE_load_builtin_engines, file, "");
        (void)newXSproto_portable("Net::SSLeay::ENGINE_register_all_complete", XS_Net__SSLeay_ENGINE_register_all_complete, file, "");
        (void)newXSproto_portable("Net::SSLeay::ENGINE_by_id", XS_Net__SSLeay_ENGINE_by_id, file, "$");
        (void)newXSproto_portable("Net::SSLeay::ENGINE_set_default", XS_Net__SSLeay_ENGINE_set_default, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::ERR_load_SSL_strings", XS_Net__SSLeay_ERR_load_SSL_strings, file, "");
        (void)newXSproto_portable("Net::SSLeay::ERR_load_RAND_strings", XS_Net__SSLeay_ERR_load_RAND_strings, file, "");
        (void)newXSproto_portable("Net::SSLeay::RAND_bytes", XS_Net__SSLeay_RAND_bytes, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::RAND_pseudo_bytes", XS_Net__SSLeay_RAND_pseudo_bytes, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::RAND_add", XS_Net__SSLeay_RAND_add, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::RAND_poll", XS_Net__SSLeay_RAND_poll, file, "");
        (void)newXSproto_portable("Net::SSLeay::RAND_status", XS_Net__SSLeay_RAND_status, file, "");
        (void)newXSproto_portable("Net::SSLeay::RAND_file_name", XS_Net__SSLeay_RAND_file_name, file, "$");
        (void)newXSproto_portable("Net::SSLeay::RAND_seed", XS_Net__SSLeay_RAND_seed, file, "$");
        (void)newXSproto_portable("Net::SSLeay::RAND_cleanup", XS_Net__SSLeay_RAND_cleanup, file, "");
        (void)newXSproto_portable("Net::SSLeay::RAND_load_file", XS_Net__SSLeay_RAND_load_file, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::RAND_write_file", XS_Net__SSLeay_RAND_write_file, file, "$");
#if XSubPPtmpAAAO
        (void)newXSproto_portable("Net::SSLeay::X509_check_host", XS_Net__SSLeay_X509_check_host, file, "$$;$$");
        (void)newXSproto_portable("Net::SSLeay::X509_check_email", XS_Net__SSLeay_X509_check_email, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_check_ip", XS_Net__SSLeay_X509_check_ip, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_check_ip_asc", XS_Net__SSLeay_X509_check_ip_asc, file, "$$;$");
#endif
        (void)newXSproto_portable("Net::SSLeay::X509_get_issuer_name", XS_Net__SSLeay_X509_get_issuer_name, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_subject_name", XS_Net__SSLeay_X509_get_subject_name, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_set_issuer_name", XS_Net__SSLeay_X509_set_issuer_name, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_set_subject_name", XS_Net__SSLeay_X509_set_subject_name, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_set_version", XS_Net__SSLeay_X509_set_version, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_set_pubkey", XS_Net__SSLeay_X509_set_pubkey, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_version", XS_Net__SSLeay_X509_get_version, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_pubkey", XS_Net__SSLeay_X509_get_pubkey, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_serialNumber", XS_Net__SSLeay_X509_get_serialNumber, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_set_serialNumber", XS_Net__SSLeay_X509_set_serialNumber, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_certificate_type", XS_Net__SSLeay_X509_certificate_type, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_sign", XS_Net__SSLeay_X509_sign, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::X509_verify", XS_Net__SSLeay_X509_verify, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_new", XS_Net__SSLeay_X509_NAME_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_hash", XS_Net__SSLeay_X509_NAME_hash, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_oneline", XS_Net__SSLeay_X509_NAME_oneline, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_print_ex", XS_Net__SSLeay_X509_NAME_print_ex, file, "$;$$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_get_text_by_NID", XS_Net__SSLeay_X509_NAME_get_text_by_NID, file, "$$");
#if XSubPPtmpAAAP
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_add_entry_by_NID", XS_Net__SSLeay_X509_NAME_add_entry_by_NID, file, "$$$$;$$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_add_entry_by_OBJ", XS_Net__SSLeay_X509_NAME_add_entry_by_OBJ, file, "$$$$;$$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_add_entry_by_txt", XS_Net__SSLeay_X509_NAME_add_entry_by_txt, file, "$$$$;$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_cmp", XS_Net__SSLeay_X509_NAME_cmp, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_entry_count", XS_Net__SSLeay_X509_NAME_entry_count, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_get_entry", XS_Net__SSLeay_X509_NAME_get_entry, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_ENTRY_get_data", XS_Net__SSLeay_X509_NAME_ENTRY_get_data, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_ENTRY_get_object", XS_Net__SSLeay_X509_NAME_ENTRY_get_object, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_free", XS_Net__SSLeay_X509_CRL_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_new", XS_Net__SSLeay_X509_CRL_new, file, "");
#if XSubPPtmpAAAQ
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_set_version", XS_Net__SSLeay_X509_CRL_set_version, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_set_issuer_name", XS_Net__SSLeay_X509_CRL_set_issuer_name, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_set_lastUpdate", XS_Net__SSLeay_X509_CRL_set_lastUpdate, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_set_nextUpdate", XS_Net__SSLeay_X509_CRL_set_nextUpdate, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_sort", XS_Net__SSLeay_X509_CRL_sort, file, "$");
#endif
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_get_version", XS_Net__SSLeay_X509_CRL_get_version, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_get_issuer", XS_Net__SSLeay_X509_CRL_get_issuer, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_get_lastUpdate", XS_Net__SSLeay_X509_CRL_get_lastUpdate, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_get_nextUpdate", XS_Net__SSLeay_X509_CRL_get_nextUpdate, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_verify", XS_Net__SSLeay_X509_CRL_verify, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_sign", XS_Net__SSLeay_X509_CRL_sign, file, "$$$");
#if XSubPPtmpAAAR
        (void)newXSproto_portable("Net::SSLeay::P_X509_CRL_set_serial", XS_Net__SSLeay_P_X509_CRL_set_serial, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::P_X509_CRL_get_serial", XS_Net__SSLeay_P_X509_CRL_get_serial, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_X509_CRL_add_revoked_serial_hex", XS_Net__SSLeay_P_X509_CRL_add_revoked_serial_hex, file, "$$$;$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_new", XS_Net__SSLeay_X509_REQ_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_free", XS_Net__SSLeay_X509_REQ_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_get_subject_name", XS_Net__SSLeay_X509_REQ_get_subject_name, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_set_subject_name", XS_Net__SSLeay_X509_REQ_set_subject_name, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_set_pubkey", XS_Net__SSLeay_X509_REQ_set_pubkey, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_get_pubkey", XS_Net__SSLeay_X509_REQ_get_pubkey, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_sign", XS_Net__SSLeay_X509_REQ_sign, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_verify", XS_Net__SSLeay_X509_REQ_verify, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_set_version", XS_Net__SSLeay_X509_REQ_set_version, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_get_version", XS_Net__SSLeay_X509_REQ_get_version, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_get_attr_count", XS_Net__SSLeay_X509_REQ_get_attr_count, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_get_attr_by_NID", XS_Net__SSLeay_X509_REQ_get_attr_by_NID, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_get_attr_by_OBJ", XS_Net__SSLeay_X509_REQ_get_attr_by_OBJ, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_add1_attr_by_NID", XS_Net__SSLeay_X509_REQ_add1_attr_by_NID, file, "$$$$");
#if XSubPPtmpAAAS
        (void)newXSproto_portable("Net::SSLeay::P_X509_REQ_get_attr", XS_Net__SSLeay_P_X509_REQ_get_attr, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::P_X509_REQ_add_extensions", XS_Net__SSLeay_P_X509_REQ_add_extensions, file, "$;@");
        (void)newXSproto_portable("Net::SSLeay::P_X509_add_extensions", XS_Net__SSLeay_P_X509_add_extensions, file, "$$;@");
        (void)newXSproto_portable("Net::SSLeay::P_X509_copy_extensions", XS_Net__SSLeay_P_X509_copy_extensions, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_CTX_get_current_cert", XS_Net__SSLeay_X509_STORE_CTX_get_current_cert, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_CTX_get_ex_data", XS_Net__SSLeay_X509_STORE_CTX_get_ex_data, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_fingerprint", XS_Net__SSLeay_X509_get_fingerprint, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_subjectAltNames", XS_Net__SSLeay_X509_get_subjectAltNames, file, "$");
#if XSubPPtmpAAAT
        (void)newXSproto_portable("Net::SSLeay::P_X509_get_crl_distribution_points", XS_Net__SSLeay_P_X509_get_crl_distribution_points, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_X509_get_ocsp_uri", XS_Net__SSLeay_P_X509_get_ocsp_uri, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_X509_get_ext_key_usage", XS_Net__SSLeay_P_X509_get_ext_key_usage, file, "$;$");
#endif
        (void)newXSproto_portable("Net::SSLeay::P_X509_get_key_usage", XS_Net__SSLeay_P_X509_get_key_usage, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_X509_get_netscape_cert_type", XS_Net__SSLeay_P_X509_get_netscape_cert_type, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_ext_by_NID", XS_Net__SSLeay_X509_get_ext_by_NID, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_ext", XS_Net__SSLeay_X509_get_ext, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_EXTENSION_get_critical", XS_Net__SSLeay_X509_EXTENSION_get_critical, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_EXTENSION_get_data", XS_Net__SSLeay_X509_EXTENSION_get_data, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_EXTENSION_get_object", XS_Net__SSLeay_X509_EXTENSION_get_object, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_ext_count", XS_Net__SSLeay_X509_get_ext_count, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_get_ext_count", XS_Net__SSLeay_X509_CRL_get_ext_count, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_get_ext_by_NID", XS_Net__SSLeay_X509_CRL_get_ext_by_NID, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_get_ext", XS_Net__SSLeay_X509_CRL_get_ext, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509V3_EXT_print", XS_Net__SSLeay_X509V3_EXT_print, file, "$;$$");
        (void)newXSproto_portable("Net::SSLeay::X509V3_EXT_d2i", XS_Net__SSLeay_X509V3_EXT_d2i, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_CTX_get_error", XS_Net__SSLeay_X509_STORE_CTX_get_error, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_CTX_get_error_depth", XS_Net__SSLeay_X509_STORE_CTX_get_error_depth, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_CTX_set_ex_data", XS_Net__SSLeay_X509_STORE_CTX_set_ex_data, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_CTX_set_error", XS_Net__SSLeay_X509_STORE_CTX_set_error, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_CTX_set_cert", XS_Net__SSLeay_X509_STORE_CTX_set_cert, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_add_cert", XS_Net__SSLeay_X509_STORE_add_cert, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_add_crl", XS_Net__SSLeay_X509_STORE_add_crl, file, "$$");
#if XSubPPtmpAAAU
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_set_flags", XS_Net__SSLeay_X509_STORE_set_flags, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_set_purpose", XS_Net__SSLeay_X509_STORE_set_purpose, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_set_trust", XS_Net__SSLeay_X509_STORE_set_trust, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_STORE_set1_param", XS_Net__SSLeay_X509_STORE_set1_param, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::X509_load_cert_file", XS_Net__SSLeay_X509_load_cert_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::X509_load_crl_file", XS_Net__SSLeay_X509_load_crl_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::X509_load_cert_crl_file", XS_Net__SSLeay_X509_load_cert_crl_file, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::X509_verify_cert_error_string", XS_Net__SSLeay_X509_verify_cert_error_string, file, "$");
        (void)newXSproto_portable("Net::SSLeay::ASN1_INTEGER_new", XS_Net__SSLeay_ASN1_INTEGER_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::ASN1_INTEGER_free", XS_Net__SSLeay_ASN1_INTEGER_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::ASN1_INTEGER_set", XS_Net__SSLeay_ASN1_INTEGER_set, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::ASN1_INTEGER_get", XS_Net__SSLeay_ASN1_INTEGER_get, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_ASN1_INTEGER_set_hex", XS_Net__SSLeay_P_ASN1_INTEGER_set_hex, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::P_ASN1_INTEGER_set_dec", XS_Net__SSLeay_P_ASN1_INTEGER_set_dec, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::P_ASN1_INTEGER_get_hex", XS_Net__SSLeay_P_ASN1_INTEGER_get_hex, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_ASN1_INTEGER_get_dec", XS_Net__SSLeay_P_ASN1_INTEGER_get_dec, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_ASN1_STRING_get", XS_Net__SSLeay_P_ASN1_STRING_get, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_notBefore", XS_Net__SSLeay_X509_get_notBefore, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_get_notAfter", XS_Net__SSLeay_X509_get_notAfter, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_gmtime_adj", XS_Net__SSLeay_X509_gmtime_adj, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::ASN1_TIME_set", XS_Net__SSLeay_ASN1_TIME_set, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::ASN1_TIME_free", XS_Net__SSLeay_ASN1_TIME_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::ASN1_TIME_timet", XS_Net__SSLeay_ASN1_TIME_timet, file, "$");
        (void)newXSproto_portable("Net::SSLeay::ASN1_TIME_new", XS_Net__SSLeay_ASN1_TIME_new, file, "");
        cv = newXSproto_portable("Net::SSLeay::P_ASN1_TIME_put2string", XS_Net__SSLeay_P_ASN1_TIME_put2string, file, "$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("Net::SSLeay::P_ASN1_UTCTIME_put2string", XS_Net__SSLeay_P_ASN1_TIME_put2string, file, "$");
        XSANY.any_i32 = 1;
#if XSubPPtmpAAAV
        (void)newXSproto_portable("Net::SSLeay::P_ASN1_TIME_get_isotime", XS_Net__SSLeay_P_ASN1_TIME_get_isotime, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_ASN1_TIME_set_isotime", XS_Net__SSLeay_P_ASN1_TIME_set_isotime, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::EVP_PKEY_copy_parameters", XS_Net__SSLeay_EVP_PKEY_copy_parameters, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::EVP_PKEY_new", XS_Net__SSLeay_EVP_PKEY_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::EVP_PKEY_free", XS_Net__SSLeay_EVP_PKEY_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_PKEY_assign_RSA", XS_Net__SSLeay_EVP_PKEY_assign_RSA, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::EVP_PKEY_bits", XS_Net__SSLeay_EVP_PKEY_bits, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_PKEY_size", XS_Net__SSLeay_EVP_PKEY_size, file, "$");
#if XSubPPtmpAAAW
        (void)newXSproto_portable("Net::SSLeay::EVP_PKEY_id", XS_Net__SSLeay_EVP_PKEY_id, file, "$");
#endif
        (void)newXSproto_portable("Net::SSLeay::PEM_get_string_X509", XS_Net__SSLeay_PEM_get_string_X509, file, "$");
        (void)newXSproto_portable("Net::SSLeay::PEM_get_string_X509_REQ", XS_Net__SSLeay_PEM_get_string_X509_REQ, file, "$");
        (void)newXSproto_portable("Net::SSLeay::PEM_get_string_X509_CRL", XS_Net__SSLeay_PEM_get_string_X509_CRL, file, "$");
        (void)newXSproto_portable("Net::SSLeay::PEM_get_string_PrivateKey", XS_Net__SSLeay_PEM_get_string_PrivateKey, file, "$;$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_PKCS12_file", XS_Net__SSLeay_CTX_use_PKCS12_file, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::P_PKCS12_load_file", XS_Net__SSLeay_P_PKCS12_load_file, file, "$;$$");
#if XSubPPtmpAAAX
        (void)newXSproto_portable("Net::SSLeay::MD2", XS_Net__SSLeay_MD2, file, "$");
#endif
#if XSubPPtmpAAAY
        (void)newXSproto_portable("Net::SSLeay::MD4", XS_Net__SSLeay_MD4, file, "$");
#endif
#if XSubPPtmpAAAZ
        (void)newXSproto_portable("Net::SSLeay::MD5", XS_Net__SSLeay_MD5, file, "$");
#endif
#if XSubPPtmpAABA
        (void)newXSproto_portable("Net::SSLeay::RIPEMD160", XS_Net__SSLeay_RIPEMD160, file, "$");
#endif
#if XSubPPtmpAABB
        (void)newXSproto_portable("Net::SSLeay::SHA1", XS_Net__SSLeay_SHA1, file, "$");
#endif
#if XSubPPtmpAABC
        (void)newXSproto_portable("Net::SSLeay::SHA256", XS_Net__SSLeay_SHA256, file, "$");
#endif
#if XSubPPtmpAABD
        (void)newXSproto_portable("Net::SSLeay::SHA512", XS_Net__SSLeay_SHA512, file, "$");
#endif
#if XSubPPtmpAABE
        (void)newXSproto_portable("Net::SSLeay::SSLv2_method", XS_Net__SSLeay_SSLv2_method, file, "");
#endif
#if XSubPPtmpAABF
        (void)newXSproto_portable("Net::SSLeay::SSLv3_method", XS_Net__SSLeay_SSLv3_method, file, "");
#endif
        (void)newXSproto_portable("Net::SSLeay::TLSv1_method", XS_Net__SSLeay_TLSv1_method, file, "");
#if XSubPPtmpAABG
        (void)newXSproto_portable("Net::SSLeay::TLSv1_1_method", XS_Net__SSLeay_TLSv1_1_method, file, "");
#endif
#if XSubPPtmpAABH
        (void)newXSproto_portable("Net::SSLeay::TLSv1_2_method", XS_Net__SSLeay_TLSv1_2_method, file, "");
#endif
#if XSubPPtmpAABI
        (void)newXSproto_portable("Net::SSLeay::set_ssl_method", XS_Net__SSLeay_set_ssl_method, file, "$$");
#endif
#if XSubPPtmpAABJ
        (void)newXSproto_portable("Net::SSLeay::set_ssl_method", XS_Net__SSLeay_set_ssl_method, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::get_ssl_method", XS_Net__SSLeay_get_ssl_method, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_new_buffer_ssl_connect", XS_Net__SSLeay_BIO_new_buffer_ssl_connect, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_new_file", XS_Net__SSLeay_BIO_new_file, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::BIO_new_ssl", XS_Net__SSLeay_BIO_new_ssl, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::BIO_new_ssl_connect", XS_Net__SSLeay_BIO_new_ssl_connect, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_new", XS_Net__SSLeay_BIO_new, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_free", XS_Net__SSLeay_BIO_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_read", XS_Net__SSLeay_BIO_read, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::BIO_write", XS_Net__SSLeay_BIO_write, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::BIO_eof", XS_Net__SSLeay_BIO_eof, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_pending", XS_Net__SSLeay_BIO_pending, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_wpending", XS_Net__SSLeay_BIO_wpending, file, "$");
        (void)newXSproto_portable("Net::SSLeay::BIO_ssl_copy_session_id", XS_Net__SSLeay_BIO_ssl_copy_session_id, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::BIO_ssl_shutdown", XS_Net__SSLeay_BIO_ssl_shutdown, file, "$");
        (void)newXSproto_portable("Net::SSLeay::add_client_CA", XS_Net__SSLeay_add_client_CA, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::alert_desc_string", XS_Net__SSLeay_alert_desc_string, file, "$");
        (void)newXSproto_portable("Net::SSLeay::alert_desc_string_long", XS_Net__SSLeay_alert_desc_string_long, file, "$");
        (void)newXSproto_portable("Net::SSLeay::alert_type_string", XS_Net__SSLeay_alert_type_string, file, "$");
        (void)newXSproto_portable("Net::SSLeay::alert_type_string_long", XS_Net__SSLeay_alert_type_string_long, file, "$");
        (void)newXSproto_portable("Net::SSLeay::callback_ctrl", XS_Net__SSLeay_callback_ctrl, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::check_private_key", XS_Net__SSLeay_check_private_key, file, "$");
#if XSubPPtmpAABK
        (void)newXSproto_portable("Net::SSLeay::CIPHER_description", XS_Net__SSLeay_CIPHER_description, file, "$$$");
#endif
#if XSubPPtmpAABL
        (void)newXSproto_portable("Net::SSLeay::CIPHER_description", XS_Net__SSLeay_CIPHER_description, file, "$$$");
#endif
#if XSubPPtmpAABM
        (void)newXSproto_portable("Net::SSLeay::CIPHER_get_name", XS_Net__SSLeay_CIPHER_get_name, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CIPHER_get_bits", XS_Net__SSLeay_CIPHER_get_bits, file, "$;$");
#endif
#if XSubPPtmpAABN
        (void)newXSproto_portable("Net::SSLeay::CIPHER_get_name", XS_Net__SSLeay_CIPHER_get_name, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CIPHER_get_bits", XS_Net__SSLeay_CIPHER_get_bits, file, "$;$");
#endif
        (void)newXSproto_portable("Net::SSLeay::COMP_add_compression_method", XS_Net__SSLeay_COMP_add_compression_method, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_add_client_CA", XS_Net__SSLeay_CTX_add_client_CA, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_callback_ctrl", XS_Net__SSLeay_CTX_callback_ctrl, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_check_private_key", XS_Net__SSLeay_CTX_check_private_key, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_ex_data", XS_Net__SSLeay_CTX_get_ex_data, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_quiet_shutdown", XS_Net__SSLeay_CTX_get_quiet_shutdown, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_timeout", XS_Net__SSLeay_CTX_get_timeout, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_verify_depth", XS_Net__SSLeay_CTX_get_verify_depth, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_verify_mode", XS_Net__SSLeay_CTX_get_verify_mode, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_cert_store", XS_Net__SSLeay_CTX_set_cert_store, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_cert_store", XS_Net__SSLeay_CTX_get_cert_store, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_cert_verify_callback", XS_Net__SSLeay_CTX_set_cert_verify_callback, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_client_CA_list", XS_Net__SSLeay_CTX_get_client_CA_list, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_client_CA_list", XS_Net__SSLeay_CTX_set_client_CA_list, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_default_passwd_cb", XS_Net__SSLeay_CTX_set_default_passwd_cb, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_default_passwd_cb_userdata", XS_Net__SSLeay_CTX_set_default_passwd_cb_userdata, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_ex_data", XS_Net__SSLeay_CTX_set_ex_data, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_purpose", XS_Net__SSLeay_CTX_set_purpose, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_quiet_shutdown", XS_Net__SSLeay_CTX_set_quiet_shutdown, file, "$$");
#if XSubPPtmpAABO
        (void)newXSproto_portable("Net::SSLeay::CTX_set_ssl_version", XS_Net__SSLeay_CTX_set_ssl_version, file, "$$");
#endif
#if XSubPPtmpAABP
        (void)newXSproto_portable("Net::SSLeay::CTX_set_ssl_version", XS_Net__SSLeay_CTX_set_ssl_version, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::CTX_set_timeout", XS_Net__SSLeay_CTX_set_timeout, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_trust", XS_Net__SSLeay_CTX_set_trust, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_verify_depth", XS_Net__SSLeay_CTX_set_verify_depth, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_certificate", XS_Net__SSLeay_CTX_use_certificate, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_certificate_chain_file", XS_Net__SSLeay_CTX_use_certificate_chain_file, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_PrivateKey", XS_Net__SSLeay_CTX_use_PrivateKey, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_use_RSAPrivateKey", XS_Net__SSLeay_CTX_use_RSAPrivateKey, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::do_handshake", XS_Net__SSLeay_do_handshake, file, "$");
        (void)newXSproto_portable("Net::SSLeay::dup", XS_Net__SSLeay_dup, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_current_cipher", XS_Net__SSLeay_get_current_cipher, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_default_timeout", XS_Net__SSLeay_get_default_timeout, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_ex_data", XS_Net__SSLeay_get_ex_data, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_finished", XS_Net__SSLeay_get_finished, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::get_peer_finished", XS_Net__SSLeay_get_peer_finished, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::get_quiet_shutdown", XS_Net__SSLeay_get_quiet_shutdown, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_shutdown", XS_Net__SSLeay_get_shutdown, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_verify_depth", XS_Net__SSLeay_get_verify_depth, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_verify_mode", XS_Net__SSLeay_get_verify_mode, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_verify_result", XS_Net__SSLeay_get_verify_result, file, "$");
        (void)newXSproto_portable("Net::SSLeay::renegotiate", XS_Net__SSLeay_renegotiate, file, "$");
#if XSubPPtmpAABQ
        (void)newXSproto_portable("Net::SSLeay::SESSION_cmp", XS_Net__SSLeay_SESSION_cmp, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::SESSION_get_ex_data", XS_Net__SSLeay_SESSION_get_ex_data, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_get_time", XS_Net__SSLeay_SESSION_get_time, file, "$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_get_timeout", XS_Net__SSLeay_SESSION_get_timeout, file, "$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_print_fp", XS_Net__SSLeay_SESSION_print_fp, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_set_ex_data", XS_Net__SSLeay_SESSION_set_ex_data, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_set_time", XS_Net__SSLeay_SESSION_set_time, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_set_timeout", XS_Net__SSLeay_SESSION_set_timeout, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_accept_state", XS_Net__SSLeay_set_accept_state, file, "$");
        (void)newXSproto_portable("Net::SSLeay::sk_X509_NAME_free", XS_Net__SSLeay_sk_X509_NAME_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::sk_X509_NAME_num", XS_Net__SSLeay_sk_X509_NAME_num, file, "$");
        (void)newXSproto_portable("Net::SSLeay::sk_X509_NAME_value", XS_Net__SSLeay_sk_X509_NAME_value, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_client_CA_list", XS_Net__SSLeay_get_client_CA_list, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_client_CA_list", XS_Net__SSLeay_set_client_CA_list, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_connect_state", XS_Net__SSLeay_set_connect_state, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_ex_data", XS_Net__SSLeay_set_ex_data, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::set_info_callback", XS_Net__SSLeay_set_info_callback, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_info_callback", XS_Net__SSLeay_CTX_set_info_callback, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::set_purpose", XS_Net__SSLeay_set_purpose, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_quiet_shutdown", XS_Net__SSLeay_set_quiet_shutdown, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_shutdown", XS_Net__SSLeay_set_shutdown, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_trust", XS_Net__SSLeay_set_trust, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_verify_depth", XS_Net__SSLeay_set_verify_depth, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_verify_result", XS_Net__SSLeay_set_verify_result, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::shutdown", XS_Net__SSLeay_shutdown, file, "$");
        (void)newXSproto_portable("Net::SSLeay::version", XS_Net__SSLeay_version, file, "$");
        (void)newXSproto_portable("Net::SSLeay::load_client_CA_file", XS_Net__SSLeay_load_client_CA_file, file, "$");
        (void)newXSproto_portable("Net::SSLeay::add_file_cert_subjects_to_stack", XS_Net__SSLeay_add_file_cert_subjects_to_stack, file, "$$");
#if XSubPPtmpAABR
        (void)newXSproto_portable("Net::SSLeay::add_dir_cert_subjects_to_stack", XS_Net__SSLeay_add_dir_cert_subjects_to_stack, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::CTX_get_ex_new_index", XS_Net__SSLeay_CTX_get_ex_new_index, file, "$$$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_session_id_context", XS_Net__SSLeay_CTX_set_session_id_context, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::set_session_id_context", XS_Net__SSLeay_set_session_id_context, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_tmp_rsa_callback", XS_Net__SSLeay_CTX_set_tmp_rsa_callback, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_tmp_rsa_callback", XS_Net__SSLeay_set_tmp_rsa_callback, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_tmp_dh_callback", XS_Net__SSLeay_CTX_set_tmp_dh_callback, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_tmp_dh_callback", XS_Net__SSLeay_set_tmp_dh_callback, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_ex_new_index", XS_Net__SSLeay_get_ex_new_index, file, "$$$$$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_get_ex_new_index", XS_Net__SSLeay_SESSION_get_ex_new_index, file, "$$$$$");
        (void)newXSproto_portable("Net::SSLeay::clear_num_renegotiations", XS_Net__SSLeay_clear_num_renegotiations, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_add_extra_chain_cert", XS_Net__SSLeay_CTX_add_extra_chain_cert, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_app_data", XS_Net__SSLeay_CTX_get_app_data, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_mode", XS_Net__SSLeay_CTX_get_mode, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_read_ahead", XS_Net__SSLeay_CTX_get_read_ahead, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_get_session_cache_mode", XS_Net__SSLeay_CTX_get_session_cache_mode, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_need_tmp_RSA", XS_Net__SSLeay_CTX_need_tmp_RSA, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_app_data", XS_Net__SSLeay_CTX_set_app_data, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_mode", XS_Net__SSLeay_CTX_set_mode, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_read_ahead", XS_Net__SSLeay_CTX_set_read_ahead, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_session_cache_mode", XS_Net__SSLeay_CTX_set_session_cache_mode, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_tmp_dh", XS_Net__SSLeay_CTX_set_tmp_dh, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_tmp_rsa", XS_Net__SSLeay_CTX_set_tmp_rsa, file, "$$");
#if XSubPPtmpAABS
        (void)newXSproto_portable("Net::SSLeay::EC_KEY_new_by_curve_name", XS_Net__SSLeay_EC_KEY_new_by_curve_name, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EC_KEY_free", XS_Net__SSLeay_EC_KEY_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_tmp_ecdh", XS_Net__SSLeay_CTX_set_tmp_ecdh, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::get_app_data", XS_Net__SSLeay_get_app_data, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_cipher_bits", XS_Net__SSLeay_get_cipher_bits, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::get_mode", XS_Net__SSLeay_get_mode, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_state", XS_Net__SSLeay_get_state, file, "$");
        (void)newXSproto_portable("Net::SSLeay::set_state", XS_Net__SSLeay_set_state, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::need_tmp_RSA", XS_Net__SSLeay_need_tmp_RSA, file, "$");
        (void)newXSproto_portable("Net::SSLeay::num_renegotiations", XS_Net__SSLeay_num_renegotiations, file, "$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_get_app_data", XS_Net__SSLeay_SESSION_get_app_data, file, "$");
        (void)newXSproto_portable("Net::SSLeay::session_reused", XS_Net__SSLeay_session_reused, file, "$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_set_app_data", XS_Net__SSLeay_SESSION_set_app_data, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_app_data", XS_Net__SSLeay_set_app_data, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_mode", XS_Net__SSLeay_set_mode, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_pref_cipher", XS_Net__SSLeay_set_pref_cipher, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_tmp_dh", XS_Net__SSLeay_set_tmp_dh, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set_tmp_rsa", XS_Net__SSLeay_set_tmp_rsa, file, "$$");
#if XSubPPtmpAABT
        (void)newXSproto_portable("Net::SSLeay::RSA_generate_key", XS_Net__SSLeay_RSA_generate_key, file, "$$;$$");
#endif
#if XSubPPtmpAABU
        (void)newXSproto_portable("Net::SSLeay::RSA_generate_key", XS_Net__SSLeay_RSA_generate_key, file, "$$;$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::RSA_free", XS_Net__SSLeay_RSA_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_new", XS_Net__SSLeay_X509_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::X509_free", XS_Net__SSLeay_X509_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::d2i_X509_CRL_bio", XS_Net__SSLeay_d2i_X509_CRL_bio, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::d2i_X509_REQ_bio", XS_Net__SSLeay_d2i_X509_REQ_bio, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::d2i_X509_bio", XS_Net__SSLeay_d2i_X509_bio, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::PEM_read_bio_DHparams", XS_Net__SSLeay_PEM_read_bio_DHparams, file, "$;$$$");
        (void)newXSproto_portable("Net::SSLeay::PEM_read_bio_X509_CRL", XS_Net__SSLeay_PEM_read_bio_X509_CRL, file, "$;$$$");
        (void)newXSproto_portable("Net::SSLeay::PEM_read_bio_X509", XS_Net__SSLeay_PEM_read_bio_X509, file, "$;$$$");
        (void)newXSproto_portable("Net::SSLeay::PEM_read_bio_X509_REQ", XS_Net__SSLeay_PEM_read_bio_X509_REQ, file, "$;$$$");
        (void)newXSproto_portable("Net::SSLeay::PEM_read_bio_PrivateKey", XS_Net__SSLeay_PEM_read_bio_PrivateKey, file, "$;$$");
        (void)newXSproto_portable("Net::SSLeay::DH_free", XS_Net__SSLeay_DH_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::total_renegotiations", XS_Net__SSLeay_total_renegotiations, file, "$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_get_master_key", XS_Net__SSLeay_SESSION_get_master_key, file, "$");
        (void)newXSproto_portable("Net::SSLeay::SESSION_set_master_key", XS_Net__SSLeay_SESSION_set_master_key, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::get_client_random", XS_Net__SSLeay_get_client_random, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_server_random", XS_Net__SSLeay_get_server_random, file, "$");
        (void)newXSproto_portable("Net::SSLeay::get_keyblock_size", XS_Net__SSLeay_get_keyblock_size, file, "$");
#if XSubPPtmpAABV
        (void)newXSproto_portable("Net::SSLeay::set_hello_extension", XS_Net__SSLeay_set_hello_extension, file, "$$$");
#endif
#if XSubPPtmpAABW
        (void)newXSproto_portable("Net::SSLeay::set_session_secret_cb", XS_Net__SSLeay_set_session_secret_cb, file, "$;$$");
#endif
#if XSubPPtmpAABX
        (void)newXSproto_portable("Net::SSLeay::EVP_add_digest", XS_Net__SSLeay_EVP_add_digest, file, "$");
#endif
#if XSubPPtmpAABY
        (void)newXSproto_portable("Net::SSLeay::EVP_add_digest", XS_Net__SSLeay_EVP_add_digest, file, "$");
#endif
#if XSubPPtmpAABZ
        (void)newXSproto_portable("Net::SSLeay::EVP_sha1", XS_Net__SSLeay_EVP_sha1, file, "");
#endif
#if XSubPPtmpAACA
        (void)newXSproto_portable("Net::SSLeay::EVP_sha256", XS_Net__SSLeay_EVP_sha256, file, "");
#endif
#if XSubPPtmpAACB
        (void)newXSproto_portable("Net::SSLeay::EVP_sha512", XS_Net__SSLeay_EVP_sha512, file, "");
#endif
        (void)newXSproto_portable("Net::SSLeay::OpenSSL_add_all_digests", XS_Net__SSLeay_OpenSSL_add_all_digests, file, "");
        (void)newXSproto_portable("Net::SSLeay::EVP_get_digestbyname", XS_Net__SSLeay_EVP_get_digestbyname, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_MD_type", XS_Net__SSLeay_EVP_MD_type, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_MD_size", XS_Net__SSLeay_EVP_MD_size, file, "$");
#if XSubPPtmpAACC
        (void)newXSproto_portable("Net::SSLeay::P_EVP_MD_list_all", XS_Net__SSLeay_P_EVP_MD_list_all, file, "");
#endif
#if XSubPPtmpAACD
        (void)newXSproto_portable("Net::SSLeay::EVP_MD_CTX_md", XS_Net__SSLeay_EVP_MD_CTX_md, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_MD_CTX_create", XS_Net__SSLeay_EVP_MD_CTX_create, file, "");
        (void)newXSproto_portable("Net::SSLeay::EVP_DigestInit", XS_Net__SSLeay_EVP_DigestInit, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::EVP_DigestInit_ex", XS_Net__SSLeay_EVP_DigestInit_ex, file, "$$$");
        (void)newXSproto_portable("Net::SSLeay::EVP_MD_CTX_destroy", XS_Net__SSLeay_EVP_MD_CTX_destroy, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_DigestUpdate", XS_Net__SSLeay_EVP_DigestUpdate, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::EVP_DigestFinal", XS_Net__SSLeay_EVP_DigestFinal, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_DigestFinal_ex", XS_Net__SSLeay_EVP_DigestFinal_ex, file, "$");
        (void)newXSproto_portable("Net::SSLeay::EVP_Digest", XS_Net__SSLeay_EVP_Digest, file, ";@");
#endif
        (void)newXSproto_portable("Net::SSLeay::EVP_get_cipherbyname", XS_Net__SSLeay_EVP_get_cipherbyname, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OpenSSL_add_all_algorithms", XS_Net__SSLeay_OpenSSL_add_all_algorithms, file, "");
#if XSubPPtmpAACE
        (void)newXSproto_portable("Net::SSLeay::OPENSSL_add_all_algorithms_noconf", XS_Net__SSLeay_OPENSSL_add_all_algorithms_noconf, file, "");
        (void)newXSproto_portable("Net::SSLeay::OPENSSL_add_all_algorithms_conf", XS_Net__SSLeay_OPENSSL_add_all_algorithms_conf, file, "");
#endif
#if XSubPPtmpAACF
        (void)newXSproto_portable("Net::SSLeay::CTX_set1_param", XS_Net__SSLeay_CTX_set1_param, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::set1_param", XS_Net__SSLeay_set1_param, file, "$$");
#endif
#if XSubPPtmpAACG
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_new", XS_Net__SSLeay_X509_VERIFY_PARAM_new, file, "");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_free", XS_Net__SSLeay_X509_VERIFY_PARAM_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_inherit", XS_Net__SSLeay_X509_VERIFY_PARAM_inherit, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set1", XS_Net__SSLeay_X509_VERIFY_PARAM_set1, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set1_name", XS_Net__SSLeay_X509_VERIFY_PARAM_set1_name, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set_flags", XS_Net__SSLeay_X509_VERIFY_PARAM_set_flags, file, "$$");
#if XSubPPtmpAACH
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_clear_flags", XS_Net__SSLeay_X509_VERIFY_PARAM_clear_flags, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_get_flags", XS_Net__SSLeay_X509_VERIFY_PARAM_get_flags, file, "$");
#endif
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set_purpose", XS_Net__SSLeay_X509_VERIFY_PARAM_set_purpose, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set_trust", XS_Net__SSLeay_X509_VERIFY_PARAM_set_trust, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set_depth", XS_Net__SSLeay_X509_VERIFY_PARAM_set_depth, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set_time", XS_Net__SSLeay_X509_VERIFY_PARAM_set_time, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_add0_policy", XS_Net__SSLeay_X509_VERIFY_PARAM_add0_policy, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_set1_policies", XS_Net__SSLeay_X509_VERIFY_PARAM_set1_policies, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_get_depth", XS_Net__SSLeay_X509_VERIFY_PARAM_get_depth, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_add0_table", XS_Net__SSLeay_X509_VERIFY_PARAM_add0_table, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_lookup", XS_Net__SSLeay_X509_VERIFY_PARAM_lookup, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_VERIFY_PARAM_table_cleanup", XS_Net__SSLeay_X509_VERIFY_PARAM_table_cleanup, file, "");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_tree_free", XS_Net__SSLeay_X509_policy_tree_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_tree_level_count", XS_Net__SSLeay_X509_policy_tree_level_count, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_tree_get0_level", XS_Net__SSLeay_X509_policy_tree_get0_level, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_tree_get0_policies", XS_Net__SSLeay_X509_policy_tree_get0_policies, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_tree_get0_user_policies", XS_Net__SSLeay_X509_policy_tree_get0_user_policies, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_level_node_count", XS_Net__SSLeay_X509_policy_level_node_count, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_level_get0_node", XS_Net__SSLeay_X509_policy_level_get0_node, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_node_get0_policy", XS_Net__SSLeay_X509_policy_node_get0_policy, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_node_get0_qualifiers", XS_Net__SSLeay_X509_policy_node_get0_qualifiers, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_policy_node_get0_parent", XS_Net__SSLeay_X509_policy_node_get0_parent, file, "$");
#endif
        (void)newXSproto_portable("Net::SSLeay::OBJ_dup", XS_Net__SSLeay_OBJ_dup, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_nid2obj", XS_Net__SSLeay_OBJ_nid2obj, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_nid2ln", XS_Net__SSLeay_OBJ_nid2ln, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_nid2sn", XS_Net__SSLeay_OBJ_nid2sn, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_obj2nid", XS_Net__SSLeay_OBJ_obj2nid, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_txt2obj", XS_Net__SSLeay_OBJ_txt2obj, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_obj2txt", XS_Net__SSLeay_OBJ_obj2txt, file, "$;$");
#if XSubPPtmpAACI
        (void)newXSproto_portable("Net::SSLeay::OBJ_txt2nid", XS_Net__SSLeay_OBJ_txt2nid, file, "$");
#endif
#if XSubPPtmpAACJ
        (void)newXSproto_portable("Net::SSLeay::OBJ_txt2nid", XS_Net__SSLeay_OBJ_txt2nid, file, "$");
#endif
        (void)newXSproto_portable("Net::SSLeay::OBJ_ln2nid", XS_Net__SSLeay_OBJ_ln2nid, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_sn2nid", XS_Net__SSLeay_OBJ_sn2nid, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OBJ_cmp", XS_Net__SSLeay_OBJ_cmp, file, "$$");
#if XSubPPtmpAACK
        (void)newXSproto_portable("Net::SSLeay::X509_pubkey_digest", XS_Net__SSLeay_X509_pubkey_digest, file, "$$");
#endif
        (void)newXSproto_portable("Net::SSLeay::X509_digest", XS_Net__SSLeay_X509_digest, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_CRL_digest", XS_Net__SSLeay_X509_CRL_digest, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_REQ_digest", XS_Net__SSLeay_X509_REQ_digest, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_NAME_digest", XS_Net__SSLeay_X509_NAME_digest, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::X509_subject_name_hash", XS_Net__SSLeay_X509_subject_name_hash, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_issuer_name_hash", XS_Net__SSLeay_X509_issuer_name_hash, file, "$");
        (void)newXSproto_portable("Net::SSLeay::X509_issuer_and_serial_hash", XS_Net__SSLeay_X509_issuer_and_serial_hash, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_X509_get_signature_alg", XS_Net__SSLeay_P_X509_get_signature_alg, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_X509_get_pubkey_alg", XS_Net__SSLeay_P_X509_get_pubkey_alg, file, "$");
#if XSubPPtmpAACL
        (void)newXSproto_portable("Net::SSLeay::CTX_set_next_protos_advertised_cb", XS_Net__SSLeay_CTX_set_next_protos_advertised_cb, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_next_proto_select_cb", XS_Net__SSLeay_CTX_set_next_proto_select_cb, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::P_next_proto_negotiated", XS_Net__SSLeay_P_next_proto_negotiated, file, "$");
        (void)newXSproto_portable("Net::SSLeay::P_next_proto_last_status", XS_Net__SSLeay_P_next_proto_last_status, file, "$");
#endif
#if XSubPPtmpAACM
        (void)newXSproto_portable("Net::SSLeay::set_tlsext_status_type", XS_Net__SSLeay_set_tlsext_status_type, file, "$$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_tlsext_status_cb", XS_Net__SSLeay_CTX_set_tlsext_status_cb, file, "$$;$");
#endif
#if XSubPPtmpAACN
        (void)newXSproto_portable("Net::SSLeay::d2i_OCSP_RESPONSE", XS_Net__SSLeay_d2i_OCSP_RESPONSE, file, "$");
        (void)newXSproto_portable("Net::SSLeay::i2d_OCSP_RESPONSE", XS_Net__SSLeay_i2d_OCSP_RESPONSE, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OCSP_RESPONSE_free", XS_Net__SSLeay_OCSP_RESPONSE_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::d2i_OCSP_REQUEST", XS_Net__SSLeay_d2i_OCSP_REQUEST, file, "$");
        (void)newXSproto_portable("Net::SSLeay::i2d_OCSP_REQUEST", XS_Net__SSLeay_i2d_OCSP_REQUEST, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OCSP_REQUEST_free", XS_Net__SSLeay_OCSP_REQUEST_free, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OCSP_response_status_str", XS_Net__SSLeay_OCSP_response_status_str, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OCSP_response_status", XS_Net__SSLeay_OCSP_response_status, file, "$");
        (void)newXSproto_portable("Net::SSLeay::OCSP_cert2ids", XS_Net__SSLeay_OCSP_cert2ids, file, "$;@");
        (void)newXSproto_portable("Net::SSLeay::OCSP_ids2req", XS_Net__SSLeay_OCSP_ids2req, file, ";@");
        (void)newXSproto_portable("Net::SSLeay::OCSP_response_verify", XS_Net__SSLeay_OCSP_response_verify, file, "$$;$$");
        (void)newXSproto_portable("Net::SSLeay::OCSP_response_results", XS_Net__SSLeay_OCSP_response_results, file, "$;@");
#endif
#if XSubPPtmpAACO
        (void)newXSproto_portable("Net::SSLeay::CTX_set_alpn_select_cb", XS_Net__SSLeay_CTX_set_alpn_select_cb, file, "$$;$");
        (void)newXSproto_portable("Net::SSLeay::CTX_set_alpn_protos", XS_Net__SSLeay_CTX_set_alpn_protos, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::set_alpn_protos", XS_Net__SSLeay_set_alpn_protos, file, "$;$");
        (void)newXSproto_portable("Net::SSLeay::P_alpn_selected", XS_Net__SSLeay_P_alpn_selected, file, "$");
#endif
#if XSubPPtmpAACP
        (void)newXSproto_portable("Net::SSLeay::export_keying_material", XS_Net__SSLeay_export_keying_material, file, "$$$$");
#endif

    /* Initialisation Section */

#line 1339 "SSLeay.xs"
    {
    MY_CXT_INIT;
    LIB_initialized = 0;
#ifdef USE_ITHREADS
    MUTEX_INIT(&LIB_init_mutex);
#ifdef OPENSSL_THREADS
    /* If we running under ModPerl, we dont need our own thread locking because
     * perl threads are not supported under mod-perl, and we can fall back to the thread
     * locking built in to mod-ssl      
     */
     if (!hv_fetch(get_hv("ENV", 1), "MOD_PERL", 8, 0))
	openssl_threads_init();
#endif
#endif
    /* initialize global shared callback data hash */
    MY_CXT.global_cb_data = newHV();
    MY_CXT.tid = get_my_thread_id();
    PR3("BOOT: tid=%d my_perl=0x%p\n", MY_CXT.tid, my_perl);
    }

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#if XSubPPtmpAAAK
#endif
#if XSubPPtmpAAAL
#endif
#if XSubPPtmpAAAM
#endif
#if XSubPPtmpAAAN
#endif
#if XSubPPtmpAAAO
#endif
#if XSubPPtmpAAAP
#endif
#if XSubPPtmpAAAQ
#endif
#if XSubPPtmpAAAR
#endif
#if XSubPPtmpAAAS
#endif
#if XSubPPtmpAAAT
#endif
#if XSubPPtmpAAAU
#endif
#if XSubPPtmpAAAV
#endif
#if XSubPPtmpAAAW
#endif
#if XSubPPtmpAAAX
#endif
#if XSubPPtmpAAAY
#endif
#if XSubPPtmpAAAZ
#endif
#if XSubPPtmpAABA
#endif
#if XSubPPtmpAABB
#endif
#if XSubPPtmpAABC
#endif
#if XSubPPtmpAABD
#endif
#if XSubPPtmpAABE
#endif
#if XSubPPtmpAABF
#endif
#if XSubPPtmpAABG
#endif
#if XSubPPtmpAABH
#endif
#if XSubPPtmpAABI
#endif
#if XSubPPtmpAABJ
#endif
#if XSubPPtmpAABK
#endif
#if XSubPPtmpAABL
#endif
#if XSubPPtmpAABM
#endif
#if XSubPPtmpAABN
#endif
#if XSubPPtmpAABO
#endif
#if XSubPPtmpAABP
#endif
#if XSubPPtmpAABQ
#endif
#if XSubPPtmpAABR
#endif
#if XSubPPtmpAABS
#endif
#if XSubPPtmpAABT
#endif
#if XSubPPtmpAABU
#endif
#if XSubPPtmpAABV
#endif
#if XSubPPtmpAABW
#endif
#if XSubPPtmpAABX
#endif
#if XSubPPtmpAABY
#endif
#if XSubPPtmpAABZ
#endif
#if XSubPPtmpAACA
#endif
#if XSubPPtmpAACB
#endif
#if XSubPPtmpAACC
#endif
#if XSubPPtmpAACD
#endif
#if XSubPPtmpAACE
#endif
#if XSubPPtmpAACF
#endif
#if XSubPPtmpAACG
#if XSubPPtmpAACH
#endif
#endif
#if XSubPPtmpAACI
#endif
#if XSubPPtmpAACJ
#endif
#if XSubPPtmpAACK
#endif
#if XSubPPtmpAACL
#endif
#if XSubPPtmpAACM
#endif
#if XSubPPtmpAACN
#endif
#if XSubPPtmpAACO
#endif
#if XSubPPtmpAACP
#endif
#line 15493 "SSLeay.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

