package Blog::Post;

use strict;
use warnings;

use base 'Blog::GEN::Post';

use Gantry::Plugins::CRUD;

use Blog::Model::post qw(
    $POST
);

#-----------------------------------------------------------------
# $self->controller_config(  )
#-----------------------------------------------------------------
# This method inherited from Blog::GEN::Post

my $post = Gantry::Plugins::CRUD->new(
    add_action      => \&post_add,
    edit_action     => \&post_edit,
    delete_action   => \&post_delete,
    form            => __PACKAGE__->can( 'post_form' ),
    redirect        => \&post_redirect,
    text_descr      => 'post',
);

#-----------------------------------------------------------------
# $self->post_redirect( $data )
# The generated version mimics the default behavior, feel free
# to delete the redirect key from the constructor call for $crud
# and this sub.
#-----------------------------------------------------------------
sub post_redirect {
    my ( $self, $data ) = @_;
    return $self->location;
}

#-------------------------------------------------
# $self->do_add( )
#-------------------------------------------------
sub do_add {
    my $self = shift;

    Gantry::Plugins::CRUD::verify_permission( { site => $self } );

    $post->add( $self, { data => \@_ } );
}

#-------------------------------------------------
# $self->post_add( $params, $data )
#-------------------------------------------------
sub post_add {
    my ( $self, $params, $data ) = @_;

    # make a new row in the $POST table using data from $params
    # remember to add commit if needed

    $POST->gupdate_or_create( $self, $params );
}

#-------------------------------------------------
# $self->do_delete( $doomed_id, $confirm )
#-------------------------------------------------
sub do_delete {
    my ( $self, $doomed_id, $confirm ) = @_;

    my $row = $POST->gfind( $self, $doomed_id );

    Gantry::Plugins::CRUD::verify_permission( { site => $self, row => $row } );

    $post->delete( $self, $confirm, { row => $row } );
}

#-------------------------------------------------
# $self->post_delete( $data )
#-------------------------------------------------
sub post_delete {
    my ( $self, $data ) = @_;

    # fish the id (or the actual row) from the data hash
    # delete it
    # remember to add commit if needed

    $data->{ row }->delete;
}

#-------------------------------------------------
# $self->do_edit( $id )
#-------------------------------------------------
sub do_edit {
    my ( $self, $id ) = @_;

    my $row = $POST->gfind( $self, $id );

    Gantry::Plugins::CRUD::verify_permission( { site => $self, row => $row } );

    $post->edit( $self, { row => $row } );
}

#-------------------------------------------------
# $self->post_edit( $param, $data )
#-------------------------------------------------
sub post_edit {
    my( $self, $params, $data ) = @_;

    # retrieve the row from the data hash
    # update the row
    # remember to add commit if needed

    $data->{row}->update( $params );
}

#-----------------------------------------------------------------
# $self->post_form( $data )
#-----------------------------------------------------------------
# This method inherited from Blog::GEN::Post


1;

=head1 NAME

Blog::Post - A controller in the Blog application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use Blog::Post;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'Blog::Post',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use Blog::Post;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler Blog::Post
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item get_model_name

=item text_descr

=item post_redirect

=item do_add

=item post_add

=item do_delete

=item post_delete

=item do_edit

=item post_edit


=back


=head1 METHODS INHERITED FROM Blog::GEN::Post

=over 4

=item controller_config

=item post_form


=back


=head1 DEPENDENCIES

    Blog
    Blog::GEN::Post
    Blog::Model::post
    Gantry::Plugins::CRUD

=head1 AUTHOR

Phil Crow, E<lt>mail@example.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

All rights reserved.

=cut
