#!/usr/bin/perl
use strict;
use warnings;
use lib '.';

use t::lib;
use Code::Quality qw/:all/;
use Test::More;

BEGIN {
	plan skip_all => 'lizard.py not found' unless $Code::Quality::lizard_path;
	plan tests => 4;
}

local $Code::Quality::DEBUG = \&Test::More::note;

sub is_lizard_warning {
	my ($code, $expected, $language) = @_;
	my $warnings = test_lizard(code => $code, language => $language);
	my $message = "lizard warning contains $expected";
	if (!defined $warnings || @$warnings == 0) {
		note 'no warning from lizard';
		fail $message;
	} elsif (@$warnings > 1) {
		note 'multiple warnings from lizard';
		note explain $warnings;
		fail $message
	} else {
		my $warnmsg = $warnings->[0][1];
		like $warnmsg, qr/\Q$expected\E/, $message;
	}
}

local $Code::Quality::lizard_warning_ccn = 14;
is_lizard_warning $t::lib::c_complex_function, '[high-complexity]', 'C';
is_lizard_warning $t::lib::java_very_complex_function, '[very-high-complexity]', 'Java';

local $Code::Quality::lizard_warning_loc = 20;
local $Code::Quality::lizard_error_loc = 30;
is_lizard_warning $t::lib::cpp_long_function, '[long-function]', 'C++';
is_lizard_warning $t::lib::cpp_very_long_function, '[very-long-function]', 'C++';
