/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.safari.SafariOptions;

public class DefaultCapabilityMatcher
implements CapabilityMatcher {
    private static final String GRID_TOKEN = "_";
    private final List<Validator> validators = new ArrayList<Validator>();

    public DefaultCapabilityMatcher() {
        this.validators.addAll(Arrays.asList(new PlatformValidator(), new AliasedPropertyValidator("browserName", "browser"), new AliasedPropertyValidator("browserVersion", "version"), new SimplePropertyValidator("applicationName"), new FirefoxSpecificValidator(), new SafariSpecificValidator()));
    }

    private boolean anything(Object requested) {
        return requested == null || ImmutableSet.of("any", "", "*").contains(requested.toString().toLowerCase());
    }

    public void addToConsider(String capabilityName) {
        this.validators.add(new SimplePropertyValidator(capabilityName));
    }

    @Override
    public boolean matches(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
        return providedCapabilities != null && requestedCapabilities != null && this.validators.stream().allMatch(v -> (Boolean)v.apply(providedCapabilities, requestedCapabilities));
    }

    private Platform extractPlatform(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Platform) {
            return (Platform)((Object)o);
        }
        try {
            return Platform.fromString(o.toString());
        }
        catch (WebDriverException ex) {
            return null;
        }
    }

    class SafariSpecificValidator
    implements Validator {
        SafariSpecificValidator() {
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            if (!"safari".equals(requestedCapabilities.get("browserName")) && !"Safari Technology Preview".equals(requestedCapabilities.get("browserName"))) {
                return true;
            }
            SafariOptions providedOptions = new SafariOptions(new ImmutableCapabilities(providedCapabilities));
            SafariOptions requestedOptions = new SafariOptions(new ImmutableCapabilities(requestedCapabilities));
            return requestedOptions.getAutomaticInspection() == providedOptions.getAutomaticInspection() && requestedOptions.getAutomaticProfiling() == providedOptions.getAutomaticProfiling() && requestedOptions.getUseTechnologyPreview() == providedOptions.getUseTechnologyPreview();
        }
    }

    class FirefoxSpecificValidator
    implements Validator {
        FirefoxSpecificValidator() {
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            if (!"firefox".equals(requestedCapabilities.get("browserName"))) {
                return true;
            }
            if (requestedCapabilities.get("marionette") != null && !Boolean.valueOf(requestedCapabilities.get("marionette").toString()).booleanValue()) {
                return providedCapabilities.get("marionette") != null && Boolean.valueOf(providedCapabilities.get("marionette").toString()) == false;
            }
            return providedCapabilities.get("marionette") == null || Boolean.valueOf(providedCapabilities.get("marionette").toString()) != false;
        }
    }

    class SimplePropertyValidator
    implements Validator {
        private List<String> toConsider;

        SimplePropertyValidator(String ... toConsider) {
            this.toConsider = Arrays.asList(toConsider);
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            return requestedCapabilities.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(DefaultCapabilityMatcher.GRID_TOKEN)).filter(entry -> this.toConsider.contains(entry.getKey())).filter(entry -> !DefaultCapabilityMatcher.this.anything(entry.getValue())).allMatch(entry -> entry.getValue().equals(providedCapabilities.get(entry.getKey())));
        }
    }

    class AliasedPropertyValidator
    implements Validator {
        private String[] propertyAliases;

        AliasedPropertyValidator(String ... propertyAliases) {
            this.propertyAliases = propertyAliases;
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            Object requested = Stream.of(this.propertyAliases).map(requestedCapabilities::get).filter(Objects::nonNull).findFirst().orElse(null);
            if (DefaultCapabilityMatcher.this.anything(requested)) {
                return true;
            }
            Object provided = Stream.of(this.propertyAliases).map(providedCapabilities::get).filter(Objects::nonNull).findFirst().orElse(null);
            return Objects.equals(requested, provided);
        }
    }

    class PlatformValidator
    implements Validator {
        PlatformValidator() {
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            Object requested = Optional.ofNullable(requestedCapabilities.get("platform")).orElse(requestedCapabilities.get("platformName"));
            if (DefaultCapabilityMatcher.this.anything(requested)) {
                return true;
            }
            Object provided = Optional.ofNullable(providedCapabilities.get("platform")).orElse(providedCapabilities.get("platformName"));
            Platform requestedPlatform = DefaultCapabilityMatcher.this.extractPlatform(requested);
            if (requestedPlatform != null) {
                Platform providedPlatform = DefaultCapabilityMatcher.this.extractPlatform(provided);
                return providedPlatform != null && providedPlatform.is(requestedPlatform);
            }
            return provided != null && Objects.equals(requested.toString(), provided.toString());
        }
    }

    static interface Validator
    extends BiFunction<Map<String, Object>, Map<String, Object>, Boolean> {
    }
}

