/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.io.UnsupportedEncodingException;
import net.sourceforge.plantuml.eggs.EggUtils;

public class SentenceDecoder {
    private final String secret;

    public SentenceDecoder(String string, byte[] byArray) throws UnsupportedEncodingException {
        byte[] byArray2 = EggUtils.fromSecretSentence(string).toByteArray();
        byte[] byArray3 = EggUtils.xor(byArray, byArray2);
        this.secret = new String(byArray3, "UTF-8");
    }

    public boolean isOk() {
        for (char c : this.secret.toCharArray()) {
            if (c > '\u0100') {
                return false;
            }
            if (!Character.isDefined(c)) {
                return false;
            }
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }

    public String getSecret() {
        return this.secret;
    }
}

