package OpenInteract::SQLInstall::Classified;

# $Id: Classified.pm,v 1.4 2002/05/02 12:29:12 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
 tables        => [ 'classified.sql' ],
 tables_oracle => [ 'classified_oracle.sql', 'classified_sequence.sql' ],
 tables_pg     => [ 'classified.sql', 'classified_sequence.sql' ],
 tables_ib     => [ 'classified_interbase.sql', 'classified_generator.sql' ],
 security      => [ 'install_security.dat' ],
);

%HANDLERS = (
 create_structure => { '_default_' => [ 'create_structure',
                                        { table_file_list => $files{tables} } ],
                       'Oracle'    => [ 'create_structure',
                                        { table_file_list => $files{tables_oracle} } ],
                       'Pg'        => [ 'create_structure',
                                        { table_file_list => $files{tables_pg} } ],
                       'InterBase' => [ 'create_structure',
                                        { table_file_list => $files{tables_ib} } ],
  },
 install_security => { '_default_' => [ 'install_data',
                                        { data_file_list => $files{security} } ] },
);

1;
