# Generated by default/object.tt
package Paws::GuardDuty::DefaultServerSideEncryption;
  use Moose;
  has EncryptionType => (is => 'ro', isa => 'Str', request_name => 'encryptionType', traits => ['NameInRequest']);
  has KmsMasterKeyArn => (is => 'ro', isa => 'Str', request_name => 'kmsMasterKeyArn', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::DefaultServerSideEncryption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::DefaultServerSideEncryption object:

  $service_obj->Method(Att1 => { EncryptionType => $value, ..., KmsMasterKeyArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::DefaultServerSideEncryption object:

  $result = $service_obj->Method(...);
  $result->Att1->EncryptionType

=head1 DESCRIPTION

Contains information on the server side encryption method used in the
S3 bucket. See S3 Server-Side Encryption
(https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html)
for more information.

=head1 ATTRIBUTES


=head2 EncryptionType => Str

The type of encryption used for objects within the S3 bucket.


=head2 KmsMasterKeyArn => Str

The Amazon Resource Name (ARN) of the KMS encryption key. Only
available if the bucket C<EncryptionType> is C<aws:kms>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

