/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

public enum ErrorCode {
    SUCCESS(0),
    KEY_ENOENT(1),
    KEY_EEXISTS(2),
    E2BIG(3),
    EINVAL(4),
    NOT_STORED(5),
    DELTA_BADVAL(6),
    NOT_MY_VBUCKET(7),
    AUTH_ERROR(32),
    AUTH_CONTINUE(33),
    UNKNOWN_COMMAND(129),
    ENOMEM(130),
    NOT_SUPPORTED(131),
    EINTERNAL(132),
    EBUSY(133),
    ETMPFAIL(134);

    private final short value;

    private ErrorCode(int value) {
        this.value = (short)value;
    }

    public short value() {
        return this.value;
    }

    static ErrorCode valueOf(short cc) {
        switch (cc) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return KEY_ENOENT;
            }
            case 2: {
                return KEY_EEXISTS;
            }
            case 3: {
                return E2BIG;
            }
            case 4: {
                return EINVAL;
            }
            case 5: {
                return NOT_STORED;
            }
            case 6: {
                return DELTA_BADVAL;
            }
            case 7: {
                return NOT_MY_VBUCKET;
            }
            case 32: {
                return AUTH_ERROR;
            }
            case 33: {
                return AUTH_CONTINUE;
            }
            case 129: {
                return UNKNOWN_COMMAND;
            }
            case 130: {
                return ENOMEM;
            }
            case 131: {
                return NOT_SUPPORTED;
            }
            case 132: {
                return EINTERNAL;
            }
            case 133: {
                return EBUSY;
            }
            case 134: {
                return ETMPFAIL;
            }
        }
        return UNKNOWN_COMMAND;
    }
}

