/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.geom.LineSegmentDouble;

public class Frame {
    private double x;
    private double y;
    private final int width;
    private final int height;

    public Frame(double d, double d2, int n, int n2) {
        this.x = d;
        this.y = d2;
        this.width = n;
        this.height = n2;
    }

    LineSegmentDouble getSide1() {
        return new LineSegmentDouble(this.x, this.y, this.x, this.y + (double)this.height);
    }

    LineSegmentDouble getSide2() {
        return new LineSegmentDouble(this.x, this.y, this.x + (double)this.width, this.y);
    }

    LineSegmentDouble getSide3() {
        return new LineSegmentDouble(this.x + (double)this.width, this.y, this.x + (double)this.width, this.y + (double)this.height);
    }

    LineSegmentDouble getSide4() {
        return new LineSegmentDouble(this.x, this.y + (double)this.height, this.x + (double)this.width, this.y + (double)this.height);
    }

    public Point2D getFrontierPointViewBy(Point2D point2D) {
        LineSegmentDouble lineSegmentDouble = new LineSegmentDouble(point2D, this.getCenter());
        Point2D point2D2 = lineSegmentDouble.getSegIntersection(this.getSide1());
        if (point2D2 != null) {
            return point2D2;
        }
        point2D2 = lineSegmentDouble.getSegIntersection(this.getSide2());
        if (point2D2 != null) {
            return point2D2;
        }
        point2D2 = lineSegmentDouble.getSegIntersection(this.getSide3());
        if (point2D2 != null) {
            return point2D2;
        }
        point2D2 = lineSegmentDouble.getSegIntersection(this.getSide4());
        if (point2D2 != null) {
            return point2D2;
        }
        return null;
    }

    private Point2D getCenter() {
        return new Point2D.Double(this.x + (double)this.width / 2.0, this.y + (double)this.height / 2.0);
    }

    public Point2D getMainCorner() {
        return new Point2D.Double(this.x, this.y);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }
}

