#!/usr/bin/perl

package eBay::API::XML::DataType::AdFormatLeadType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AdFormatLeadType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AdFormatLeadType

=head1 DESCRIPTION

Contains prospective buyer contact information and other details associated with
a lead for an ad format listing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AdFormatLeadType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::MemberMessageExchangeArrayType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::AdFormatLeadStatusCodeType;


my @gaProperties = ( [ 'AdditionalInformation', 'xs:string', '', '', '' ]
	, [ 'Address', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'Answer1', 'xs:boolean', '', '', '' ]
	, [ 'Answer2', 'xs:boolean', '', '', '' ]
	, [ 'BestTimeToCall', 'xs:string', '', '', '' ]
	, [ 'Email', 'xs:string', '', '', '' ]
	, [ 'ExternalEmail', 'xs:string', '', '', '' ]
	, [ 'FinancingAnswer', 'xs:boolean', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ItemTitle', 'xs:string', '', '', '' ]
	, [ 'LeadFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'MemberMessage', 'ns:MemberMessageExchangeArrayType', ''
	     ,'eBay::API::XML::DataType::MemberMessageExchangeArrayType', '1' ]
	, [ 'PurchaseTimeFrame', 'xs:string', '', '', '' ]
	, [ 'Status', 'ns:AdFormatLeadStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AdFormatLeadStatusCodeType', '' ]
	, [ 'SubmittedTime', 'xs:dateTime', '', '', '' ]
	, [ 'TradeInMake', 'xs:string', '', '', '' ]
	, [ 'TradeInModel', 'xs:string', '', '', '' ]
	, [ 'TradeInYear', 'xs:string', '', '', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdditionalInformation()

Message sent from the prospective buyer to the seller. Same
content as in the AdFormatLead.MemberMessage.MemberMessageExchange.Question.Body node (that is only displayed if IncludeMemberMessages =
true is included in the request). The advantage of
retrieving the MemberMessageExchange node, however, is that
you retrieve the entire exchange between the seller and the
lead.

#    Argument: 'xs:string'

=cut

sub setAdditionalInformation {
  my $self = shift;
  $self->{'AdditionalInformation'} = shift
}

=head2 getAdditionalInformation()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getAdditionalInformation {
  my $self = shift;
  return $self->{'AdditionalInformation'};
}


=head2 setAddress()

Address information for the prospective buyer.
Not returned or returned self-closed if information is unavailable.

#    Argument: 'ns:AddressType'

=cut

sub setAddress {
  my $self = shift;
  $self->{'Address'} = shift
}

=head2 getAddress()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AddressType'

=cut

sub getAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Address'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setAnswer1()

This field corresponds to a configurable question on the lead form in the View
Item web page. The corresponding question is site-specific. To determine the
question for a specific site, you must view the form in the web flow for the given
site. This field applies to Classified Ad format listings in Motors categories
only.

MaxLength: 1

#    Argument: 'xs:boolean'

=cut

sub setAnswer1 {
  my $self = shift;
  $self->{'Answer1'} = shift
}

=head2 isAnswer1()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isAnswer1 {
  my $self = shift;
  return $self->{'Answer1'};
}


=head2 setAnswer2()

This field corresponds to a configurable question on the lead form in the View
Item web page. The corresponding question is site-specific. To determine the
question for a specific site, you must view the form in the web flow for the given
site. This field applies to Classified Ad format listings in Motors categories
only.

MaxLength: 1

#    Argument: 'xs:boolean'

=cut

sub setAnswer2 {
  my $self = shift;
  $self->{'Answer2'} = shift
}

=head2 isAnswer2()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isAnswer2 {
  my $self = shift;
  return $self->{'Answer2'};
}


=head2 setBestTimeToCall()

The time of day when the prospective buyer prefers to be contacted by the
seller.
Not returned if information is unavailable.

#    Argument: 'xs:string'

=cut

sub setBestTimeToCall {
  my $self = shift;
  $self->{'BestTimeToCall'} = shift
}

=head2 getBestTimeToCall()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getBestTimeToCall {
  my $self = shift;
  return $self->{'BestTimeToCall'};
}


=head2 setEmail()

Email address for the prospective buyer. If the prospective buyer chooses to
hide his email address when contacting the seller, this element contains two
dashes (--) instead of an email address.

#    Argument: 'xs:string'

=cut

sub setEmail {
  my $self = shift;
  $self->{'Email'} = shift
}

=head2 getEmail()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getEmail {
  my $self = shift;
  return $self->{'Email'};
}


=head2 setExternalEmail()

Email address for the prospective buyer as entered in the lead form on the View
Item page. Provides a way for sellers to contact prospective buyers who choose not to
log in to eBay. This applies to only eBay Motors and eBay Motors categories.

MaxLength: 128

#    Argument: 'xs:string'

=cut

sub setExternalEmail {
  my $self = shift;
  $self->{'ExternalEmail'} = shift
}

=head2 getExternalEmail()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getExternalEmail {
  my $self = shift;
  return $self->{'ExternalEmail'};
}


=head2 setFinancingAnswer()

Prospective buyer answer whether or not the prospective buyer would like
financing. Entered on the lead form on the View Item page. Applies to eBay Motors
and Motors categories only. Financing response meanings: 0= no response,1= yes, 2=
no.

MaxLength: 1

#    Argument: 'xs:boolean'

=cut

sub setFinancingAnswer {
  my $self = shift;
  $self->{'FinancingAnswer'} = shift
}

=head2 isFinancingAnswer()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isFinancingAnswer {
  my $self = shift;
  return $self->{'FinancingAnswer'};
}


=head2 setItemID()

The ID of the item that the lead is for.

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setItemTitle()

The title of the item that the lead is for.

#    Argument: 'xs:string'

=cut

sub setItemTitle {
  my $self = shift;
  $self->{'ItemTitle'} = shift
}

=head2 getItemTitle()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getItemTitle {
  my $self = shift;
  return $self->{'ItemTitle'};
}


=head2 setLeadFee()

The total fee from email and phone leads.
Applies to the item specified in the request.
LeadFee is part the pay-per-lead feature.

#    Argument: 'ns:AmountType'

=cut

sub setLeadFee {
  my $self = shift;
  $self->{'LeadFee'} = shift
}

=head2 getLeadFee()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getLeadFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LeadFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setMemberMessage()

Contains any mail message content shared between the seller and lead.

#    Argument: 'ns:MemberMessageExchangeArrayType'

=cut

sub setMemberMessage {
  my $self = shift;
  $self->{'MemberMessage'} = shift
}

=head2 getMemberMessage()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:MemberMessageExchangeArrayType'

=cut

sub getMemberMessage {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MemberMessage'
		,'eBay::API::XML::DataType::MemberMessageExchangeArrayType');
}


=head2 setPurchaseTimeFrame()

Prospective buyer's time frame for purchasing a vehicle as entered in the
Lead form on View Item page for eBay Motors and eBay Motors categories.
Purchasing Time Frames include:
<ul>
<li>
within next 3 days
</li>
<li>
within a week
</li>
<li>
within a month
</li>
<li>
within three months
</li>
<li>
in more than three months
</li>
<li>
within an undecided time frame
</li>
</ul>

MaxLength: 255

#    Argument: 'xs:string'

=cut

sub setPurchaseTimeFrame {
  my $self = shift;
  $self->{'PurchaseTimeFrame'} = shift
}

=head2 getPurchaseTimeFrame()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getPurchaseTimeFrame {
  my $self = shift;
  return $self->{'PurchaseTimeFrame'};
}


=head2 setStatus()

Status of the lead.

#    Argument: 'ns:AdFormatLeadStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AdFormatLeadStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}


=head2 setSubmittedTime()

Date and time (in GMT) that the lead was submitted.

#    Argument: 'xs:dateTime'

=cut

sub setSubmittedTime {
  my $self = shift;
  $self->{'SubmittedTime'} = shift
}

=head2 getSubmittedTime()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:dateTime'

=cut

sub getSubmittedTime {
  my $self = shift;
  return $self->{'SubmittedTime'};
}


=head2 setTradeInMake()

The make of the vehicle the prospective buyer would like to trade in. Entered on
the lead form on the View Item page. Applies to eBay Motors and Motors categories
only.

MaxLength: 128

#    Argument: 'xs:string'

=cut

sub setTradeInMake {
  my $self = shift;
  $self->{'TradeInMake'} = shift
}

=head2 getTradeInMake()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getTradeInMake {
  my $self = shift;
  return $self->{'TradeInMake'};
}


=head2 setTradeInModel()

The model of the vehicle the prospective buyer would like to trade in. Entered on the lead form on the View Item page.Applies to eBay Motors and Motors categories only.

MaxLength: 128

#    Argument: 'xs:string'

=cut

sub setTradeInModel {
  my $self = shift;
  $self->{'TradeInModel'} = shift
}

=head2 getTradeInModel()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getTradeInModel {
  my $self = shift;
  return $self->{'TradeInModel'};
}


=head2 setTradeInYear()

The year of the vehicle the prospective buyer would like to trade in. Entered on
the lead form on the View Item page. Applies to eBay Motors and Motors categories
only.

MaxLength: 32

#    Argument: 'xs:string'

=cut

sub setTradeInYear {
  my $self = shift;
  $self->{'TradeInYear'} = shift
}

=head2 getTradeInYear()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getTradeInYear {
  my $self = shift;
  return $self->{'TradeInYear'};
}


=head2 setUserID()

The eBay ID of the user who is interested in the seller's item.

#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
