/*
 * parse_auxiliary.c
 *
 * Anything needed by the parser that's too hairy to go in the grammar 
 * itself.  Currently, just stuff needed for generating syntax errors.
 * (See error.c for how they're actually printed.)
 *
 * created 1996/08/07, GPW
 *
 * $Id: parse_auxiliary.c,v 1.5 1997/02/28 03:46:16 greg Exp $
 */

#include "stdpccts.h"
#include "error.h"
#include "parse_auxiliary.h"

/* this is stolen from PCCTS' err.h */
static SetWordType bitmask[] = 
{
    0x00000001, 0x00000002, 0x00000004, 0x00000008,
    0x00000010, 0x00000020, 0x00000040, 0x00000080
};

static struct 
{
   int    token;
   char  *new_name;
} new_tokens[] = 
{
   { ENTRY_TYPE, "entry type" },
   { ENTRY_OPEN, "start of entry (\"{\" or \"(\")" },
   { ENTRY_KEY,  "entry key" },
   { KEYWORD,    "field or macro name" },
   { EQUALS,     "\"=\"" },
   { HASH,       "\"#\"" },
   { COMMA,      "\",\"" },
   { NUMBER,     "number" },
   { ENTRY_CLOSE,"end of entry (\"}\" or \")\")" },
   { STRING,     "quoted string ({...} or \"...\")" }
};

/* char **token_names; */

void
fix_token_names (void)
{
   int    i;
   int    num_replace;

/*
   int    num_tok;

   num_tok = (sizeof(zztokens) / sizeof(*zztokens));
   sizeof (zztokens);
   sizeof (*zztokens);
   token_names = (char **) malloc (sizeof (char *) * num_tok);

   for (i = 0; i < num_tok; i++)
   {
      token_names[i] = zztokens[i];
   }
*/
   num_replace = (sizeof(new_tokens) / sizeof(*new_tokens));
   for (i = 0; i < num_replace; i++)
   {
      char  *new = new_tokens[i].new_name;
      char **old = zztokens + new_tokens[i].token;

      *old = new;
   }
}


#ifdef USER_ZZSYN

static void
append_token_set (char *msg, SetWordType *a)
{
   SetWordType *p = a;
   SetWordType *endp = &(p[zzSET_SIZE]);
   unsigned e = 0;
   int      tokens_printed = 0;
   
   do 
   {
      SetWordType t = *p;
      SetWordType *b = &(bitmask[0]);
      do
      {
         if (t & *b)
         {
            strcat (msg, zztokens[e]);
            tokens_printed++;
            if (tokens_printed < zzset_deg (a) - 1)
               strcat (msg, ", ");
            else if (tokens_printed == zzset_deg (a) - 1)
               strcat (msg, " or ");
         }
         e++;
      } while (++b < &(bitmask[sizeof(SetWordType)*8]));
   } while (++p < endp);
}


void
zzsyn(char *text, int tok, 
      char *egroup, SetWordType *eset, int etok,
      int k, char *bad_text)
{
#if 0
   extern char    InputFilename[]; /* from bibparse.c (main program) */
   extern int     SyntaxErrors;
#endif
   static char    msg [MAX_ERROR];
   int            len;

   /* Initial message: give location of error */

   msg[0] = (char) 0;           /* make sure string is empty to start! */
   if (tok == zzEOF_TOKEN)
      strcat (msg, "found end of file, ");
   else
      sprintf (msg, "found \"%s\", ", bad_text);

   len = strlen (msg);

   
   /* Caller supplied neither a single token nor set of tokens expected... */

   if (!etok && !eset)
   {
      syntax_error ("%s", msg);
      return;
   }

   
   /* I'm not quite sure what this is all about, or where k would be != 1... */
   
   if (k != 1)
   {
      sprintf (msg+len, "; \"%s\" not", bad_text);
      if (zzset_deg (eset) > 1) strcat (msg, " in");
      len = strlen (msg);
   }


   /* This is the code that usually gets run */
   
   if (zzset_deg (eset) > 0) 
   {
      if (zzset_deg (eset) == 1)
         strcat (msg, "expected ");
      else
         strcat (msg, "expected one of: ");

      append_token_set (msg, eset);
   }
   else
   {
      sprintf (msg+len, "expected %s", zztokens[etok]);
   }

   len = strlen (msg);
   if (egroup && strlen (egroup) > 0) 
      sprintf (msg+len, " in %s", egroup);

   syntax_error ("%s", msg);

}
#endif /* USER_ZZSYN */


void show_stack (char *label)           /* for debugging */
{
   extern char *nodetype_names[];       /* nicked from traversal.c */
   AST   *top;

   top = zzastStack[zzast_sp];
   printf ("%-15s: zzast_sp = %d, top = ", label, zzast_sp);
   if (top && top->nodetype >= AST_ENTRY && top->nodetype <= AST_MACRO)
      printf ("{ %s: \"%s\" }\n",
              nodetype_names[top->nodetype], top->text);
   else
      printf ("NULL (or bogus)\n");
}
