package Google::Ads::AdWords::v201206::TargetRestrictSetting;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201206::Setting);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Setting__Type_of :ATTR(:get<Setting__Type>);
my %useAdGroup_of :ATTR(:get<useAdGroup>);

__PACKAGE__->_factory(
    [ qw(        Setting__Type
        useAdGroup

    ) ],
    {
        'Setting__Type' => \%Setting__Type_of,
        'useAdGroup' => \%useAdGroup_of,
    },
    {
        'Setting__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'useAdGroup' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'Setting__Type' => 'Setting.Type',
        'useAdGroup' => 'useAdGroup',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::TargetRestrictSetting

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TargetRestrictSetting from the namespace https://adwords.google.com/api/adwords/cm/v201206.

Target restrict setting. Set useAdGroup to true to indicate the use of adgroup level targeting settings. Set useAdGroup to false to use the old campaign level broad/restrict setting. Choosing this option will be a one-way transition: once you choose it, you cannot go back to the old broad/specific settings. This setting is automatically added to all campaigns created with API v201206 with useAdGroup set to true. Any passed value will be ignored. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * useAdGroup




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

