use Math::Symbolic qw(:all);
use Math::Symbolic::Custom::Collect;

use Test::More;

my @tests = (
    '1+2+3+4+5+6+7+8+9',
    '1-2-3-4-5-6-7-8-9',
    '1+2-3+4-5+6-7+8-9',
    '1*2*3*4*5*6*7*8*9',
    '1/2/3/4/5/6/7/8/9',
    '1+2*3+4*5+6*7+8*9',
    'x^2+y^2',
    '((x+y)^2)/7',
    'x^(4*(x+y))',
    '0/1',
    '5/1',
    '7/4',
    '-1/7',
    '1/-7',
    '-1/-7',
    '10/5',
    '11/5',
    '(1+2+x)*(y+z)',
    '(1+2+x)*((y+z)*(a+b+c))',
    '(1+2+x)*((y+z)*(a-b-c))',
    '(y+x)*(x+2*x)*(1+(y*x))',
    '(1/4)*(1*2*3)',
    '(1/4)*(1/3)*(1/2)*5',
    '(1/14)*(x+x+y)',
    '(x+y)*(((x+y)/14) + ((x+y)/12))',
    '((x*(2/14))+(x*y))*y',
    'x^(4*(x+y))',
    '3*(1/4)',
    '(((x+y)/2)*((x+y)/3))/4',
    '(((x+y)/2)*((x+y)/3))/(x+y)',
    '((((1/5)*(x+(z*y)))/2)*(((1/5)*(x+(z*y)))/3))/4',
    '(1+2+x)*(sin(y)+z)',
    'sin(x)*(x+y+z)',
    'cos(x^2+y^2)',
    'cos(((x+y)^2)/7)',
    'cos(5/1)',
    'cos(7/4)',
    'cos(-1/7)',
    'cos(1/-7)',
    'cos(-1/-7)',
    'cos(10/5)',
    'cos(11/5)',
    'cos((1+2+x)*(y+z))',
    'cos((1+2+x)*((y+z)*(a+b+c)))',
    'cos((1+2+x)*((y+z)*(a-b-c)))',
    'cos((1+2+x)*(sin(y)+z))',
    '(x^2+y^2)/(k^2+l^2)',
    '(sinh(x)+cosh(y))*(sinh(x)+cosh(y))',
    '(sinh(x)+cosh(y))*(sinh(x)-cosh(y))',
    '(sinh(sin(x)+cos(y))+cosh(sin(x)+cos(y)))*(sinh(x)-cosh(y))',
    '(1/4)*(1*2*3)',
    '(1/4)*(1/3)*(1/2)*5',
    '(1/14)*(x+x+y)',
    '(x+y)*(((x+y)/14) + ((x+y)/12))',
    '((x*(2/14))+(x*y))*y',
    'x^(4*(x+y))',
    '3*(1/4)',
    '(((x+y)/2)*((x+y)/3))/4',
    '(((x+y)/2)*((x+y)/3))/(x+y)',
    '((((1/5)*(x+(z*y)))/2)*(((1/5)*(x+(z*y)))/3))/4',
    '((1/2)*x^2 + 2*x + (1/4))*2',
    '((1/2)*x^2 + 2*x + (1/4))*x^2',
    '((1/2)*x^2 + 2*x + (1/4))*(x+z+y)',
    '((y/x)*z)+((y/x)*y)',
    '(1/4)/(1/2)',
    '(1/2)+(1/2)',
    '1+(1/2)',
    '(1/2)-(1/2)',
    '1-(1/2)',
    '(1/2)-1',
    '(1/2)-(3/4)',
    '(x+y+z)*x',
    '(x+y+z)*x^2',
    '((x+y+z)*x^2)/5',
    '2*(1/4)',
    '(5/(x+1))-((x-2)/(x+1))',
    '(x*a-x*b)/(x*a+x*b)',
    '-1+2+3+4-5+6+7+8+9',
    '-1-2-3-4-5-6-7-8-9',
    '-1+2-3+4-5+6-7+8-9',
    '-1*2*3*4*5*6*7*8*9',
    '-1/2/-3/4/-5/6/-7/-8/9',
    '-1+2*3+4*5+6*7+8*9',
    '-x^2-y^2',
    '-((x+y)^2)/-7',
    '-x^(4*(x+y))',
    '-0/1',
    '-5/1',
    '-7/4',
    '1/7',
    '-1/-7',
    '1/-7',
    '-10/5',
    '-11/5',
    '-(1-2+x)*(y-z)',
    '-(1+2+x)*((y+z)*(a+b+c))',
    '-(1+2+x)*((y+z)*(a-b-c))',
    '-(y+x)*(x+2*x)*(1+(y*x))',
    '-(1/4)*(1*-2*3)',
    '-(1/4)*(1/3)*(1/2)*5',
    '-(1/14)*(x+x+y)',
    '-(x+y)*(((x-y)/14) + ((x+y)/12))',
    '-((x*(2/14))+(x*y))*y',
    '-x^(4*(x+y))',
    '-3*(1/4)',
    '-(((x+y)/2)*((x-y)/3))/-4',
    '-(((x+y)/2)*((x+y)/3))/(x+y)',
    '-((((1/5)*(x-(z*y)))/2)*(((1/-5)*(x+(z*y)))/3))/4',
    '-(1+2+x)*(sin(y)-z)',
    '-sin(x)*(x+y+z)',
    '-cos(x^2+y^2)',
    '-cos(((x+y)^2)/7)',
    '-cos(5/1)',
    '-cos(7/4)',
    '-cos(-1/7)',
    '-cos(1/-7)',
    '-cos(-1/-7)',
    '-cos(10/5)',
    '-cos(11/5)',
    '-cos((1-2+x)*(y+z))',
    '-cos((1+2+x)*((y-z)*(a+b+c)))',
    '-cos((1+2+x)*((y+z)*(a-b-c)))',
    '-cos((1+2-x)*(sin(y)+z))',
    '-(x^2+y^2)/(k^2+l^2)',
    '-(sinh(x)-cosh(y))*(sinh(x)+cosh(y))',
    '-(sinh(x)+cosh(y))*(sinh(x)-cosh(y))',
    '-(sinh(sin(x)-cos(y))+cosh(sin(x)-cos(y)))*(sinh(x)-cosh(y))',
    '-(1/4)*(1*2*3)',
    '-(1/4)*(1/3)*(1/2)*5',
    '-(1/14)*(x+x+y)',
    '-(x+y)*(((x+y)/14) + ((x+y)/12))',
    '-((x*(2/14))+(x*y))*y',
    '-x^(4*(x+y))',
    '-3*(1/4)',
    '-(((x+y)/2)*((x+y)/3))/4',
    '-(((x+y)/2)*((x+y)/3))/(x+y)',
    '-((((1/5)*(x+(z*y)))/2)*(((1/5)*(x+(z*y)))/3))/4',
    '-((1/2)*x^2 + 2*x - (1/4))*2',
    '-((1/2)*x^2 + 2*x + (1/4))*x^2',
    '-((1/2)*x^2 - 2*x + (1/4))*(x+z+y)',
    '-((y/x)*z)+((y/x)*y)',
    '-(1/4)/(1/-2)',
    '-(1/2)+(-1/2)',
    '-1+(1/2)',
    '-(1/2)-(1/-2)',
    '-1-(1/2)',
    '-(1/2)-1',
    '-(1/2)-(3/-4)',
    '-(x-y-z)*x',
    '-(x+y-z)*x^2',
    '-((x-y+z)*x^2)/5',
    '-2*(1/-4)',
    '-(5/(x+1))-((x-2)/(x-1))',
    '-(x*a-x*b)/(x*a-x*b)',
    '2/1',
    '11/2',
    '-11/-22',
    '-5/10',
    '5/-10',
    '(2/3)-(-1/6)',
    '(2/3)-(1/-6)',
    '(-2/3)-(1/6)',
    '(2/-3)-(1/6)',
    '(-2/-3)-(1/6)',
    '(2/3)-(-1/-6)',
    '24/36',
    '36/30',
    '45/75',
    '2001/3000',
    '2740/8220',
    '(2/4)+(1/4)',
    '(1/2)+(1/4)+(1/4)',
    '(3*3)/(3-1)',
    '(4/5)*(2/3)',
    '(11/2)*2',
    '2*(10/2)',
    '3*((10+12)/6)',
    '(2/3)-(1/6)',
    '(2/4)-(2/8)',
    '(3/10)/(18/25)',
    '(0+(8/13))+(5/13)',
    '-2/-x',
    '2/-x',
    '-2/(-2*x)',
    '(a*(b+c))/((b+c)*a)',
    '(6*x+4)/2',
    '(21*w+9)/15',
    '(-12*y+36)/-8',
    '(5*z-30)/-5',
    '(5/(x+1))-((x-2)/(x+1))',
    '(1/(x+1))+(x/(4-x))-(1/(x-2))',
    '(a-a^2)/(3*a^3-3*a)',
    '((1/(3*a))-(1/(3*b)))/((a/b)-(b/a))',
    '-1*(x+1)*(x+1)+1',
    '4*x*(1/4)',
    '-(((x+y)/2)*((x-y)/3))/-4',
    'x/x',
    '1/(1-(1/x))',
    '(5*x)/(1-(1/x))',
    '(sin(x)*b + sin(x)*c)/(sin(x)*a + sin(x)*d)',
    'x^2+4*x+4+((13*x+7)/(x^2-x-2))',
    '(2*4)-(9+8+7+6+5+4+3+2+1)',
    '(2*4)-(6-3)',
    '(2*4)-(6*3)',
    '(2*4+3^3)-(9+8+7+6+5+4+3+2+1)',
    '8-(9+8+7+6+5+4+3+2+1)',
    '8-(6-3)',
    '8-(6*3)',
    '(8+3^3)-(9+8+7+6+5+4+3+2+1)',
    '5*x^3',
    '(5+y)*x^2',
    '5*x^(3+z)',
    '(5+y)*x^(2-k)',
    'x^3*5',
    'x^2*(5+y)',
    'x^(3+z)*5',
    'x^(2-k)*(5+y)',
    '6*x^3*5',
    '(5+y)*x^2*(5+y)',
    '5*x^(3+z)*5',
    '(5+y)*x^(2-k)*(5+y)',
    '(1/4)*2+(x/2)',
    '((1/4)+(1/2))*3*x'
);

TEST_LOOP: foreach my $test (@tests) {
    my $f = parse_from_string($test);
    # can the parser parse the test string?
    ok( defined($f), "parsing test string [$test]" );
    if (!defined $f) {
        next TEST_LOOP;
    }  

    my $f2 = $f->to_collected();
    # does to_collected() return something?
    ok( defined($f2), "to_collected() returns defined [$f2]" );
    if (!defined $f2) {
        next TEST_LOOP;
    }   
    
    # the new Math::Symbolic tree should be numerically equivalent to the original tree
    ok($f->test_num_equiv($f2), "output expression is numerically equivalent to original [$test |vs| $f2]");  
}

done_testing( 3*scalar(@tests) );


