# Generated by default/object.tt
package Paws::Macie2::GroupCount;
  use Moose;
  has Count => (is => 'ro', isa => 'Int', request_name => 'count', traits => ['NameInRequest']);
  has GroupKey => (is => 'ro', isa => 'Str', request_name => 'groupKey', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::GroupCount

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::GroupCount object:

  $service_obj->Method(Att1 => { Count => $value, ..., GroupKey => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::GroupCount object:

  $result = $service_obj->Method(...);
  $result->Att1->Count

=head1 DESCRIPTION

Provides a group of results for a query that retrieved aggregated
statistical data about findings.

=head1 ATTRIBUTES


=head2 Count => Int

The total number of findings in the group of query results.


=head2 GroupKey => Str

The name of the property that defines the group in the query results,
as specified by the groupBy property in the query request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

