# Generated by default/object.tt
package Paws::NimbleStudio::CreateStudioInput;
  use Moose;
  has AdminRoleArn => (is => 'ro', isa => 'Str', request_name => 'adminRoleArn', traits => ['NameInRequest'], required => 1);
  has DisplayName => (is => 'ro', isa => 'Str', request_name => 'displayName', traits => ['NameInRequest'], required => 1);
  has StudioEncryptionConfiguration => (is => 'ro', isa => 'Paws::NimbleStudio::StudioEncryptionConfiguration', request_name => 'studioEncryptionConfiguration', traits => ['NameInRequest']);
  has StudioName => (is => 'ro', isa => 'Str', request_name => 'studioName', traits => ['NameInRequest'], required => 1);
  has Tags => (is => 'ro', isa => 'Paws::NimbleStudio::Tags', request_name => 'tags', traits => ['NameInRequest']);
  has UserRoleArn => (is => 'ro', isa => 'Str', request_name => 'userRoleArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::CreateStudioInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::CreateStudioInput object:

  $service_obj->Method(Att1 => { AdminRoleArn => $value, ..., UserRoleArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::CreateStudioInput object:

  $result = $service_obj->Method(...);
  $result->Att1->AdminRoleArn

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 B<REQUIRED> AdminRoleArn => Str

The IAM role that Studio Admins will assume when logging in to the
Nimble Studio portal.


=head2 B<REQUIRED> DisplayName => Str

A friendly name for the studio.


=head2 StudioEncryptionConfiguration => L<Paws::NimbleStudio::StudioEncryptionConfiguration>

The studio encryption configuration.


=head2 B<REQUIRED> StudioName => Str

The studio name that is used in the URL of the Nimble Studio portal
when accessed by Nimble Studio users.


=head2 Tags => L<Paws::NimbleStudio::Tags>

A collection of labels, in the form of key:value pairs, that apply to
this resource.


=head2 B<REQUIRED> UserRoleArn => Str

The IAM role that Studio Users will assume when logging in to the
Nimble Studio portal.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

