
package Paws::Athena::ListDatabases;
  use Moose;
  has CatalogName => (is => 'ro', isa => 'Str', required => 1);
  has MaxResults => (is => 'ro', isa => 'Int');
  has NextToken => (is => 'ro', isa => 'Str');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListDatabases');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Athena::ListDatabasesOutput');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::ListDatabases - Arguments for method ListDatabases on L<Paws::Athena>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListDatabases on the
L<Amazon Athena|Paws::Athena> service. Use the attributes of this class
as arguments to method ListDatabases.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListDatabases.

=head1 SYNOPSIS

    my $athena = Paws->service('Athena');
    my $ListDatabasesOutput = $athena->ListDatabases(
      CatalogName => 'MyCatalogNameString',
      MaxResults  => 1,                       # OPTIONAL
      NextToken   => 'MyToken',               # OPTIONAL
    );

    # Results:
    my $DatabaseList = $ListDatabasesOutput->DatabaseList;
    my $NextToken    = $ListDatabasesOutput->NextToken;

    # Returns a L<Paws::Athena::ListDatabasesOutput> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/athena/ListDatabases>

=head1 ATTRIBUTES


=head2 B<REQUIRED> CatalogName => Str

The name of the data catalog that contains the databases to return.



=head2 MaxResults => Int

Specifies the maximum number of results to return.



=head2 NextToken => Str

A token generated by the Athena service that specifies where to
continue pagination if a previous request was truncated. To obtain the
next set of pages, pass in the C<NextToken> from the response object of
the previous page call.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListDatabases in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

