#!/usr/bin/env perl

use strict;
use warnings;

use Wikibase::Datatype::Languages qw(all_language_codes);

my @language_codes = sort { $a cmp $b } all_language_codes();

# Print out.
print join "\n", @language_codes;
print "\n";

# Output:
# aa
# ab
# abs
# ace
# acm
# ady
# ady-cyrl
# aeb
# aeb-arab
# aeb-latn
# af
# agq
# ak
# aln
# als
# alt
# am
# ami
# an
# ang
# ann
# anp
# ar
# arc
# arn
# arq
# ary
# arz
# as
# ase
# ast
# atj
# av
# avk
# awa
# ay
# az
# azb
# ba
# bag
# ban
# ban-bali
# bar
# bas
# bat-smg
# bax
# bbc
# bbc-latn
# bbj
# bcc
# bci
# bcl
# be
# be-tarask
# be-x-old
# bfd
# bg
# bgn
# bh
# bho
# bi
# bjn
# bkc
# bkh
# bkm
# blk
# bm
# bn
# bo
# bpy
# bqi
# bqz
# br
# brh
# bs
# btm
# bto
# bug
# bxr
# byv
# ca
# cak
# cbk-zam
# cdo
# ce
# ceb
# ch
# cho
# chr
# chy
# ckb
# cnh
# co
# cps
# cr
# crh
# crh-cyrl
# crh-latn
# cs
# csb
# cu
# cv
# cy
# da
# dag
# de
# de-at
# de-ch
# de-formal
# dga
# din
# diq
# dsb
# dtp
# dty
# dua
# dv
# dz
# ee
# egl
# el
# eml
# en
# en-ca
# en-gb
# en-us
# en-x-piglatin
# eo
# es
# es-419
# es-formal
# et
# eto
# etu
# eu
# ewo
# ext
# fa
# fat
# ff
# fi
# fit
# fiu-vro
# fj
# fkv
# fmp
# fo
# fon
# fr
# frc
# frp
# frr
# fur
# fy
# ga
# gaa
# gag
# gan
# gan-hans
# gan-hant
# gcr
# gd
# gl
# gld
# glk
# gn
# gom
# gom-deva
# gom-latn
# gor
# got
# gpe
# grc
# gsw
# gu
# guc
# gur
# guw
# gv
# gya
# ha
# hak
# haw
# he
# hi
# hif
# hif-latn
# hil
# hno
# ho
# hr
# hrx
# hsb
# hsn
# ht
# hu
# hu-formal
# hy
# hyw
# hz
# ia
# id
# ie
# ig
# igl
# ii
# ik
# ike-cans
# ike-latn
# ilo
# inh
# io
# is
# isu
# it
# iu
# ja
# jam
# jbo
# jut
# jv
# ka
# kaa
# kab
# kbd
# kbd-cyrl
# kbp
# kcg
# kea
# ker
# kg
# khw
# ki
# kiu
# kj
# kjh
# kjp
# kk
# kk-arab
# kk-cn
# kk-cyrl
# kk-kz
# kk-latn
# kk-tr
# kl
# km
# kn
# ko
# ko-kp
# koi
# kr
# krc
# kri
# krj
# krl
# ks
# ks-arab
# ks-deva
# ksf
# ksh
# ksw
# ku
# ku-arab
# ku-latn
# kum
# kus
# kv
# kw
# ky
# la
# lad
# lb
# lbe
# lem
# lez
# lfn
# lg
# li
# lij
# liv
# lki
# lld
# lmo
# ln
# lns
# lo
# loz
# lrc
# lt
# ltg
# lus
# luz
# lv
# lzh
# lzz
# mad
# mag
# mai
# map-bms
# mcn
# mcp
# mdf
# mg
# mh
# mhr
# mi
# min
# mis
# mk
# ml
# mn
# mni
# mnw
# mo
# mos
# mr
# mrh
# mrj
# ms
# ms-arab
# mt
# mua
# mul
# mus
# mwl
# my
# myv
# mzn
# na
# nah
# nan
# nan-hani
# nap
# nb
# nds
# nds-nl
# ne
# new
# ng
# nge
# nia
# niu
# nl
# nl-informal
# nla
# nmg
# nmz
# nn
# nnh
# nnz
# no
# nod
# nog
# nov
# nqo
# nrm
# nso
# nv
# ny
# nyn
# nys
# oc
# ojb
# olo
# om
# or
# os
# osa-latn
# ota
# pa
# pag
# pam
# pap
# pap-aw
# pcd
# pcm
# pdc
# pdt
# pfl
# pi
# pih
# pl
# pms
# pnb
# pnt
# prg
# ps
# pt
# pt-br
# pwn
# qu
# quc
# qug
# rgn
# rif
# rki
# rm
# rmc
# rmf
# rmy
# rn
# ro
# roa-rup
# roa-tara
# rsk
# ru
# rue
# rup
# ruq
# ruq-cyrl
# ruq-latn
# rw
# rwr
# ryu
# sa
# sah
# sat
# sc
# scn
# sco
# sd
# sdc
# sdh
# se
# se-fi
# se-no
# se-se
# sei
# ses
# sg
# sgs
# sh
# sh-cyrl
# sh-latn
# shi
# shi-latn
# shi-tfng
# shn
# shy
# shy-latn
# si
# simple
# sjd
# sje
# sju
# sk
# skr
# skr-arab
# sl
# sli
# sm
# sma
# smj
# smn
# sms
# sn
# so
# sq
# sr
# sr-ec
# sr-el
# srn
# sro
# srq
# ss
# st
# stq
# sty
# su
# sv
# sw
# syl
# szl
# szy
# ta
# tay
# tcy
# tdd
# te
# tet
# tg
# tg-cyrl
# tg-latn
# th
# ti
# tk
# tl
# tly
# tly-cyrl
# tn
# to
# tok
# tpi
# tr
# tru
# trv
# ts
# tt
# tt-cyrl
# tt-latn
# tum
# tvu
# tw
# ty
# tyv
# tzm
# udm
# ug
# ug-arab
# ug-latn
# uk
# und
# ur
# uz
# uz-cyrl
# uz-latn
# ve
# vec
# vep
# vi
# vls
# vmf
# vmw
# vo
# vot
# vro
# vut
# wa
# wal
# war
# wes
# wls
# wo
# wuu
# wya
# xal
# xh
# xmf
# xsy
# yas
# yat
# yav
# ybb
# yi
# yo
# yrl
# yue
# za
# zea
# zgh
# zh
# zh-classical
# zh-cn
# zh-hans
# zh-hant
# zh-hk
# zh-min-nan
# zh-mo
# zh-my
# zh-sg
# zh-tw
# zh-yue
# zu
# zxx