/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.BucketConfiguration;
import org.couchbase.mock.control.MockCommandDispatcher;
import org.couchbase.mock.harakiri.HarakiriMonitor;
import org.couchbase.mock.http.Authenticator;
import org.couchbase.mock.http.ControlHandler;
import org.couchbase.mock.http.PoolsHandler;
import org.couchbase.mock.util.Getopt;

public class CouchbaseMock {
    private final Map<String, Bucket> buckets = new HashMap<String, Bucket>();
    private int port = 8091;
    private HttpServer httpServer;
    private Authenticator authenticator;
    private ArrayList<Thread> nodeThreads;
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private HarakiriMonitor harakiriMonitor;
    private MockCommandDispatcher controlDispatcher;

    public void setupHarakiriMonitor(String host, boolean terminate) throws IOException {
        int idx = host.indexOf(58);
        String h = host.substring(0, idx);
        int p = Integer.parseInt(host.substring(idx + 1));
        this.harakiriMonitor = new HarakiriMonitor(h, p, terminate, this.controlDispatcher);
        this.harakiriMonitor.start();
    }

    public String getPoolName() {
        return "default";
    }

    public Map<String, Bucket> getBuckets() {
        return this.buckets;
    }

    public HarakiriMonitor getMonitor() {
        return this.harakiriMonitor;
    }

    public MockCommandDispatcher getDispatcher() {
        return this.controlDispatcher;
    }

    private static BucketConfiguration parseBucketString(String spec, BucketConfiguration defaults) {
        BucketConfiguration config = new BucketConfiguration(defaults);
        String[] parts = spec.split(":");
        String name = parts[0];
        String pass = "";
        config.name = name;
        if (parts.length > 1) {
            pass = parts[1];
            if (parts.length > 2 && parts[2].equals("memcache")) {
                config.type = Bucket.BucketType.MEMCACHED;
            }
        }
        config.password = pass;
        return config;
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets, String bucketSpec, int numReplicas) throws IOException {
        ArrayList<BucketConfiguration> configs = new ArrayList<BucketConfiguration>();
        BucketConfiguration defaultConfig = new BucketConfiguration();
        defaultConfig.name = "default";
        defaultConfig.type = Bucket.BucketType.COUCHBASE;
        defaultConfig.hostname = hostname;
        defaultConfig.port = port;
        defaultConfig.numNodes = numNodes;
        if (numReplicas > -1) {
            defaultConfig.numReplicas = numReplicas;
        }
        defaultConfig.bucketStartPort = bucketStartPort;
        defaultConfig.numVBuckets = numVBuckets;
        if (bucketSpec == null) {
            configs.add(defaultConfig);
        } else {
            for (String spec : bucketSpec.split(",")) {
                configs.add(CouchbaseMock.parseBucketString(spec, defaultConfig));
            }
        }
        this.initCommon(port, configs);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets) throws IOException {
        this(hostname, port, numNodes, bucketStartPort, numVBuckets, null, -1);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int numVBuckets) throws IOException {
        this(hostname, port, numNodes, 0, numVBuckets, null, -1);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int numVBuckets, String bucketSpec) throws IOException {
        this(hostname, port, numNodes, 0, numVBuckets, bucketSpec, -1);
    }

    public CouchbaseMock(int port, List<BucketConfiguration> configs) throws IOException {
        this.initCommon(port, configs);
    }

    private void initCommon(int port, List<BucketConfiguration> configs) throws IOException {
        this.port = port;
        for (BucketConfiguration config : configs) {
            Bucket bucket = Bucket.create(this, config);
            this.buckets.put(bucket.getName(), bucket);
        }
        this.authenticator = new Authenticator("Administrator", "password", this.buckets);
        this.controlDispatcher = new MockCommandDispatcher(this);
    }

    public void waitForStartup() throws InterruptedException {
        this.startupLatch.await();
    }

    public int getHttpPort() {
        return this.port;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public static void main(String[] args) {
        int port = 8091;
        int nodes = 100;
        int vbuckets = 4096;
        String harakiriMonitorAddress = null;
        String hostname = null;
        String bucketsSpec = null;
        int replicaCount = -1;
        Getopt getopt = new Getopt();
        getopt.addOption(new Getopt.CommandLineOption('h', "--host", true)).addOption(new Getopt.CommandLineOption('b', "--buckets", true)).addOption(new Getopt.CommandLineOption('p', "--port", true)).addOption(new Getopt.CommandLineOption('n', "--nodes", true)).addOption(new Getopt.CommandLineOption('v', "--vbuckets", true)).addOption(new Getopt.CommandLineOption('\u0000', "--harakiri-monitor", true)).addOption(new Getopt.CommandLineOption('R', "--replicas", true)).addOption(new Getopt.CommandLineOption('?', "--help", false));
        List<Getopt.Entry> options = getopt.parse(args);
        for (Getopt.Entry e : options) {
            if (e.key.equals("-h") || e.key.equals("--host")) {
                hostname = e.value;
                continue;
            }
            if (e.key.equals("-b") || e.key.equals("--buckets")) {
                bucketsSpec = e.value;
                continue;
            }
            if (e.key.equals("-p") || e.key.equals("--port")) {
                port = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-n") || e.key.equals("--nodes")) {
                nodes = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-v") || e.key.equals("--vbuckets")) {
                vbuckets = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-R") || e.key.equals("--replicas")) {
                replicaCount = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("--harakiri-monitor")) {
                int idx = e.value.indexOf(58);
                if (idx == -1) {
                    System.err.println("ERROR: --harakiri-monitor requires host:port");
                }
                harakiriMonitorAddress = e.value;
                continue;
            }
            if (!e.key.equals("-?") && !e.key.equals("--help")) continue;
            System.out.println("Usage: --host=hostname --buckets=bucketsSpec --port=REST-port --nodes=#nodes --vbuckets=#vbuckets --harakiri-monitor=host:port --replicas=#replicas");
            System.out.println("  Default values: REST-port:    8091");
            System.out.println("                  bucketsSpec:  default:");
            System.out.println("                  #nodes:       10");
            System.out.println("                  #vbuckets:    4096");
            System.out.println("                  #replicas:    2");
            System.out.println("Buckets descriptions is a comma-separated list of {name}:{password}:{bucket type} pairs. To allow unauthorized connections, omit password. Third parameter could be either 'memcache' or 'couchbase' (default value is 'couchbase'). E.g.\n    default:,test:,protected:secret,cache::memcache");
            System.exit(0);
        }
        try {
            CouchbaseMock mock = new CouchbaseMock(hostname, port, nodes, 0, vbuckets, bucketsSpec, replicaCount);
            if (harakiriMonitorAddress != null) {
                mock.setupHarakiriMonitor(harakiriMonitorAddress, true);
            }
            mock.start();
        }
        catch (Exception e) {
            Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, "Fatal error! failed to create socket: ", e);
        }
    }

    public void failSome(String name, float percentage) {
        Bucket bucket = this.getBuckets().get(name);
        if (bucket != null) {
            bucket.failSome(percentage);
        }
    }

    public void fixSome(String name, float percentage) {
        Bucket bucket = this.getBuckets().get(name);
        if (bucket != null) {
            bucket.fixSome(percentage);
        }
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
            this.httpServer = null;
        }
        for (Thread t : this.nodeThreads) {
            t.interrupt();
            do {
                try {
                    t.join();
                    t = null;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, null, ex);
                    t.interrupt();
                }
            } while (t != null);
        }
    }

    public void start() {
        this.nodeThreads = new ArrayList();
        for (String s : this.getBuckets().keySet()) {
            Bucket bucket = this.getBuckets().get(s);
            bucket.start(this.nodeThreads);
        }
        boolean useAnyPort = this.port == 0;
        try {
            boolean busy = true;
            do {
                if (this.port == 0) {
                    ServerSocket server = new ServerSocket(0);
                    this.port = server.getLocalPort();
                    server.close();
                }
                try {
                    this.httpServer = HttpServer.create(new InetSocketAddress(this.port), 10);
                    busy = false;
                }
                catch (BindException ex) {
                    if (!useAnyPort) {
                        throw ex;
                    }
                    System.err.println("Looks like port " + this.port + " busy, lets try another one");
                }
            } while (busy);
            this.httpServer.createContext("/pools", new PoolsHandler(this)).setAuthenticator(this.authenticator);
            this.httpServer.createContext("/mock", new ControlHandler(this.controlDispatcher));
            this.httpServer.setExecutor(Executors.newCachedThreadPool());
            this.httpServer.start();
            this.startupLatch.countDown();
        }
        catch (IOException ex) {
            Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(-1);
        }
    }
}

