/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XML
extends DataType
implements XMLDataValue,
StreamStorable {
    protected static final short UTF8_IMPL_ID = 0;
    protected static final String XML_PARSER_CLASS = "org.apache.xerces.parsers.SAXParser";
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$org$apache$derby$iapi$types$XML == null ? (class$org$apache$derby$iapi$types$XML = XML.class$("org.apache.derby.iapi.types.XML")) : class$org$apache$derby$iapi$types$XML);
    private SQLChar xmlStringValue;
    protected XMLReader saxReader;
    private static final String XPATH_PLACEHOLDER = "XPATH_PLACEHOLDER";
    private static final String QUERY_MATCH_STRING = "MATCH";
    private static String xsltStylesheet;
    private XMLReader xsltReader;
    private TransformerFactoryImpl saxTFactory;
    static /* synthetic */ Class class$org$apache$derby$iapi$types$XML;

    public XML() {
        this.xmlStringValue = null;
    }

    private XML(SQLChar sQLChar) {
        this.xmlStringValue = sQLChar == null ? null : (SQLChar)sQLChar.getClone();
    }

    public DataValueDescriptor getClone() {
        return new XML(this.xmlStringValue);
    }

    public DataValueDescriptor getNewNull() {
        return new XML();
    }

    public String getTypeName() {
        return "XML";
    }

    public int typePrecedence() {
        return 180;
    }

    public String getString() throws StandardException {
        return this.xmlStringValue == null ? null : this.xmlStringValue.getString();
    }

    public int getLength() throws StandardException {
        return this.xmlStringValue == null ? 0 : this.xmlStringValue.getLength();
    }

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (this.xmlStringValue != null) {
            n += this.xmlStringValue.estimateMemoryUsage();
        }
        return n;
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        arrayInputStream.readShort();
        this.xmlStringValue.readExternalFromArray(arrayInputStream);
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        this.xmlStringValue.setValue(dataValueDescriptor.getString());
    }

    public final void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        this.xmlStringValue.setValue(resultSet.getString(n));
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.isNull()) {
            if (dataValueDescriptor.isNull()) {
                return 0;
            }
            return -1;
        }
        if (dataValueDescriptor.isNull()) {
            return 1;
        }
        return 0;
    }

    public int getTypeFormatId() {
        return 458;
    }

    public boolean isNull() {
        return this.xmlStringValue == null || this.xmlStringValue.isNull();
    }

    public void restoreToNull() {
        if (this.xmlStringValue != null) {
            this.xmlStringValue.restoreToNull();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        objectInput.readShort();
        this.xmlStringValue.readExternal(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(0);
        this.xmlStringValue.writeExternal(objectOutput);
    }

    public InputStream returnStream() {
        return this.xmlStringValue == null ? null : this.xmlStringValue.returnStream();
    }

    public void setStream(InputStream inputStream) {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        try {
            inputStream.read();
            inputStream.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xmlStringValue.setStream(inputStream);
    }

    public void loadStream() throws StandardException {
        this.getString();
    }

    public void parseAndLoadXML(String string, boolean bl) throws StandardException {
        try {
            if (bl) {
                this.loadSAXReader();
                this.saxReader.parse(new InputSource(new StringReader(string)));
            }
        }
        catch (Exception exception) {
            throw StandardException.newException("2200L", exception);
        }
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        this.xmlStringValue.setValue(string);
    }

    public StringDataValue XMLSerialize(StringDataValue stringDataValue, int n, int n2) throws StandardException {
        if (stringDataValue == null) {
            switch (n) {
                case 1: {
                    stringDataValue = new SQLChar();
                    break;
                }
                case 12: {
                    stringDataValue = new SQLVarchar();
                    break;
                }
                case -1: {
                    stringDataValue = new SQLLongvarchar();
                    break;
                }
                case 2005: {
                    stringDataValue = new SQLClob();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        stringDataValue.setValue(this.xmlStringValue.getString());
        stringDataValue.setWidth(n2, 0, true);
        return stringDataValue;
    }

    public BooleanDataValue XMLExists(StringDataValue stringDataValue, XMLDataValue xMLDataValue) throws StandardException {
        if (stringDataValue == null || stringDataValue.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        if (xMLDataValue == null || xMLDataValue.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        return new SQLBoolean(xMLDataValue.exists(stringDataValue.getString()));
    }

    public boolean exists(String string) throws StandardException {
        try {
            ExistsHandler existsHandler;
            block4: {
                string = this.replaceDoubleQuotes(string);
                this.loadXSLTObjects();
                int n = xsltStylesheet.indexOf(XPATH_PLACEHOLDER);
                StringBuffer stringBuffer = new StringBuffer(xsltStylesheet);
                stringBuffer.replace(n, n + XPATH_PLACEHOLDER.length(), string);
                TemplatesHandler templatesHandler = this.saxTFactory.newTemplatesHandler();
                this.xsltReader.setContentHandler(templatesHandler);
                this.xsltReader.parse(new InputSource(new StringReader(stringBuffer.toString())));
                Templates templates = templatesHandler.getTemplates();
                TransformerHandler transformerHandler = this.saxTFactory.newTransformerHandler(templates);
                this.xsltReader.setContentHandler(transformerHandler);
                existsHandler = new ExistsHandler();
                transformerHandler.setResult(new SAXResult(existsHandler));
                try {
                    this.xsltReader.parse(new InputSource(new StringReader(this.getString())));
                }
                catch (Throwable throwable) {
                    if (throwable.getMessage().indexOf("SAXException: MATCH") != -1) break block4;
                    throw new Exception(throwable.getMessage());
                }
            }
            return existsHandler.exists();
        }
        catch (Exception exception) {
            throw StandardException.newException("X0XML.S", exception);
        }
    }

    protected void loadSAXReader() throws Exception {
        if (this.saxReader != null) {
            return;
        }
        this.saxReader = XMLReaderFactory.createXMLReader(XML_PARSER_CLASS);
        this.saxReader.setFeature("http://xml.org/sax/features/validation", false);
        this.saxReader.setFeature("http://xml.org/sax/features/namespaces", true);
        this.saxReader.setErrorHandler(new XMLErrorHandler());
    }

    private void loadXSLTObjects() throws SAXException {
        if (this.xsltReader != null) {
            return;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.saxTFactory = (TransformerFactoryImpl)transformerFactory;
        this.xsltReader = XMLReaderFactory.createXMLReader(XML_PARSER_CLASS);
        this.xsltReader.setFeature("http://xml.org/sax/features/namespaces", true);
        if (xsltStylesheet == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<xsl:stylesheet version=\"1.0\"\n");
            stringBuffer.append("xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
            stringBuffer.append(" <xsl:template match=\"/\">\n");
            stringBuffer.append("  <xsl:for-each select=\"");
            stringBuffer.append(XPATH_PLACEHOLDER);
            stringBuffer.append("\">.</xsl:for-each>\n");
            stringBuffer.append(" </xsl:template>\n");
            stringBuffer.append("</xsl:stylesheet>\n");
            xsltStylesheet = stringBuffer.toString();
        }
    }

    private String replaceDoubleQuotes(String string) {
        int n = string.indexOf("\"");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n >= 0) {
            stringBuffer.replace(n, n + 1, "'");
            n = string.indexOf("\"", n + 1);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ExistsHandler
    extends DefaultHandler {
        private boolean atLeastOneMatch = false;

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.atLeastOneMatch = true;
            throw new SAXException(XML.QUERY_MATCH_STRING);
        }

        public boolean exists() {
            return this.atLeastOneMatch;
        }
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }
    }
}

