#!/usr/bin/perl

package eBay::API::XML::Call::GetNotificationPreferences;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetNotificationPreferences.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetNotificationPreferences

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetNotificationPreferences inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesRequestType;
use eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetNotificationPreferences';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesResponseType';
}

#
# input properties
#

=head2 setPreferenceLevel()

Specifies what type of Preference to retrieve.

  RequiredInput: Yes
#    Argument: 'ns:NotificationRoleCodeType'

=cut
       
sub setPreferenceLevel {
   my $self   = shift;
   my $sPreferenceLevel = shift;
   $self->getRequestDataType()->setPreferenceLevel($sPreferenceLevel);
}



#
# output properties
#

=head2 getApplicationDeliveryPreferences()

Specifies application-based event preferences that have been enabled.

  Returned: Conditionally
#    Returns: 'ns:ApplicationDeliveryPreferencesType'

=cut
       
sub getApplicationDeliveryPreferences {
   my $self = shift;
   return $self->getResponseDataType()->getApplicationDeliveryPreferences();
}

=head2 getDeliveryURLName()

Specifies application delivery URL Name associated with this user.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getDeliveryURLName {
   my $self = shift;
   return $self->getResponseDataType()->getDeliveryURLName();
}

=head2 getEventProperty()

Characteristics or details of an event such as type, name and value.

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:NotificationEventPropertyType'

=cut
       
sub getEventProperty {
   my $self = shift;
   return $self->getResponseDataType()->getEventProperty();
}

=head2 getUserData()

return user data for notification settings such as set mobile phone number etc.

  Returned: Conditionally
#    Returns: 'ns:NotificationUserDataType'

=cut
       
sub getUserData {
   my $self = shift;
   return $self->getResponseDataType()->getUserData();
}

=head2 getUserDeliveryPreferenceArray()

Specifies user-based event preferences that have been enabled or disabled.

  Returned: Conditionally
#    Returns: 'ns:NotificationEnableArrayType'

=cut
       
sub getUserDeliveryPreferenceArray {
   my $self = shift;
   return $self->getResponseDataType()->getUserDeliveryPreferenceArray();
}





1;   
