#!/usr/bin/perl

package eBay::API::XML::Call::GetSessionID::GetSessionIDResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSessionIDResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSessionID::GetSessionIDResponseType

=head1 DESCRIPTION

Contains the generated SessionID, which is a unique identifier for authenticating data entry during the process that creates a user token.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSessionID::GetSessionIDResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");



my @gaProperties = ( [ 'SessionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSessionID()

A 32-character identifier supplied by eBay to an application. Used to confirm the
identities of the user and the application in a URL redirect during the
process in which the user agrees to let the application wield a user token that
grants the application the right to access eBay data on behalf of the user.
Subsequently also used as input for the FetchToken API call.

#    Argument: 'xs:string'

=cut

sub setSessionID {
  my $self = shift;
  $self->{'SessionID'} = shift
}

=head2 getSessionID()

  Returned: Always
#    Returns: 'xs:string'

=cut

sub getSessionID {
  my $self = shift;
  return $self->{'SessionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
