#!/usr/bin/perl

package eBay::API::XML::DataType::LiveAuctionDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. LiveAuctionDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::LiveAuctionDetailsType

=head1 DESCRIPTION

Describes the live auction-specific details of a lot item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::LiveAuctionDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;


my @gaProperties = ( [ 'HighEstimate', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'LotNumber', 'xs:string', '', '', '' ]
	, [ 'LowEstimate', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ScheduleID', 'xs:int', '', '', '' ]
	, [ 'UserCatalogID', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setHighEstimate()

Highest appraised value for the item.
Must be greater than zero and greater than the value in LowEstimate.
(Pass an integer value only, not a double.)

  Calls: AddLiveAuctionItem
  RequiredInput: Yes

  Calls: ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setHighEstimate {
  my $self = shift;
  $self->{'HighEstimate'} = shift
}

=head2 getHighEstimate()

#    Returns: 'ns:AmountType'

=cut

sub getHighEstimate {
  my $self = shift;
  return $self->_getDataTypeInstance( 'HighEstimate'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setLotNumber()

Lot number defined by the seller. Each lot number must be unique within the schedule.
A lot number can consist of 1-10 alphanumeric characters beginning with a
number from 0-9. If all values are numbers, the highest allowed value is 2147483647.

  Calls: AddLiveAuctionItem
  RequiredInput: Yes

  Calls: ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setLotNumber {
  my $self = shift;
  $self->{'LotNumber'} = shift
}

=head2 getLotNumber()

#    Returns: 'xs:string'

=cut

sub getLotNumber {
  my $self = shift;
  return $self->{'LotNumber'};
}


=head2 setLowEstimate()

Lowest appraised value for the item. Must be greater than zero and
less than the value in HighEstimate.
(Pass an integer value only, not a double.)

  Calls: AddLiveAuctionItem
  RequiredInput: Yes

  Calls: ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setLowEstimate {
  my $self = shift;
  $self->{'LowEstimate'} = shift
}

=head2 getLowEstimate()

#    Returns: 'ns:AmountType'

=cut

sub getLowEstimate {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LowEstimate'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setScheduleID()

Number that identifies the sale schedule for the lot. The schedule ID must be
for a pending sale associated with the catalog identified in UserCatalogID.
Call GetLiveAuctionCatalogDetails to determine the valid schedule IDs for the catalog.

  Calls: AddLiveAuctionItem
         ReviseLiveAuctionItem
  RequiredInput: Yes

#    Argument: 'xs:int'

=cut

sub setScheduleID {
  my $self = shift;
  $self->{'ScheduleID'} = shift
}

=head2 getScheduleID()

#    Returns: 'xs:int'

=cut

sub getScheduleID {
  my $self = shift;
  return $self->{'ScheduleID'};
}


=head2 setUserCatalogID()

Number that identifies the seller's eBay Live Auctions catalog
within which the lot item will be listed. Use GetLiveAuctionCatalogDetails
to determine the seller's available catalog IDs.

  Calls: AddLiveAuctionItem
  RequiredInput: Yes

#    Argument: 'xs:int'

=cut

sub setUserCatalogID {
  my $self = shift;
  $self->{'UserCatalogID'} = shift
}

=head2 getUserCatalogID()

#    Returns: 'xs:int'

=cut

sub getUserCatalogID {
  my $self = shift;
  return $self->{'UserCatalogID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
