/* Nios II R2 opcode list for GAS, the GNU assembler.
   Copyright (C) 2013-2017 Free Software Foundation, Inc.
   Contributed by Mentor Graphics, Inc.

   This file is part of GAS, the GNU Assembler, and GDB, the GNU disassembler.

   GAS/GDB is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GAS/GDB is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GAS or GDB; see the file COPYING3.  If not, write to
   the Free Software Foundation, 51 Franklin Street - Fifth Floor,
   Boston, MA 02110-1301, USA.  */

#ifndef _NIOS2R2_H_
#define _NIOS2R2_H_

/* Fields for 32-bit R2 instructions.  */

#define IW_R2_OP_LSB 0
#define IW_R2_OP_SIZE 6
#define IW_R2_OP_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_R2_OP_SIZE))
#define IW_R2_OP_SHIFTED_MASK (IW_R2_OP_UNSHIFTED_MASK << IW_R2_OP_LSB)
#define GET_IW_R2_OP(W) (((W) >> IW_R2_OP_LSB) & IW_R2_OP_UNSHIFTED_MASK)
#define SET_IW_R2_OP(V) (((V) & IW_R2_OP_UNSHIFTED_MASK) << IW_R2_OP_LSB)

#define IW_L26_IMM26_LSB 6
#define IW_L26_IMM26_SIZE 26
#define IW_L26_IMM26_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_L26_IMM26_SIZE))
#define IW_L26_IMM26_SHIFTED_MASK (IW_L26_IMM26_UNSHIFTED_MASK << IW_L26_IMM26_LSB)
#define GET_IW_L26_IMM26(W) (((W) >> IW_L26_IMM26_LSB) & IW_L26_IMM26_UNSHIFTED_MASK)
#define SET_IW_L26_IMM26(V) (((V) & IW_L26_IMM26_UNSHIFTED_MASK) << IW_L26_IMM26_LSB)

#define IW_F2I16_A_LSB 6
#define IW_F2I16_A_SIZE 5
#define IW_F2I16_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2I16_A_SIZE))
#define IW_F2I16_A_SHIFTED_MASK (IW_F2I16_A_UNSHIFTED_MASK << IW_F2I16_A_LSB)
#define GET_IW_F2I16_A(W) (((W) >> IW_F2I16_A_LSB) & IW_F2I16_A_UNSHIFTED_MASK)
#define SET_IW_F2I16_A(V) (((V) & IW_F2I16_A_UNSHIFTED_MASK) << IW_F2I16_A_LSB)

#define IW_F2I16_B_LSB 11
#define IW_F2I16_B_SIZE 5
#define IW_F2I16_B_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2I16_B_SIZE))
#define IW_F2I16_B_SHIFTED_MASK (IW_F2I16_B_UNSHIFTED_MASK << IW_F2I16_B_LSB)
#define GET_IW_F2I16_B(W) (((W) >> IW_F2I16_B_LSB) & IW_F2I16_B_UNSHIFTED_MASK)
#define SET_IW_F2I16_B(V) (((V) & IW_F2I16_B_UNSHIFTED_MASK) << IW_F2I16_B_LSB)

#define IW_F2I16_IMM16_LSB 16
#define IW_F2I16_IMM16_SIZE 16
#define IW_F2I16_IMM16_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2I16_IMM16_SIZE))
#define IW_F2I16_IMM16_SHIFTED_MASK (IW_F2I16_IMM16_UNSHIFTED_MASK << IW_F2I16_IMM16_LSB)
#define GET_IW_F2I16_IMM16(W) (((W) >> IW_F2I16_IMM16_LSB) & IW_F2I16_IMM16_UNSHIFTED_MASK)
#define SET_IW_F2I16_IMM16(V) (((V) & IW_F2I16_IMM16_UNSHIFTED_MASK) << IW_F2I16_IMM16_LSB)

/* Common to all three I12-group formats F2X4I12, F1X4I12, F1X4L17.  */
#define IW_I12_X_LSB 28
#define IW_I12_X_SIZE 4
#define IW_I12_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_I12_X_SIZE))
#define IW_I12_X_SHIFTED_MASK (IW_I12_X_UNSHIFTED_MASK << IW_I12_X_LSB)
#define GET_IW_I12_X(W) (((W) >> IW_I12_X_LSB) & IW_I12_X_UNSHIFTED_MASK)
#define SET_IW_I12_X(V) (((V) & IW_I12_X_UNSHIFTED_MASK) << IW_I12_X_LSB)

#define IW_F2X4I12_A_LSB 6
#define IW_F2X4I12_A_SIZE 5
#define IW_F2X4I12_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2X4I12_A_SIZE))
#define IW_F2X4I12_A_SHIFTED_MASK (IW_F2X4I12_A_UNSHIFTED_MASK << IW_F2X4I12_A_LSB)
#define GET_IW_F2X4I12_A(W) (((W) >> IW_F2X4I12_A_LSB) & IW_F2X4I12_A_UNSHIFTED_MASK)
#define SET_IW_F2X4I12_A(V) (((V) & IW_F2X4I12_A_UNSHIFTED_MASK) << IW_F2X4I12_A_LSB)

#define IW_F2X4I12_B_LSB 11
#define IW_F2X4I12_B_SIZE 5
#define IW_F2X4I12_B_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2X4I12_B_SIZE))
#define IW_F2X4I12_B_SHIFTED_MASK (IW_F2X4I12_B_UNSHIFTED_MASK << IW_F2X4I12_B_LSB)
#define GET_IW_F2X4I12_B(W) (((W) >> IW_F2X4I12_B_LSB) & IW_F2X4I12_B_UNSHIFTED_MASK)
#define SET_IW_F2X4I12_B(V) (((V) & IW_F2X4I12_B_UNSHIFTED_MASK) << IW_F2X4I12_B_LSB)

#define IW_F2X4I12_IMM12_LSB 16
#define IW_F2X4I12_IMM12_SIZE 12
#define IW_F2X4I12_IMM12_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2X4I12_IMM12_SIZE))
#define IW_F2X4I12_IMM12_SHIFTED_MASK (IW_F2X4I12_IMM12_UNSHIFTED_MASK << IW_F2X4I12_IMM12_LSB)
#define GET_IW_F2X4I12_IMM12(W) (((W) >> IW_F2X4I12_IMM12_LSB) & IW_F2X4I12_IMM12_UNSHIFTED_MASK)
#define SET_IW_F2X4I12_IMM12(V) (((V) & IW_F2X4I12_IMM12_UNSHIFTED_MASK) << IW_F2X4I12_IMM12_LSB)

#define IW_F1X4I12_A_LSB 6
#define IW_F1X4I12_A_SIZE 5
#define IW_F1X4I12_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4I12_A_SIZE))
#define IW_F1X4I12_A_SHIFTED_MASK (IW_F1X4I12_A_UNSHIFTED_MASK << IW_F1X4I12_A_LSB)
#define GET_IW_F1X4I12_A(W) (((W) >> IW_F1X4I12_A_LSB) & IW_F1X4I12_A_UNSHIFTED_MASK)
#define SET_IW_F1X4I12_A(V) (((V) & IW_F1X4I12_A_UNSHIFTED_MASK) << IW_F1X4I12_A_LSB)

#define IW_F1X4I12_X_LSB 11
#define IW_F1X4I12_X_SIZE 5
#define IW_F1X4I12_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4I12_X_SIZE))
#define IW_F1X4I12_X_SHIFTED_MASK (IW_F1X4I12_X_UNSHIFTED_MASK << IW_F1X4I12_X_LSB)
#define GET_IW_F1X4I12_X(W) (((W) >> IW_F1X4I12_X_LSB) & IW_F1X4I12_X_UNSHIFTED_MASK)
#define SET_IW_F1X4I12_X(V) (((V) & IW_F1X4I12_X_UNSHIFTED_MASK) << IW_F1X4I12_X_LSB)

#define IW_F1X4I12_IMM12_LSB 16
#define IW_F1X4I12_IMM12_SIZE 12
#define IW_F1X4I12_IMM12_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4I12_IMM12_SIZE))
#define IW_F1X4I12_IMM12_SHIFTED_MASK (IW_F1X4I12_IMM12_UNSHIFTED_MASK << IW_F1X4I12_IMM12_LSB)
#define GET_IW_F1X4I12_IMM12(W) (((W) >> IW_F1X4I12_IMM12_LSB) & IW_F1X4I12_IMM12_UNSHIFTED_MASK)
#define SET_IW_F1X4I12_IMM12(V) (((V) & IW_F1X4I12_IMM12_UNSHIFTED_MASK) << IW_F1X4I12_IMM12_LSB)

#define IW_F1X4L17_A_LSB 6
#define IW_F1X4L17_A_SIZE 5
#define IW_F1X4L17_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4L17_A_SIZE))
#define IW_F1X4L17_A_SHIFTED_MASK (IW_F1X4L17_A_UNSHIFTED_MASK << IW_F1X4L17_A_LSB)
#define GET_IW_F1X4L17_A(W) (((W) >> IW_F1X4L17_A_LSB) & IW_F1X4L17_A_UNSHIFTED_MASK)
#define SET_IW_F1X4L17_A(V) (((V) & IW_F1X4L17_A_UNSHIFTED_MASK) << IW_F1X4L17_A_LSB)

#define IW_F1X4L17_ID_LSB 11
#define IW_F1X4L17_ID_SIZE 1
#define IW_F1X4L17_ID_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4L17_ID_SIZE))
#define IW_F1X4L17_ID_SHIFTED_MASK (IW_F1X4L17_ID_UNSHIFTED_MASK << IW_F1X4L17_ID_LSB)
#define GET_IW_F1X4L17_ID(W) (((W) >> IW_F1X4L17_ID_LSB) & IW_F1X4L17_ID_UNSHIFTED_MASK)
#define SET_IW_F1X4L17_ID(V) (((V) & IW_F1X4L17_ID_UNSHIFTED_MASK) << IW_F1X4L17_ID_LSB)

#define IW_F1X4L17_WB_LSB 12
#define IW_F1X4L17_WB_SIZE 1
#define IW_F1X4L17_WB_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4L17_WB_SIZE))
#define IW_F1X4L17_WB_SHIFTED_MASK (IW_F1X4L17_WB_UNSHIFTED_MASK << IW_F1X4L17_WB_LSB)
#define GET_IW_F1X4L17_WB(W) (((W) >> IW_F1X4L17_WB_LSB) & IW_F1X4L17_WB_UNSHIFTED_MASK)
#define SET_IW_F1X4L17_WB(V) (((V) & IW_F1X4L17_WB_UNSHIFTED_MASK) << IW_F1X4L17_WB_LSB)

#define IW_F1X4L17_RS_LSB 13
#define IW_F1X4L17_RS_SIZE 1
#define IW_F1X4L17_RS_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4L17_RS_SIZE))
#define IW_F1X4L17_RS_SHIFTED_MASK (IW_F1X4L17_RS_UNSHIFTED_MASK << IW_F1X4L17_RS_LSB)
#define GET_IW_F1X4L17_RS(W) (((W) >> IW_F1X4L17_RS_LSB) & IW_F1X4L17_RS_UNSHIFTED_MASK)
#define SET_IW_F1X4L17_RS(V) (((V) & IW_F1X4L17_RS_UNSHIFTED_MASK) << IW_F1X4L17_RS_LSB)

#define IW_F1X4L17_PC_LSB 14
#define IW_F1X4L17_PC_SIZE 1
#define IW_F1X4L17_PC_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4L17_PC_SIZE))
#define IW_F1X4L17_PC_SHIFTED_MASK (IW_F1X4L17_PC_UNSHIFTED_MASK << IW_F1X4L17_PC_LSB)
#define GET_IW_F1X4L17_PC(W) (((W) >> IW_F1X4L17_PC_LSB) & IW_F1X4L17_PC_UNSHIFTED_MASK)
#define SET_IW_F1X4L17_PC(V) (((V) & IW_F1X4L17_PC_UNSHIFTED_MASK) << IW_F1X4L17_PC_LSB)

#define IW_F1X4L17_RSV_LSB 15
#define IW_F1X4L17_RSV_SIZE 1
#define IW_F1X4L17_RSV_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4L17_RSV_SIZE))
#define IW_F1X4L17_RSV_SHIFTED_MASK (IW_F1X4L17_RSV_UNSHIFTED_MASK << IW_F1X4L17_RSV_LSB)
#define GET_IW_F1X4L17_RSV(W) (((W) >> IW_F1X4L17_RSV_LSB) & IW_F1X4L17_RSV_UNSHIFTED_MASK)
#define SET_IW_F1X4L17_RSV(V) (((V) & IW_F1X4L17_RSV_UNSHIFTED_MASK) << IW_F1X4L17_RSV_LSB)

#define IW_F1X4L17_REGMASK_LSB 16
#define IW_F1X4L17_REGMASK_SIZE 12
#define IW_F1X4L17_REGMASK_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X4L17_REGMASK_SIZE))
#define IW_F1X4L17_REGMASK_SHIFTED_MASK (IW_F1X4L17_REGMASK_UNSHIFTED_MASK << IW_F1X4L17_REGMASK_LSB)
#define GET_IW_F1X4L17_REGMASK(W) (((W) >> IW_F1X4L17_REGMASK_LSB) & IW_F1X4L17_REGMASK_UNSHIFTED_MASK)
#define SET_IW_F1X4L17_REGMASK(V) (((V) & IW_F1X4L17_REGMASK_UNSHIFTED_MASK) << IW_F1X4L17_REGMASK_LSB)

/* Shared by OPX-group formats F3X6L5, F2X6L10, F3X6.  */
#define IW_OPX_X_LSB 26
#define IW_OPX_X_SIZE 6
#define IW_OPX_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_OPX_X_SIZE))
#define IW_OPX_X_SHIFTED_MASK (IW_OPX_X_UNSHIFTED_MASK << IW_OPX_X_LSB)
#define GET_IW_OPX_X(W) (((W) >> IW_OPX_X_LSB) & IW_OPX_X_UNSHIFTED_MASK)
#define SET_IW_OPX_X(V) (((V) & IW_OPX_X_UNSHIFTED_MASK) << IW_OPX_X_LSB)

/* F3X6L5 accessors are also used for F3X6 formats.  */
#define IW_F3X6L5_A_LSB 6
#define IW_F3X6L5_A_SIZE 5
#define IW_F3X6L5_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X6L5_A_SIZE))
#define IW_F3X6L5_A_SHIFTED_MASK (IW_F3X6L5_A_UNSHIFTED_MASK << IW_F3X6L5_A_LSB)
#define GET_IW_F3X6L5_A(W) (((W) >> IW_F3X6L5_A_LSB) & IW_F3X6L5_A_UNSHIFTED_MASK)
#define SET_IW_F3X6L5_A(V) (((V) & IW_F3X6L5_A_UNSHIFTED_MASK) << IW_F3X6L5_A_LSB)

#define IW_F3X6L5_B_LSB 11
#define IW_F3X6L5_B_SIZE 5
#define IW_F3X6L5_B_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X6L5_B_SIZE))
#define IW_F3X6L5_B_SHIFTED_MASK (IW_F3X6L5_B_UNSHIFTED_MASK << IW_F3X6L5_B_LSB)
#define GET_IW_F3X6L5_B(W) (((W) >> IW_F3X6L5_B_LSB) & IW_F3X6L5_B_UNSHIFTED_MASK)
#define SET_IW_F3X6L5_B(V) (((V) & IW_F3X6L5_B_UNSHIFTED_MASK) << IW_F3X6L5_B_LSB)

#define IW_F3X6L5_C_LSB 16
#define IW_F3X6L5_C_SIZE 5
#define IW_F3X6L5_C_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X6L5_C_SIZE))
#define IW_F3X6L5_C_SHIFTED_MASK (IW_F3X6L5_C_UNSHIFTED_MASK << IW_F3X6L5_C_LSB)
#define GET_IW_F3X6L5_C(W) (((W) >> IW_F3X6L5_C_LSB) & IW_F3X6L5_C_UNSHIFTED_MASK)
#define SET_IW_F3X6L5_C(V) (((V) & IW_F3X6L5_C_UNSHIFTED_MASK) << IW_F3X6L5_C_LSB)

#define IW_F3X6L5_IMM5_LSB 21
#define IW_F3X6L5_IMM5_SIZE 5
#define IW_F3X6L5_IMM5_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X6L5_IMM5_SIZE))
#define IW_F3X6L5_IMM5_SHIFTED_MASK (IW_F3X6L5_IMM5_UNSHIFTED_MASK << IW_F3X6L5_IMM5_LSB)
#define GET_IW_F3X6L5_IMM5(W) (((W) >> IW_F3X6L5_IMM5_LSB) & IW_F3X6L5_IMM5_UNSHIFTED_MASK)
#define SET_IW_F3X6L5_IMM5(V) (((V) & IW_F3X6L5_IMM5_UNSHIFTED_MASK) << IW_F3X6L5_IMM5_LSB)

#define IW_F2X6L10_A_LSB 6
#define IW_F2X6L10_A_SIZE 5
#define IW_F2X6L10_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2X6L10_A_SIZE))
#define IW_F2X6L10_A_SHIFTED_MASK (IW_F2X6L10_A_UNSHIFTED_MASK << IW_F2X6L10_A_LSB)
#define GET_IW_F2X6L10_A(W) (((W) >> IW_F2X6L10_A_LSB) & IW_F2X6L10_A_UNSHIFTED_MASK)
#define SET_IW_F2X6L10_A(V) (((V) & IW_F2X6L10_A_UNSHIFTED_MASK) << IW_F2X6L10_A_LSB)

#define IW_F2X6L10_B_LSB 11
#define IW_F2X6L10_B_SIZE 5
#define IW_F2X6L10_B_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2X6L10_B_SIZE))
#define IW_F2X6L10_B_SHIFTED_MASK (IW_F2X6L10_B_UNSHIFTED_MASK << IW_F2X6L10_B_LSB)
#define GET_IW_F2X6L10_B(W) (((W) >> IW_F2X6L10_B_LSB) & IW_F2X6L10_B_UNSHIFTED_MASK)
#define SET_IW_F2X6L10_B(V) (((V) & IW_F2X6L10_B_UNSHIFTED_MASK) << IW_F2X6L10_B_LSB)

#define IW_F2X6L10_LSB_LSB 16
#define IW_F2X6L10_LSB_SIZE 5
#define IW_F2X6L10_LSB_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2X6L10_LSB_SIZE))
#define IW_F2X6L10_LSB_SHIFTED_MASK (IW_F2X6L10_LSB_UNSHIFTED_MASK << IW_F2X6L10_LSB_LSB)
#define GET_IW_F2X6L10_LSB(W) (((W) >> IW_F2X6L10_LSB_LSB) & IW_F2X6L10_LSB_UNSHIFTED_MASK)
#define SET_IW_F2X6L10_LSB(V) (((V) & IW_F2X6L10_LSB_UNSHIFTED_MASK) << IW_F2X6L10_LSB_LSB)

#define IW_F2X6L10_MSB_LSB 21
#define IW_F2X6L10_MSB_SIZE 5
#define IW_F2X6L10_MSB_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2X6L10_MSB_SIZE))
#define IW_F2X6L10_MSB_SHIFTED_MASK (IW_F2X6L10_MSB_UNSHIFTED_MASK << IW_F2X6L10_MSB_LSB)
#define GET_IW_F2X6L10_MSB(W) (((W) >> IW_F2X6L10_MSB_LSB) & IW_F2X6L10_MSB_UNSHIFTED_MASK)
#define SET_IW_F2X6L10_MSB(V) (((V) & IW_F2X6L10_MSB_UNSHIFTED_MASK) << IW_F2X6L10_MSB_LSB)

#define IW_F3X8_A_LSB 6
#define IW_F3X8_A_SIZE 5
#define IW_F3X8_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X8_A_SIZE))
#define IW_F3X8_A_SHIFTED_MASK (IW_F3X8_A_UNSHIFTED_MASK << IW_F3X8_A_LSB)
#define GET_IW_F3X8_A(W) (((W) >> IW_F3X8_A_LSB) & IW_F3X8_A_UNSHIFTED_MASK)
#define SET_IW_F3X8_A(V) (((V) & IW_F3X8_A_UNSHIFTED_MASK) << IW_F3X8_A_LSB)

#define IW_F3X8_B_LSB 11
#define IW_F3X8_B_SIZE 5
#define IW_F3X8_B_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X8_B_SIZE))
#define IW_F3X8_B_SHIFTED_MASK (IW_F3X8_B_UNSHIFTED_MASK << IW_F3X8_B_LSB)
#define GET_IW_F3X8_B(W) (((W) >> IW_F3X8_B_LSB) & IW_F3X8_B_UNSHIFTED_MASK)
#define SET_IW_F3X8_B(V) (((V) & IW_F3X8_B_UNSHIFTED_MASK) << IW_F3X8_B_LSB)

#define IW_F3X8_C_LSB 16
#define IW_F3X8_C_SIZE 5
#define IW_F3X8_C_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X8_C_SIZE))
#define IW_F3X8_C_SHIFTED_MASK (IW_F3X8_C_UNSHIFTED_MASK << IW_F3X8_C_LSB)
#define GET_IW_F3X8_C(W) (((W) >> IW_F3X8_C_LSB) & IW_F3X8_C_UNSHIFTED_MASK)
#define SET_IW_F3X8_C(V) (((V) & IW_F3X8_C_UNSHIFTED_MASK) << IW_F3X8_C_LSB)

#define IW_F3X8_READA_LSB 21
#define IW_F3X8_READA_SIZE 1
#define IW_F3X8_READA_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X8_READA_SIZE))
#define IW_F3X8_READA_SHIFTED_MASK (IW_F3X8_READA_UNSHIFTED_MASK << IW_F3X8_READA_LSB)
#define GET_IW_F3X8_READA(W) (((W) >> IW_F3X8_READA_LSB) & IW_F3X8_READA_UNSHIFTED_MASK)
#define SET_IW_F3X8_READA(V) (((V) & IW_F3X8_READA_UNSHIFTED_MASK) << IW_F3X8_READA_LSB)

#define IW_F3X8_READB_LSB 22
#define IW_F3X8_READB_SIZE 1
#define IW_F3X8_READB_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X8_READB_SIZE))
#define IW_F3X8_READB_SHIFTED_MASK (IW_F3X8_READB_UNSHIFTED_MASK << IW_F3X8_READB_LSB)
#define GET_IW_F3X8_READB(W) (((W) >> IW_F3X8_READB_LSB) & IW_F3X8_READB_UNSHIFTED_MASK)
#define SET_IW_F3X8_READB(V) (((V) & IW_F3X8_READB_UNSHIFTED_MASK) << IW_F3X8_READB_LSB)

#define IW_F3X8_READC_LSB 23
#define IW_F3X8_READC_SIZE 1
#define IW_F3X8_READC_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X8_READC_SIZE))
#define IW_F3X8_READC_SHIFTED_MASK (IW_F3X8_READC_UNSHIFTED_MASK << IW_F3X8_READC_LSB)
#define GET_IW_F3X8_READC(W) (((W) >> IW_F3X8_READC_LSB) & IW_F3X8_READC_UNSHIFTED_MASK)
#define SET_IW_F3X8_READC(V) (((V) & IW_F3X8_READC_UNSHIFTED_MASK) << IW_F3X8_READC_LSB)

#define IW_F3X8_N_LSB 24
#define IW_F3X8_N_SIZE 8
#define IW_F3X8_N_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F3X8_N_SIZE))
#define IW_F3X8_N_SHIFTED_MASK (IW_F3X8_N_UNSHIFTED_MASK << IW_F3X8_N_LSB)
#define GET_IW_F3X8_N(W) (((W) >> IW_F3X8_N_LSB) & IW_F3X8_N_UNSHIFTED_MASK)
#define SET_IW_F3X8_N(V) (((V) & IW_F3X8_N_UNSHIFTED_MASK) << IW_F3X8_N_LSB)

/* 16-bit R2 fields.  */

#define IW_I10_IMM10_LSB 6
#define IW_I10_IMM10_SIZE 10
#define IW_I10_IMM10_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_I10_IMM10_SIZE))
#define IW_I10_IMM10_SHIFTED_MASK (IW_I10_IMM10_UNSHIFTED_MASK << IW_I10_IMM10_LSB)
#define GET_IW_I10_IMM10(W) (((W) >> IW_I10_IMM10_LSB) & IW_I10_IMM10_UNSHIFTED_MASK)
#define SET_IW_I10_IMM10(V) (((V) & IW_I10_IMM10_UNSHIFTED_MASK) << IW_I10_IMM10_LSB)

#define IW_T1I7_A3_LSB 6
#define IW_T1I7_A3_SIZE 3
#define IW_T1I7_A3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T1I7_A3_SIZE))
#define IW_T1I7_A3_SHIFTED_MASK (IW_T1I7_A3_UNSHIFTED_MASK << IW_T1I7_A3_LSB)
#define GET_IW_T1I7_A3(W) (((W) >> IW_T1I7_A3_LSB) & IW_T1I7_A3_UNSHIFTED_MASK)
#define SET_IW_T1I7_A3(V) (((V) & IW_T1I7_A3_UNSHIFTED_MASK) << IW_T1I7_A3_LSB)

#define IW_T1I7_IMM7_LSB 9
#define IW_T1I7_IMM7_SIZE 7
#define IW_T1I7_IMM7_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T1I7_IMM7_SIZE))
#define IW_T1I7_IMM7_SHIFTED_MASK (IW_T1I7_IMM7_UNSHIFTED_MASK << IW_T1I7_IMM7_LSB)
#define GET_IW_T1I7_IMM7(W) (((W) >> IW_T1I7_IMM7_LSB) & IW_T1I7_IMM7_UNSHIFTED_MASK)
#define SET_IW_T1I7_IMM7(V) (((V) & IW_T1I7_IMM7_UNSHIFTED_MASK) << IW_T1I7_IMM7_LSB)

#define IW_T2I4_A3_LSB 6
#define IW_T2I4_A3_SIZE 3
#define IW_T2I4_A3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2I4_A3_SIZE))
#define IW_T2I4_A3_SHIFTED_MASK (IW_T2I4_A3_UNSHIFTED_MASK << IW_T2I4_A3_LSB)
#define GET_IW_T2I4_A3(W) (((W) >> IW_T2I4_A3_LSB) & IW_T2I4_A3_UNSHIFTED_MASK)
#define SET_IW_T2I4_A3(V) (((V) & IW_T2I4_A3_UNSHIFTED_MASK) << IW_T2I4_A3_LSB)

#define IW_T2I4_B3_LSB 9
#define IW_T2I4_B3_SIZE 3
#define IW_T2I4_B3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2I4_B3_SIZE))
#define IW_T2I4_B3_SHIFTED_MASK (IW_T2I4_B3_UNSHIFTED_MASK << IW_T2I4_B3_LSB)
#define GET_IW_T2I4_B3(W) (((W) >> IW_T2I4_B3_LSB) & IW_T2I4_B3_UNSHIFTED_MASK)
#define SET_IW_T2I4_B3(V) (((V) & IW_T2I4_B3_UNSHIFTED_MASK) << IW_T2I4_B3_LSB)

#define IW_T2I4_IMM4_LSB 12
#define IW_T2I4_IMM4_SIZE 4
#define IW_T2I4_IMM4_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2I4_IMM4_SIZE))
#define IW_T2I4_IMM4_SHIFTED_MASK (IW_T2I4_IMM4_UNSHIFTED_MASK << IW_T2I4_IMM4_LSB)
#define GET_IW_T2I4_IMM4(W) (((W) >> IW_T2I4_IMM4_LSB) & IW_T2I4_IMM4_UNSHIFTED_MASK)
#define SET_IW_T2I4_IMM4(V) (((V) & IW_T2I4_IMM4_UNSHIFTED_MASK) << IW_T2I4_IMM4_LSB)

#define IW_T1X1I6_A3_LSB 6
#define IW_T1X1I6_A3_SIZE 3
#define IW_T1X1I6_A3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T1X1I6_A3_SIZE))
#define IW_T1X1I6_A3_SHIFTED_MASK (IW_T1X1I6_A3_UNSHIFTED_MASK << IW_T1X1I6_A3_LSB)
#define GET_IW_T1X1I6_A3(W) (((W) >> IW_T1X1I6_A3_LSB) & IW_T1X1I6_A3_UNSHIFTED_MASK)
#define SET_IW_T1X1I6_A3(V) (((V) & IW_T1X1I6_A3_UNSHIFTED_MASK) << IW_T1X1I6_A3_LSB)

#define IW_T1X1I6_IMM6_LSB 9
#define IW_T1X1I6_IMM6_SIZE 6
#define IW_T1X1I6_IMM6_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T1X1I6_IMM6_SIZE))
#define IW_T1X1I6_IMM6_SHIFTED_MASK (IW_T1X1I6_IMM6_UNSHIFTED_MASK << IW_T1X1I6_IMM6_LSB)
#define GET_IW_T1X1I6_IMM6(W) (((W) >> IW_T1X1I6_IMM6_LSB) & IW_T1X1I6_IMM6_UNSHIFTED_MASK)
#define SET_IW_T1X1I6_IMM6(V) (((V) & IW_T1X1I6_IMM6_UNSHIFTED_MASK) << IW_T1X1I6_IMM6_LSB)

#define IW_T1X1I6_X_LSB 15
#define IW_T1X1I6_X_SIZE 1
#define IW_T1X1I6_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T1X1I6_X_SIZE))
#define IW_T1X1I6_X_SHIFTED_MASK (IW_T1X1I6_X_UNSHIFTED_MASK << IW_T1X1I6_X_LSB)
#define GET_IW_T1X1I6_X(W) (((W) >> IW_T1X1I6_X_LSB) & IW_T1X1I6_X_UNSHIFTED_MASK)
#define SET_IW_T1X1I6_X(V) (((V) & IW_T1X1I6_X_UNSHIFTED_MASK) << IW_T1X1I6_X_LSB)

#define IW_X1I7_IMM7_LSB 6
#define IW_X1I7_IMM7_SIZE 7
#define IW_X1I7_IMM7_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_X1I7_IMM7_SIZE))
#define IW_X1I7_IMM7_SHIFTED_MASK (IW_X1I7_IMM7_UNSHIFTED_MASK << IW_X1I7_IMM7_LSB)
#define GET_IW_X1I7_IMM7(W) (((W) >> IW_X1I7_IMM7_LSB) & IW_X1I7_IMM7_UNSHIFTED_MASK)
#define SET_IW_X1I7_IMM7(V) (((V) & IW_X1I7_IMM7_UNSHIFTED_MASK) << IW_X1I7_IMM7_LSB)

#define IW_X1I7_RSV_LSB 13
#define IW_X1I7_RSV_SIZE 2
#define IW_X1I7_RSV_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_X1I7_RSV_SIZE))
#define IW_X1I7_RSV_SHIFTED_MASK (IW_X1I7_RSV_UNSHIFTED_MASK << IW_X1I7_RSV_LSB)
#define GET_IW_X1I7_RSV(W) (((W) >> IW_X1I7_RSV_LSB) & IW_X1I7_RSV_UNSHIFTED_MASK)
#define SET_IW_X1I7_RSV(V) (((V) & IW_X1I7_RSV_UNSHIFTED_MASK) << IW_X1I7_RSV_LSB)

#define IW_X1I7_X_LSB 15
#define IW_X1I7_X_SIZE 1
#define IW_X1I7_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_X1I7_X_SIZE))
#define IW_X1I7_X_SHIFTED_MASK (IW_X1I7_X_UNSHIFTED_MASK << IW_X1I7_X_LSB)
#define GET_IW_X1I7_X(W) (((W) >> IW_X1I7_X_LSB) & IW_X1I7_X_UNSHIFTED_MASK)
#define SET_IW_X1I7_X(V) (((V) & IW_X1I7_X_UNSHIFTED_MASK) << IW_X1I7_X_LSB)

#define IW_L5I4X1_IMM4_LSB 6
#define IW_L5I4X1_IMM4_SIZE 4
#define IW_L5I4X1_IMM4_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_L5I4X1_IMM4_SIZE))
#define IW_L5I4X1_IMM4_SHIFTED_MASK (IW_L5I4X1_IMM4_UNSHIFTED_MASK << IW_L5I4X1_IMM4_LSB)
#define GET_IW_L5I4X1_IMM4(W) (((W) >> IW_L5I4X1_IMM4_LSB) & IW_L5I4X1_IMM4_UNSHIFTED_MASK)
#define SET_IW_L5I4X1_IMM4(V) (((V) & IW_L5I4X1_IMM4_UNSHIFTED_MASK) << IW_L5I4X1_IMM4_LSB)

#define IW_L5I4X1_REGRANGE_LSB 10
#define IW_L5I4X1_REGRANGE_SIZE 3
#define IW_L5I4X1_REGRANGE_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_L5I4X1_REGRANGE_SIZE))
#define IW_L5I4X1_REGRANGE_SHIFTED_MASK (IW_L5I4X1_REGRANGE_UNSHIFTED_MASK << IW_L5I4X1_REGRANGE_LSB)
#define GET_IW_L5I4X1_REGRANGE(W) (((W) >> IW_L5I4X1_REGRANGE_LSB) & IW_L5I4X1_REGRANGE_UNSHIFTED_MASK)
#define SET_IW_L5I4X1_REGRANGE(V) (((V) & IW_L5I4X1_REGRANGE_UNSHIFTED_MASK) << IW_L5I4X1_REGRANGE_LSB)

#define IW_L5I4X1_FP_LSB 13
#define IW_L5I4X1_FP_SIZE 1
#define IW_L5I4X1_FP_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_L5I4X1_FP_SIZE))
#define IW_L5I4X1_FP_SHIFTED_MASK (IW_L5I4X1_FP_UNSHIFTED_MASK << IW_L5I4X1_FP_LSB)
#define GET_IW_L5I4X1_FP(W) (((W) >> IW_L5I4X1_FP_LSB) & IW_L5I4X1_FP_UNSHIFTED_MASK)
#define SET_IW_L5I4X1_FP(V) (((V) & IW_L5I4X1_FP_UNSHIFTED_MASK) << IW_L5I4X1_FP_LSB)

#define IW_L5I4X1_CS_LSB 14
#define IW_L5I4X1_CS_SIZE 1
#define IW_L5I4X1_CS_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_L5I4X1_CS_SIZE))
#define IW_L5I4X1_CS_SHIFTED_MASK (IW_L5I4X1_CS_UNSHIFTED_MASK << IW_L5I4X1_CS_LSB)
#define GET_IW_L5I4X1_CS(W) (((W) >> IW_L5I4X1_CS_LSB) & IW_L5I4X1_CS_UNSHIFTED_MASK)
#define SET_IW_L5I4X1_CS(V) (((V) & IW_L5I4X1_CS_UNSHIFTED_MASK) << IW_L5I4X1_CS_LSB)

#define IW_L5I4X1_X_LSB 15
#define IW_L5I4X1_X_SIZE 1
#define IW_L5I4X1_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_L5I4X1_X_SIZE))
#define IW_L5I4X1_X_SHIFTED_MASK (IW_L5I4X1_X_UNSHIFTED_MASK << IW_L5I4X1_X_LSB)
#define GET_IW_L5I4X1_X(W) (((W) >> IW_L5I4X1_X_LSB) & IW_L5I4X1_X_UNSHIFTED_MASK)
#define SET_IW_L5I4X1_X(V) (((V) & IW_L5I4X1_X_UNSHIFTED_MASK) << IW_L5I4X1_X_LSB)

#define IW_T2X1L3_A3_LSB 6
#define IW_T2X1L3_A3_SIZE 3
#define IW_T2X1L3_A3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1L3_A3_SIZE))
#define IW_T2X1L3_A3_SHIFTED_MASK (IW_T2X1L3_A3_UNSHIFTED_MASK << IW_T2X1L3_A3_LSB)
#define GET_IW_T2X1L3_A3(W) (((W) >> IW_T2X1L3_A3_LSB) & IW_T2X1L3_A3_UNSHIFTED_MASK)
#define SET_IW_T2X1L3_A3(V) (((V) & IW_T2X1L3_A3_UNSHIFTED_MASK) << IW_T2X1L3_A3_LSB)

#define IW_T2X1L3_B3_LSB 9
#define IW_T2X1L3_B3_SIZE 3
#define IW_T2X1L3_B3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1L3_B3_SIZE))
#define IW_T2X1L3_B3_SHIFTED_MASK (IW_T2X1L3_B3_UNSHIFTED_MASK << IW_T2X1L3_B3_LSB)
#define GET_IW_T2X1L3_B3(W) (((W) >> IW_T2X1L3_B3_LSB) & IW_T2X1L3_B3_UNSHIFTED_MASK)
#define SET_IW_T2X1L3_B3(V) (((V) & IW_T2X1L3_B3_UNSHIFTED_MASK) << IW_T2X1L3_B3_LSB)

#define IW_T2X1L3_SHAMT_LSB 12
#define IW_T2X1L3_SHAMT_SIZE 3
#define IW_T2X1L3_SHAMT_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1L3_SHAMT_SIZE))
#define IW_T2X1L3_SHAMT_SHIFTED_MASK (IW_T2X1L3_SHAMT_UNSHIFTED_MASK << IW_T2X1L3_SHAMT_LSB)
#define GET_IW_T2X1L3_SHAMT(W) (((W) >> IW_T2X1L3_SHAMT_LSB) & IW_T2X1L3_SHAMT_UNSHIFTED_MASK)
#define SET_IW_T2X1L3_SHAMT(V) (((V) & IW_T2X1L3_SHAMT_UNSHIFTED_MASK) << IW_T2X1L3_SHAMT_LSB)

#define IW_T2X1L3_X_LSB 15
#define IW_T2X1L3_X_SIZE 1
#define IW_T2X1L3_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1L3_X_SIZE))
#define IW_T2X1L3_X_SHIFTED_MASK (IW_T2X1L3_X_UNSHIFTED_MASK << IW_T2X1L3_X_LSB)
#define GET_IW_T2X1L3_X(W) (((W) >> IW_T2X1L3_X_LSB) & IW_T2X1L3_X_UNSHIFTED_MASK)
#define SET_IW_T2X1L3_X(V) (((V) & IW_T2X1L3_X_UNSHIFTED_MASK) << IW_T2X1L3_X_LSB)

#define IW_T2X1I3_A3_LSB 6
#define IW_T2X1I3_A3_SIZE 3
#define IW_T2X1I3_A3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1I3_A3_SIZE))
#define IW_T2X1I3_A3_SHIFTED_MASK (IW_T2X1I3_A3_UNSHIFTED_MASK << IW_T2X1I3_A3_LSB)
#define GET_IW_T2X1I3_A3(W) (((W) >> IW_T2X1I3_A3_LSB) & IW_T2X1I3_A3_UNSHIFTED_MASK)
#define SET_IW_T2X1I3_A3(V) (((V) & IW_T2X1I3_A3_UNSHIFTED_MASK) << IW_T2X1I3_A3_LSB)

#define IW_T2X1I3_B3_LSB 9
#define IW_T2X1I3_B3_SIZE 3
#define IW_T2X1I3_B3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1I3_B3_SIZE))
#define IW_T2X1I3_B3_SHIFTED_MASK (IW_T2X1I3_B3_UNSHIFTED_MASK << IW_T2X1I3_B3_LSB)
#define GET_IW_T2X1I3_B3(W) (((W) >> IW_T2X1I3_B3_LSB) & IW_T2X1I3_B3_UNSHIFTED_MASK)
#define SET_IW_T2X1I3_B3(V) (((V) & IW_T2X1I3_B3_UNSHIFTED_MASK) << IW_T2X1I3_B3_LSB)

#define IW_T2X1I3_IMM3_LSB 12
#define IW_T2X1I3_IMM3_SIZE 3
#define IW_T2X1I3_IMM3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1I3_IMM3_SIZE))
#define IW_T2X1I3_IMM3_SHIFTED_MASK (IW_T2X1I3_IMM3_UNSHIFTED_MASK << IW_T2X1I3_IMM3_LSB)
#define GET_IW_T2X1I3_IMM3(W) (((W) >> IW_T2X1I3_IMM3_LSB) & IW_T2X1I3_IMM3_UNSHIFTED_MASK)
#define SET_IW_T2X1I3_IMM3(V) (((V) & IW_T2X1I3_IMM3_UNSHIFTED_MASK) << IW_T2X1I3_IMM3_LSB)

#define IW_T2X1I3_X_LSB 15
#define IW_T2X1I3_X_SIZE 1
#define IW_T2X1I3_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X1I3_X_SIZE))
#define IW_T2X1I3_X_SHIFTED_MASK (IW_T2X1I3_X_UNSHIFTED_MASK << IW_T2X1I3_X_LSB)
#define GET_IW_T2X1I3_X(W) (((W) >> IW_T2X1I3_X_LSB) & IW_T2X1I3_X_UNSHIFTED_MASK)
#define SET_IW_T2X1I3_X(V) (((V) & IW_T2X1I3_X_UNSHIFTED_MASK) << IW_T2X1I3_X_LSB)

#define IW_T3X1_A3_LSB 6
#define IW_T3X1_A3_SIZE 3
#define IW_T3X1_A3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T3X1_A3_SIZE))
#define IW_T3X1_A3_SHIFTED_MASK (IW_T3X1_A3_UNSHIFTED_MASK << IW_T3X1_A3_LSB)
#define GET_IW_T3X1_A3(W) (((W) >> IW_T3X1_A3_LSB) & IW_T3X1_A3_UNSHIFTED_MASK)
#define SET_IW_T3X1_A3(V) (((V) & IW_T3X1_A3_UNSHIFTED_MASK) << IW_T3X1_A3_LSB)

#define IW_T3X1_B3_LSB 9
#define IW_T3X1_B3_SIZE 3
#define IW_T3X1_B3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T3X1_B3_SIZE))
#define IW_T3X1_B3_SHIFTED_MASK (IW_T3X1_B3_UNSHIFTED_MASK << IW_T3X1_B3_LSB)
#define GET_IW_T3X1_B3(W) (((W) >> IW_T3X1_B3_LSB) & IW_T3X1_B3_UNSHIFTED_MASK)
#define SET_IW_T3X1_B3(V) (((V) & IW_T3X1_B3_UNSHIFTED_MASK) << IW_T3X1_B3_LSB)

#define IW_T3X1_C3_LSB 12
#define IW_T3X1_C3_SIZE 3
#define IW_T3X1_C3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T3X1_C3_SIZE))
#define IW_T3X1_C3_SHIFTED_MASK (IW_T3X1_C3_UNSHIFTED_MASK << IW_T3X1_C3_LSB)
#define GET_IW_T3X1_C3(W) (((W) >> IW_T3X1_C3_LSB) & IW_T3X1_C3_UNSHIFTED_MASK)
#define SET_IW_T3X1_C3(V) (((V) & IW_T3X1_C3_UNSHIFTED_MASK) << IW_T3X1_C3_LSB)

#define IW_T3X1_X_LSB 15
#define IW_T3X1_X_SIZE 1
#define IW_T3X1_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T3X1_X_SIZE))
#define IW_T3X1_X_SHIFTED_MASK (IW_T3X1_X_UNSHIFTED_MASK << IW_T3X1_X_LSB)
#define GET_IW_T3X1_X(W) (((W) >> IW_T3X1_X_LSB) & IW_T3X1_X_UNSHIFTED_MASK)
#define SET_IW_T3X1_X(V) (((V) & IW_T3X1_X_UNSHIFTED_MASK) << IW_T3X1_X_LSB)

/* The X field for all three R.N-class instruction formats is represented
   here as 4 bits, including the bits defined as constant 0 or 1 that
   determine which of the formats T2X3, F1X1, or X2L5 it is.  */
#define IW_R_N_X_LSB 12
#define IW_R_N_X_SIZE 4
#define IW_R_N_X_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_R_N_X_SIZE))
#define IW_R_N_X_SHIFTED_MASK (IW_R_N_X_UNSHIFTED_MASK << IW_R_N_X_LSB)
#define GET_IW_R_N_X(W) (((W) >> IW_R_N_X_LSB) & IW_R_N_X_UNSHIFTED_MASK)
#define SET_IW_R_N_X(V) (((V) & IW_R_N_X_UNSHIFTED_MASK) << IW_R_N_X_LSB)

#define IW_T2X3_A3_LSB 6
#define IW_T2X3_A3_SIZE 3
#define IW_T2X3_A3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X3_A3_SIZE))
#define IW_T2X3_A3_SHIFTED_MASK (IW_T2X3_A3_UNSHIFTED_MASK << IW_T2X3_A3_LSB)
#define GET_IW_T2X3_A3(W) (((W) >> IW_T2X3_A3_LSB) & IW_T2X3_A3_UNSHIFTED_MASK)
#define SET_IW_T2X3_A3(V) (((V) & IW_T2X3_A3_UNSHIFTED_MASK) << IW_T2X3_A3_LSB)

#define IW_T2X3_B3_LSB 9
#define IW_T2X3_B3_SIZE 3
#define IW_T2X3_B3_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_T2X3_B3_SIZE))
#define IW_T2X3_B3_SHIFTED_MASK (IW_T2X3_B3_UNSHIFTED_MASK << IW_T2X3_B3_LSB)
#define GET_IW_T2X3_B3(W) (((W) >> IW_T2X3_B3_LSB) & IW_T2X3_B3_UNSHIFTED_MASK)
#define SET_IW_T2X3_B3(V) (((V) & IW_T2X3_B3_UNSHIFTED_MASK) << IW_T2X3_B3_LSB)

#define IW_F1X1_A_LSB 6
#define IW_F1X1_A_SIZE 5
#define IW_F1X1_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X1_A_SIZE))
#define IW_F1X1_A_SHIFTED_MASK (IW_F1X1_A_UNSHIFTED_MASK << IW_F1X1_A_LSB)
#define GET_IW_F1X1_A(W) (((W) >> IW_F1X1_A_LSB) & IW_F1X1_A_UNSHIFTED_MASK)
#define SET_IW_F1X1_A(V) (((V) & IW_F1X1_A_UNSHIFTED_MASK) << IW_F1X1_A_LSB)

#define IW_F1X1_RSV_LSB 11
#define IW_F1X1_RSV_SIZE 1
#define IW_F1X1_RSV_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1X1_RSV_SIZE))
#define IW_F1X1_RSV_SHIFTED_MASK (IW_F1X1_RSV_UNSHIFTED_MASK << IW_F1X1_RSV_LSB)
#define GET_IW_F1X1_RSV(W) (((W) >> IW_F1X1_RSV_LSB) & IW_F1X1_RSV_UNSHIFTED_MASK)
#define SET_IW_F1X1_RSV(V) (((V) & IW_F1X1_RSV_UNSHIFTED_MASK) << IW_F1X1_RSV_LSB)

#define IW_X2L5_IMM5_LSB 6
#define IW_X2L5_IMM5_SIZE 5
#define IW_X2L5_IMM5_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_X2L5_IMM5_SIZE))
#define IW_X2L5_IMM5_SHIFTED_MASK (IW_X2L5_IMM5_UNSHIFTED_MASK << IW_X2L5_IMM5_LSB)
#define GET_IW_X2L5_IMM5(W) (((W) >> IW_X2L5_IMM5_LSB) & IW_X2L5_IMM5_UNSHIFTED_MASK)
#define SET_IW_X2L5_IMM5(V) (((V) & IW_X2L5_IMM5_UNSHIFTED_MASK) << IW_X2L5_IMM5_LSB)

#define IW_X2L5_RSV_LSB 11
#define IW_X2L5_RSV_SIZE 1
#define IW_X2L5_RSV_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_X2L5_RSV_SIZE))
#define IW_X2L5_RSV_SHIFTED_MASK (IW_X2L5_RSV_UNSHIFTED_MASK << IW_X2L5_RSV_LSB)
#define GET_IW_X2L5_RSV(W) (((W) >> IW_X2L5_RSV_LSB) & IW_X2L5_RSV_UNSHIFTED_MASK)
#define SET_IW_X2L5_RSV(V) (((V) & IW_X2L5_RSV_UNSHIFTED_MASK) << IW_X2L5_RSV_LSB)

#define IW_F1I5_IMM5_LSB 6
#define IW_F1I5_IMM5_SIZE 5
#define IW_F1I5_IMM5_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1I5_IMM5_SIZE))
#define IW_F1I5_IMM5_SHIFTED_MASK (IW_F1I5_IMM5_UNSHIFTED_MASK << IW_F1I5_IMM5_LSB)
#define GET_IW_F1I5_IMM5(W) (((W) >> IW_F1I5_IMM5_LSB) & IW_F1I5_IMM5_UNSHIFTED_MASK)
#define SET_IW_F1I5_IMM5(V) (((V) & IW_F1I5_IMM5_UNSHIFTED_MASK) << IW_F1I5_IMM5_LSB)

#define IW_F1I5_B_LSB 11
#define IW_F1I5_B_SIZE 5
#define IW_F1I5_B_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F1I5_B_SIZE))
#define IW_F1I5_B_SHIFTED_MASK (IW_F1I5_B_UNSHIFTED_MASK << IW_F1I5_B_LSB)
#define GET_IW_F1I5_B(W) (((W) >> IW_F1I5_B_LSB) & IW_F1I5_B_UNSHIFTED_MASK)
#define SET_IW_F1I5_B(V) (((V) & IW_F1I5_B_UNSHIFTED_MASK) << IW_F1I5_B_LSB)

#define IW_F2_A_LSB 6
#define IW_F2_A_SIZE 5
#define IW_F2_A_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2_A_SIZE))
#define IW_F2_A_SHIFTED_MASK (IW_F2_A_UNSHIFTED_MASK << IW_F2_A_LSB)
#define GET_IW_F2_A(W) (((W) >> IW_F2_A_LSB) & IW_F2_A_UNSHIFTED_MASK)
#define SET_IW_F2_A(V) (((V) & IW_F2_A_UNSHIFTED_MASK) << IW_F2_A_LSB)

#define IW_F2_B_LSB 11
#define IW_F2_B_SIZE 5
#define IW_F2_B_UNSHIFTED_MASK (0xffffffffu >> (32 - IW_F2_B_SIZE))
#define IW_F2_B_SHIFTED_MASK (IW_F2_B_UNSHIFTED_MASK << IW_F2_B_LSB)
#define GET_IW_F2_B(W) (((W) >> IW_F2_B_LSB) & IW_F2_B_UNSHIFTED_MASK)
#define SET_IW_F2_B(V) (((V) & IW_F2_B_UNSHIFTED_MASK) << IW_F2_B_LSB)

/* R2 opcodes.  */
#define R2_OP_CALL 0
#define R2_OP_AS_N 1
#define R2_OP_BR 2
#define R2_OP_BR_N 3
#define R2_OP_ADDI 4
#define R2_OP_LDBU_N 5
#define R2_OP_LDBU 6
#define R2_OP_LDB 7
#define R2_OP_JMPI 8
#define R2_OP_R_N 9
#define R2_OP_ANDI_N 11
#define R2_OP_ANDI 12
#define R2_OP_LDHU_N 13
#define R2_OP_LDHU 14
#define R2_OP_LDH 15
#define R2_OP_ASI_N 17
#define R2_OP_BGE 18
#define R2_OP_LDWSP_N 19
#define R2_OP_ORI 20
#define R2_OP_LDW_N 21
#define R2_OP_CMPGEI 22
#define R2_OP_LDW 23
#define R2_OP_SHI_N 25
#define R2_OP_BLT 26
#define R2_OP_MOVI_N 27
#define R2_OP_XORI 28
#define R2_OP_STZ_N 29
#define R2_OP_CMPLTI 30
#define R2_OP_ANDCI 31
#define R2_OP_OPX 32
#define R2_OP_PP_N 33
#define R2_OP_BNE 34
#define R2_OP_BNEZ_N 35
#define R2_OP_MULI 36
#define R2_OP_STB_N 37
#define R2_OP_CMPNEI 38
#define R2_OP_STB 39
#define R2_OP_I12 40
#define R2_OP_SPI_N 41
#define R2_OP_BEQ 42
#define R2_OP_BEQZ_N 43
#define R2_OP_ANDHI 44
#define R2_OP_STH_N 45
#define R2_OP_CMPEQI 46
#define R2_OP_STH 47
#define R2_OP_CUSTOM 48
#define R2_OP_BGEU 50
#define R2_OP_STWSP_N 51
#define R2_OP_ORHI 52
#define R2_OP_STW_N 53
#define R2_OP_CMPGEUI 54
#define R2_OP_STW 55
#define R2_OP_BLTU 58
#define R2_OP_MOV_N 59
#define R2_OP_XORHI 60
#define R2_OP_SPADDI_N 61
#define R2_OP_CMPLTUI 62
#define R2_OP_ANDCHI 63

#define R2_OPX_WRPIE 0
#define R2_OPX_ERET 1
#define R2_OPX_ROLI 2
#define R2_OPX_ROL 3
#define R2_OPX_FLUSHP 4
#define R2_OPX_RET 5
#define R2_OPX_NOR 6
#define R2_OPX_MULXUU 7
#define R2_OPX_ENI 8
#define R2_OPX_BRET 9
#define R2_OPX_ROR 11
#define R2_OPX_FLUSHI 12
#define R2_OPX_JMP 13
#define R2_OPX_AND 14
#define R2_OPX_CMPGE 16
#define R2_OPX_SLLI 18
#define R2_OPX_SLL 19
#define R2_OPX_WRPRS 20
#define R2_OPX_OR 22
#define R2_OPX_MULXSU 23
#define R2_OPX_CMPLT 24
#define R2_OPX_SRLI 26
#define R2_OPX_SRL 27
#define R2_OPX_NEXTPC 28
#define R2_OPX_CALLR 29
#define R2_OPX_XOR 30
#define R2_OPX_MULXSS 31
#define R2_OPX_CMPNE 32
#define R2_OPX_INSERT 35
#define R2_OPX_DIVU 36
#define R2_OPX_DIV 37
#define R2_OPX_RDCTL 38
#define R2_OPX_MUL 39
#define R2_OPX_CMPEQ 40
#define R2_OPX_INITI 41
#define R2_OPX_MERGE 43
#define R2_OPX_HBREAK 44
#define R2_OPX_TRAP 45
#define R2_OPX_WRCTL 46
#define R2_OPX_CMPGEU 48
#define R2_OPX_ADD 49
#define R2_OPX_EXTRACT 51
#define R2_OPX_BREAK 52
#define R2_OPX_LDEX 53
#define R2_OPX_SYNC 54
#define R2_OPX_LDSEX 55
#define R2_OPX_CMPLTU 56
#define R2_OPX_SUB 57
#define R2_OPX_SRAI 58
#define R2_OPX_SRA 59
#define R2_OPX_STEX 61
#define R2_OPX_STSEX 63

#define R2_I12_LDBIO 0
#define R2_I12_STBIO 1
#define R2_I12_LDBUIO 2
#define R2_I12_DCACHE 3
#define R2_I12_LDHIO 4
#define R2_I12_STHIO 5
#define R2_I12_LDHUIO 6
#define R2_I12_RDPRS 7
#define R2_I12_LDWIO 8
#define R2_I12_STWIO 9
#define R2_I12_LDWM 12
#define R2_I12_STWM 13

#define R2_DCACHE_INITD 0
#define R2_DCACHE_INITDA 1
#define R2_DCACHE_FLUSHD 2
#define R2_DCACHE_FLUSHDA 3

#define R2_AS_N_ADD_N 0
#define R2_AS_N_SUB_N 1

#define R2_R_N_AND_N 0
#define R2_R_N_OR_N 2
#define R2_R_N_XOR_N 3
#define R2_R_N_SLL_N 4
#define R2_R_N_SRL_N 5
#define R2_R_N_NOT_N 6
#define R2_R_N_NEG_N 7
#define R2_R_N_CALLR_N 8
#define R2_R_N_JMPR_N 10
#define R2_R_N_BREAK_N 12
#define R2_R_N_TRAP_N 13
#define R2_R_N_RET_N 14

#define R2_SPI_N_SPINCI_N 0
#define R2_SPI_N_SPDECI_N 1

#define R2_ASI_N_ADDI_N 0
#define R2_ASI_N_SUBI_N 1

#define R2_SHI_N_SLLI_N 0
#define R2_SHI_N_SRLI_N 1

#define R2_PP_N_POP_N 0
#define R2_PP_N_PUSH_N 1

#define R2_STZ_N_STWZ_N 0
#define R2_STZ_N_STBZ_N 1

/* Convenience macros for R2 encodings. */

#define MATCH_R2_OP(NAME) \
  (SET_IW_R2_OP (R2_OP_##NAME))
#define MASK_R2_OP \
  IW_R2_OP_SHIFTED_MASK

#define MATCH_R2_OPX0(NAME) \
  (SET_IW_R2_OP (R2_OP_OPX) | SET_IW_OPX_X (R2_OPX_##NAME))
#define MASK_R2_OPX0 \
  (IW_R2_OP_SHIFTED_MASK | IW_OPX_X_SHIFTED_MASK \
   | IW_F3X6L5_IMM5_SHIFTED_MASK)

#define MATCH_R2_OPX(NAME, A, B, C)				\
  (MATCH_R2_OPX0 (NAME) | SET_IW_F3X6L5_A (A) | SET_IW_F3X6L5_B (B) \
   | SET_IW_F3X6L5_C (C))
#define MASK_R2_OPX(A, B, C, N)				\
  (IW_R2_OP_SHIFTED_MASK | IW_OPX_X_SHIFTED_MASK	\
   | (A ? IW_F3X6L5_A_SHIFTED_MASK : 0)			\
   | (B ? IW_F3X6L5_B_SHIFTED_MASK : 0)			\
   | (C ? IW_F3X6L5_C_SHIFTED_MASK : 0)			\
   | (N ? IW_F3X6L5_IMM5_SHIFTED_MASK : 0))

#define MATCH_R2_I12(NAME) \
  (SET_IW_R2_OP (R2_OP_I12) | SET_IW_I12_X (R2_I12_##NAME))
#define MASK_R2_I12 \
  (IW_R2_OP_SHIFTED_MASK | IW_I12_X_SHIFTED_MASK )

#define MATCH_R2_DCACHE(NAME) \
  (MATCH_R2_I12(DCACHE) | SET_IW_F1X4I12_X (R2_DCACHE_##NAME))
#define MASK_R2_DCACHE \
  (MASK_R2_I12 | IW_F1X4I12_X_SHIFTED_MASK)

#define MATCH_R2_R_N(NAME) \
  (SET_IW_R2_OP (R2_OP_R_N) | SET_IW_R_N_X (R2_R_N_##NAME))
#define MASK_R2_R_N \
  (IW_R2_OP_SHIFTED_MASK | IW_R_N_X_SHIFTED_MASK )

/* Match/mask macros for R2 instructions.  */

#define MATCH_R2_ADD	MATCH_R2_OPX0 (ADD)
#define MASK_R2_ADD	MASK_R2_OPX0
#define MATCH_R2_ADDI	MATCH_R2_OP (ADDI)
#define MASK_R2_ADDI	MASK_R2_OP
#define MATCH_R2_ADD_N	(MATCH_R2_OP (AS_N) | SET_IW_T3X1_X (R2_AS_N_ADD_N))
#define MASK_R2_ADD_N	(MASK_R2_OP | IW_T3X1_X_SHIFTED_MASK)
#define MATCH_R2_ADDI_N	(MATCH_R2_OP (ASI_N) | SET_IW_T2X1I3_X (R2_ASI_N_ADDI_N))
#define MASK_R2_ADDI_N	(MASK_R2_OP | IW_T2X1I3_X_SHIFTED_MASK)
#define MATCH_R2_AND	MATCH_R2_OPX0 (AND)
#define MASK_R2_AND	MASK_R2_OPX0
#define MATCH_R2_ANDCHI	MATCH_R2_OP (ANDCHI)
#define MASK_R2_ANDCHI	MASK_R2_OP
#define MATCH_R2_ANDCI	MATCH_R2_OP (ANDCI)
#define MASK_R2_ANDCI	MASK_R2_OP
#define MATCH_R2_ANDHI	MATCH_R2_OP (ANDHI)
#define MASK_R2_ANDHI	MASK_R2_OP
#define MATCH_R2_ANDI	MATCH_R2_OP (ANDI)
#define MASK_R2_ANDI	MASK_R2_OP
#define MATCH_R2_ANDI_N	MATCH_R2_OP (ANDI_N)
#define MASK_R2_ANDI_N	MASK_R2_OP
#define MATCH_R2_AND_N	MATCH_R2_R_N (AND_N)
#define MASK_R2_AND_N	MASK_R2_R_N
#define MATCH_R2_BEQ	MATCH_R2_OP (BEQ)
#define MASK_R2_BEQ	MASK_R2_OP
#define MATCH_R2_BEQZ_N	MATCH_R2_OP (BEQZ_N)
#define MASK_R2_BEQZ_N	MASK_R2_OP
#define MATCH_R2_BGE	MATCH_R2_OP (BGE)
#define MASK_R2_BGE	MASK_R2_OP
#define MATCH_R2_BGEU	MATCH_R2_OP (BGEU)
#define MASK_R2_BGEU	MASK_R2_OP
#define MATCH_R2_BGT	MATCH_R2_OP (BLT)
#define MASK_R2_BGT	MASK_R2_OP
#define MATCH_R2_BGTU	MATCH_R2_OP (BLTU)
#define MASK_R2_BGTU	MASK_R2_OP
#define MATCH_R2_BLE	MATCH_R2_OP (BGE)
#define MASK_R2_BLE	MASK_R2_OP
#define MATCH_R2_BLEU	MATCH_R2_OP (BGEU)
#define MASK_R2_BLEU	MASK_R2_OP
#define MATCH_R2_BLT	MATCH_R2_OP (BLT)
#define MASK_R2_BLT	MASK_R2_OP
#define MATCH_R2_BLTU	MATCH_R2_OP (BLTU)
#define MASK_R2_BLTU	MASK_R2_OP
#define MATCH_R2_BNE	MATCH_R2_OP (BNE)
#define MASK_R2_BNE	MASK_R2_OP
#define MATCH_R2_BNEZ_N	MATCH_R2_OP (BNEZ_N)
#define MASK_R2_BNEZ_N	MASK_R2_OP
#define MATCH_R2_BR	MATCH_R2_OP (BR)
#define MASK_R2_BR	MASK_R2_OP | IW_F2I16_A_SHIFTED_MASK | IW_F2I16_B_SHIFTED_MASK
#define MATCH_R2_BREAK	MATCH_R2_OPX (BREAK, 0, 0, 0x1e)
#define MASK_R2_BREAK	MASK_R2_OPX (1, 1, 1, 0)
#define MATCH_R2_BREAK_N	MATCH_R2_R_N (BREAK_N)
#define MASK_R2_BREAK_N	MASK_R2_R_N
#define MATCH_R2_BRET	MATCH_R2_OPX (BRET, 0x1e, 0, 0)
#define MASK_R2_BRET	MASK_R2_OPX (1, 1, 1, 1)
#define MATCH_R2_BR_N	MATCH_R2_OP (BR_N)
#define MASK_R2_BR_N	MASK_R2_OP
#define MATCH_R2_CALL	MATCH_R2_OP (CALL)
#define MASK_R2_CALL	MASK_R2_OP
#define MATCH_R2_CALLR	MATCH_R2_OPX (CALLR, 0, 0, 0x1f)
#define MASK_R2_CALLR	MASK_R2_OPX (0, 1, 1, 1)
#define MATCH_R2_CALLR_N	MATCH_R2_R_N (CALLR_N)
#define MASK_R2_CALLR_N	MASK_R2_R_N
#define MATCH_R2_CMPEQ	MATCH_R2_OPX0 (CMPEQ)
#define MASK_R2_CMPEQ	MASK_R2_OPX0
#define MATCH_R2_CMPEQI	MATCH_R2_OP (CMPEQI)
#define MASK_R2_CMPEQI	MASK_R2_OP
#define MATCH_R2_CMPGE	MATCH_R2_OPX0 (CMPGE)
#define MASK_R2_CMPGE	MASK_R2_OPX0
#define MATCH_R2_CMPGEI	MATCH_R2_OP (CMPGEI)
#define MASK_R2_CMPGEI	MASK_R2_OP
#define MATCH_R2_CMPGEU	MATCH_R2_OPX0 (CMPGEU)
#define MASK_R2_CMPGEU	MASK_R2_OPX0
#define MATCH_R2_CMPGEUI	MATCH_R2_OP (CMPGEUI)
#define MASK_R2_CMPGEUI	MASK_R2_OP
#define MATCH_R2_CMPGT	MATCH_R2_OPX0 (CMPLT)
#define MASK_R2_CMPGT	MASK_R2_OPX0
#define MATCH_R2_CMPGTI	MATCH_R2_OP (CMPGEI)
#define MASK_R2_CMPGTI	MASK_R2_OP
#define MATCH_R2_CMPGTU	MATCH_R2_OPX0 (CMPLTU)
#define MASK_R2_CMPGTU	MASK_R2_OPX0
#define MATCH_R2_CMPGTUI	MATCH_R2_OP (CMPGEUI)
#define MASK_R2_CMPGTUI	MASK_R2_OP
#define MATCH_R2_CMPLE	MATCH_R2_OPX0 (CMPGE)
#define MASK_R2_CMPLE	MASK_R2_OPX0
#define MATCH_R2_CMPLEI	MATCH_R2_OP (CMPLTI)
#define MASK_R2_CMPLEI	MASK_R2_OP
#define MATCH_R2_CMPLEU	MATCH_R2_OPX0 (CMPGEU)
#define MASK_R2_CMPLEU	MASK_R2_OPX0
#define MATCH_R2_CMPLEUI	MATCH_R2_OP (CMPLTUI)
#define MASK_R2_CMPLEUI	MASK_R2_OP
#define MATCH_R2_CMPLT	MATCH_R2_OPX0 (CMPLT)
#define MASK_R2_CMPLT	MASK_R2_OPX0
#define MATCH_R2_CMPLTI	MATCH_R2_OP (CMPLTI)
#define MASK_R2_CMPLTI	MASK_R2_OP
#define MATCH_R2_CMPLTU	MATCH_R2_OPX0 (CMPLTU)
#define MASK_R2_CMPLTU	MASK_R2_OPX0
#define MATCH_R2_CMPLTUI	MATCH_R2_OP (CMPLTUI)
#define MASK_R2_CMPLTUI	MASK_R2_OP
#define MATCH_R2_CMPNE	MATCH_R2_OPX0 (CMPNE)
#define MASK_R2_CMPNE	MASK_R2_OPX0
#define MATCH_R2_CMPNEI	MATCH_R2_OP (CMPNEI)
#define MASK_R2_CMPNEI	MASK_R2_OP
#define MATCH_R2_CUSTOM	MATCH_R2_OP (CUSTOM)
#define MASK_R2_CUSTOM	MASK_R2_OP
#define MATCH_R2_DIV	MATCH_R2_OPX0 (DIV)
#define MASK_R2_DIV	MASK_R2_OPX0
#define MATCH_R2_DIVU	MATCH_R2_OPX0 (DIVU)
#define MASK_R2_DIVU	MASK_R2_OPX0
#define MATCH_R2_ENI	MATCH_R2_OPX (ENI, 0, 0, 0)
#define MASK_R2_ENI	MASK_R2_OPX (1, 1, 1, 0)
#define MATCH_R2_ERET	MATCH_R2_OPX (ERET, 0x1d, 0x1e, 0)
#define MASK_R2_ERET	MASK_R2_OPX (1, 1, 1, 1)
#define MATCH_R2_EXTRACT	MATCH_R2_OPX (EXTRACT, 0, 0, 0)
#define MASK_R2_EXTRACT	MASK_R2_OPX (0, 0, 0, 0)
#define MATCH_R2_FLUSHD	MATCH_R2_DCACHE (FLUSHD)
#define MASK_R2_FLUSHD	MASK_R2_DCACHE
#define MATCH_R2_FLUSHDA	MATCH_R2_DCACHE (FLUSHDA)
#define MASK_R2_FLUSHDA	MASK_R2_DCACHE
#define MATCH_R2_FLUSHI	MATCH_R2_OPX (FLUSHI, 0, 0, 0)
#define MASK_R2_FLUSHI	MASK_R2_OPX (0, 1, 1, 1)
#define MATCH_R2_FLUSHP	MATCH_R2_OPX (FLUSHP, 0, 0, 0)
#define MASK_R2_FLUSHP	MASK_R2_OPX (1, 1, 1, 1)
#define MATCH_R2_INITD	MATCH_R2_DCACHE (INITD)
#define MASK_R2_INITD	MASK_R2_DCACHE
#define MATCH_R2_INITDA	MATCH_R2_DCACHE (INITDA)
#define MASK_R2_INITDA	MASK_R2_DCACHE
#define MATCH_R2_INITI	MATCH_R2_OPX (INITI, 0, 0, 0)
#define MASK_R2_INITI	MASK_R2_OPX (0, 1, 1, 1)
#define MATCH_R2_INSERT	MATCH_R2_OPX (INSERT, 0, 0, 0)
#define MASK_R2_INSERT	MASK_R2_OPX (0, 0, 0, 0)
#define MATCH_R2_JMP	MATCH_R2_OPX (JMP, 0, 0, 0)
#define MASK_R2_JMP	MASK_R2_OPX (0, 1, 1, 1)
#define MATCH_R2_JMPI	MATCH_R2_OP (JMPI)
#define MASK_R2_JMPI	MASK_R2_OP
#define MATCH_R2_JMPR_N	MATCH_R2_R_N (JMPR_N)
#define MASK_R2_JMPR_N	MASK_R2_R_N
#define MATCH_R2_LDB	MATCH_R2_OP (LDB)
#define MASK_R2_LDB	MASK_R2_OP
#define MATCH_R2_LDBIO	MATCH_R2_I12 (LDBIO)
#define MASK_R2_LDBIO	MASK_R2_I12
#define MATCH_R2_LDBU	MATCH_R2_OP (LDBU)
#define MASK_R2_LDBU	MASK_R2_OP
#define MATCH_R2_LDBUIO	MATCH_R2_I12 (LDBUIO)
#define MASK_R2_LDBUIO	MASK_R2_I12
#define MATCH_R2_LDBU_N	MATCH_R2_OP (LDBU_N)
#define MASK_R2_LDBU_N	MASK_R2_OP
#define MATCH_R2_LDEX	MATCH_R2_OPX (LDEX, 0, 0, 0)
#define MASK_R2_LDEX	MASK_R2_OPX (0, 1, 0, 1)
#define MATCH_R2_LDH	MATCH_R2_OP (LDH)
#define MASK_R2_LDH	MASK_R2_OP
#define MATCH_R2_LDHIO	MATCH_R2_I12 (LDHIO)
#define MASK_R2_LDHIO	MASK_R2_I12
#define MATCH_R2_LDHU	MATCH_R2_OP (LDHU)
#define MASK_R2_LDHU	MASK_R2_OP
#define MATCH_R2_LDHUIO	MATCH_R2_I12 (LDHUIO)
#define MASK_R2_LDHUIO	MASK_R2_I12
#define MATCH_R2_LDHU_N	MATCH_R2_OP (LDHU_N)
#define MASK_R2_LDHU_N	MASK_R2_OP
#define MATCH_R2_LDSEX	MATCH_R2_OPX (LDSEX, 0, 0, 0)
#define MASK_R2_LDSEX	MASK_R2_OPX (0, 1, 0, 1)
#define MATCH_R2_LDW	MATCH_R2_OP (LDW)
#define MASK_R2_LDW	MASK_R2_OP
#define MATCH_R2_LDWIO	MATCH_R2_I12 (LDWIO)
#define MASK_R2_LDWIO	MASK_R2_I12
#define MATCH_R2_LDWM	MATCH_R2_I12 (LDWM)
#define MASK_R2_LDWM	MASK_R2_I12
#define MATCH_R2_LDWSP_N	MATCH_R2_OP (LDWSP_N)
#define MASK_R2_LDWSP_N	MASK_R2_OP
#define MATCH_R2_LDW_N	MATCH_R2_OP (LDW_N)
#define MASK_R2_LDW_N	MASK_R2_OP
#define MATCH_R2_MERGE	MATCH_R2_OPX (MERGE, 0, 0, 0)
#define MASK_R2_MERGE	MASK_R2_OPX (0, 0, 0, 0)
#define MATCH_R2_MOV	MATCH_R2_OPX (ADD, 0, 0, 0)
#define MASK_R2_MOV	MASK_R2_OPX (0, 1, 0, 1)
#define MATCH_R2_MOVHI	MATCH_R2_OP (ORHI) | SET_IW_F2I16_A (0)
#define MASK_R2_MOVHI	MASK_R2_OP | IW_F2I16_A_SHIFTED_MASK
#define MATCH_R2_MOVI	MATCH_R2_OP (ADDI) | SET_IW_F2I16_A (0)
#define MASK_R2_MOVI	MASK_R2_OP | IW_F2I16_A_SHIFTED_MASK
#define MATCH_R2_MOVUI	MATCH_R2_OP (ORI) | SET_IW_F2I16_A (0)
#define MASK_R2_MOVUI	MASK_R2_OP | IW_F2I16_A_SHIFTED_MASK
#define MATCH_R2_MOV_N	MATCH_R2_OP (MOV_N)
#define MASK_R2_MOV_N	MASK_R2_OP
#define MATCH_R2_MOVI_N	MATCH_R2_OP (MOVI_N)
#define MASK_R2_MOVI_N	MASK_R2_OP
#define MATCH_R2_MUL	MATCH_R2_OPX0 (MUL)
#define MASK_R2_MUL	MASK_R2_OPX0
#define MATCH_R2_MULI	MATCH_R2_OP (MULI)
#define MASK_R2_MULI	MASK_R2_OP
#define MATCH_R2_MULXSS	MATCH_R2_OPX0 (MULXSS)
#define MASK_R2_MULXSS	MASK_R2_OPX0
#define MATCH_R2_MULXSU	MATCH_R2_OPX0 (MULXSU)
#define MASK_R2_MULXSU	MASK_R2_OPX0
#define MATCH_R2_MULXUU	MATCH_R2_OPX0 (MULXUU)
#define MASK_R2_MULXUU	MASK_R2_OPX0
#define MATCH_R2_NEG_N	MATCH_R2_R_N (NEG_N)
#define MASK_R2_NEG_N	MASK_R2_R_N
#define MATCH_R2_NEXTPC	MATCH_R2_OPX (NEXTPC, 0, 0, 0)
#define MASK_R2_NEXTPC	MASK_R2_OPX (1, 1, 0, 1)
#define MATCH_R2_NOP	MATCH_R2_OPX (ADD, 0, 0, 0)
#define MASK_R2_NOP	MASK_R2_OPX (1, 1, 1, 1)
#define MATCH_R2_NOP_N	(MATCH_R2_OP (MOV_N) | SET_IW_F2_A (0) | SET_IW_F2_B (0))
#define MASK_R2_NOP_N	(MASK_R2_OP | IW_F2_A_SHIFTED_MASK | IW_F2_B_SHIFTED_MASK)
#define MATCH_R2_NOR	MATCH_R2_OPX0 (NOR)
#define MASK_R2_NOR	MASK_R2_OPX0
#define MATCH_R2_NOT_N	MATCH_R2_R_N (NOT_N)
#define MASK_R2_NOT_N	MASK_R2_R_N
#define MATCH_R2_OR	MATCH_R2_OPX0 (OR)
#define MASK_R2_OR	MASK_R2_OPX0
#define MATCH_R2_OR_N	MATCH_R2_R_N (OR_N)
#define MASK_R2_OR_N	MASK_R2_R_N
#define MATCH_R2_ORHI	MATCH_R2_OP (ORHI)
#define MASK_R2_ORHI	MASK_R2_OP
#define MATCH_R2_ORI	MATCH_R2_OP (ORI)
#define MASK_R2_ORI	MASK_R2_OP
#define MATCH_R2_POP_N	(MATCH_R2_OP (PP_N) | SET_IW_L5I4X1_X (R2_PP_N_POP_N))
#define MASK_R2_POP_N	(MASK_R2_OP | IW_L5I4X1_X_SHIFTED_MASK)
#define MATCH_R2_PUSH_N	(MATCH_R2_OP (PP_N) | SET_IW_L5I4X1_X (R2_PP_N_PUSH_N))
#define MASK_R2_PUSH_N	(MASK_R2_OP | IW_L5I4X1_X_SHIFTED_MASK)
#define MATCH_R2_RDCTL	MATCH_R2_OPX (RDCTL, 0, 0, 0)
#define MASK_R2_RDCTL	MASK_R2_OPX (1, 1, 0, 0)
#define MATCH_R2_RDPRS	MATCH_R2_I12 (RDPRS)
#define MASK_R2_RDPRS	MASK_R2_I12
#define MATCH_R2_RET	MATCH_R2_OPX (RET, 0x1f, 0, 0)
#define MASK_R2_RET	MASK_R2_OPX (1, 1, 1, 1)
#define MATCH_R2_RET_N	(MATCH_R2_R_N (RET_N) | SET_IW_X2L5_IMM5 (0))
#define MASK_R2_RET_N	(MASK_R2_R_N | IW_X2L5_IMM5_SHIFTED_MASK)
#define MATCH_R2_ROL	MATCH_R2_OPX0 (ROL)
#define MASK_R2_ROL	MASK_R2_OPX0
#define MATCH_R2_ROLI	MATCH_R2_OPX (ROLI, 0, 0, 0)
#define MASK_R2_ROLI	MASK_R2_OPX (0, 1, 0, 0)
#define MATCH_R2_ROR	MATCH_R2_OPX0 (ROR)
#define MASK_R2_ROR	MASK_R2_OPX0
#define MATCH_R2_SLL	MATCH_R2_OPX0 (SLL)
#define MASK_R2_SLL	MASK_R2_OPX0
#define MATCH_R2_SLLI	MATCH_R2_OPX (SLLI, 0, 0, 0)
#define MASK_R2_SLLI	MASK_R2_OPX (0, 1, 0, 0)
#define MATCH_R2_SLL_N	MATCH_R2_R_N (SLL_N)
#define MASK_R2_SLL_N	MASK_R2_R_N
#define MATCH_R2_SLLI_N	(MATCH_R2_OP (SHI_N) | SET_IW_T2X1L3_X (R2_SHI_N_SLLI_N))
#define MASK_R2_SLLI_N	(MASK_R2_OP | IW_T2X1L3_X_SHIFTED_MASK)
#define MATCH_R2_SPADDI_N	MATCH_R2_OP (SPADDI_N)
#define MASK_R2_SPADDI_N	MASK_R2_OP
#define MATCH_R2_SPDECI_N	(MATCH_R2_OP (SPI_N) | SET_IW_X1I7_X (R2_SPI_N_SPDECI_N))
#define MASK_R2_SPDECI_N	(MASK_R2_OP | IW_X1I7_X_SHIFTED_MASK)
#define MATCH_R2_SPINCI_N	(MATCH_R2_OP (SPI_N) | SET_IW_X1I7_X (R2_SPI_N_SPINCI_N))
#define MASK_R2_SPINCI_N	(MASK_R2_OP | IW_X1I7_X_SHIFTED_MASK)
#define MATCH_R2_SRA	MATCH_R2_OPX0 (SRA)
#define MASK_R2_SRA	MASK_R2_OPX0
#define MATCH_R2_SRAI	MATCH_R2_OPX (SRAI, 0, 0, 0)
#define MASK_R2_SRAI	MASK_R2_OPX (0, 1, 0, 0)
#define MATCH_R2_SRL	MATCH_R2_OPX0 (SRL)
#define MASK_R2_SRL	MASK_R2_OPX0
#define MATCH_R2_SRLI	MATCH_R2_OPX (SRLI, 0, 0, 0)
#define MASK_R2_SRLI	MASK_R2_OPX (0, 1, 0, 0)
#define MATCH_R2_SRL_N	MATCH_R2_R_N (SRL_N)
#define MASK_R2_SRL_N	MASK_R2_R_N
#define MATCH_R2_SRLI_N	(MATCH_R2_OP (SHI_N) | SET_IW_T2X1L3_X (R2_SHI_N_SRLI_N))
#define MASK_R2_SRLI_N	(MASK_R2_OP | IW_T2X1L3_X_SHIFTED_MASK)
#define MATCH_R2_STB	MATCH_R2_OP (STB)
#define MASK_R2_STB	MASK_R2_OP
#define MATCH_R2_STBIO	MATCH_R2_I12 (STBIO)
#define MASK_R2_STBIO	MASK_R2_I12
#define MATCH_R2_STB_N	MATCH_R2_OP (STB_N)
#define MASK_R2_STB_N	MASK_R2_OP
#define MATCH_R2_STBZ_N	(MATCH_R2_OP (STZ_N) | SET_IW_T1X1I6_X (R2_STZ_N_STBZ_N))
#define MASK_R2_STBZ_N	(MASK_R2_OP | IW_T1X1I6_X_SHIFTED_MASK)
#define MATCH_R2_STEX	MATCH_R2_OPX0 (STEX)
#define MASK_R2_STEX	MASK_R2_OPX0
#define MATCH_R2_STH	MATCH_R2_OP (STH)
#define MASK_R2_STH	MASK_R2_OP
#define MATCH_R2_STHIO	MATCH_R2_I12 (STHIO)
#define MASK_R2_STHIO	MASK_R2_I12
#define MATCH_R2_STH_N	MATCH_R2_OP (STH_N)
#define MASK_R2_STH_N	MASK_R2_OP
#define MATCH_R2_STSEX	MATCH_R2_OPX0 (STSEX)
#define MASK_R2_STSEX	MASK_R2_OPX0
#define MATCH_R2_STW	MATCH_R2_OP (STW)
#define MASK_R2_STW	MASK_R2_OP
#define MATCH_R2_STWIO	MATCH_R2_I12 (STWIO)
#define MASK_R2_STWIO	MASK_R2_I12
#define MATCH_R2_STWM	MATCH_R2_I12 (STWM)
#define MASK_R2_STWM	MASK_R2_I12
#define MATCH_R2_STWSP_N	MATCH_R2_OP (STWSP_N)
#define MASK_R2_STWSP_N	MASK_R2_OP
#define MATCH_R2_STW_N	MATCH_R2_OP (STW_N)
#define MASK_R2_STW_N	MASK_R2_OP
#define MATCH_R2_STWZ_N	MATCH_R2_OP (STZ_N)
#define MASK_R2_STWZ_N	MASK_R2_OP
#define MATCH_R2_SUB	MATCH_R2_OPX0 (SUB)
#define MASK_R2_SUB	MASK_R2_OPX0
#define MATCH_R2_SUBI	MATCH_R2_OP (ADDI)
#define MASK_R2_SUBI	MASK_R2_OP
#define MATCH_R2_SUB_N	(MATCH_R2_OP (AS_N) | SET_IW_T3X1_X (R2_AS_N_SUB_N))
#define MASK_R2_SUB_N	(MASK_R2_OP | IW_T3X1_X_SHIFTED_MASK)
#define MATCH_R2_SUBI_N	(MATCH_R2_OP (ASI_N) | SET_IW_T2X1I3_X (R2_ASI_N_SUBI_N))
#define MASK_R2_SUBI_N	(MASK_R2_OP | IW_T2X1I3_X_SHIFTED_MASK)
#define MATCH_R2_SYNC	MATCH_R2_OPX (SYNC, 0, 0, 0)
#define MASK_R2_SYNC	MASK_R2_OPX (1, 1, 1, 1)
#define MATCH_R2_TRAP	MATCH_R2_OPX (TRAP, 0, 0, 0x1d)
#define MASK_R2_TRAP	MASK_R2_OPX (1, 1, 1, 0)
#define MATCH_R2_TRAP_N	MATCH_R2_R_N (TRAP_N)
#define MASK_R2_TRAP_N	MASK_R2_R_N
#define MATCH_R2_WRCTL	MATCH_R2_OPX (WRCTL, 0, 0, 0)
#define MASK_R2_WRCTL	MASK_R2_OPX (0, 1, 1, 0)
#define MATCH_R2_WRPIE	MATCH_R2_OPX (WRPIE, 0, 0, 0)
#define MASK_R2_WRPIE	MASK_R2_OPX (0, 1, 0, 1)
#define MATCH_R2_WRPRS	MATCH_R2_OPX (WRPRS, 0, 0, 0)
#define MASK_R2_WRPRS	MASK_R2_OPX (0, 1, 0, 1)
#define MATCH_R2_XOR	MATCH_R2_OPX0 (XOR)
#define MASK_R2_XOR	MASK_R2_OPX0
#define MATCH_R2_XORHI	MATCH_R2_OP (XORHI)
#define MASK_R2_XORHI	MASK_R2_OP
#define MATCH_R2_XORI	MATCH_R2_OP (XORI)
#define MASK_R2_XORI	MASK_R2_OP
#define MATCH_R2_XOR_N	MATCH_R2_R_N (XOR_N)
#define MASK_R2_XOR_N	MASK_R2_R_N

#endif /* _NIOS2R2_H */


