/* LocaleInformation_nl.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_nl extends ListResourceBundle
{
  private static final String collation_rules = 
    "<0<1<2<3<4<5<6<7<8<9<A,a<b,B<c,C<d,D<e,E<f,F<g,G<h,H<i,I<j,J<k,K" +
    "<l,L<m,M<n,N<o,O<p,P<q,Q<r,R<s,S<t,T<u,U<v,V<w,W<x,X<y,Y<z,Z";
  
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jordaanse dinar|Boliviaanse mvdol|Goud|Faer\u00f6erse kroon|Libanees pond|Euro|Vietnamese dong|Tanzaniaanse shilling|Boliviaanse peso|Cambodjaanse riel|Aziatische monetaire eenheid|Boliviano (1863-1962)|Cambodjaanse oude riel|Zambiaans pond|Australisch pond|CFA-franc BEAC|Maltees pond|Ghanese hergewaardeerde cedi|Zambiaanse kwacha|Aziatische dinar-rekeneenheid|Ghanees pond|Boliviano|Ghanese oude cedi|Maltese lire|Australische dollar|Amerikaanse dollar (zelfde dag)|Italiaanse lire|Amerikaanse dollar (volgende dag)|Ghanese cedi|Singaporese dollar|Panamese balboa|Laotiaanse kip|Kirgizische som|Zwitserse franc|Oostenrijkse schilling|Amerikaanse dollar|Ethiopische dollar|Bruneise dollar|Jamaicaans pond|Ethiopische birr|Algerijnse franc germinal|Algerijnse nieuwe franc|Algerijnse dinar|Paraguayaanse guarani|Libisch pond|Jamaicaanse dollar|IJslandse kroon|Spaanse peseta|Bermuda-pond|Libische dinar|Libische Britse Militaire Autoriteit-lire|Bermuda-dollar|Nederlandse gulden|Mauritaanse ouguiya|Iraanse rial|Zweedse kroon|Eritrese nakfa|Kenyaanse shilling|Centraal-Afrikaanse CFA-franc|Argentijnse peso|Argentijnse peso (1983-1985)|Argentijnse peso moneda nacional|Nieuwe Taiwanese dollar|Soedanees pond|Georgische lari|Georgische kupon larit|Martinikaanse franc|Falklandeilands pond|Argentijnse austral|Soedanese dinar|Iraakse dinar|Tuvaluaanse dollar|Seychelse rupee|Letse roebel|Fijisch pond|Letse lats|Congolese za\u00efre|Congolese franc|Congolese franc congolais|Fijische dollar|Nicaraguaanse  c\u00f3rdoba oro|Macause pataca|Nicaraguaanse gouden c\u00f3rdoba|Nicaraguaanse c\u00f3rdoba|COMECON transferable roebel|Finse markka (1860-1962)|Finse markka|Salomonseilandse dollar|Luxemburgse frank|Trinidad en Tobago-oude dollar|Angolese escudo|Angolese kwanza reajustado (1995-1999)|Mongoolse tugrik|Hongaarse forint|Burundese franc|Angolese nieuwe kwanza (1990-2000)|Angolese kwanza (1977-1990)|Trinidad en Tobago-dollar|Swazische lilangeni|Nieuw-Hebridiaanse CFP-franc|Brits pond sterling|Saoedische souvereine rial|Saoedische rial|Litouwse talonas|Indiase rupee|Portugese escudo|Angolese kwanza|Portugese conto|Litouwse litas|Kazachstaanse tenge|Kazachstaanse roebel|Britse Maagdeneilandse dollar|Nigeriaans pond|Myanmarese dollarwisselcertificaten|Nigeriaanse naira|Ha\u00eftiaanse gourde|Syrisch pond|Palestijns pond|Bahreinse dinar|Myanmarese kyat|Nederlands-Antilliaanse gulden|Tsjechische koruna|Isle of Man pond sterling|Bulgaarse levwisselcertificaten|Lesothaanse loti|Gabonese CFA-franc|Bulgaarse lev (1879-1952)|Bulgaarse nieuwe lev|Bulgaarse socialistische lev|Canadese dollar|Bulgaarse harde lev|Turkse lire|Caymaneilandse dollar|Cyprisch pond|Isra\u00eblische nieuwe shekel|Guyaanse dollar|Armeense dram|Isra\u00eblisch pond|Malinese franc|Isra\u00eblische shekel|Venezolaanse bolivar|Albanese dollarwisselcertificaten|Liberiaanse dollar|Albanese lek valute|Kroatische kuna|R\u00e9unionse franc|Kroatische dinar|Albanese lek|Jersey pond sterling|Albanese lek (1946-1961)|Macedonische denar (1992-1993)|Noord-Vietnamese viet minh piastre dong viet|Noord-Vietnamese nieuwe dong|Macedonische denar|Noord-Vietnamese piastre dong viet|Timorese pataca|CFP-franc|Belgische frank (financieel)|Guinee-Bissause peso|Koeweitse dinar|Portuguees-Guinese mil reis|Belgische frank|Timorese escudo|Belgische frank (convertibel)|Portuguees-Guinese escudo|Salvadoraanse col\u00f3n|Cura\u00e7ao-gulden|Bengalese taka|Tongaans pond sterling|Tongaanse pa\u02bbanga|CFA-franc BCEAO|Sovjet-roebel|Nieuwe sovjet-roebel|Nieuw-Caledonische franc germinal|Kaapverdische escudo|Franse antillen CFA-franc|Zuid-Afrikaanse rand|Dominicaanse peso|Cubaanse wisselcertificaten|Zuid-Afrikaans pond|Zuid-Afrikaanse rand (financieel)|Tunesische dinar|Cubaanse peso|Frans-Guyaanse franc guiana|Oegandese shilling|Ceylon-rupee|Affars en Issas-franc|Vaticaanse lire|Santomese escudo|Oegandese shilling (1966-1987)|Santomese dobra|Marshalleilandse dollar|Nieuw-Zeelands pond|West-Samoaanse tala|West-Samoaans pond|Hodurese lempira|Franse metropolische nieuwe franc|Turkmeense manat|Guatemalteekse quetzal|Nieuw-Zeelandse dollar|Schotse pond|Barbadaanse dollar|Namibische dollar|Malagassische franc|Malagassische ariary|Egyptisch pond|Brits-Hondurese dollar|Poolse zloty (1950-1995)|Bosnische nieuwe dinar|Poolse Amerikaanse-dollarwisselcertificaten|Bosnische convertibele mark|Belizaanse dollar|Bosnische dinar|Poolse zloty|Jemenitische rial|Surinaamse gulden|Tsjechoslowaakse harde koruna|Zuid-Koreaanse won|Wit-Russische roebel|Jemenitische imadi rial|Wit-Russische roebel (1992-1994)|Tsjechoslowaakse koruna|Zuid-Koreaanse oude won|Zuid-Koreaanse hwan|Wit-Russische nieuwe roebel (1994-1999)|Somalilandse shilling|Griekse nieuwe drachme|Pakistaanse rupee|Afghani|Zimbabwaanse dollar|Srilankaanse rupee|Griekse drachme|Iers pond|Afghani (1927-2002)|Jemenitische dinar|Rwandese franc|Costaricaanse col\u00f3n|Tadzjikistaanse somoni|Tadzjikistaanse roebel|Estlandse kroon|Equatoriaal-Guinese peseta puineana|Moldavische roebel-cupon|Hongkongse dollar|Deense kroon|Moldavische leu|Equatoriaal-Guinese franco|Equatoriaal-Guinese ekwele guineana|Indonesische rupiah|Verenigde Arabische Emiraten-dirham|Noord-Koreaanse won|Indonesische nieuwe rupiah|Botswaanse pula|Monegaskische leu cupon|Indonesische Java-rupiah|Noord-Koreaanse Volksrepubliek-won|Indonesische nica-gulden|Vanuatuaanse vatu|Islamitische dinar|Somalische shilling|Andorrese peseta|Russische roebel (1991-1998)|Guadeloupse franc|Djiboutiaanse franc|Andorrese diner|Monegaskische franc germinal|Monegaskische nieuwe franc|Ecuadoraanse unidad de valor constante (UVC)|Ecuadoraanse sucre|Liechtensteinse frank|Russische roebel|Filipijnse peso|Oezbekistaanse sum|Colombiaanse peso|Thaise baht|Noord-Iers pond|Birmese rupee|Congolese CFA-franc|Birmese kyat|Colombiaanse papieren peso|Oezbekistaanse coupon-som|Oekra\u00efense karbovanetz|Qatarese rial|Oekra\u00efense hryvnia|Guinese syli|Chinese yuan renminbi|Mozambikaanse metical|Chinese Amerikaanse-dollarwisselcertificaten|Uruguayaanse peso uruguayo|Guinese franc (1960-1972)|Sanmarinese lire|Chinese jen min piao yuan|Mozambikaanse escudo|Guinese franc|Omaanse rial saidi|Papuaanse kina|Omaanse rial|Uruguayaanse peso (1975-1993)|Franse UIC-franc|Bhutaanse rupee|Za\u00efrese za\u00efre|Marokkaanse franc|Marokkaanse dirham|Bhutaanse ngultrum|Franse gouden franc|Uruguayaanse peso fuerte|Maleisische ringgit|Za\u00efrese nieuwe za\u00efre|Azerbeidzjaanse manat|Gambiaans pond|Comorese franc|Sierraleoonse leone|Gambiaanse dalasi|European Currency Unit|Bahamaans pond|Kameroense CFA-franc|Mexicaanse unidad de inversion (UDI)|CFA-franc BCEAEC|Bahamaanse dollar|Mexicaanse zilveren peso (1861-1992)|Mexicaanse peso|Peruaanse sol|Groenlandse kroon|Braziliaanse cruzeiro (1942-1967)|Peruaanse nieuwe sol|Chileense peso|Slowaakse koruna|Peruaanse inti|Braziliaanse cruzeiro|Special Drawing Rights|Franse franc germinal/franc poincare|Franse franc|Braziliaanse cruzado novo|Chileense unidades de fomento|Chileense escudo|Braziliaanse real|Chileense condor|Braziliaanse cruzeiro (1990-1993)|Duitse sperrmark|Malawisch pond|Braziliaanse cruzado|Braziliaanse cruzeiro novo (1967-1986)|Malawische kwacha|Trans-Djnestrische roebel|Duitse mark|Tsjaadse CFA-franc|Trans-Djnestrische nieuwe roebel|Trans-Djnestrische roebel-kupon|Nepalese rupee|Cookeilandse dollar|Japanse yen|Maldivische rufiyaa|CFA nieuwe franc|Maldivische rupee|Oost-Caribische dollar|Sloveense tolar|Joegoslavische  hervormde dinar|Arubaanse gulden|Joegoslavische oktober-dinar|Oost-Duitse ostmark|Joegoslavische convertibele dinar|Joegoslavische noviy-dinar|Turks en Caicos-kroon|Joegoslavische 1994-dinar|Joegoslavische federale dinar|Roemeense nieuwe leu|Joegoslavische harde dinar|Roemeense leu|Sloveense tolar bons|Noorse kroon|Mauritiaanse rupee|Europese rekeneenheid (XBD)|Gibraltarees pond|Vietnamese nationale dong|Europese rekeneenheid (XBC)|Vietnamese Republiek-dong|Europese monetaire eenheid|Europese samengestelde eenheid|Kiribatische dollar|Sint-Heleense pond|Vietnamese nieuwe dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|fl|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|CNP|MZE|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mrt",
    "apr",
    "mei",
    "jun",
    "jul",
    "aug",
    "sep",
    "okt",
    "nov",
    "dec",
    null,
  };

  private static final String[] months = {
    "januari",
    "februari",
    "maart",
    "april",
    "mei",
    "juni",
    "juli",
    "augustus",
    "september",
    "oktober",
    "november",
    "december",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "zo",
    "ma",
    "di",
    "wo",
    "do",
    "vr",
    "za",
  };

  private static final String[] weekdays = {
    null,
    "zondag",
    "maandag",
    "dinsdag",
    "woensdag",
    "donderdag",
    "vrijdag",
    "zaterdag",
  };

  private static final String[] eras = {
    "v. Chr.",
    "n. Chr.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Pacific-standaardtijd", "PDT", "Pacific-zomertijd",  "America/Los_Angeles" },
    { "GMT", "Greenwich Mean Time", "GMT", "Greenwich Mean Time",  "Africa/Casablanca" },
    { "EST", "Eastern-standaardtijd", "EDT", "Eastern-zomertijd",  "America/New_York" },
    { "AST", "Alaska-standaardtijd", "ADT", "Alaska-zomertijd",  "America/Anchorage" },
    { "GMT", "Greenwich Mean Time", "GMT", "Greenwich Mean Time",  "Etc/GMT" },
    { "CTT", "Chinese standaardtijd", "CDT", "Chinese standaardtijd",  "Asia/Shanghai" },
    { "AST", "Atlantic-standaardtijd", "ADT", "Atlantic-zomertijd",  "America/Halifax" },
    { "CET", "Midden-Europese standaardtijd", "CEST", "Midden-Europese zomertijd",  "Europe/Paris" },
    { "MST", "Mountain-standaardtijd", "MDT", "Mountain-zomertijd",  "America/Denver" },
    { "IST", "Isra\u00eblische standaardtijd", "IDT", "Isra\u00eblische zomertijd",  "Asia/Jerusalem" },
    { "HST", "Hawa\u00ef-standaardtijd", "HST", "Hawa\u00ef-standaardtijd",  "Pacific/Honolulu" },
    { "CNT", "Newfoundland-standaardtijd", "CDT", "Newfoundland-zomertijd",  "America/St_Johns" },
    { "EST", "Eastern-standaardtijd", "EST", "Eastern-standaardtijd",  "America/Indianapolis" },
    { "CST", "Central-standaardtijd", "CDT", "Central-zomertijd",  "America/Chicago" },
    { "EET", "Oost-Europese standaardtijd", "EEST", "Oost-Europese zomertijd",  "Europe/Bucharest" },
    { "JST", "Japanse standaardtijd", "JST", "Japanse standaardtijd",  "Asia/Tokyo" },
    { "MST", "Mountain-standaardtijd", "MST", "Mountain-standaardtijd",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Oost-Timor|Tokelau|Tadzjikistan|Thailand|Togo|Franse Gebieden in de zuidelijke Indische Oceaan|Guyana|Tsjaad|Turks- en Caicoseilanden|Guinee-Bissau|Guam|Guatemala|Zuid-Georgi\u00eb en Zuidelijke Sandwicheilanden|Griekenland|Equatoriaal-Guinea|Guadeloupe|Swaziland|Syri\u00eb|Guinea|Gambia|Groenland|El Salvador|Sao Tom\u00e9 en Principe|Gibraltar|Ghana|Suriname|Frans-Guyana|Servi\u00eb|Georgi\u00eb|Somali\u00eb|Grenada|Senegal|San Marino|Verenigd Koninkrijk|Sierra Leone|Gabon|Slowakije|Svalbard en Jan Mayen|Sloveni\u00eb|Saint Helena|Singapore|Zweden|Soedan|Seychellen|Salomonseilanden|Saoedi-Arabi\u00eb|Frankrijk|Faer\u00f6er|Micronesia, Federale Staten van|Rwanda|Falklandeilanden|Russische Federatie|Fiji|Finland|Roemeni\u00eb|R\u00e9union|Ethiopi\u00eb|Spanje|Eritrea|West-Sahara|Egypte|Estland|Ecuador|Algerije|Qatar|Dominicaanse Republiek|Paraguay|Dominica|Palau|Denemarken|Djibouti|Portugal|Palestijns Gebied|Puerto Rico|Duitsland|Pitcairn|Saint Pierre en Miquelon|Polen|Pakistan|Filipijnen|Papoea-Nieuw-Guinea|Frans-Polynesi\u00eb|Tsjechi\u00eb|Peru|Cyprus|Christmaseiland|Kaapverdi\u00eb|Panama|Cuba|Costa Rica|Colombia|China|Kameroen|Chili|Cookeilanden|Ivoorkust|Zwitserland|Congo|Centraal-Afrikaanse Republiek|Congo, Democratische Republiek|Cocoseilanden|Oman|Canada|Belize|Wit-Rusland|Botswana|Bouveteiland|Bhutan|Bahama\u2019s|Brazili\u00eb|Nieuw-Zeeland|Bolivia|Brunei Darussalam|Bermuda|Niue|Benin|Burundi|Bahrein|Nauru|Bulgarije|Burkina Faso|Nepal|Belgi\u00eb|Noorwegen|Bangladesh|Barbados|Zimbabwe|Nederland|Bosni\u00eb Herzegovina|Nicaragua|Nigeria|Norfolkeiland|Azerbeidzjan|Niger|Nieuw-Caledoni\u00eb|Aruba|Zambia|Namibi\u00eb|Australi\u00eb|Oostenrijk|Amerikaans Samoa|Argentini\u00eb|Antarctica|Mozambique|Angola|Maleisi\u00eb|Nederlandse Antillen|Mexico|Armeni\u00eb|Malawi|Albani\u00eb|Maldiven|Zuid-Afrika|Mauritius|Malta|Anguilla|Montserrat|Mauritani\u00eb|Antigua en Barbuda|Martinique|Afghanistan|Noordelijke Marianeneilanden|Verenigde Arabische Emiraten|Macao S.A.R. van China|Andorra|Mongoli\u00eb|Myanmar|Mali|Macedoni\u00eb, Republiek|Joegoslavi\u00eb|Mayotte|Marshalleilanden|Madagaskar|Republiek Moldavi\u00eb|Monaco|Marokko|Jemen|Libi\u00eb|Letland|Luxemburg|Litouwen|Lesotho|Liberia|Sri Lanka|Liechtenstein|Saint Lucia|Libanon|Laos|Kazachstan|Caymaneilanden|Koeweit|Zuid-Korea|Noord-Korea|Saint Kitts en Nevis|Comoren|Kiribati|Samoa|Cambodja|Kirgizstan|Kenia|Wallis en Futuna|Japan|Jordani\u00eb|Jamaica|Vanuatu|Vietnam|Amerikaanse Maagdeneilanden|Britse Maagdeneilanden|Venezuela|Saint Vincent en de Grenadines|Vaticaanstad|Itali\u00eb|IJsland|Iran|Irak|Oezbekistan|Brits Territorium in de Indische Oceaan|Uruguay|India|Isra\u00ebl|Verenigde Staten|Ierland|Indonesi\u00eb|Amerikaanse ondergeschikte afgelegen eilanden|Oeganda|Oekra\u00efne|Hongarije|Ha\u00efti|Kroati\u00eb|Tanzania|Honduras|Heardeiland en McDonaldeiland|Taiwan|Tuvalu|Hongkong S.A.R. van China|Trinidad en Tobago|Turkije|Tonga|Tunesi\u00eb|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "Gwich\u02bbin|Akkadisch|Ekajuk|Ijo|Xhosa|Soemerisch|Soesoe|Diverse talen|Lozi|Tonga (Nyasa)|Pohnpeiaans|Minangkabau|Sukuma|Wolof|Mongo|Kutenai|Micmac|Wallonisch|Kumyk|Zapotec|Koesjitisch (overige)|Lojban|Dogri|Volap\u00fck|Otomi-talen|Vietnamees|Vai|Rarotongan|Venda|Rapanui|Rajasthani|Turks, Ottomaans (1500-1928)|Nzima|Napolitaans|Oezbeeks|Oegaritisch|Tamashek|Noord-Amerikaans Indiaans (overige)|Nahuatl|Urdu|Fanti|Oekra\u00efens|Egyptisch (klassiek)|Uighur|Fang|Nilo-Saharam (overige)|Iers, middel- (900-1200)|Baltisch (overige)|Nyoro|Basa|Nyankole|Nyamwezi|Hmong|Balinees|Osage|Baloetsji|Tahitisch|Bamileke-talen|Twi|Serer|Tlingit|Tataars|Tsonga|Banda|Turks|Tonga (Tonga-eilanden)|Tswana|Tagalog|Turkmeens|Tigrinya|Thai|Kurukh|Tadzjik|Blin|Teloegoe|Kru|Kasjoebisch|Tamil|Tokelau|Efik|Swahili|Zweeds|Sundanees|Karachay-Balkar|Sotho, zuid|Swati|Servisch|Albanees|Mende|Creools en Pidgin (overige)|Somalisch|Afrihili|Shona|Samoaans|Sloveens|Grieks, klassiek (tot 1453)|Slowaaks|Gerbo|Singalees|Servokroatisch|Krim-Turks; Krim-Tataars|Afro-aziatisch (overige)|Sango|Noord-Samisch|Sindhi|Udmurt|Sardinisch|Sanskrit|Kinyarwanda|Russisch|Mandar|Roemeens|Rundi|Retoromaans|Moksha|Tiv|Adyghe|Zuni|Kpelle|Quechua|Tigre|Songhai|Creools en Pidgin, op Portugees gebaseerd (overige)|Sogdisch|Adangme|Kosreaans|Hittite|Creools en Pidgin, op Frans gebaseerd (overige)|Creools en Pidgin, op Engels gebaseerd (overige)|Himachali|Konkani|Hiligaynon|Gothisch|Gorontalo|Gondi|Dinka|Nubische talen|Portugees|Pashto|Friulisch|Foenicisch|Duits, oudhoog- (ca. 750-1050)|Soninke|Koptisch|Yapees|Akoli|Yao|Filipijns (overige)|Pools|Atjehs|Pali|Punjabi|Buginees|Iban|Skolt Sami|Buriat|Masai|Inari Sami|Ossetisch|Austronesisch|Oriya|Mandingo|Lule Sami|Sami-talen (overige)|Makassaars|Oromo|Maithili|Ojibwa|Magahi|Madurees|Zuid-Samisch|Langue d\u2019Oc (na 1500)|Sotho, noorderlijk|Batak|Erzya|Dogrib|Nyanja|Mayan|Navajo|Kimbundu|Ndebele, zuid-|Duits, middelhoog- (ca. 1050-1500)|Noors|Noors - Nynorsk|Nederlands|Ndonga|Slavisch (overige)|Nepalees|Ndebele, noord-|Chamische talen|Tetum|Noors - Bokm\u00e5l|Nauru|Tereno|Timne|Birmees|Lezgisch|Maltees|Perzisch, oud- (ca. 600-400 B.C.)|Maleis|Marathi|Frans, oud (842-ca. 1400)|Moldavisch|Frans, middel (ca. 1400-1600)|Mongools|Judeo-Arabisch|Malayalam|Macedonisch|Maori|Marshallees|Malagasisch|Marwari|Braj|Slave|Letlands|Luba-Katanga|Delaware|Litouws|Lao|Lingala|Limburgs|Ewondo|Ganda|Luxemburgs|Latijn|Judeo-Perzisch|Votisch|Sino-Tibetaans (overige)|Kirgizisch|Cornish|Komi|Koerdisch|Siouaanse talen|Kashmiri|Kanuri|Awadhi|Koreaans|Kannada|Khmer|Kalaallisut|Kazachs|Romani|Kuanyama|Sidamo|Kikuyu|Kongo|Noors, oud-|Georgisch|Creek|Romaans (overige)|Nogai|Munda-talen|Meerdere talen|Javaans|Gilbertees|Zande|Shan|Fon|Kalmyk|Australische talen|Khotanees|Japans|Khoisan (overige)|Palauaans|Cheyenne|Tai (overige)|Inuktitut|Papiamento|Italiaans|Gebarentalen|IJslands|Khasi|Cherokee|Pampanga|Pahlavi|Chipewyan|Ido|Choctaw|Chinook-jargon|Mari|Tuvinisch|Bantu|Pangasinan|Inupiaq|Chuukees|Sichuan Yi|Hawa\u00efaans|Lamba|Igbo|Chagatai|Iers, oud- (tot 900)|Papoea (overige)|Interlingue|Indonesisch|Lahnda|Dajak|Chibcha|Interlingua|Ladino|Herero|Haida|Dargwa|Armeens|Athapascaanse talen|Hongaars|Ha\u00eftiaans|Dakota|Kroatisch|Hiri Motu|Hindi|Dyula|Hebreeuws|Asturisch|Hausa|Sorbische talen|Manx|Gujarati|Semitisch (overige)|Selkup|Irokese talen|Guarani|Galicisch|Arawak|Geez|Kunsttalen (overige)|Schots Gaelic|Iraans|Iers|Arapaho|Araukaans|Fries|Siksika|Germaans (overige)|Yupik-talen|Aramees|Frans|Faer\u00f6ers|Keltisch (overige)|Fijisch|Fins|Fulah|Tuvalu|Cebuano|Perzisch|Baskisch|Schots|Estlands|Spaans|Esperanto|Engels|Grieks|Alta\u00efsch (overige)|Niueaans|Tupi-talen|Ewe|Toemboeka|Mossi|Dzongkha|Niger - Kordofanisch (overige)|Lushai|Fins-Oegrisch (overige)|Divehi|Nias|Mohawk|Luo|Lunda|Apache-talen|Luiseno|Hupa|Bini|Duits|Luba-Lulua|Bikol|Washo|Onbepaald|Waray|Deens|Nederlands, middel- (ca. 1050-1350)|Walamo|Manobo-talen|Wakashan-talen|Santali|Welsh|Sasak|Kabardisch|Tsjoevasjisch|Kerkslavisch|Manipoeri|Tsjechisch|Samaritaans Aramees|Cree|Salishan-talen|Duala|Corsicaans|Zuid-Amerikaans Indiaans (overige)|Mantsjoe|Yakut|Kawi|Ingoesj|Gbaya|Sandawe|Chamorro|Indo-Europees (overige)|Bhojpuri|Engels, middel- (1100-1500)|Karen|Indisch (overige)|Chechen|Gayo|Catalaans|Umbundu|Syriac|Kamba|Tsimshian|Engels, oud (ca. 450-1100)|Kachin|Kaukasisch (overige)|Kabyle|Kara-Kalpaks|Bosnisch|Caribisch|Bretons|Tibetaans|Bengalees|Bambara|Ga|Midden-Amerikaans Indiaans (overige)|Bislama|Bihari|Bulgaars|Wit-Russisch|Caddo|Basjkiers|Zulu|Zenaga|Proven\u00e7aals, oud- (tot 1500)|Oppersorbisch|Azerbeidzjaans|Aymara|Avarisch|Assamees|Nedersorbisch|Arabisch|Iloko|Elamitisch|Chinees|Aragonees|Prakrit-talen|Amhaars|Newari|Akan|Zhuang|Afrikaans|Avestisch|Abchazisch|Afar|Joruba|Algonkium-talen|Aleut|Mon-Khmer (overige)|Jiddisch|Dravidisch (overige)|Berber|Laagduits; Laagsaxon|Bemba|Beja|Tok Pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "Gewijzigd";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "collation_rules", collation_rules },
    { "localPatternChars", "GyMdhHmsSEDFwWakKz" },
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "d-M-yy" },
    { "mediumDateFormat", "d-MMM-yyyy" },
    { "longDateFormat", "d MMMM yyyy" },
    { "fullDateFormat", "EEEE d MMMM yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss' uur' z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
