/* LocaleInformation_sl.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_sl extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "SIT";

  private static final String currenciesDisplayNameValues = "Slovenski tolar";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "SIT";

  private static final String currenciesSymbolValues = "SIT";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "maj",
    "jun",
    "jul",
    "avg",
    "sep",
    "okt",
    "nov",
    "dec",
    null,
  };

  private static final String[] months = {
    "januar",
    "februar",
    "marec",
    "april",
    "maj",
    "junij",
    "julij",
    "avgust",
    "september",
    "oktober",
    "november",
    "december",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "ned",
    "pon",
    "tor",
    "sre",
    "\u010det",
    "pet",
    "sob",
  };

  private static final String[] weekdays = {
    null,
    "nedelja",
    "ponedeljek",
    "torek",
    "sreda",
    "\u010detrtek",
    "petek",
    "sobota",
  };

  private static final String[] eras = {
    "pr.n.\u0161.",
    "po Kr.",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Vzhodni Timor|Tokelau|Tad\u017eikistan|Tajska|Togo|Francoski ju\u017eni teritorij|Gvajana|\u010cad|Oto\u010dji Turks in Caicos|Gvineja Bissau|Guam|Gvatemala|Ju\u017ena Georgija in Ju\u017eni Sandwich Islands|Gr\u010dija|Ekvatorialna Gvineja|Guadeloupe|Svazi|Sirija|Gvineja|Gambija|Grenlandija|Salvador|Sao Tome in Principe|Gibraltar|Gana|Surinam|Francoska Gvajana|Serbia|Gruzija|Somalija|Grenada|Senegal|San Marino|Velika Britanija|Sierra Leone|Gabon|Slova\u0161ka|Svalbard in Jan Mayen|Slovenija|Sveta Helena|Singapur|\u0160vedska|Sudan|Sej\u0161eli|Salomonovo oto\u010dje|Saudova Arabija|Francija|Fererski otoki|Mikronezija|Ruanda|Falklandski (Malvinski) otoki|Ruska federacija|Fid\u017ei|Finska|Romunija|Reunion|Etiopija|\u0160panija|Eritreja|Zahodna Sahara|Egipt|Estonija|Ekvador|Al\u017eirija|Katar|Dominikanska republika|Paragvaj|Dominika|Palau|Danska|D\u017eibuti|Portugalska|Palestinsko ozemlje|Portoriko|Nem\u010dija|Pitcairn|Saint Pierre in Miquelon|Poljska|Pakistan|Filipini|Papua Nova Gvineja|Francoska Polinezija|\u010ce\u0161ka|Peru|Ciper|Bo\u017ei\u010dni otok|Kapverdski otoki|Panama|Kuba|Kostarika|Kolumbija|Kitajska|Kamerun|\u010cile|Cookovi otoki|Slonoko\u0161\u010dena obala|\u0160vica|Kongo|Centralnoafri\u0161ka republika|Demokrati\u010dna republika Kongo|Kokosovi otoki|Oman|Kanada|Belize|Belorusija|Bocvana|Otok Bouvet|Butan|Bahami|Brazilija|Nova Zelandija|Bolivija|Brunej|Bermuda|Niue|Benin|Burundi|Bahrajn|Nauru|Bolgarija|Burkina Faso|Nepal|Belgija|Norve\u0161ka|Banglade\u0161|Barbados|Zimbabve|Nizozemska|Bosna in Hercegovina|Nikaragva|Nigerija|Otok Norfolk|Azerbajd\u017ean|Niger|Nova Kaledonija|Aruba|Zambija|Namibija|Avstralija|Avstrija|Ameri\u0161ka Samoa|Argentina|Antarktika|Mozambik|Angola|Malezija|Nizozemski Antili|Mehika|Armenija|Malavi|Albanija|Maldivi|Ju\u017ena Afrika|Mauritius|Malta|Angvila|Montserrat|Mavretanija|Antigva in Barbuda|Martinik|Afganistan|Severni Marianski otoki|Zdru\u017eeni arabski emirati|Makao S.A.R. Kitajske|Andora|Mongolija|Myanmar|Mali|Republika Makedonija|Jugoslavija|Mayotte|Marshallovi otoki|Madagaskar|Republika Moldova|Monako|Maroko|Jemen|Libija|Latvija|Luxemburg|Litva|Lesoto|Liberija|\u0160rilanka|Liechtenstein|Saint Lucia|Libanon|Ljudska demokrati\u010dna republika Laos|Kazahstan|Kajmanski otoki|Kuvajt|Ju\u017ena Koreja|Severna Koreja|Saint Kitts in Nevis|Komori|Kiribati|Samoa|Kambod\u017ea|Kirgizistan|Kenija|Wallis in Futuna|Japonska|Jordan|Jamajka|Vanuatu|Vietnam|Ameri\u0161ki Devi\u0161ki otoki|Britanski Devi\u0161ki otoki|Venezuela|Saint Vincent in Grenadine|Vatikan|Italija|Islandija|Iran|Irak|Uzbekistan|Britanska Indija|Urugvaj|Indija|Izrael|Zdru\u017eene dr\u017eave Amerike|Irska|Indonezija|Ameri\u0161ki manj\u0161i oddaljeni otoki|Uganda|Ukrajina|Mad\u017earska|Haiti|Hrva\u0161ka|Tanzanija|Honduras|Heardov otok in McDonaldovi otoki|Tajvan|Tuvalu|Hong Kong S.A.R. Kitajske|Trinidad in Tobago|Tur\u010dija|Tonga|Tunizija|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ja|en|tr|ko|no|el|nl|bg|lv|he|cs|it|lt|fr|zh|ru|ro|fi|ar|sv|pt|pl|sl|sk|de|hu|et|es|hr|da";

  private static final String languagesValues = "Japon\u0161\u010dina|Angle\u0161\u010dina|Tur\u0161\u010dina|Korej\u0161\u010dina|Norve\u0161\u010dina|Gr\u0161\u010dina|Nizozem\u0161\u010dina|Bolgar\u0161\u010dina|Leton\u0161\u010dina|Hebrej\u0161\u010dina|\u010ce\u0161\u010dina|Italijan\u0161\u010dina|Litov\u0161\u010dina|Franco\u0161\u010dina|Kitaj\u0161\u010dina|Ru\u0161\u010dina|Romun\u0161\u010dina|Fin\u0161\u010dina|Arab\u0161\u010dina|\u0160ved\u0161\u010dina|Portugal\u0161\u010dina|Polj\u0161\u010dina|Sloven\u0161\u010dina|Slova\u0161\u010dina|Nem\u0161\u010dina|Mad\u017ear\u0161\u010dina|Eston\u0161\u010dina|\u0160pan\u0161\u010dina|Hrva\u0161\u010dina|Dan\u0161\u010dina";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "yy.M.d" },
    { "mediumDateFormat", "yyyy.M.d" },
    { "longDateFormat", "dd. MMMM yyyy" },
    { "fullDateFormat", "EEEE, dd. MMMM yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
