/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import java.util.HashMap;

public class ImmutableTextDescriptor
extends TextDescriptor {
    private final boolean display;
    private final long bits;
    private final int colorIndex;
    private final TextDescriptor.Code code;
    private static final HashMap allDescriptors = new HashMap();

    private ImmutableTextDescriptor(TextDescriptor descriptor) {
        boolean display = descriptor.isDisplay();
        long bits = descriptor.lowLevelGet();
        if ((bits & 0xFL) >> 0 > 9L) {
            bits = bits & 0xFFFFFFFFFFFFFFF0L | 0L;
        }
        if ((bits & 0x30L) != 0L) {
            bits = bits & 0xFFFFFFFFFFFFFFCFL | 0x20L;
        }
        if ((bits & 0x7FFF00000000L) == 0L) {
            bits |= 0x10000000000L;
        }
        if (!display) {
            bits &= VTSEMANTIC;
        }
        this.display = display;
        this.bits = bits;
        this.colorIndex = display ? descriptor.getColorIndex() : 0;
        this.code = descriptor.getCode();
    }

    public static ImmutableTextDescriptor newImmutableTextDescriptor(TextDescriptor td) {
        if (td instanceof ImmutableTextDescriptor) {
            return (ImmutableTextDescriptor)td;
        }
        ImmutableTextDescriptor cacheTd = (ImmutableTextDescriptor)allDescriptors.get(td);
        if (cacheTd != null) {
            return cacheTd;
        }
        ImmutableTextDescriptor itd = new ImmutableTextDescriptor(td);
        if (!itd.equals(td) && (cacheTd = (ImmutableTextDescriptor)allDescriptors.get(itd)) != null) {
            return cacheTd;
        }
        allDescriptors.put(itd, itd);
        return itd;
    }

    public ImmutableTextDescriptor withoutParam() {
        if (!this.isParam()) {
            return this;
        }
        MutableTextDescriptor mtd = new MutableTextDescriptor(this);
        mtd.setParam(false);
        return ImmutableTextDescriptor.newImmutableTextDescriptor(mtd);
    }

    public ImmutableTextDescriptor withDisplayWithoutParamAndCode() {
        if (this.isDisplay() && !this.isParam() && !this.isCode()) {
            return this;
        }
        MutableTextDescriptor mtd = new MutableTextDescriptor(this);
        mtd.setDisplay(true);
        mtd.setParam(false);
        mtd.setCode(TextDescriptor.Code.NONE);
        return ImmutableTextDescriptor.newImmutableTextDescriptor(mtd);
    }

    public static int cacheSize() {
        return allDescriptors.size();
    }

    public boolean isDisplay() {
        return this.display;
    }

    public long lowLevelGet() {
        return this.bits;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public TextDescriptor.Code getCode() {
        return this.code;
    }

    public static ImmutableTextDescriptor getNodeTextDescriptor() {
        return cacheNodeDescriptor.newTextDescriptor(true);
    }

    public static ImmutableTextDescriptor getArcTextDescriptor() {
        return cacheArcDescriptor.newTextDescriptor(true);
    }

    public static ImmutableTextDescriptor getExportTextDescriptor() {
        return cacheExportDescriptor.newTextDescriptor(true);
    }

    public static ImmutableTextDescriptor getAnnotationTextDescriptor() {
        return cacheAnnotationDescriptor.newTextDescriptor(true);
    }

    public static ImmutableTextDescriptor getInstanceTextDescriptor() {
        return cacheInstanceDescriptor.newTextDescriptor(true);
    }

    public static ImmutableTextDescriptor getCellTextDescriptor() {
        return cacheCellDescriptor.newTextDescriptor(true);
    }
}

