/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.NetworkHighlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class Highlighter
implements DatabaseChangeListener {
    private static Highlighter currentHighlighter = null;
    private int highOffX = 0;
    private int highOffY = 0;
    private List highlightList = new ArrayList();
    private List highlightStack = new ArrayList();
    private boolean changed = false;
    private List highlightListeners = new ArrayList();
    private Highlight lastHighlightListEndObj;
    private int showNetworkLevel;
    private int type;
    private WindowFrame wf;
    public static final int SELECT_HIGHLIGHTER = 0;
    public static final int MOUSEOVER_HIGHLIGHTER = 1;
    private static final int EXACTSELECTDISTANCE = 5;

    public Highlighter(int type, WindowFrame wf) {
        Undo.addDatabaseChangeListener(this);
        if (currentHighlighter == null) {
            currentHighlighter = this;
        }
        this.lastHighlightListEndObj = null;
        this.showNetworkLevel = 0;
        this.type = type;
        this.wf = wf;
    }

    public void delete() {
        Undo.removeDatabaseChangeListener(this);
    }

    public Highlight addElectricObject(ElectricObject eobj, Cell cell) {
        return this.addElectricObject(eobj, cell, true);
    }

    public Highlight addElectricObject(ElectricObject eobj, Cell cell, boolean highlightConnected) {
        Highlight h = new Highlight(Highlight.Type.EOBJ, eobj, cell);
        h.setHighlightConnected(highlightConnected);
        this.addHighlight(h);
        return h;
    }

    public Highlight addText(ElectricObject eobj, Cell cell, Variable var, Name name) {
        Highlight h = new Highlight(Highlight.Type.TEXT, eobj, cell);
        h.setVar(var);
        h.setName(name);
        this.addHighlight(h);
        return h;
    }

    public Highlight addMessage(Cell cell, String message, Point2D loc) {
        Highlight h = new Highlight(Highlight.Type.MESSAGE, null, cell);
        h.setMessage(message);
        h.setLocation(loc);
        this.addHighlight(h);
        return h;
    }

    public Highlight addArea(Rectangle2D area, Cell cell) {
        Highlight h = new Highlight(Highlight.Type.BBOX, null, cell);
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(area);
        h.setBounds(bounds);
        this.addHighlight(h);
        return h;
    }

    public Highlight addObject(Object obj, Highlight.Type type, Cell cell) {
        Highlight h = new Highlight(type, null, cell);
        h.setObject(obj);
        this.addHighlight(h);
        return h;
    }

    public Highlight addLine(Point2D start, Point2D end, Cell cell) {
        Highlight h = new Highlight(Highlight.Type.LINE, null, cell);
        h.setLineStart(new Point2D.Double(start.getX(), start.getY()));
        h.setLineEnd(new Point2D.Double(end.getX(), end.getY()));
        this.addHighlight(h);
        return h;
    }

    public Highlight addThickLine(Point2D start, Point2D end, Point2D center, Cell cell) {
        Highlight h = new Highlight(Highlight.Type.THICKLINE, null, cell);
        h.setLineStart(new Point2D.Double(start.getX(), start.getY()));
        h.setLineEnd(new Point2D.Double(end.getX(), end.getY()));
        h.setCenter(new Point2D.Double(center.getX(), center.getY()));
        this.addHighlight(h);
        return h;
    }

    public Highlight addPoly(Poly poly, Cell cell, Color color) {
        Highlight h = new Highlight(Highlight.Type.POLY, null, cell);
        h.setPoly(poly);
        h.setColor(color);
        this.addHighlight(h);
        return h;
    }

    public void addNetwork(Network net, Cell cell) {
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted highlighting (network information unavailable).  Please try again");
            return;
        }
        List highlights = NetworkHighlighter.getHighlights(cell, netlist, net, 0, 0);
        Iterator it = highlights.iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            this.addHighlight(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNetworks(Set nets, Netlist netlist, Cell cell) {
        int showNetworkLevel;
        Highlighter highlighter = this;
        synchronized (highlighter) {
            showNetworkLevel = this.showNetworkLevel;
        }
        if (showNetworkLevel == 0) {
            this.clear();
        }
        int count = 0;
        Iterator netIt = nets.iterator();
        while (netIt.hasNext()) {
            Network net = (Network)netIt.next();
            if (showNetworkLevel == 0) {
                System.out.println("Highlighting " + net);
            }
            List highlights = NetworkHighlighter.getHighlights(cell, netlist, net, showNetworkLevel, showNetworkLevel);
            Iterator it = highlights.iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                this.addHighlight(h);
                ++count;
            }
        }
        Highlighter highlighter2 = this;
        synchronized (highlighter2) {
            this.showNetworkLevel = showNetworkLevel + 1;
        }
        if (count == 0) {
            System.out.println("Nothing more in hierarchy on network(s) to show");
        }
    }

    private synchronized void addHighlight(Highlight h) {
        if (h == null) {
            return;
        }
        this.highlightList.add(h);
        this.changed = true;
    }

    public void clear() {
        this.clear(true);
    }

    private synchronized void clear(boolean resetLastHighlightListEndObj) {
        this.highOffY = 0;
        this.highOffX = 0;
        this.showNetworkLevel = 0;
        if (this.highlightList.size() == 0) {
            return;
        }
        if (resetLastHighlightListEndObj) {
            this.lastHighlightListEndObj = (Highlight)this.highlightList.get(this.highlightList.size() - 1);
        }
        this.highlightList.clear();
        this.changed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        Highlighter highlighter = this;
        synchronized (highlighter) {
            Iterator it = this.getHighlights().iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.isValid()) continue;
                this.remove(h);
                this.changed = true;
            }
            if (!this.changed) {
                return;
            }
        }
        boolean mixedArc = false;
        ArcProto foundArcProto = null;
        Iterator it = this.getHighlights().iterator();
        while (it.hasNext()) {
            ElectricObject eobj;
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
            ArcProto ap = ((ArcInst)eobj).getProto();
            if (foundArcProto == null) {
                foundArcProto = ap;
                continue;
            }
            if (foundArcProto == ap) continue;
            mixedArc = true;
        }
        if (this.type == 0 && foundArcProto != null && !mixedArc) {
            User.getUserTool().setCurrentArcProto(foundArcProto);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Highlighter.this.fireHighlightChanged();
                }
            });
        } else {
            this.fireHighlightChanged();
        }
    }

    private synchronized Highlight getLastSelected(List underCursor) {
        List currentHighlights = this.getHighlights();
        Iterator igIt = underCursor.iterator();
        while (igIt.hasNext()) {
            Highlight h = (Highlight)igIt.next();
            Iterator it = currentHighlights.iterator();
            while (it.hasNext()) {
                Highlight curHigh = (Highlight)it.next();
                if (!h.sameThing(curHigh)) continue;
                return this.lastHighlightListEndObj;
            }
        }
        if (currentHighlights.size() > 0) {
            return (Highlight)currentHighlights.get(currentHighlights.size() - 1);
        }
        return this.lastHighlightListEndObj;
    }

    public synchronized void copyState(Highlighter highlighter) {
        this.clear();
        this.lastHighlightListEndObj = highlighter.lastHighlightListEndObj;
        Iterator it = highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            Highlight copy = (Highlight)h.clone();
            this.addHighlight(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showHighlights(EditWindow wnd, Graphics g) {
        int highOffY;
        int highOffX;
        int num = this.getNumHighlights();
        Highlighter highlighter = this;
        synchronized (highlighter) {
            highOffX = this.highOffX;
            highOffY = this.highOffY;
        }
        Iterator it = this.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getCell() != wnd.getCell()) continue;
            Color color = new Color(User.getColorHighlight());
            BasicStroke stroke = Highlight.solidLine;
            if (this.type == 1) {
                color = new Color(51, 255, 255);
                stroke = Highlight.solidLine;
                h.setHighlightConnected(false);
            }
            h.showHighlight(wnd, g, highOffX, highOffY, num == 1, color, stroke);
        }
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    public synchronized void addHighlightListener(HighlightListener l) {
        this.highlightListeners.add(l);
    }

    public synchronized void removeHighlightListener(HighlightListener l) {
        this.highlightListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHighlightChanged() {
        ArrayList listenersCopy;
        Highlighter highlighter = this;
        synchronized (highlighter) {
            listenersCopy = new ArrayList(this.highlightListeners);
        }
        Iterator it = listenersCopy.iterator();
        while (it.hasNext()) {
            HighlightListener l = (HighlightListener)it.next();
            l.highlightChanged(this);
        }
        highlighter = this;
        synchronized (highlighter) {
            this.changed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireHighlighterLostFocus(Highlighter highlighterGainedFocus) {
        ArrayList listenersCopy;
        Highlighter highlighter = this;
        synchronized (highlighter) {
            listenersCopy = new ArrayList(this.highlightListeners);
        }
        Iterator it = listenersCopy.iterator();
        while (it.hasNext()) {
            HighlightListener l = (HighlightListener)it.next();
            l.highlighterLostFocus(highlighterGainedFocus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gainedFocus() {
        Highlighter oldHighlighter = null;
        Highlighter highlighter = currentHighlighter;
        synchronized (highlighter) {
            oldHighlighter = currentHighlighter;
            currentHighlighter = this;
        }
        if (oldHighlighter != null && oldHighlighter != this) {
            oldHighlighter.fireHighlighterLostFocus(this);
        }
    }

    public synchronized void pushHighlight() {
        ArrayList pushable = new ArrayList();
        Iterator it = this.highlightList.iterator();
        while (it.hasNext()) {
            pushable.add(it.next());
        }
        this.highlightStack.add(pushable);
    }

    public synchronized void popHighlight() {
        int stackSize = this.highlightStack.size();
        if (stackSize <= 0) {
            System.out.println("There is no highlighting saved on the highlight stack");
            return;
        }
        List popable = (List)this.highlightStack.get(stackSize - 1);
        this.highlightStack.remove(stackSize - 1);
        this.clear();
        Iterator it = popable.iterator();
        while (it.hasNext()) {
            Highlight newH;
            Highlight h = (Highlight)it.next();
            Highlight.Type type = h.getType();
            Cell cell = h.getCell();
            ElectricObject eobj = h.getElectricObject();
            if (type == Highlight.Type.EOBJ) {
                if (!cell.objInCell(eobj)) continue;
                newH = this.addElectricObject(eobj, cell);
                newH.setPoint(h.getPoint());
                continue;
            }
            if (type == Highlight.Type.TEXT) {
                if (!cell.objInCell(eobj)) continue;
                newH = this.addText(eobj, cell, h.getVar(), h.getName());
                continue;
            }
            if (type == Highlight.Type.BBOX) {
                newH = this.addArea(h.getBounds(), cell);
                continue;
            }
            if (type == Highlight.Type.LINE) {
                newH = this.addLine(h.getLineStart(), h.getLineEnd(), cell);
                continue;
            }
            if (type == Highlight.Type.THICKLINE) {
                newH = this.addThickLine(h.getLineStart(), h.getLineEnd(), h.getCenter(), cell);
                continue;
            }
            if (type != Highlight.Type.MESSAGE) continue;
            newH = this.addMessage(cell, h.getMessage(), h.getCenter());
        }
        this.finished();
    }

    public synchronized void remove(Highlight h) {
        this.highlightList.remove(h);
    }

    public synchronized int getNumHighlights() {
        return this.highlightList.size();
    }

    public synchronized List getHighlights() {
        ArrayList highlightsCopy = new ArrayList(this.highlightList);
        return highlightsCopy;
    }

    public synchronized void setHighlightList(List newHighlights) {
        this.clear();
        Iterator it = newHighlights.iterator();
        while (it.hasNext()) {
            this.highlightList.add(it.next());
        }
        this.changed = true;
    }

    public List getHighlightedEObjs(boolean wantNodes, boolean wantArcs) {
        ArrayList<ElectricObject> highlightedGeoms = new ArrayList<ElectricObject>();
        Iterator it = this.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() == Highlight.Type.EOBJ || h.getType() == Highlight.Type.TEXT) {
                Geometric geom = h.getGeometric();
                if (geom == null || !wantNodes && geom instanceof NodeInst || !wantArcs && geom instanceof ArcInst || highlightedGeoms.contains(geom)) continue;
                highlightedGeoms.add(geom);
            }
            if (h.getType() != Highlight.Type.BBOX) continue;
            List inArea = this.findAllInArea(h.getCell(), false, false, false, false, false, false, h.getBounds(), null);
            Iterator ait = inArea.iterator();
            while (ait.hasNext()) {
                Highlight ah = (Highlight)ait.next();
                if (ah.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj = ah.getElectricObject();
                if (!wantNodes && (eobj instanceof NodeInst || eobj instanceof PortInst) || !wantArcs && eobj instanceof ArcInst) continue;
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                highlightedGeoms.add(eobj);
            }
        }
        return highlightedGeoms;
    }

    public Set getHighlightedNetworks() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            return ww.getHighlightedNetworks();
        }
        Set<Network> nets = new HashSet();
        Cell cell = WindowFrame.getCurrentCell();
        if (cell != null) {
            Netlist netlist = cell.acquireUserNetlist();
            if (netlist == null) {
                String msg = "Selected networks are not ready";
                System.out.println(msg);
                ActivityLogger.logMessage(msg);
                return nets;
            }
            Iterator it = this.getHighlights().iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.getType() == Highlight.Type.EOBJ) {
                    PortInst pi;
                    NodeInst ni;
                    ElectricObject eObj = h.getElectricObject();
                    if (eObj instanceof NodeInst && (ni = (NodeInst)eObj).getNumPortInsts() == 1 && (pi = ni.getOnlyPortInst()) != null) {
                        eObj = pi;
                    }
                    if (eObj instanceof PortInst) {
                        PortInst pi2 = (PortInst)eObj;
                        nets = NetworkTool.getNetworksOnPort(pi2, netlist, nets);
                        continue;
                    }
                    if (!(eObj instanceof ArcInst)) continue;
                    ArcInst ai = (ArcInst)eObj;
                    int width = netlist.getBusWidth(ai);
                    for (int i = 0; i < width; ++i) {
                        Network net = netlist.getNetwork((ArcInst)eObj, i);
                        if (net == null) continue;
                        nets.add(net);
                    }
                    continue;
                }
                if (h.getType() != Highlight.Type.TEXT || h.getVar() != null || h.getName() != null || !(h.getElectricObject() instanceof Export)) continue;
                Export pp = (Export)h.getElectricObject();
                int width = netlist.getBusWidth(pp);
                for (int i = 0; i < width; ++i) {
                    Network net = netlist.getNetwork(pp, i);
                    if (net == null) continue;
                    nets.add(net);
                }
            }
        }
        return nets;
    }

    public List getHighlightedText(boolean unique) {
        ArrayList<Highlight> highlightedText = new ArrayList<Highlight>();
        Iterator it = this.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.TEXT || highlightedText.contains(h)) continue;
            if (unique) {
                ElectricObject eobj = h.getElectricObject();
                ElectricObject onObj = null;
                if (h.getVar() != null) {
                    if (eobj instanceof Export) {
                        onObj = ((Export)eobj).getOriginalPort().getNodeInst();
                    } else if (eobj instanceof PortInst) {
                        onObj = ((PortInst)eobj).getNodeInst();
                    } else if (eobj instanceof Geometric) {
                        onObj = eobj;
                    }
                } else if (h.getName() != null) {
                    if (eobj instanceof Geometric) {
                        onObj = eobj;
                    }
                } else if (eobj instanceof Export) {
                    onObj = ((Export)eobj).getOriginalPort().getNodeInst();
                } else if (eobj instanceof NodeInst) {
                    onObj = eobj;
                }
                if (eobj != null) {
                    boolean found = false;
                    Iterator fIt = this.getHighlights().iterator();
                    while (fIt.hasNext()) {
                        Highlight oH = (Highlight)fIt.next();
                        if (oH.getType() != Highlight.Type.EOBJ) continue;
                        ElectricObject fobj = oH.getElectricObject();
                        if (fobj instanceof PortInst) {
                            fobj = ((PortInst)fobj).getNodeInst();
                        }
                        if (fobj != onObj) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
            }
            highlightedText.add(h);
        }
        return highlightedText;
    }

    public Rectangle2D getHighlightedArea(EditWindow wnd) {
        Rectangle2D.Double bounds = null;
        Iterator it = this.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            Rectangle2D highBounds = null;
            if (h.getType() == Highlight.Type.EOBJ) {
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (eobj instanceof Geometric) {
                    Geometric geom = (Geometric)eobj;
                    highBounds = geom.getBounds();
                }
            } else if (h.getType() == Highlight.Type.TEXT) {
                Poly poly;
                if (wnd != null && (poly = h.getElectricObject().computeTextPoly(wnd, h.getVar(), h.getName())) != null) {
                    highBounds = poly.getBounds2D();
                }
            } else if (h.getType() == Highlight.Type.BBOX) {
                highBounds = h.getBounds();
            } else if (h.getType() == Highlight.Type.LINE || h.getType() == Highlight.Type.THICKLINE) {
                Point2D pt1 = h.getLineStart();
                Point2D pt2 = h.getLineEnd();
                double cX = (pt1.getX() + pt2.getX()) / 2.0;
                double cY = (pt1.getY() + pt2.getY()) / 2.0;
                double sX = Math.abs(pt1.getX() - pt2.getX());
                double sY = Math.abs(pt1.getY() - pt2.getY());
                highBounds = new Rectangle2D.Double(cX, cY, sX, sY);
            } else if (h.getType() == Highlight.Type.MESSAGE) {
                highBounds = new Rectangle2D.Double(h.getLocation().getX(), h.getLocation().getY(), 0.0, 0.0);
            }
            if (highBounds == null) continue;
            if (bounds == null) {
                bounds = new Rectangle2D.Double();
                ((Rectangle2D)bounds).setRect(highBounds);
                continue;
            }
            Rectangle2D.union(bounds, highBounds, bounds);
        }
        return bounds;
    }

    public Highlight getOneHighlight() {
        if (this.getNumHighlights() == 0) {
            System.out.println("Must select an object first");
            return null;
        }
        Highlight h = null;
        Iterator it = this.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight theH = (Highlight)it.next();
            if (theH.getElectricObject() == null) continue;
            return theH;
        }
        if (h == null) {
            System.out.println("Must select an object first");
            return null;
        }
        return h;
    }

    public ElectricObject getOneElectricObject(Class type) {
        Highlight high = this.getOneHighlight();
        if (high == null) {
            return null;
        }
        if (high.getType() != Highlight.Type.EOBJ) {
            System.out.println("Must first select an object");
            return null;
        }
        ElectricObject eobj = high.getElectricObject();
        if (type == NodeInst.class && eobj instanceof PortInst) {
            eobj = ((PortInst)eobj).getNodeInst();
        }
        if (type != eobj.getClass()) {
            System.out.println("Wrong type of object is selected");
            System.out.println(" (Wanted " + type.toString() + " but got " + eobj.getClass().toString() + ")");
            return null;
        }
        return eobj;
    }

    public synchronized void setHighlightOffset(int offX, int offY) {
        this.highOffX = offX;
        this.highOffY = offY;
    }

    public synchronized Point2D getHighlightOffset() {
        return new Point2D.Double(this.highOffX, this.highOffY);
    }

    public void selectArea(EditWindow wnd, double minSelX, double maxSelX, double minSelY, double maxSelY, boolean invertSelection, boolean findSpecial) {
        Rectangle2D.Double searchArea = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
        List underCursor = this.findAllInArea(wnd.getCell(), false, false, false, false, findSpecial, true, searchArea, wnd);
        if (invertSelection) {
            Iterator it = underCursor.iterator();
            while (it.hasNext()) {
                Highlight newHigh = (Highlight)it.next();
                boolean found = false;
                Iterator it2 = this.getHighlights().iterator();
                while (it2.hasNext()) {
                    Highlight oldHigh = (Highlight)it2.next();
                    if (!newHigh.sameThing(oldHigh)) continue;
                    this.remove(oldHigh);
                    found = true;
                    break;
                }
                if (found) continue;
                this.addHighlight(newHigh);
            }
        } else {
            this.setHighlightList(underCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean overHighlighted(EditWindow wnd, int x, int y) {
        Iterator it = this.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight got;
            Highlight h = (Highlight)it.next();
            Highlight.Type style = h.getType();
            if (style == Highlight.Type.TEXT) {
                Point2D start = wnd.screenToDatabase(x, y);
                Poly poly = h.getElectricObject().computeTextPoly(wnd, h.getVar(), h.getName());
                if (poly == null || !poly.isInside(start)) continue;
                return true;
            }
            if (style != Highlight.Type.EOBJ) continue;
            Point2D slop = wnd.deltaScreenToDatabase(10, 10);
            double directHitDist = slop.getX();
            Point2D start = wnd.screenToDatabase(x, y);
            Rectangle2D.Double searchArea = new Rectangle2D.Double(start.getX(), start.getY(), 0.0, 0.0);
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                eobj = ((PortInst)eobj).getNodeInst();
            }
            if (!(eobj instanceof Geometric) || (got = Highlighter.checkOutObject((Geometric)eobj, true, false, true, searchArea, wnd, directHitDist, false)) == null) continue;
            ElectricObject hObj = got.getElectricObject();
            ElectricObject hReal = hObj;
            if (hReal instanceof PortInst) {
                hReal = ((PortInst)hReal).getNodeInst();
            }
            Iterator sIt = this.getHighlights().iterator();
            while (sIt.hasNext()) {
                Highlight alreadyHighlighted = (Highlight)sIt.next();
                if (alreadyHighlighted.getType() != got.getType()) continue;
                ElectricObject aHObj = alreadyHighlighted.getElectricObject();
                ElectricObject aHReal = aHObj;
                if (aHReal instanceof PortInst) {
                    aHReal = ((PortInst)aHReal).getNodeInst();
                }
                if (hReal != aHReal) continue;
                if (hObj == aHObj && alreadyHighlighted.getPoint() == got.getPoint()) break;
                alreadyHighlighted.setElectricObject(got.getElectricObject());
                alreadyHighlighted.setPoint(got.getPoint());
                Highlighter highlighter = this;
                synchronized (highlighter) {
                    this.changed = true;
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public static Point2D[] describeHighlightText(EditWindow wnd, ElectricObject eObj, Variable var, Name name) {
        if (!Job.acquireExamineLock(false)) {
            return null;
        }
        Poly.Type style = null;
        Point2D[] points = null;
        Rectangle2D bounds = null;
        try {
            Poly poly = eObj.computeTextPoly(wnd, var, name);
            if (poly == null) {
                Job.releaseExamineLock();
                return null;
            }
            bounds = poly.getBounds2D();
            style = poly.getStyle();
            if ((style = Poly.rotateType(style, eObj)) == Poly.Type.TEXTBOX && eObj instanceof Geometric) {
                bounds = ((Geometric)eObj).getBounds();
            }
            Job.releaseExamineLock();
        }
        catch (Error e) {
            Job.releaseExamineLock();
            throw e;
        }
        if (style == Poly.Type.TEXTCENT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTBOT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTTOP) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTLEFT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTRIGHT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTTOPLEFT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTBOTLEFT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTTOPRIGHT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTBOTRIGHT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTBOX) {
            points = new Point2D.Double[12];
            double lX = bounds.getMinX();
            double hX = bounds.getMaxX();
            double lY = bounds.getMinY();
            double hY = bounds.getMaxY();
            points[0] = new Point2D.Double(lX, lY);
            points[1] = new Point2D.Double(hX, hY);
            points[2] = new Point2D.Double(lX, hY);
            points[3] = new Point2D.Double(hX, lY);
            double shrinkX = (hX - lX) / 5.0;
            double shrinkY = (hY - lY) / 5.0;
            points[4] = new Point2D.Double(lX + shrinkX, lY);
            points[5] = new Point2D.Double(hX - shrinkX, lY);
            points[6] = new Point2D.Double(lX + shrinkX, hY);
            points[7] = new Point2D.Double(hX - shrinkX, hY);
            points[8] = new Point2D.Double(lX, lY + shrinkY);
            points[9] = new Point2D.Double(lX, hY - shrinkY);
            points[10] = new Point2D.Double(hX, lY + shrinkY);
            points[11] = new Point2D.Double(hX, hY - shrinkY);
        }
        return points;
    }

    public int findObject(Point2D pt, EditWindow wnd, boolean exclusively, boolean another, boolean invert, boolean findPort, boolean findPoint, boolean findSpecial, boolean findText) {
        List highlightList;
        Rectangle2D.Double bounds;
        double bestdist = Double.MAX_VALUE;
        boolean looping = false;
        Cell cell = wnd.getCell();
        ArrayList<Highlight> underCursor = this.findAllInArea(cell, exclusively, another, findPort, findPoint, findSpecial, findText, bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0), wnd);
        if (underCursor.size() == 0) {
            if (!invert) {
                this.clear();
                this.finished();
            }
            return 0;
        }
        Highlight lastSelected = this.getLastSelected(underCursor);
        if (lastSelected != null) {
            ArrayList<Highlight> newUnderCursor = new ArrayList<Highlight>();
            while (!underCursor.isEmpty()) {
                Highlight h = Highlighter.getSimiliarHighlight(underCursor, lastSelected);
                newUnderCursor.add(h);
                underCursor.remove(h);
            }
            underCursor = newUnderCursor;
        }
        if (underCursor.size() > 1 && another) {
            for (int j = 0; j < this.getNumHighlights(); ++j) {
                highlightList = this.getHighlights();
                Highlight oldHigh = (Highlight)highlightList.get(j);
                for (int i = 0; i < underCursor.size(); ++i) {
                    if (!oldHigh.sameThing((Highlight)underCursor.get(i))) continue;
                    if (invert) {
                        this.remove(oldHigh);
                    } else {
                        this.clear(false);
                    }
                    if (i < underCursor.size() - 1) {
                        this.addHighlight((Highlight)underCursor.get(i + 1));
                    } else {
                        this.addHighlight((Highlight)underCursor.get(0));
                    }
                    this.finished();
                    return 1;
                }
            }
        }
        if (invert) {
            Highlight newHigh = (Highlight)underCursor.get(0);
            highlightList = this.getHighlights();
            for (int i = 0; i < highlightList.size(); ++i) {
                if (!newHigh.sameThing((Highlight)highlightList.get(i))) continue;
                this.remove((Highlight)highlightList.get(i));
                this.finished();
                return 1;
            }
            this.addHighlight(newHigh);
            this.finished();
        } else {
            this.clear();
            this.addHighlight((Highlight)underCursor.get(0));
            this.finished();
        }
        return 1;
    }

    private void printHighlightList(List highs) {
        int i = 0;
        Iterator it = highs.iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            System.out.println("highlight " + i + ": " + h.getElectricObject());
            ++i;
        }
    }

    public List findAllInArea(Cell cell, boolean exclusively, boolean another, boolean findPort, boolean findPoint, boolean findSpecial, boolean findText, Rectangle2D bounds, EditWindow wnd) {
        ArrayList<Highlight> list = new ArrayList<Highlight>();
        boolean areaMustEnclose = User.isDraggingMustEncloseObjects();
        double directHitDist = 0.0;
        if (wnd != null) {
            Point2D extra = wnd.deltaScreenToDatabase(5, 5);
            directHitDist = extra.getX();
        }
        if (!Job.acquireExamineLock(false)) {
            return list;
        }
        try {
            if (findText && wnd != null) {
                Poly[] polys;
                if (User.isTextVisibilityOnCell() && (polys = cell.getAllText(findSpecial, wnd)) != null) {
                    for (int i = 0; i < polys.length; ++i) {
                        Poly poly = polys[i];
                        if (poly == null || poly.setExactTextBounds(wnd, cell) || (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0) ? !poly.isInside(bounds) : poly.polyDistance(bounds) >= directHitDist)) continue;
                        Highlight h = new Highlight(Highlight.Type.TEXT, cell, cell);
                        h.setVar(poly.getVariable());
                        list.add(h);
                    }
                }
                Iterator it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = (NodeInst)it.next();
                    AffineTransform trans = ni.rotateOut();
                    EditWindow subWnd = wnd;
                    Poly[] polys2 = ni.getAllText(findSpecial, wnd);
                    if (polys2 == null) continue;
                    for (int i = 0; i < polys2.length; ++i) {
                        double hitdist;
                        Poly poly = polys2[i];
                        if (poly == null) continue;
                        poly.transform(trans);
                        if (poly.setExactTextBounds(wnd, ni) || (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0) ? !poly.isInside(bounds) : (hitdist = poly.polyDistance(bounds)) >= directHitDist)) continue;
                        Highlight h = new Highlight(Highlight.Type.TEXT, null, cell);
                        if (poly.getPort() != null) {
                            PortProto pp = poly.getPort();
                            if (pp instanceof Export) {
                                h.setElectricObject((Export)pp);
                            }
                            Iterator pIt = ni.getPortInsts();
                            while (pIt.hasNext()) {
                                PortInst pi = (PortInst)pIt.next();
                                if (pi.getPortProto() != pp) continue;
                                h.setElectricObject(pi);
                                break;
                            }
                        } else {
                            h.setElectricObject(ni);
                        }
                        h.setVar(poly.getVariable());
                        h.setName(poly.getName());
                        list.add(h);
                    }
                }
                it = cell.getArcs();
                while (it.hasNext()) {
                    Poly[] polys3;
                    ArcInst ai = (ArcInst)it.next();
                    if (!User.isTextVisibilityOnArc() || (polys3 = ai.getAllText(findSpecial, wnd)) == null) continue;
                    for (int i = 0; i < polys3.length; ++i) {
                        Poly poly = polys3[i];
                        if (poly.setExactTextBounds(wnd, ai) || (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0) ? !poly.isInside(bounds) : poly.polyDistance(bounds) >= directHitDist)) continue;
                        Highlight h = new Highlight(Highlight.Type.TEXT, ai, cell);
                        h.setVar(poly.getVariable());
                        h.setName(poly.getName());
                        list.add(h);
                    }
                }
            }
            if (exclusively) {
                Iterator sIt = this.getHighlights().iterator();
                while (sIt.hasNext()) {
                    Highlight h = (Highlight)sIt.next();
                    if (h.getType() != Highlight.Type.EOBJ) continue;
                    ElectricObject eobj = h.getElectricObject();
                    if (eobj instanceof PortInst) {
                        eobj = ((PortInst)eobj).getNodeInst();
                    }
                    if (!(eobj instanceof NodeInst) || (h = Highlighter.checkOutObject((Geometric)eobj, findPort, findPoint, findSpecial, bounds, wnd, Double.MAX_VALUE, areaMustEnclose)) == null) continue;
                    list.add(h);
                }
                Job.releaseExamineLock();
                return list;
            }
            Rectangle2D.Double searchArea = new Rectangle2D.Double(bounds.getMinX() - directHitDist, bounds.getMinY() - directHitDist, bounds.getWidth() + directHitDist * 2.0, bounds.getHeight() + directHitDist * 2.0);
            for (int phase = 0; phase < 3; ++phase) {
                if (phase == 0 && !findSpecial && !User.isEasySelectionOfCellInstances()) continue;
                Iterator it = cell.searchIterator(searchArea);
                while (it.hasNext()) {
                    Geometric geom = (Geometric)it.next();
                    switch (phase) {
                        case 0: {
                            Highlight h;
                            if (!(geom instanceof NodeInst) || ((NodeInst)geom).getProto() instanceof Cell || (h = Highlighter.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                            list.add(h);
                            break;
                        }
                        case 1: {
                            Highlight h;
                            if (!(geom instanceof NodeInst) || ((NodeInst)geom).getProto() instanceof PrimitiveNode || (h = Highlighter.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                            list.add(h);
                            break;
                        }
                        case 2: {
                            Highlight h;
                            if (!(geom instanceof ArcInst) || (h = Highlighter.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                            list.add(h);
                        }
                    }
                }
            }
            Job.releaseExamineLock();
        }
        catch (Error e) {
            Job.releaseExamineLock();
            throw e;
        }
        return list;
    }

    private static Highlight checkOutObject(Geometric geom, boolean findPort, boolean findPoint, boolean findSpecial, Rectangle2D bounds, EditWindow wnd, double directHitDist, boolean areaMustEnclose) {
        if (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0)) {
            Poly poly = null;
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                poly = Highlight.getNodeInstOutline(ni);
            } else {
                ArcInst ai = (ArcInst)geom;
                poly = ai.makePoly(ai.getLength(), ai.getWidth() - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
            }
            if (poly == null) {
                return null;
            }
            if (!poly.isInside(bounds)) {
                return null;
            }
            Highlight h = new Highlight(Highlight.Type.EOBJ, geom, geom.getParent());
            return h;
        }
        if (geom instanceof NodeInst) {
            NodeInst ni = (NodeInst)geom;
            boolean hardToSelect = ni.isHardSelect();
            if (ni.getProto() instanceof Cell) {
                if (!User.isEasySelectionOfCellInstances()) {
                    hardToSelect = true;
                }
            } else {
                PrimitiveNode np = (PrimitiveNode)ni.getProto();
                if (np.isNodeInvisible()) {
                    return null;
                }
            }
            if (!findSpecial && hardToSelect) {
                return null;
            }
            if (ni.isInvisiblePinWithText()) {
                return null;
            }
            double dist = Highlighter.distToNode(bounds, ni, wnd);
            if (dist < directHitDist) {
                Highlight h = new Highlight(Highlight.Type.EOBJ, null, geom.getParent());
                Geometric eobj = geom;
                if (findPort) {
                    double bestDist = Double.MAX_VALUE;
                    PortInst bestPort = null;
                    Iterator it = ni.getPortInsts();
                    while (it.hasNext()) {
                        PortInst pi = (PortInst)it.next();
                        Poly poly = pi.getPoly();
                        dist = poly.polyDistance(bounds);
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestPort = pi;
                    }
                    if (bestPort != null) {
                        eobj = bestPort;
                    }
                }
                if (findPoint) {
                    Point2D[] points = ni.getTrace();
                    Point2D.Double cursor = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    if (points != null) {
                        double bestDist = Double.MAX_VALUE;
                        int bestPoint = -1;
                        AffineTransform trans = ni.rotateOutAboutTrueCenter();
                        for (int i = 0; i < points.length; ++i) {
                            Point2D.Double pt = new Point2D.Double(ni.getAnchorCenterX() + points[i].getX(), ni.getAnchorCenterY() + points[i].getY());
                            trans.transform(pt, pt);
                            dist = pt.distance(cursor);
                            if (!(dist < bestDist)) continue;
                            bestDist = dist;
                            bestPoint = i;
                        }
                        if (bestPoint >= 0) {
                            h.setPoint(bestPoint);
                        }
                    }
                }
                h.setElectricObject(eobj);
                return h;
            }
        } else {
            ArcInst ai = (ArcInst)geom;
            if (!findSpecial && ai.isHardSelect()) {
                return null;
            }
            if (ai.getProto().isArcInvisible()) {
                return null;
            }
            double dist = Highlighter.distToArc(bounds, ai, wnd);
            if (dist < directHitDist) {
                Highlight h = new Highlight(Highlight.Type.EOBJ, geom, geom.getParent());
                return h;
            }
        }
        return null;
    }

    public static Highlight getSimiliarHighlight(List highlights, Highlight exampleHigh) {
        if (highlights.size() == 0) {
            return null;
        }
        if (exampleHigh == null) {
            return (Highlight)highlights.get(0);
        }
        ArrayList<Highlight> sameTypes = new ArrayList<Highlight>();
        Iterator it = highlights.iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != exampleHigh.getType()) continue;
            sameTypes.add(h);
        }
        if (sameTypes.size() == 1) {
            return (Highlight)sameTypes.get(0);
        }
        if (sameTypes.size() == 0) {
            return (Highlight)highlights.get(0);
        }
        if (exampleHigh.getType() == Highlight.Type.EOBJ) {
            ArcInst exAi;
            ArrayList<Highlight> sameEObj = new ArrayList<Highlight>();
            Iterator it2 = sameTypes.iterator();
            while (it2.hasNext()) {
                Highlight h = (Highlight)it2.next();
                if (h.getElectricObject().getClass() != exampleHigh.getElectricObject().getClass()) continue;
                sameEObj.add(h);
            }
            if (sameEObj.size() == 1) {
                return (Highlight)sameEObj.get(0);
            }
            if (sameEObj.size() > 0) {
                Highlight h;
                Iterator it3;
                if (exampleHigh.getElectricObject().getClass() == PortInst.class) {
                    PortInst pi;
                    PortInst exPi = (PortInst)exampleHigh.getElectricObject();
                    NodeProto exNp = exPi.getNodeInst().getProto();
                    it3 = sameEObj.iterator();
                    while (it3.hasNext()) {
                        h = (Highlight)it3.next();
                        pi = (PortInst)h.getElectricObject();
                        NodeProto np = pi.getNodeInst().getProto();
                        if (np != exNp) continue;
                        return h;
                    }
                    it3 = sameEObj.iterator();
                    while (it3.hasNext()) {
                        h = (Highlight)it3.next();
                        pi = (PortInst)h.getElectricObject();
                        if (Router.getArcToUse(exPi.getPortProto(), pi.getPortProto()) == null) continue;
                        return h;
                    }
                }
                if (exampleHigh.getElectricObject().getClass() == ArcInst.class) {
                    exAi = (ArcInst)exampleHigh.getElectricObject();
                    ArcProto exAp = exAi.getProto();
                    it3 = sameEObj.iterator();
                    while (it3.hasNext()) {
                        h = (Highlight)it3.next();
                        ArcInst ai = (ArcInst)h.getElectricObject();
                        ArcProto ap = ai.getProto();
                        if (exAp != ap) continue;
                        return h;
                    }
                }
            } else {
                exAi = null;
                PortInst exPi = null;
                if (exampleHigh.getElectricObject().getClass() == ArcInst.class) {
                    exAi = (ArcInst)exampleHigh.getElectricObject();
                }
                if (exampleHigh.getElectricObject().getClass() == PortInst.class) {
                    exPi = (PortInst)exampleHigh.getElectricObject();
                }
                Iterator it4 = sameTypes.iterator();
                while (it4.hasNext()) {
                    Highlight h = (Highlight)it4.next();
                    ArcInst ai = exAi;
                    PortInst pi = exPi;
                    if (h.getElectricObject().getClass() == (class$com$sun$electric$database$topology$ArcInst == null ? Highlighter.class$("com.sun.electric.database.topology.ArcInst") : class$com$sun$electric$database$topology$ArcInst)) {
                        ai = (ArcInst)h.getElectricObject();
                    }
                    if (h.getElectricObject().getClass() == (class$com$sun$electric$database$topology$PortInst == null ? Highlighter.class$("com.sun.electric.database.topology.PortInst") : class$com$sun$electric$database$topology$PortInst)) {
                        pi = (PortInst)h.getElectricObject();
                    }
                    if (ai == null || pi == null || !pi.getPortProto().connectsTo(ai.getProto())) continue;
                    return h;
                }
            }
            if (sameEObj.size() > 0) {
                return (Highlight)sameEObj.get(0);
            }
        }
        return (Highlight)sameTypes.get(0);
    }

    private static double distToNode(Rectangle2D bounds, NodeInst ni, EditWindow wnd) {
        AffineTransform trans = ni.rotateOut();
        NodeProto np = ni.getProto();
        Poly nodePoly = null;
        if (np instanceof PrimitiveNode) {
            PrimitiveNode.Function fun = np.getFunction();
            if (fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRAPMOS || fun == PrimitiveNode.Function.TRADMOS) {
                Technology tech = np.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, wnd);
                double bestDist = Double.MAX_VALUE;
                for (int box = 0; box < polys.length; ++box) {
                    Layer.Function lf;
                    Poly poly = polys[box];
                    Layer layer = poly.getLayer();
                    if (layer == null || !(lf = layer.getFunction()).isPoly() && !lf.isDiff()) continue;
                    poly.transform(trans);
                    double dist = poly.polyDistance(bounds);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (((PrimitiveNode)np).isEdgeSelect()) {
                Technology tech = np.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, wnd);
                double bestDist = Double.MAX_VALUE;
                for (int box = 0; box < polys.length; ++box) {
                    Poly poly = polys[box];
                    poly.transform(trans);
                    double dist = poly.polyDistance(bounds);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            SizeOffset so = ni.getSizeOffset();
            double lX = ni.getAnchorCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
            double hX = ni.getAnchorCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
            double lY = ni.getAnchorCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
            double hY = ni.getAnchorCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
            nodePoly = new Poly((lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY);
        } else {
            Cell subCell = (Cell)np;
            Rectangle2D instBounds = subCell.getBounds();
            nodePoly = new Poly(ni.getAnchorCenterX() + instBounds.getCenterX(), ni.getAnchorCenterY() + instBounds.getCenterY(), instBounds.getWidth(), instBounds.getHeight());
        }
        AffineTransform pureTrans = ni.rotateOut();
        nodePoly.transform(pureTrans);
        nodePoly.setStyle(Poly.Type.FILLED);
        double dist = nodePoly.polyDistance(bounds);
        return dist;
    }

    private static double distToArc(Rectangle2D bounds, ArcInst ai, EditWindow wnd) {
        ArcProto ap = ai.getProto();
        if (ap.isEdgeSelect()) {
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai, wnd);
            double bestDist = Double.MAX_VALUE;
            for (int box = 0; box < polys.length; ++box) {
                Poly poly = polys[box];
                double dist = poly.polyDistance(bounds);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
            }
            return bestDist;
        }
        double wid = ai.getWidth() - ai.getProto().getWidthOffset();
        if (DBMath.doublesEqual(wid, 0.0)) {
            wid = 1.0;
        }
        Poly poly = ai.makePoly(ai.getLength(), wid, Poly.Type.FILLED);
        return poly.polyDistance(bounds);
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        this.finished();
    }
}

