/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.Java3D;

import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.VirtualUniverse;

public class J3DQueryProperties {
    private static void printProps(Map map, String[] propList) {
        try {
            ArrayList keyList = new ArrayList(map.keySet());
            Collections.sort(keyList);
            HashSet<String> hs = new HashSet<String>();
            for (int i = 0; i < propList.length; ++i) {
                int len = propList[i].length();
                int idxWild = propList[i].indexOf(42);
                if (idxWild < 0) {
                    String key = propList[i];
                    if (hs.contains(key)) continue;
                    System.out.println(key + " = " + map.get(key));
                    hs.add(key);
                    continue;
                }
                if (idxWild == len - 1) {
                    String pattern = propList[i].substring(0, len - 1);
                    for (String key : keyList) {
                        if (!key.startsWith(pattern) || hs.contains(key)) continue;
                        System.out.println(key + " = " + map.get(key));
                        hs.add(key);
                    }
                    continue;
                }
                System.out.println(propList[i] + " = ERROR: KEY WITH EMBEDDED WILD CARD IGNORED");
            }
            for (String key : keyList) {
                if (hs.contains(key)) continue;
                System.out.println(key + " = " + map.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void queryHardwareAcceleration() {
        Map vuMap = VirtualUniverse.getProperties();
        String[] vuPropList = new String[]{"j3d.version", "j3d.vendor", "j3d.specification.version", "j3d.specification.vendor", "j3d.*"};
        J3DQueryProperties.printProps(vuMap, vuPropList);
        System.out.println();
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setStereo(2);
        template.setSceneAntialiasing(2);
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
        Map c3dMap = new Canvas3D(config).queryProperties();
        String[] c3dPropList = new String[]{"native.*", "doubleBufferAvailable", "stereoAvailable", "sceneAntialiasing*", "compressedGeometry.majorVersionNumber", "compressedGeometry.minorVersionNumber", "compressedGeometry.*", "textureUnitStateMax", "textureWidthMax", "textureHeightMax"};
        J3DQueryProperties.printProps(c3dMap, c3dPropList);
    }
}

