/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StratDebug2
extends Strategy {
    private StratDebug2(NccGlobals globals) {
        super(globals);
        NccOptions options = globals.getOptions();
        int saveHowMuchStatus = options.howMuchStatus;
        options.howMuchStatus = 10;
        globals.status2("begin search for RK stuff");
        this.doFor(globals.getRoot());
        globals.status2("end search for RK stuff");
        options.howMuchStatus = saveHowMuchStatus;
    }

    private boolean hasRKstuff(Circuit ckt) {
        Iterator<NetObject> it = ckt.getNetObjs();
        while (it.hasNext()) {
            NetObject no = it.next();
            String name = no.getName();
            if (name.indexOf("/rks_") != -1) {
                return true;
            }
            if (name.indexOf("/rkl_") == -1) continue;
            return true;
        }
        return false;
    }

    private boolean hasRKstuff(EquivRecord er) {
        Iterator<Circuit> it = er.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = it.next();
            if (!this.hasRKstuff(ckt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LeafList doFor(EquivRecord er) {
        if (er.isLeaf()) {
            if (this.hasRKstuff(er)) {
                this.globals.status2(er.nameString());
                List<String> reasons = er.getPartitionReasonsFromRootToMe();
                for (String s : reasons) {
                    this.globals.status2("   " + s);
                }
                super.doFor(er);
            }
        } else {
            super.doFor(er);
        }
        return new LeafList();
    }

    @Override
    public HashMap<Integer, List<NetObject>> doFor(Circuit c) {
        this.globals.status2(" " + c.nameString());
        return super.doFor(c);
    }

    @Override
    public Integer doFor(NetObject n) {
        this.globals.status2("  " + n.fullDescription());
        return CODE_NO_CHANGE;
    }

    public static void doYourJob(NccGlobals globals) {
        new StratDebug2(globals);
    }
}

