/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnitsTab
extends PreferencePanel {
    private TextUtils.UnitScale initialUnitsDistance;
    private TextUtils.UnitScale initialUnitsResistance;
    private TextUtils.UnitScale initialUnitsCapacitance;
    private TextUtils.UnitScale initialUnitsInductance;
    private TextUtils.UnitScale initialUnitsAmperage;
    private TextUtils.UnitScale initialUnitsVoltage;
    private TextUtils.UnitScale initialUnitsTime;
    private JLabel jLabel39;
    private JLabel jLabel40;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JLabel jLabel65;
    private JLabel jLabel66;
    private JPanel units;
    private JComboBox unitsCapacitance;
    private JComboBox unitsCurrent;
    private JComboBox unitsDistance;
    private JComboBox unitsInductance;
    private JComboBox unitsResistance;
    private JComboBox unitsTime;
    private JComboBox unitsVoltage;

    public UnitsTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public JPanel getPanel() {
        return this.units;
    }

    @Override
    public String getName() {
        return "Units";
    }

    @Override
    public void init() {
        this.unitsDistance.addItem("Millimeters");
        this.unitsDistance.addItem("Microns");
        this.unitsDistance.addItem("Nanometers");
        this.initialUnitsDistance = User.getDistanceUnits();
        int index = this.initialUnitsDistance.getIndex() - TextUtils.UnitScale.MILLI.getIndex();
        if (index < 0) {
            index = 0;
        }
        if (index >= this.unitsDistance.getItemCount()) {
            index = this.unitsDistance.getItemCount() - 1;
        }
        this.unitsDistance.setSelectedIndex(index);
        this.unitsResistance.addItem("Giga-ohms");
        this.unitsResistance.addItem("Mega-ohms");
        this.unitsResistance.addItem("Kilo-ohms");
        this.unitsResistance.addItem("Ohms");
        this.initialUnitsResistance = User.getResistanceUnits();
        index = this.initialUnitsResistance.getIndex() - TextUtils.UnitScale.GIGA.getIndex();
        if (index < 0) {
            index = 0;
        }
        if (index >= this.unitsDistance.getItemCount()) {
            index = this.unitsDistance.getItemCount() - 1;
        }
        this.unitsResistance.setSelectedIndex(index);
        this.unitsCapacitance.addItem("Farads");
        this.unitsCapacitance.addItem("Milli-farads");
        this.unitsCapacitance.addItem("Micro-farads");
        this.unitsCapacitance.addItem("Nano-farads");
        this.unitsCapacitance.addItem("Pico-farads");
        this.unitsCapacitance.addItem("Femto-farads");
        this.initialUnitsCapacitance = User.getCapacitanceUnits();
        index = this.initialUnitsCapacitance.getIndex() - TextUtils.UnitScale.NONE.getIndex();
        if (index < 0) {
            index = 0;
        }
        if (index >= this.unitsDistance.getItemCount()) {
            index = this.unitsDistance.getItemCount() - 1;
        }
        this.unitsCapacitance.setSelectedIndex(index);
        this.unitsInductance.addItem("Henrys");
        this.unitsInductance.addItem("Milli-henrys");
        this.unitsInductance.addItem("Micro-henrys");
        this.unitsInductance.addItem("Nano-henrys");
        this.initialUnitsInductance = User.getInductanceUnits();
        index = this.initialUnitsInductance.getIndex() - TextUtils.UnitScale.NONE.getIndex();
        if (index < 0) {
            index = 0;
        }
        if (index >= this.unitsDistance.getItemCount()) {
            index = this.unitsDistance.getItemCount() - 1;
        }
        this.unitsInductance.setSelectedIndex(index);
        this.unitsCurrent.addItem("Amps");
        this.unitsCurrent.addItem("Milli-amps");
        this.unitsCurrent.addItem("Micro-amps");
        this.initialUnitsAmperage = User.getAmperageUnits();
        index = this.initialUnitsAmperage.getIndex() - TextUtils.UnitScale.NONE.getIndex();
        if (index < 0) {
            index = 0;
        }
        if (index >= this.unitsDistance.getItemCount()) {
            index = this.unitsDistance.getItemCount() - 1;
        }
        this.unitsCurrent.setSelectedIndex(index);
        this.unitsVoltage.addItem("Kilo-volts");
        this.unitsVoltage.addItem("Volts");
        this.unitsVoltage.addItem("Milli-volts");
        this.unitsVoltage.addItem("Micro-volts");
        this.initialUnitsVoltage = User.getVoltageUnits();
        index = this.initialUnitsVoltage.getIndex() - TextUtils.UnitScale.KILO.getIndex();
        if (index < 0) {
            index = 0;
        }
        if (index >= this.unitsDistance.getItemCount()) {
            index = this.unitsDistance.getItemCount() - 1;
        }
        this.unitsVoltage.setSelectedIndex(index);
        this.unitsTime.addItem("Seconds");
        this.unitsTime.addItem("Milli-seconds");
        this.unitsTime.addItem("Micro-seconds");
        this.unitsTime.addItem("Nano-seconds");
        this.unitsTime.addItem("Pico-seconds");
        this.unitsTime.addItem("Femto-seconds");
        this.initialUnitsTime = User.getTimeUnits();
        index = this.initialUnitsTime.getIndex() - TextUtils.UnitScale.NONE.getIndex();
        if (index < 0) {
            index = 0;
        }
        if (index >= this.unitsDistance.getItemCount()) {
            index = this.unitsDistance.getItemCount() - 1;
        }
        this.unitsTime.setSelectedIndex(index);
        index = TextUtils.UnitScale.NONE.getIndex();
        this.unitsResistance.setSelectedIndex(-1);
        this.unitsResistance.setEnabled(false);
        this.unitsCapacitance.setSelectedIndex(-1);
        this.unitsCapacitance.setEnabled(false);
        this.unitsInductance.setSelectedIndex(-1);
        this.unitsInductance.setEnabled(false);
        this.unitsCurrent.setSelectedIndex(-1);
        this.unitsCurrent.setEnabled(false);
        this.unitsVoltage.setSelectedIndex(-1);
        this.unitsVoltage.setEnabled(false);
        this.unitsTime.setSelectedIndex(-1);
        this.unitsTime.setEnabled(false);
    }

    @Override
    public void term() {
        TextUtils.UnitScale currentTime;
        TextUtils.UnitScale currentVoltage;
        TextUtils.UnitScale currentAmperage;
        TextUtils.UnitScale currentInductance;
        TextUtils.UnitScale currentCapacitance;
        TextUtils.UnitScale currentResistance;
        TextUtils.UnitScale currentDistance = TextUtils.UnitScale.findFromIndex(this.unitsDistance.getSelectedIndex());
        if (currentDistance != this.initialUnitsDistance) {
            User.setDistanceUnits(currentDistance);
        }
        if ((currentResistance = TextUtils.UnitScale.findFromIndex(this.unitsResistance.getSelectedIndex())) != this.initialUnitsResistance) {
            User.setResistanceUnits(currentResistance);
        }
        if ((currentCapacitance = TextUtils.UnitScale.findFromIndex(this.unitsCapacitance.getSelectedIndex())) != this.initialUnitsCapacitance) {
            User.setCapacitanceUnits(currentCapacitance);
        }
        if ((currentInductance = TextUtils.UnitScale.findFromIndex(this.unitsInductance.getSelectedIndex())) != this.initialUnitsInductance) {
            User.setInductanceUnits(currentInductance);
        }
        if ((currentAmperage = TextUtils.UnitScale.findFromIndex(this.unitsCurrent.getSelectedIndex())) != this.initialUnitsAmperage) {
            User.setAmperageUnits(currentAmperage);
        }
        if ((currentVoltage = TextUtils.UnitScale.findFromIndex(this.unitsVoltage.getSelectedIndex())) != this.initialUnitsVoltage) {
            User.setVoltageUnits(currentVoltage);
        }
        if ((currentTime = TextUtils.UnitScale.findFromIndex(this.unitsTime.getSelectedIndex())) != this.initialUnitsTime) {
            User.setTimeUnits(currentTime);
        }
    }

    private void initComponents() {
        this.units = new JPanel();
        this.jLabel39 = new JLabel();
        this.unitsDistance = new JComboBox();
        this.jLabel40 = new JLabel();
        this.unitsResistance = new JComboBox();
        this.jLabel50 = new JLabel();
        this.unitsCapacitance = new JComboBox();
        this.jLabel51 = new JLabel();
        this.unitsInductance = new JComboBox();
        this.jLabel63 = new JLabel();
        this.unitsCurrent = new JComboBox();
        this.jLabel64 = new JLabel();
        this.unitsVoltage = new JComboBox();
        this.jLabel65 = new JLabel();
        this.unitsTime = new JComboBox();
        this.jLabel66 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UnitsTab.this.closeDialog(evt);
            }
        });
        this.units.setLayout(new GridBagLayout());
        this.jLabel39.setText("Distance:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel39, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsDistance, gridBagConstraints);
        this.jLabel40.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel40, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsResistance, gridBagConstraints);
        this.jLabel50.setText("Capacitance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel50, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsCapacitance, gridBagConstraints);
        this.jLabel51.setText("Inductance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel51, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsInductance, gridBagConstraints);
        this.jLabel63.setText("Current:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel63, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsCurrent, gridBagConstraints);
        this.jLabel64.setText("Voltage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel64, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsVoltage, gridBagConstraints);
        this.jLabel65.setText("Time:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel65, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsTime, gridBagConstraints);
        this.jLabel66.setText("These units will be used for display");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.jLabel66, gridBagConstraints);
        this.getContentPane().add((Component)this.units, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

