/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.VddGndStraps;

class CapLayer
implements VddGndStraps {
    private CapCell capCell;
    private NodeInst capCellInst;
    private CapFloorplan plan;

    public boolean addExtraArc() {
        return true;
    }

    public CapLayer(CapFloorplan plan, CapCell capCell, Cell cell) {
        double angle;
        this.plan = plan;
        this.capCell = capCell;
        double d = angle = plan.horizontal ? 0.0 : 90.0;
        if (capCell != null) {
            this.capCellInst = LayoutLib.newNodeInst(capCell.getCell(), 0.0, 0.0, G.DEF_SIZE, G.DEF_SIZE, angle, cell);
        }
    }

    public boolean isHorizontal() {
        return this.plan.horizontal;
    }

    public int numVdd() {
        return this.capCell != null ? this.capCell.numVdd() : 0;
    }

    public PortInst getVdd(int n, int pos) {
        return this.capCellInst.findPortInst("vdd_" + n);
    }

    public double getVddCenter(int n) {
        EPoint center = this.getVdd(n, 0).getCenter();
        return this.plan.horizontal ? center.getY() : center.getX();
    }

    public double getVddWidth(int n) {
        return this.capCell.getVddWidth();
    }

    public int numGnd() {
        return this.capCell.numGnd();
    }

    public PortInst getGnd(int n, int pos) {
        return this.capCellInst.findPortInst("gnd_" + n);
    }

    public double getGndCenter(int n) {
        EPoint center = this.getGnd(n, 0).getCenter();
        return this.plan.horizontal ? center.getY() : center.getX();
    }

    public double getGndWidth(int n) {
        return this.capCell.getGndWidth();
    }

    public PrimitiveNode getPinType() {
        return Tech.m1pin();
    }

    public ArcProto getMetalType() {
        return Tech.m1();
    }

    public double getCellWidth() {
        return this.plan.cellWidth;
    }

    public double getCellHeight() {
        return this.plan.cellHeight;
    }

    public int getLayerNumber() {
        return 1;
    }
}

