/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.io.Serializable;

public class Placement
extends Tool {
    private static Placement tool = new Placement();
    private static Pref cacheAlgorithmName = Pref.makeStringPref("AlgorithmName", Placement.tool.prefs, "Min-Cut");

    private Placement() {
        super("placement");
    }

    public void init() {
    }

    public static Placement getPlacementTool() {
        return tool;
    }

    public static void placeCurrentCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        PlacementPreferences pp = new PlacementPreferences(false);
        pp.getOptionsFromPreferences();
        new PlaceJob(cell, pp);
    }

    public static Cell placeCellNoJob(Cell cell, PlacementPreferences prefs) {
        PlacementFrame pla = Placement.getCurrentPlacementAlgorithm(prefs);
        Cell newCell = pla.doPlacement(cell);
        return newCell;
    }

    public static PlacementFrame getCurrentPlacementAlgorithm(PlacementPreferences prefs) {
        String algName = prefs.placementAlgorithm;
        for (PlacementFrame pfObj : PlacementFrame.getPlacementAlgorithms()) {
            if (!algName.equals(pfObj.getAlgorithmName())) continue;
            return pfObj;
        }
        return PlacementFrame.getPlacementAlgorithms()[0];
    }

    public static String getAlgorithmName() {
        return cacheAlgorithmName.getString();
    }

    public static void setAlgorithmName(String u) {
        cacheAlgorithmName.setString(u);
    }

    public static String getFactoryAlgorithmName() {
        return cacheAlgorithmName.getStringFactoryValue();
    }

    public static class PlacementPreferences
    implements Serializable {
        public String placementAlgorithm;

        public PlacementPreferences(boolean factory) {
            if (factory) {
                this.placementAlgorithm = Placement.getFactoryAlgorithmName();
            }
        }

        public void getOptionsFromPreferences() {
            this.placementAlgorithm = Placement.getAlgorithmName();
        }
    }

    private static class PlaceJob
    extends Job {
        private Cell cell;
        private PlacementPreferences prefs;
        private Cell newCell;

        private PlaceJob(Cell cell, PlacementPreferences prefs) {
            super("Place cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.prefs = prefs;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.newCell = Placement.placeCellNoJob(this.cell, this.prefs);
            this.fieldVariableChanged("newCell");
            return true;
        }

        public void terminateOK() {
            if (this.newCell != null) {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (User.isShowCellsInNewWindow()) {
                    wf = null;
                }
                if (wf == null) {
                    wf = WindowFrame.createEditWindow(this.newCell);
                }
                wf.setCellWindow(this.newCell, null);
            }
        }
    }
}

