/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.DeltaIndividual;
import com.sun.electric.tool.placement.genetic2.Individual;
import com.sun.electric.tool.placement.genetic2.Reference;
import com.sun.electric.tool.placement.genetic2.SimulatedAnnealing;
import com.sun.electric.tool.placement.genetic2.UnifiedPopulation;
import com.sun.electric.tool.placement.genetic2.metrics.DeltaBBMetric;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneticPlacer {
    private static final int INDIVIDUALS = 1000;
    private static int EVOLUTION_STEPS;
    public int maxRuntime;
    public int numThreads;
    public boolean printDebugInformation;
    long startTime;
    UnifiedPopulation population = null;
    Reference ref;

    public String getAlgorithmName() {
        return "team4Genetic";
    }

    public UnifiedPopulation getPopulation() {
        return this.population;
    }

    GeneticPlacer(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, int runtime, int threads, boolean debug) {
        this.maxRuntime = runtime * 1000;
        EVOLUTION_STEPS = this.maxRuntime / 10000;
        this.numThreads = threads;
        this.printDebugInformation = debug;
        this.startTime = System.currentTimeMillis();
        Random rand = new Random(System.currentTimeMillis());
        DeltaBBMetric.init(nodesToPlace, allNetworks);
        this.ref = new Reference(nodesToPlace, allNetworks, rand);
        DeltaBBMetric.setRef(this.ref);
        this.ref.calculateRefNetLength();
        Individual[] indis = new DeltaIndividual[1000];
        for (int i = 0; i < 1000; ++i) {
            indis[i] = new DeltaIndividual(this.ref, rand);
        }
        this.population = new UnifiedPopulation(nodesToPlace, allNetworks, indis, (long)(this.maxRuntime / EVOLUTION_STEPS), this.numThreads, rand);
    }

    private void placeUnified(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, long partTime) {
        DeltaIndividual champion;
        long localStartTime = System.currentTimeMillis();
        if (this.printDebugInformation) {
            System.out.println("Starting genetic algorithm...\nTotal running time is " + this.maxRuntime / 1000 + " seconds (~" + this.maxRuntime / 60000 + " minutes).\n" + "There will be " + EVOLUTION_STEPS + " text messages while running,\n" + "each will tell you the current round number and champion badness:");
        }
        int round = 0;
        long t = 0L;
        long localT = 0L;
        this.ref.calculateFirstTime();
        while (t < partTime) {
            this.population.setProgress((double)localT / (double)(partTime - (localStartTime - this.startTime)));
            this.population.evolveLocalMT(this.numThreads);
            champion = (DeltaIndividual)this.population.getChampion();
            if (this.printDebugInformation) {
                System.out.println("Round " + round + " of " + EVOLUTION_STEPS + " | champion badness: " + this.population.getChampion().getBadness());
                System.out.println("champion overlap: " + champion.getBadnessComponents()[1]);
                System.out.println("champion netlength: " + champion.getBadnessComponents()[0]);
            }
            this.ref.update(champion);
            if (round % 4 == 0) {
                this.ref.createGrid();
            }
            if (this.printDebugInformation) {
                System.out.println("ref overlap: " + this.ref.getBadnessComponents()[1]);
                System.out.println("ref netlength: " + this.ref.getBadnessComponents()[0]);
                System.out.println();
            }
            this.population.reboot();
            ++round;
            t = System.currentTimeMillis() - this.startTime;
            localT = System.currentTimeMillis() - localStartTime;
        }
        champion = (DeltaIndividual)this.population.getChampion();
        this.ref.update(champion);
        this.ref.calculateFirstTime();
        if (this.printDebugInformation) {
            System.out.println("final ref net length: " + this.ref.getBadnessComponents()[0]);
            System.out.println("final ref overlap: " + this.ref.getBadnessComponents()[1]);
            System.out.println("final ref naiveOverlap: " + this.ref.getNaiveOverlap());
            System.out.println("final net length (bb):  " + DeltaBBMetric.compute());
        }
    }

    private void placeAnnealing(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, long partTime) {
        long localStartTime = System.currentTimeMillis();
        SimulatedAnnealing annealing = new SimulatedAnnealing(nodesToPlace, allNetworks, this.maxRuntime / EVOLUTION_STEPS, this.numThreads, this.ref);
        if (this.printDebugInformation) {
            System.out.println("Starting simulated annealing...\nTotal running time is " + this.maxRuntime / 1000 + " seconds (~" + this.maxRuntime / 60000 + " minutes).\n" + "There will be " + EVOLUTION_STEPS + " text messages while running,\n" + "each will tell you the current round number and champion badness:");
        }
        int round = 0;
        long t = 0L;
        long localT = 0L;
        this.ref.calculateFirstTime();
        while (t < partTime) {
            annealing.setProgress((double)localT / (double)(partTime - (localStartTime - this.startTime)));
            annealing.go();
            if (this.printDebugInformation) {
                System.out.println("Round " + round + " of " + EVOLUTION_STEPS);
                System.out.println("ref netlength: " + this.ref.getBadnessComponents()[0]);
                System.out.println("ref overlap: " + this.ref.getBadnessComponents()[1]);
            }
            if (round % 4 == 0) {
                this.ref.createGrid();
            }
            ++round;
            t = System.currentTimeMillis() - this.startTime;
            localT = System.currentTimeMillis() - localStartTime;
        }
        if (this.printDebugInformation) {
            System.out.println("final ref net length: " + this.ref.getBadnessComponents()[0]);
            System.out.println("final ref overlap: " + this.ref.getBadnessComponents()[1]);
            System.out.println("final ref naiveOverlap: " + this.ref.getNaiveOverlap());
            System.out.println("final net length (bb):  " + DeltaBBMetric.compute());
        }
    }

    protected void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        if (this.maxRuntime >= 19900) {
            this.placeUnified(nodesToPlace, allNetworks, this.maxRuntime / 2);
        }
        this.placeAnnealing(nodesToPlace, allNetworks, this.maxRuntime);
    }
}

