/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;

public class AOMetric {
    private PlacementFrame.PlacementNode[] allNodes;
    private double currentScore;

    public AOMetric(PlacementFrame.PlacementNode[] allNodes) {
        this.allNodes = allNodes;
    }

    public double getScore() {
        this.currentScore = 0.0;
        for (PlacementFrame.PlacementNode node : this.allNodes) {
            this.currentScore += this.computeOverlapForNode(node);
        }
        return this.currentScore;
    }

    public double computeOverlapForNode(PlacementFrame.PlacementNode theOne) {
        double areaOverlap = 0.0;
        for (PlacementFrame.PlacementNode notTheOne : this.allNodes) {
            if (theOne == notTheOne) continue;
            double x1 = theOne.getPlacementX();
            double y1 = theOne.getPlacementY();
            double w1 = theOne.getWidth();
            double h1 = theOne.getHeight();
            int angle1 = theOne.getPlacementOrientation().getAngle();
            double x2 = notTheOne.getPlacementX();
            double y2 = notTheOne.getPlacementY();
            double w2 = theOne.getWidth();
            double h2 = theOne.getHeight();
            int angle2 = notTheOne.getPlacementOrientation().getAngle();
            areaOverlap += this.getIntersection(x1, y1, h1, w1, angle1, x2, y2, h2, w2, angle2);
        }
        return areaOverlap;
    }

    private double getIntersection(double x1, double y1, double h1, double w1, double a1, double x2, double y2, double h2, double w2, double a2) {
        double minX1 = 0.0;
        double minY1 = 0.0;
        double minX2 = 0.0;
        double minY2 = 0.0;
        double maxX1 = 0.0;
        double maxY1 = 0.0;
        double maxX2 = 0.0;
        double maxY2 = 0.0;
        switch ((int)a1) {
            case 0: {
                minX1 = x1 - w1 / 2.0;
                minY1 = y1 - h1 / 2.0;
                maxX1 = x1 + w1 / 2.0;
                maxY1 = y1 + h1 / 2.0;
            }
            case 90: {
                minX1 = x1 - h1 / 2.0;
                minY1 = y1 - w1 / 2.0;
                maxX1 = x1 + h1 / 2.0;
                maxY1 = y1 + w1 / 2.0;
            }
            case 180: {
                minX1 = x1 - w1 / 2.0;
                minY1 = y1 - h1 / 2.0;
                maxX1 = x1 + w1 / 2.0;
                maxY1 = y1 + h1 / 2.0;
            }
            case 270: {
                minX1 = x1 - h1 / 2.0;
                minY1 = y1 - w1 / 2.0;
                maxX1 = x1 + h1 / 2.0;
                maxY1 = y1 + w1 / 2.0;
            }
        }
        minX1 = x1 - w1 / 2.0;
        minY1 = y1 - h1 / 2.0;
        maxX1 = x1 + w1 / 2.0;
        maxY1 = y1 + h1 / 2.0;
        switch ((int)a2) {
            case 0: {
                minX2 = x2 - w2 / 2.0;
                minY2 = y2 - h2 / 2.0;
                maxX2 = x2 + w2 / 2.0;
                maxY2 = y2 + h2 / 2.0;
            }
            case 90: {
                minX2 = x2 - h2 / 2.0;
                minY2 = y2 - w2 / 2.0;
                maxX2 = x2 + h2 / 2.0;
                maxY2 = y2 + w2 / 2.0;
            }
            case 180: {
                minX2 = x2 - w2 / 2.0;
                minY2 = y2 - h2 / 2.0;
                maxX2 = x2 + w2 / 2.0;
                maxY2 = y2 + h2 / 2.0;
            }
            case 270: {
                minX2 = x2 - h2 / 2.0;
                minY2 = y2 - w2 / 2.0;
                maxX2 = x2 + h2 / 2.0;
                maxY2 = y2 + w2 / 2.0;
            }
        }
        minX2 = x2 - w2 / 2.0;
        minY2 = y2 - h2 / 2.0;
        maxX2 = x2 + w2 / 2.0;
        maxY2 = y2 + h2 / 2.0;
        double nx1 = Math.max(minX1, minX2);
        double ny1 = Math.max(minY1, minY2);
        double nx2 = Math.min(maxX1, maxX2);
        double ny2 = Math.min(maxY1, maxY2);
        if (nx2 - nx1 < 0.0 || ny2 - ny1 < 0.0) {
            return 0.0;
        }
        return (nx2 - nx1) * (ny2 - ny1);
    }
}

