# handles figuring out which student was to have taken this quiz
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.

###########################################################
# compareCapaID2
###########################################################
###########################################################
###########################################################
proc compareCapaID2 { onPaper onList } {
    set length [string length $onPaper]
    set same 0
    for { set i 0 } { $i < $length } { incr i } {
	if { [string index $onPaper $i] == [string index $onList $i] } {
	    incr same
	}
    }
    return $same
}

###########################################################
# getAnonModeID
###########################################################
###########################################################
###########################################################
proc getAnonModeID { num answerStructVar} {
    global gScorer
    upvar $answerStructVar answerStruct

    set i 0
    set length [llength $gScorer(studentList.$num)]
#    puts ofrloop:\ [time { 
	foreach student $gScorer(studentList.$num) {
	    lappend which([compareCapaID $answerStruct(CapaID) [lindex $student 3]]) $i
	    incr i
	}
#    }]
    set highest [lindex [lsort -decreasing -integer [array names which]] 0]
    if {$highest != 6} { return "" }
    set answerStruct(indices) $which($highest)
    foreach index $which($highest) {
	lappend result [lindex [lindex $gScorer(studentList.$num) $index] 1]
    }
    return $result
}

###########################################################
# scorerSum
###########################################################
###########################################################
###########################################################
proc scorerSum { scores } {
    set total 0
    foreach score [split $scores {}] { incr total $score }
    return $total
}

###########################################################
# pickAnonHighest
###########################################################
###########################################################
###########################################################
proc pickAnonHighest { num answerStructVar which } {
    global gPrompt gScorer
    upvar $answerStructVar answerStruct

    set scores ""
    foreach index $which {
	set studentNumber [lindex [lindex $gScorer(studentList.$num) $index] 1]
	lappend scores [list [scorerSum [finalScorer $num Lenient $studentNumber \
					     $answerStruct($studentNumber.numRight)]] \
			    $studentNumber]
    }
#    puts $scores
    set scores [lsort -index 0 -integer $scores]
#    puts $scores
#    puts [lindex [lindex $scores 0] 1]
    return [lindex [lindex $scores 0] 1]    
}

###########################################################
# getWhichAnon
###########################################################
###########################################################
###########################################################
proc getWhichAnon { num answerStructVar which } {
    global gPrompt gScorer
    upvar $answerStructVar answerStruct

    set dialog [toplevel .getWhichAnon$num -borderwidth 10]
    wm title $dialog "Getting Which Anonymous"

    set msgFrame [frame $dialog.msg ]
    set listFrame [frame $dialog.list ]
    set typeInFrame [frame $dialog.typein]
    set buttonFrame [frame $dialog.button]
    pack $msgFrame $listFrame $typeInFrame $buttonFrame

    label $msgFrame.lbl -text "Grading:"
    label $msgFrame.lbl2 -text "Student Number: $answerStruct(StudentNumber)"
    label $msgFrame.lbl3 -text "CapaID:         $answerStruct(CapaID)"
    label $msgFrame.lbl4 -text "Name:           $answerStruct(FirstName) $answerStruct(LastName)"
    label $msgFrame.lbl5 -text "Select the paper used to grade student." 
    label $msgFrame.lbl6 -text "Name                          StuNumber capa  capa      score"
    label $msgFrame.lbl7 -text "                                         ID  IDplus  Std  Len  Str "

    pack $msgFrame.lbl $msgFrame.lbl2 $msgFrame.lbl3 $msgFrame.lbl4 $msgFrame.lbl5 \
	$msgFrame.lbl6 $msgFrame.lbl7 -anchor w

    set listbox [listbox $listFrame.list -yscrollcommand "$listFrame.scroll set" \
		     -width 67]
    scrollbar $listFrame.scroll -command "$listFrame.list yview"
    pack $listFrame.list $listFrame.scroll -side left
    pack configure $listFrame.scroll -fill y

    label $typeInFrame.lbl -text "Type In Student Number:"
    entry $typeInFrame.typein -width 9 -textvariable gPrompt(typedin)
    pack $typeInFrame.lbl $typeInFrame.typein -side left

    button $buttonFrame.button -text Select -command "set gPrompt(ok) 1"
    button $buttonFrame.typein -text "Use Typed In Value" -command "set gPrompt(ok) 2"
    pack $buttonFrame.button $buttonFrame.typein -side left
    foreach index $which {
	set studentNumber [lindex [lindex $gScorer(studentList.$num) $index] 1]
	set scores ""
	foreach methodtype {CAPA Lenient Strict} {
	    lappend scores [scorerSum [finalScorer $num $methodtype $studentNumber \
					   $answerStruct($studentNumber.numRight)] ]
	}
	$listbox insert end [eval format {{%30s %s %4d %6s %4d %4d %4d}} [lindex $gScorer(studentList.$num) $index] $scores]
    }

    Centre_Dialog $dialog default
    focus $dialog
    capaRaise $dialog
    capaGrab $dialog
    while { 1 } {
	update
	vwait gPrompt(ok)
	if { $gPrompt(ok) == 1 } {
	    if { [$listbox curselection] != ""} { break }
	} else { 
	    if { [inClasslist $num $gPrompt(typedin)] } { break } else {
		displayError "$gPrompt(typedin) is not in the classl file"
	    }
	}
	set gPrompt(ok) 0
    }
    if { $gPrompt(ok) == 1 } {
	set selected [lindex $which [$listbox curselection]]
	set result [lindex [lindex $gScorer(studentList.$num) $selected] 1]
    } else {
	set result $gPrompt(typedin)
    }
    capaGrab release $dialog
    destroy $dialog
    
    return $result
}

###########################################################
# inClasslist
###########################################################
###########################################################
###########################################################
proc inClasslist { num pid } {
    global gScorer
    if {[lsearch -regexp $gScorer(studentList.$num) "\{.*\} .*$pid.*"]!=-1} {
	return 1
    } {
	return 0
    }
}
