#!/bin/sh

# This program tests epochs by running DEBUG EPOCH.

TEMPDIR=/tmp/pspp-tst-$$

here=`pwd`;

# ensure that top_srcdir is absolute
cd $top_srcdir; top_srcdir=`pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH


cleanup()
{
     cd /
     rm -rf $TEMPDIR
}


fail()
{
    echo $activity
    echo FAILED
    cleanup;
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    cleanup;
    exit 2;
}

pass()
{
    cleanup;
    exit 0;
}

mkdir -p $TEMPDIR

cd $TEMPDIR

activity="create program"
cat > $TEMPDIR/epoch.stat <<EOF
SET MXERR 1000.
SET MXWARN 1000.

SET EPOCH 1900.
DEBUG EVALUATE/YRMODA(0,1,1) = YRMODA(1900,1,1).
DEBUG EVALUATE/YRMODA(1,1,1) = YRMODA(1901,1,1).
DEBUG EVALUATE/YRMODA(12,1,1) = YRMODA(1912,1,1).
DEBUG EVALUATE/YRMODA(70,1,1) = YRMODA(1970,1,1).
DEBUG EVALUATE/YRMODA(87,1,1) = YRMODA(1987,1,1).
DEBUG EVALUATE/YRMODA(99,1,1) = YRMODA(1999,1,1).
DEBUG EVALUATE/YRMODA(100,1,1).
DEBUG EVALUATE/DATE.DMY(1,1,0) = DATE.DMY(1,1,1900).
DEBUG EVALUATE/DATE.DMY(1,1,1) = DATE.DMY(1,1,1901).
DEBUG EVALUATE/DATE.DMY(1,1,12) = DATE.DMY(1,1,1912).
DEBUG EVALUATE/DATE.DMY(1,1,70) = DATE.DMY(1,1,1970).
DEBUG EVALUATE/DATE.DMY(1,1,87) = DATE.DMY(1,1,1987).
DEBUG EVALUATE/DATE.DMY(1,1,99) = DATE.DMY(1,1,1999).
DEBUG EVALUATE/DATE.DMY(1,1,100).

SET EPOCH 1901.
DEBUG EVALUATE/YRMODA(0,1,1) = YRMODA(1900,1,1).
DEBUG EVALUATE/YRMODA(1,1,1) = YRMODA(1901,1,1).
DEBUG EVALUATE/YRMODA(12,1,1) = YRMODA(1912,1,1).
DEBUG EVALUATE/YRMODA(70,1,1) = YRMODA(1970,1,1).
DEBUG EVALUATE/YRMODA(87,1,1) = YRMODA(1987,1,1).
DEBUG EVALUATE/YRMODA(99,1,1) = YRMODA(1999,1,1).
DEBUG EVALUATE/YRMODA(100,1,1).
DEBUG EVALUATE/DATE.DMY(1,1,0) = DATE.DMY(1,1,2000).
DEBUG EVALUATE/DATE.DMY(1,1,1) = DATE.DMY(1,1,1901).
DEBUG EVALUATE/DATE.DMY(1,1,12) = DATE.DMY(1,1,1912).
DEBUG EVALUATE/DATE.DMY(1,1,70) = DATE.DMY(1,1,1970).
DEBUG EVALUATE/DATE.DMY(1,1,87) = DATE.DMY(1,1,1987).
DEBUG EVALUATE/DATE.DMY(1,1,99) = DATE.DMY(1,1,1999).
DEBUG EVALUATE/DATE.DMY(1,1,100).

SET EPOCH 1911.
DEBUG EVALUATE/YRMODA(0,1,1) = YRMODA(1900,1,1).
DEBUG EVALUATE/YRMODA(1,1,1) = YRMODA(1901,1,1).
DEBUG EVALUATE/YRMODA(12,1,1) = YRMODA(1912,1,1).
DEBUG EVALUATE/YRMODA(70,1,1) = YRMODA(1970,1,1).
DEBUG EVALUATE/YRMODA(87,1,1) = YRMODA(1987,1,1).
DEBUG EVALUATE/YRMODA(99,1,1) = YRMODA(1999,1,1).
DEBUG EVALUATE/YRMODA(100,1,1).
DEBUG EVALUATE/DATE.DMY(1,1,0) = DATE.DMY(1,1,2000).
DEBUG EVALUATE/DATE.DMY(1,1,1) = DATE.DMY(1,1,2001).
DEBUG EVALUATE/DATE.DMY(1,1,12) = DATE.DMY(1,1,1912).
DEBUG EVALUATE/DATE.DMY(1,1,70) = DATE.DMY(1,1,1970).
DEBUG EVALUATE/DATE.DMY(1,1,87) = DATE.DMY(1,1,1987).
DEBUG EVALUATE/DATE.DMY(1,1,99) = DATE.DMY(1,1,1999).
DEBUG EVALUATE/DATE.DMY(1,1,100).

SET EPOCH 1912.
DEBUG EVALUATE/YRMODA(0,1,1) = YRMODA(1900,1,1).
DEBUG EVALUATE/YRMODA(1,1,1) = YRMODA(1901,1,1).
DEBUG EVALUATE/YRMODA(12,1,1) = YRMODA(1912,1,1).
DEBUG EVALUATE/YRMODA(70,1,1) = YRMODA(1970,1,1).
DEBUG EVALUATE/YRMODA(87,1,1) = YRMODA(1987,1,1).
DEBUG EVALUATE/YRMODA(99,1,1) = YRMODA(1999,1,1).
DEBUG EVALUATE/YRMODA(100,1,1).
DEBUG EVALUATE/DATE.DMY(1,1,0) = DATE.DMY(1,1,2000).
DEBUG EVALUATE/DATE.DMY(1,1,1) = DATE.DMY(1,1,2001).
DEBUG EVALUATE/DATE.DMY(1,1,12) = DATE.DMY(1,1,1912).
DEBUG EVALUATE/DATE.DMY(1,1,70) = DATE.DMY(1,1,1970).
DEBUG EVALUATE/DATE.DMY(1,1,87) = DATE.DMY(1,1,1987).
DEBUG EVALUATE/DATE.DMY(1,1,99) = DATE.DMY(1,1,1999).
DEBUG EVALUATE/DATE.DMY(1,1,100).

SET EPOCH 2012.
DEBUG EVALUATE/YRMODA(0,1,1) = YRMODA(1900,1,1).
DEBUG EVALUATE/YRMODA(1,1,1) = YRMODA(1901,1,1).
DEBUG EVALUATE/YRMODA(12,1,1) = YRMODA(1912,1,1).
DEBUG EVALUATE/YRMODA(70,1,1) = YRMODA(1970,1,1).
DEBUG EVALUATE/YRMODA(87,1,1) = YRMODA(1987,1,1).
DEBUG EVALUATE/YRMODA(99,1,1) = YRMODA(1999,1,1).
DEBUG EVALUATE/YRMODA(100,1,1).
DEBUG EVALUATE/DATE.DMY(1,1,0) = DATE.DMY(1,1,2100).
DEBUG EVALUATE/DATE.DMY(1,1,1) = DATE.DMY(1,1,2101).
DEBUG EVALUATE/DATE.DMY(1,1,12) = DATE.DMY(1,1,2012).
DEBUG EVALUATE/DATE.DMY(1,1,70) = DATE.DMY(1,1,2070).
DEBUG EVALUATE/DATE.DMY(1,1,87) = DATE.DMY(1,1,2087).
DEBUG EVALUATE/DATE.DMY(1,1,99) = DATE.DMY(1,1,2099).
DEBUG EVALUATE/DATE.DMY(1,1,100).
EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $here/../src/pspp --testing-mode $TEMPDIR/epoch.stat > $TEMPDIR/epoch.err 2> $TEMPDIR/epoch.out

activity="compare results"
diff -b -B $TEMPDIR/epoch.out - <<EOF
YRMODA(0,1,1) = YRMODA(1900,1,1) => true
YRMODA(1,1,1) = YRMODA(1901,1,1) => true
YRMODA(12,1,1) = YRMODA(1912,1,1) => true
YRMODA(70,1,1) = YRMODA(1970,1,1) => true
YRMODA(87,1,1) = YRMODA(1987,1,1) => true
YRMODA(99,1,1) = YRMODA(1999,1,1) => true
YRMODA(100,1,1) => sysmis
DATE.DMY(1,1,0) = DATE.DMY(1,1,1900) => true
DATE.DMY(1,1,1) = DATE.DMY(1,1,1901) => true
DATE.DMY(1,1,12) = DATE.DMY(1,1,1912) => true
DATE.DMY(1,1,70) = DATE.DMY(1,1,1970) => true
DATE.DMY(1,1,87) = DATE.DMY(1,1,1987) => true
DATE.DMY(1,1,99) = DATE.DMY(1,1,1999) => true
DATE.DMY(1,1,100) => sysmis

YRMODA(0,1,1) = YRMODA(1900,1,1) => true
YRMODA(1,1,1) = YRMODA(1901,1,1) => true
YRMODA(12,1,1) = YRMODA(1912,1,1) => true
YRMODA(70,1,1) = YRMODA(1970,1,1) => true
YRMODA(87,1,1) = YRMODA(1987,1,1) => true
YRMODA(99,1,1) = YRMODA(1999,1,1) => true
YRMODA(100,1,1) => sysmis
DATE.DMY(1,1,0) = DATE.DMY(1,1,2000) => true
DATE.DMY(1,1,1) = DATE.DMY(1,1,1901) => true
DATE.DMY(1,1,12) = DATE.DMY(1,1,1912) => true
DATE.DMY(1,1,70) = DATE.DMY(1,1,1970) => true
DATE.DMY(1,1,87) = DATE.DMY(1,1,1987) => true
DATE.DMY(1,1,99) = DATE.DMY(1,1,1999) => true
DATE.DMY(1,1,100) => sysmis

YRMODA(0,1,1) = YRMODA(1900,1,1) => true
YRMODA(1,1,1) = YRMODA(1901,1,1) => true
YRMODA(12,1,1) = YRMODA(1912,1,1) => true
YRMODA(70,1,1) = YRMODA(1970,1,1) => true
YRMODA(87,1,1) = YRMODA(1987,1,1) => true
YRMODA(99,1,1) = YRMODA(1999,1,1) => true
YRMODA(100,1,1) => sysmis
DATE.DMY(1,1,0) = DATE.DMY(1,1,2000) => true
DATE.DMY(1,1,1) = DATE.DMY(1,1,2001) => true
DATE.DMY(1,1,12) = DATE.DMY(1,1,1912) => true
DATE.DMY(1,1,70) = DATE.DMY(1,1,1970) => true
DATE.DMY(1,1,87) = DATE.DMY(1,1,1987) => true
DATE.DMY(1,1,99) = DATE.DMY(1,1,1999) => true
DATE.DMY(1,1,100) => sysmis

YRMODA(0,1,1) = YRMODA(1900,1,1) => true
YRMODA(1,1,1) = YRMODA(1901,1,1) => true
YRMODA(12,1,1) = YRMODA(1912,1,1) => true
YRMODA(70,1,1) = YRMODA(1970,1,1) => true
YRMODA(87,1,1) = YRMODA(1987,1,1) => true
YRMODA(99,1,1) = YRMODA(1999,1,1) => true
YRMODA(100,1,1) => sysmis
DATE.DMY(1,1,0) = DATE.DMY(1,1,2000) => true
DATE.DMY(1,1,1) = DATE.DMY(1,1,2001) => true
DATE.DMY(1,1,12) = DATE.DMY(1,1,1912) => true
DATE.DMY(1,1,70) = DATE.DMY(1,1,1970) => true
DATE.DMY(1,1,87) = DATE.DMY(1,1,1987) => true
DATE.DMY(1,1,99) = DATE.DMY(1,1,1999) => true
DATE.DMY(1,1,100) => sysmis

YRMODA(0,1,1) = YRMODA(1900,1,1) => true
YRMODA(1,1,1) = YRMODA(1901,1,1) => true
YRMODA(12,1,1) = YRMODA(1912,1,1) => true
YRMODA(70,1,1) = YRMODA(1970,1,1) => true
YRMODA(87,1,1) = YRMODA(1987,1,1) => true
YRMODA(99,1,1) = YRMODA(1999,1,1) => true
YRMODA(100,1,1) => sysmis
DATE.DMY(1,1,0) = DATE.DMY(1,1,2100) => true
DATE.DMY(1,1,1) = DATE.DMY(1,1,2101) => true
DATE.DMY(1,1,12) = DATE.DMY(1,1,2012) => true
DATE.DMY(1,1,70) = DATE.DMY(1,1,2070) => true
DATE.DMY(1,1,87) = DATE.DMY(1,1,2087) => true
DATE.DMY(1,1,99) = DATE.DMY(1,1,2099) => true
DATE.DMY(1,1,100) => sysmis
EOF

if [ $? -ne 0 ] ; then no_result ; fi


if [ $? -ne 0 ] ; then fail ; fi



pass;
