/*
** Copyright (C) 1999, 2000, 2002, 2003 Lorenzo Bettini <bettini@gnu.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*/

// factory for ESC generators

#ifndef ESCGENERATORFACTORY_H
#define ESCGENERATORFACTORY_H

#include "generatorfactory.h"

#include <string>

using std::string;

class EscGeneratorFactory : public GeneratorFactory
{
 protected:
  virtual CharTranslator *createCharTranslator();
  virtual ColorMap *createColorMap();

  TextGenerator *merge(TextGenerator *, const string &);
  
  const string esc_tag(const string &);
  
  virtual const string getPreTag();
  virtual const string getPostTag();
  virtual void addBold();
  virtual void addItalic();
  virtual void addUnderline();
  virtual void addColor(const string &color);

 public:
  EscGeneratorFactory();
};

#endif // HTMLGENERATORFACTORY_H
