//
// C++ Interface: langmap
//
// Description: 
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef LANGMAP_H
#define LANGMAP_H

#include <string>
#include <map>

/**
map a file extension to a language definition

@author Lorenzo Bettini
*/
class LangMap
{
  typedef std::map<std::string, std::string> Map;
  
  Map langmap;
  
public:
  LangMap(const std::string &path, const std::string &filename);

  ~LangMap();
  
  void print();
  const std::string &get_file(const std::string &lang) {
    return langmap[lang];
  }
};

#endif
