/*	$NetBSD: gmc_8_2_d.h,v 1.3 2021/12/18 23:45:15 riastradh Exp $	*/

/*
 * GMC_8_2 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GMC_8_2_D_H
#define GMC_8_2_D_H

#define mmMC_CONFIG                                                             0x800
#define mmMC_ARB_ATOMIC                                                         0x9be
#define mmMC_ARB_AGE_CNTL                                                       0x9bf
#define mmMC_ARB_RET_CREDITS2                                                   0x9c0
#define mmMC_ARB_FED_CNTL                                                       0x9c1
#define mmMC_ARB_GECC2_STATUS                                                   0x9c2
#define mmMC_ARB_GECC2_MISC                                                     0x9c3
#define mmMC_ARB_GECC2_DEBUG                                                    0x9c4
#define mmMC_ARB_GECC2_DEBUG2                                                   0x9c5
#define mmMC_ARB_PERF_CID                                                       0x9c6
#define mmMC_ARB_SNOOP                                                          0x9c7
#define mmMC_ARB_GRUB                                                           0x9c8
#define mmMC_ARB_GECC2                                                          0x9c9
#define mmMC_ARB_GECC2_CLI                                                      0x9ca
#define mmMC_ARB_ADDR_SWIZ0                                                     0x9cb
#define mmMC_ARB_ADDR_SWIZ1                                                     0x9cc
#define mmMC_ARB_MISC3                                                          0x9cd
#define mmMC_ARB_GRUB_PROMOTE                                                   0x9ce
#define mmMC_ARB_RTT_DATA                                                       0x9cf
#define mmMC_ARB_RTT_CNTL0                                                      0x9d0
#define mmMC_ARB_RTT_CNTL1                                                      0x9d1
#define mmMC_ARB_RTT_CNTL2                                                      0x9d2
#define mmMC_ARB_RTT_DEBUG                                                      0x9d3
#define mmMC_ARB_CAC_CNTL                                                       0x9d4
#define mmMC_ARB_MISC2                                                          0x9d5
#define mmMC_ARB_MISC                                                           0x9d6
#define mmMC_ARB_BANKMAP                                                        0x9d7
#define mmMC_ARB_RAMCFG                                                         0x9d8
#define mmMC_ARB_POP                                                            0x9d9
#define mmMC_ARB_MINCLKS                                                        0x9da
#define mmMC_ARB_SQM_CNTL                                                       0x9db
#define mmMC_ARB_ADDR_HASH                                                      0x9dc
#define mmMC_ARB_DRAM_TIMING                                                    0x9dd
#define mmMC_ARB_DRAM_TIMING2                                                   0x9de
#define mmMC_ARB_WTM_CNTL_RD                                                    0x9df
#define mmMC_ARB_WTM_CNTL_WR                                                    0x9e0
#define mmMC_ARB_WTM_GRPWT_RD                                                   0x9e1
#define mmMC_ARB_WTM_GRPWT_WR                                                   0x9e2
#define mmMC_ARB_TM_CNTL_RD                                                     0x9e3
#define mmMC_ARB_TM_CNTL_WR                                                     0x9e4
#define mmMC_ARB_LAZY0_RD                                                       0x9e5
#define mmMC_ARB_LAZY0_WR                                                       0x9e6
#define mmMC_ARB_LAZY1_RD                                                       0x9e7
#define mmMC_ARB_LAZY1_WR                                                       0x9e8
#define mmMC_ARB_AGE_RD                                                         0x9e9
#define mmMC_ARB_AGE_WR                                                         0x9ea
#define mmMC_ARB_RFSH_CNTL                                                      0x9eb
#define mmMC_ARB_RFSH_RATE                                                      0x9ec
#define mmMC_ARB_PM_CNTL                                                        0x9ed
#define mmMC_ARB_GDEC_RD_CNTL                                                   0x9ee
#define mmMC_ARB_GDEC_WR_CNTL                                                   0x9ef
#define mmMC_ARB_LM_RD                                                          0x9f0
#define mmMC_ARB_LM_WR                                                          0x9f1
#define mmMC_ARB_REMREQ                                                         0x9f2
#define mmMC_ARB_REPLAY                                                         0x9f3
#define mmMC_ARB_RET_CREDITS_RD                                                 0x9f4
#define mmMC_ARB_RET_CREDITS_WR                                                 0x9f5
#define mmMC_ARB_MAX_LAT_CID                                                    0x9f6
#define mmMC_ARB_MAX_LAT_RSLT0                                                  0x9f7
#define mmMC_ARB_MAX_LAT_RSLT1                                                  0x9f8
#define mmMC_ARB_GRUB_REALTIME_RD                                               0x9f9
#define mmMC_ARB_CG                                                             0x9fa
#define mmMC_ARB_GRUB_REALTIME_WR                                               0x9fb
#define mmMC_ARB_DRAM_TIMING_1                                                  0x9fc
#define mmMC_ARB_BUSY_STATUS                                                    0x9fd
#define mmMC_ARB_DRAM_TIMING2_1                                                 0x9ff
#define mmMC_ARB_GRUB2                                                          0xa01
#define mmMC_ARB_BURST_TIME                                                     0xa02
#define mmMC_CITF_XTRA_ENABLE                                                   0x96d
#define mmCC_MC_MAX_CHANNEL                                                     0x96e
#define mmMC_CG_CONFIG                                                          0x96f
#define mmMC_CITF_CNTL                                                          0x970
#define mmMC_CITF_CREDITS_VM                                                    0x971
#define mmMC_CITF_CREDITS_ARB_RD                                                0x972
#define mmMC_CITF_CREDITS_ARB_WR                                                0x973
#define mmMC_CITF_DAGB_CNTL                                                     0x974
#define mmMC_CITF_INT_CREDITS                                                   0x975
#define mmMC_CITF_RET_MODE                                                      0x976
#define mmMC_CITF_DAGB_DLY                                                      0x977
#define mmMC_RD_GRP_EXT                                                         0x978
#define mmMC_WR_GRP_EXT                                                         0x979
#define mmMC_CITF_REMREQ                                                        0x97a
#define mmMC_WR_TC0                                                             0x97b
#define mmMC_WR_TC1                                                             0x97c
#define mmMC_CITF_INT_CREDITS_WR                                                0x97d
#define mmMC_CITF_CREDITS_ARB_RD2                                               0x97e
#define mmMC_CITF_WTM_RD_CNTL                                                   0x97f
#define mmMC_CITF_WTM_WR_CNTL                                                   0x980
#define mmMC_RD_CB                                                              0x981
#define mmMC_RD_DB                                                              0x982
#define mmMC_RD_TC0                                                             0x983
#define mmMC_RD_TC1                                                             0x984
#define mmMC_RD_HUB                                                             0x985
#define mmMC_WR_CB                                                              0x986
#define mmMC_WR_DB                                                              0x987
#define mmMC_WR_HUB                                                             0x988
#define mmMC_CITF_CREDITS_XBAR                                                  0x989
#define mmMC_RD_GRP_LCL                                                         0x98a
#define mmMC_WR_GRP_LCL                                                         0x98b
#define mmMC_CITF_PERF_MON_CNTL2                                                0x98e
#define mmMC_CITF_PERF_MON_RSLT2                                                0x991
#define mmMC_CITF_MISC_RD_CG                                                    0x992
#define mmMC_CITF_MISC_WR_CG                                                    0x993
#define mmMC_CITF_MISC_VM_CG                                                    0x994
#define mmMC_HUB_MISC_POWER                                                     0x82d
#define mmMC_HUB_MISC_HUB_CG                                                    0x82e
#define mmMC_HUB_MISC_VM_CG                                                     0x82f
#define mmMC_HUB_MISC_SIP_CG                                                    0x830
#define mmMC_HUB_MISC_STATUS                                                    0x832
#define mmMC_HUB_MISC_OVERRIDE                                                  0x833
#define mmMC_HUB_MISC_FRAMING                                                   0x834
#define mmMC_HUB_WDP_CNTL                                                       0x835
#define mmMC_HUB_WDP_ERR                                                        0x836
#define mmMC_HUB_WDP_BP                                                         0x837
#define mmMC_HUB_WDP_STATUS                                                     0x838
#define mmMC_HUB_RDREQ_STATUS                                                   0x839
#define mmMC_HUB_WRRET_STATUS                                                   0x83a
#define mmMC_HUB_RDREQ_CNTL                                                     0x83b
#define mmMC_HUB_WRRET_CNTL                                                     0x83c
#define mmMC_HUB_RDREQ_WTM_CNTL                                                 0x83d
#define mmMC_HUB_WDP_WTM_CNTL                                                   0x83e
#define mmMC_HUB_WDP_CREDITS                                                    0x83f
#define mmMC_HUB_WDP_CREDITS2                                                   0x840
#define mmMC_HUB_WDP_GBL0                                                       0x841
#define mmMC_HUB_WDP_GBL1                                                       0x842
#define mmMC_HUB_RDREQ_CREDITS                                                  0x844
#define mmMC_HUB_RDREQ_CREDITS2                                                 0x845
#define mmMC_HUB_SHARED_DAGB_DLY                                                0x846
#define mmMC_HUB_MISC_IDLE_STATUS                                               0x847
#define mmMC_HUB_RDREQ_DMIF_LIMIT                                               0x848
#define mmMC_HUB_RDREQ_ACPG_LIMIT                                               0x849
#define mmMC_HUB_WDP_BYPASS_GBL0                                                0x84a
#define mmMC_HUB_WDP_BYPASS_GBL1                                                0x84b
#define mmMC_HUB_RDREQ_BYPASS_GBL0                                              0x84c
#define mmMC_HUB_WDP_SH2                                                        0x84d
#define mmMC_HUB_WDP_SH3                                                        0x84e
#define mmMC_HUB_MISC_ATOMIC_IDLE_STATUS                                        0x84f
#define mmMC_HUB_RDREQ_MCDW                                                     0x851
#define mmMC_HUB_RDREQ_MCDX                                                     0x852
#define mmMC_HUB_RDREQ_MCDY                                                     0x853
#define mmMC_HUB_RDREQ_MCDZ                                                     0x854
#define mmMC_HUB_RDREQ_SIP                                                      0x855
#define mmMC_HUB_RDREQ_GBL0                                                     0x856
#define mmMC_HUB_RDREQ_GBL1                                                     0x857
#define mmMC_HUB_RDREQ_SMU                                                      0x858
#define mmMC_HUB_RDREQ_SDMA0                                                    0x859
#define mmMC_HUB_RDREQ_HDP                                                      0x85a
#define mmMC_HUB_RDREQ_SDMA1                                                    0x85b
#define mmMC_HUB_RDREQ_RLC                                                      0x85c
#define mmMC_HUB_RDREQ_SEM                                                      0x85d
#define mmMC_HUB_RDREQ_VCE0                                                     0x85e
#define mmMC_HUB_RDREQ_UMC                                                      0x85f
#define mmMC_HUB_RDREQ_UVD                                                      0x860
#define mmMC_HUB_RDREQ_DMIF                                                     0x862
#define mmMC_HUB_RDREQ_MCIF                                                     0x863
#define mmMC_HUB_RDREQ_VMC                                                      0x864
#define mmMC_HUB_RDREQ_VCEU0                                                    0x865
#define mmMC_HUB_WDP_MCDW                                                       0x866
#define mmMC_HUB_WDP_MCDX                                                       0x867
#define mmMC_HUB_WDP_MCDY                                                       0x868
#define mmMC_HUB_WDP_MCDZ                                                       0x869
#define mmMC_HUB_WDP_SIP                                                        0x86a
#define mmMC_HUB_WDP_SDMA1                                                      0x86b
#define mmMC_HUB_WDP_SH0                                                        0x86c
#define mmMC_HUB_WDP_MCIF                                                       0x86d
#define mmMC_HUB_WDP_VCE0                                                       0x86e
#define mmMC_HUB_WDP_XDP                                                        0x86f
#define mmMC_HUB_WDP_IH                                                         0x870
#define mmMC_HUB_WDP_RLC                                                        0x871
#define mmMC_HUB_WDP_SEM                                                        0x872
#define mmMC_HUB_WDP_SMU                                                        0x873
#define mmMC_HUB_WDP_SH1                                                        0x874
#define mmMC_HUB_WDP_UMC                                                        0x875
#define mmMC_HUB_WDP_UVD                                                        0x876
#define mmMC_HUB_WDP_HDP                                                        0x877
#define mmMC_HUB_WDP_SDMA0                                                      0x878
#define mmMC_HUB_WRRET_MCDW                                                     0x879
#define mmMC_HUB_WRRET_MCDX                                                     0x87a
#define mmMC_HUB_WRRET_MCDY                                                     0x87b
#define mmMC_HUB_WRRET_MCDZ                                                     0x87c
#define mmMC_HUB_WDP_VCEU0                                                      0x87d
#define mmMC_HUB_WDP_XDMAM                                                      0x87e
#define mmMC_HUB_WDP_XDMA                                                       0x87f
#define mmMC_HUB_RDREQ_XDMAM                                                    0x880
#define mmMC_HUB_RDREQ_ACPG                                                     0x881
#define mmMC_HUB_RDREQ_ACPO                                                     0x882
#define mmMC_HUB_RDREQ_SAMMSP                                                   0x883
#define mmMC_HUB_RDREQ_VP8                                                      0x884
#define mmMC_HUB_RDREQ_VP8U                                                     0x885
#define mmMC_HUB_WDP_ACPG                                                       0x886
#define mmMC_HUB_WDP_ACPO                                                       0x887
#define mmMC_HUB_WDP_SAMMSP                                                     0x888
#define mmMC_HUB_WDP_VP8                                                        0x889
#define mmMC_HUB_WDP_VP8U                                                       0x88a
#define mmMC_HUB_RDREQ_ISP_SPM                                                  0xde0
#define mmMC_HUB_RDREQ_ISP_MPM                                                  0xde1
#define mmMC_HUB_RDREQ_ISP_CCPU                                                 0xde2
#define mmMC_HUB_WDP_ISP_SPM                                                    0xde3
#define mmMC_HUB_WDP_ISP_MPS                                                    0xde4
#define mmMC_HUB_WDP_ISP_MPM                                                    0xde5
#define mmMC_HUB_WDP_ISP_CCPU                                                   0xde6
#define mmMC_HUB_RDREQ_MCDS                                                     0xde7
#define mmMC_HUB_RDREQ_MCDT                                                     0xde8
#define mmMC_HUB_RDREQ_MCDU                                                     0xde9
#define mmMC_HUB_RDREQ_MCDV                                                     0xdea
#define mmMC_HUB_WDP_MCDS                                                       0xdeb
#define mmMC_HUB_WDP_MCDT                                                       0xdec
#define mmMC_HUB_WDP_MCDU                                                       0xded
#define mmMC_HUB_WDP_MCDV                                                       0xdee
#define mmMC_HUB_WRRET_MCDS                                                     0xdef
#define mmMC_HUB_WRRET_MCDT                                                     0xdf0
#define mmMC_HUB_WRRET_MCDU                                                     0xdf1
#define mmMC_HUB_WRRET_MCDV                                                     0xdf2
#define mmMC_HUB_WDP_CREDITS_MCDW                                               0xdf3
#define mmMC_HUB_WDP_CREDITS_MCDX                                               0xdf4
#define mmMC_HUB_WDP_CREDITS_MCDY                                               0xdf5
#define mmMC_HUB_WDP_CREDITS_MCDZ                                               0xdf6
#define mmMC_HUB_WDP_CREDITS_MCDS                                               0xdf7
#define mmMC_HUB_WDP_CREDITS_MCDT                                               0xdf8
#define mmMC_HUB_WDP_CREDITS_MCDU                                               0xdf9
#define mmMC_HUB_WDP_CREDITS_MCDV                                               0xdfa
#define mmMC_HUB_WDP_BP2                                                        0xdfb
#define mmMC_HUB_RDREQ_VCE1                                                     0xdfc
#define mmMC_HUB_RDREQ_VCEU1                                                    0xdfd
#define mmMC_HUB_WDP_VCE1                                                       0xdfe
#define mmMC_HUB_WDP_VCEU1                                                      0xdff
#define mmMC_RPB_CONF                                                           0x94d
#define mmMC_RPB_IF_CONF                                                        0x94e
#define mmMC_RPB_DBG1                                                           0x94f
#define mmMC_RPB_EFF_CNTL                                                       0x950
#define mmMC_RPB_ARB_CNTL                                                       0x951
#define mmMC_RPB_BIF_CNTL                                                       0x952
#define mmMC_RPB_WR_SWITCH_CNTL                                                 0x953
#define mmMC_RPB_WR_COMBINE_CNTL                                                0x954
#define mmMC_RPB_RD_SWITCH_CNTL                                                 0x955
#define mmMC_RPB_CID_QUEUE_WR                                                   0x956
#define mmMC_RPB_CID_QUEUE_RD                                                   0x957
#define mmMC_RPB_PERF_COUNTER_CNTL                                              0x958
#define mmMC_RPB_PERF_COUNTER_STATUS                                            0x959
#define mmMC_RPB_CID_QUEUE_EX                                                   0x95a
#define mmMC_RPB_CID_QUEUE_EX_DATA                                              0x95b
#define mmMC_RPB_TCI_CNTL                                                       0x95c
#define mmMC_RPB_TCI_CNTL2                                                      0x95d
#define mmMC_SHARED_CHMAP                                                       0x801
#define mmMC_SHARED_CHREMAP                                                     0x802
#define mmMC_RD_GRP_GFX                                                         0x803
#define mmMC_WR_GRP_GFX                                                         0x804
#define mmMC_RD_GRP_SYS                                                         0x805
#define mmMC_WR_GRP_SYS                                                         0x806
#define mmMC_RD_GRP_OTH                                                         0x807
#define mmMC_WR_GRP_OTH                                                         0x808
#define mmMC_VM_FB_LOCATION                                                     0x809
#define mmMC_VM_AGP_TOP                                                         0x80a
#define mmMC_VM_AGP_BOT                                                         0x80b
#define mmMC_VM_AGP_BASE                                                        0x80c
#define mmMC_VM_SYSTEM_APERTURE_LOW_ADDR                                        0x80d
#define mmMC_VM_SYSTEM_APERTURE_HIGH_ADDR                                       0x80e
#define mmMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR                                    0x80f
#define mmMC_VM_DC_WRITE_CNTL                                                   0x810
#define mmMC_VM_DC_WRITE_HIT_REGION_0_LOW_ADDR                                  0x811
#define mmMC_VM_DC_WRITE_HIT_REGION_1_LOW_ADDR                                  0x812
#define mmMC_VM_DC_WRITE_HIT_REGION_2_LOW_ADDR                                  0x813
#define mmMC_VM_DC_WRITE_HIT_REGION_3_LOW_ADDR                                  0x814
#define mmMC_VM_DC_WRITE_HIT_REGION_0_HIGH_ADDR                                 0x815
#define mmMC_VM_DC_WRITE_HIT_REGION_1_HIGH_ADDR                                 0x816
#define mmMC_VM_DC_WRITE_HIT_REGION_2_HIGH_ADDR                                 0x817
#define mmMC_VM_DC_WRITE_HIT_REGION_3_HIGH_ADDR                                 0x818
#define mmMC_VM_MX_L1_TLB_CNTL                                                  0x819
#define mmMC_VM_FB_OFFSET                                                       0x81a
#define mmMC_VM_STEERING                                                        0x81b
#define mmMC_SHARED_CHREMAP2                                                    0x81c
#define mmMC_SHARED_VF_ENABLE                                                   0x81d
#define mmMC_SHARED_VIRT_RESET_REQ                                              0x81e
#define mmMC_SHARED_ACTIVE_FCN_ID                                               0x81f
#define mmMC_CONFIG_MCD                                                         0x828
#define mmMC_CG_CONFIG_MCD                                                      0x829
#define mmMC_MEM_POWER_LS                                                       0x82a
#define mmMC_SHARED_BLACKOUT_CNTL                                               0x82b
#define mmMC_VM_MB_L1_TLB0_DEBUG                                                0x891
#define mmMC_VM_MB_L1_TLB1_DEBUG                                                0x892
#define mmMC_VM_MB_L1_TLB2_DEBUG                                                0x893
#define mmMC_VM_MB_L1_TLB0_STATUS                                               0x895
#define mmMC_VM_MB_L1_TLB1_STATUS                                               0x896
#define mmMC_VM_MB_L1_TLB2_STATUS                                               0x897
#define mmMC_VM_MB_L2ARBITER_L2_CREDITS                                         0x8a1
#define mmMC_VM_MB_L1_TLB3_DEBUG                                                0x8a5
#define mmMC_VM_MB_L1_TLB3_STATUS                                               0x8a6
#define mmMC_VM_MD_L1_TLB0_DEBUG                                                0x998
#define mmMC_VM_MD_L1_TLB1_DEBUG                                                0x999
#define mmMC_VM_MD_L1_TLB2_DEBUG                                                0x99a
#define mmMC_VM_MD_L1_TLB0_STATUS                                               0x99b
#define mmMC_VM_MD_L1_TLB1_STATUS                                               0x99c
#define mmMC_VM_MD_L1_TLB2_STATUS                                               0x99d
#define mmMC_VM_MD_L2ARBITER_L2_CREDITS                                         0x9a4
#define mmMC_VM_MD_L1_TLB3_DEBUG                                                0x9a7
#define mmMC_VM_MD_L1_TLB3_STATUS                                               0x9a8
#define mmMC_XPB_RTR_SRC_APRTR0                                                 0x8cd
#define mmMC_XPB_RTR_SRC_APRTR1                                                 0x8ce
#define mmMC_XPB_RTR_SRC_APRTR2                                                 0x8cf
#define mmMC_XPB_RTR_SRC_APRTR3                                                 0x8d0
#define mmMC_XPB_RTR_SRC_APRTR4                                                 0x8d1
#define mmMC_XPB_RTR_SRC_APRTR5                                                 0x8d2
#define mmMC_XPB_RTR_SRC_APRTR6                                                 0x8d3
#define mmMC_XPB_RTR_SRC_APRTR7                                                 0x8d4
#define mmMC_XPB_RTR_SRC_APRTR8                                                 0x8d5
#define mmMC_XPB_RTR_SRC_APRTR9                                                 0x8d6
#define mmMC_XPB_XDMA_RTR_SRC_APRTR0                                            0x8d7
#define mmMC_XPB_XDMA_RTR_SRC_APRTR1                                            0x8d8
#define mmMC_XPB_XDMA_RTR_SRC_APRTR2                                            0x8d9
#define mmMC_XPB_XDMA_RTR_SRC_APRTR3                                            0x8da
#define mmMC_XPB_RTR_DEST_MAP0                                                  0x8db
#define mmMC_XPB_RTR_DEST_MAP1                                                  0x8dc
#define mmMC_XPB_RTR_DEST_MAP2                                                  0x8dd
#define mmMC_XPB_RTR_DEST_MAP3                                                  0x8de
#define mmMC_XPB_RTR_DEST_MAP4                                                  0x8df
#define mmMC_XPB_RTR_DEST_MAP5                                                  0x8e0
#define mmMC_XPB_RTR_DEST_MAP6                                                  0x8e1
#define mmMC_XPB_RTR_DEST_MAP7                                                  0x8e2
#define mmMC_XPB_RTR_DEST_MAP8                                                  0x8e3
#define mmMC_XPB_RTR_DEST_MAP9                                                  0x8e4
#define mmMC_XPB_XDMA_RTR_DEST_MAP0                                             0x8e5
#define mmMC_XPB_XDMA_RTR_DEST_MAP1                                             0x8e6
#define mmMC_XPB_XDMA_RTR_DEST_MAP2                                             0x8e7
#define mmMC_XPB_XDMA_RTR_DEST_MAP3                                             0x8e8
#define mmMC_XPB_CLG_CFG0                                                       0x8e9
#define mmMC_XPB_CLG_CFG1                                                       0x8ea
#define mmMC_XPB_CLG_CFG2                                                       0x8eb
#define mmMC_XPB_CLG_CFG3                                                       0x8ec
#define mmMC_XPB_CLG_CFG4                                                       0x8ed
#define mmMC_XPB_CLG_CFG5                                                       0x8ee
#define mmMC_XPB_CLG_CFG6                                                       0x8ef
#define mmMC_XPB_CLG_CFG7                                                       0x8f0
#define mmMC_XPB_CLG_CFG8                                                       0x8f1
#define mmMC_XPB_CLG_CFG9                                                       0x8f2
#define mmMC_XPB_CLG_CFG10                                                      0x8f3
#define mmMC_XPB_CLG_CFG11                                                      0x8f4
#define mmMC_XPB_CLG_CFG12                                                      0x8f5
#define mmMC_XPB_CLG_CFG13                                                      0x8f6
#define mmMC_XPB_CLG_CFG14                                                      0x8f7
#define mmMC_XPB_CLG_CFG15                                                      0x8f8
#define mmMC_XPB_CLG_CFG16                                                      0x8f9
#define mmMC_XPB_CLG_CFG17                                                      0x8fa
#define mmMC_XPB_CLG_CFG18                                                      0x8fb
#define mmMC_XPB_CLG_CFG19                                                      0x8fc
#define mmMC_XPB_CLG_EXTRA                                                      0x8fd
#define mmMC_XPB_LB_ADDR                                                        0x8fe
#define mmMC_XPB_UNC_THRESH_HST                                                 0x8ff
#define mmMC_XPB_UNC_THRESH_SID                                                 0x900
#define mmMC_XPB_WCB_STS                                                        0x901
#define mmMC_XPB_WCB_CFG                                                        0x902
#define mmMC_XPB_P2P_BAR_CFG                                                    0x903
#define mmMC_XPB_P2P_BAR0                                                       0x904
#define mmMC_XPB_P2P_BAR1                                                       0x905
#define mmMC_XPB_P2P_BAR2                                                       0x906
#define mmMC_XPB_P2P_BAR3                                                       0x907
#define mmMC_XPB_P2P_BAR4                                                       0x908
#define mmMC_XPB_P2P_BAR5                                                       0x909
#define mmMC_XPB_P2P_BAR6                                                       0x90a
#define mmMC_XPB_P2P_BAR7                                                       0x90b
#define mmMC_XPB_P2P_BAR_SETUP                                                  0x90c
#define mmMC_XPB_P2P_BAR_DEBUG                                                  0x90d
#define mmMC_XPB_P2P_BAR_DELTA_ABOVE                                            0x90e
#define mmMC_XPB_P2P_BAR_DELTA_BELOW                                            0x90f
#define mmMC_XPB_PEER_SYS_BAR0                                                  0x910
#define mmMC_XPB_PEER_SYS_BAR1                                                  0x911
#define mmMC_XPB_PEER_SYS_BAR2                                                  0x912
#define mmMC_XPB_PEER_SYS_BAR3                                                  0x913
#define mmMC_XPB_PEER_SYS_BAR4                                                  0x914
#define mmMC_XPB_PEER_SYS_BAR5                                                  0x915
#define mmMC_XPB_PEER_SYS_BAR6                                                  0x916
#define mmMC_XPB_PEER_SYS_BAR7                                                  0x917
#define mmMC_XPB_PEER_SYS_BAR8                                                  0x918
#define mmMC_XPB_PEER_SYS_BAR9                                                  0x919
#define mmMC_XPB_XDMA_PEER_SYS_BAR0                                             0x91a
#define mmMC_XPB_XDMA_PEER_SYS_BAR1                                             0x91b
#define mmMC_XPB_XDMA_PEER_SYS_BAR2                                             0x91c
#define mmMC_XPB_XDMA_PEER_SYS_BAR3                                             0x91d
#define mmMC_XPB_CLK_GAT                                                        0x91e
#define mmMC_XPB_INTF_CFG                                                       0x91f
#define mmMC_XPB_INTF_STS                                                       0x920
#define mmMC_XPB_PIPE_STS                                                       0x921
#define mmMC_XPB_SUB_CTRL                                                       0x922
#define mmMC_XPB_MAP_INVERT_FLUSH_NUM_LSB                                       0x923
#define mmMC_XPB_PERF_KNOBS                                                     0x924
#define mmMC_XPB_STICKY                                                         0x925
#define mmMC_XPB_STICKY_W1C                                                     0x926
#define mmMC_XPB_MISC_CFG                                                       0x927
#define mmMC_XPB_CLG_CFG20                                                      0x928
#define mmMC_XPB_CLG_CFG21                                                      0x929
#define mmMC_XPB_CLG_CFG22                                                      0x92a
#define mmMC_XPB_CLG_CFG23                                                      0x92b
#define mmMC_XPB_CLG_CFG24                                                      0x92c
#define mmMC_XPB_CLG_CFG25                                                      0x92d
#define mmMC_XPB_CLG_CFG26                                                      0x92e
#define mmMC_XPB_CLG_CFG27                                                      0x92f
#define mmMC_XPB_CLG_CFG28                                                      0x930
#define mmMC_XPB_CLG_CFG29                                                      0x931
#define mmMC_XPB_CLG_CFG30                                                      0x932
#define mmMC_XPB_CLG_CFG31                                                      0x933
#define mmMC_XPB_INTF_CFG2                                                      0x934
#define mmMC_XPB_CLG_EXTRA_RD                                                   0x935
#define mmMC_XPB_CLG_CFG32                                                      0x936
#define mmMC_XPB_CLG_CFG33                                                      0x937
#define mmMC_XPB_CLG_CFG34                                                      0x938
#define mmMC_XPB_CLG_CFG35                                                      0x939
#define mmMC_XPB_CLG_CFG36                                                      0x93a
#define mmMC_XBAR_ADDR_DEC                                                      0xc80
#define mmMC_XBAR_REMOTE                                                        0xc81
#define mmMC_XBAR_WRREQ_CREDIT                                                  0xc82
#define mmMC_XBAR_RDREQ_CREDIT                                                  0xc83
#define mmMC_XBAR_RDREQ_PRI_CREDIT                                              0xc84
#define mmMC_XBAR_WRRET_CREDIT1                                                 0xc85
#define mmMC_XBAR_WRRET_CREDIT2                                                 0xc86
#define mmMC_XBAR_RDRET_CREDIT1                                                 0xc87
#define mmMC_XBAR_RDRET_CREDIT2                                                 0xc88
#define mmMC_XBAR_RDRET_PRI_CREDIT1                                             0xc89
#define mmMC_XBAR_RDRET_PRI_CREDIT2                                             0xc8a
#define mmMC_XBAR_CHTRIREMAP                                                    0xc8b
#define mmMC_XBAR_TWOCHAN                                                       0xc8c
#define mmMC_XBAR_ARB                                                           0xc8d
#define mmMC_XBAR_ARB_MAX_BURST                                                 0xc8e
#define mmMC_XBAR_FIFO_MON_CNTL0                                                0xc8f
#define mmMC_XBAR_FIFO_MON_CNTL1                                                0xc90
#define mmMC_XBAR_FIFO_MON_CNTL2                                                0xc91
#define mmMC_XBAR_FIFO_MON_RSLT0                                                0xc92
#define mmMC_XBAR_FIFO_MON_RSLT1                                                0xc93
#define mmMC_XBAR_FIFO_MON_RSLT2                                                0xc94
#define mmMC_XBAR_FIFO_MON_RSLT3                                                0xc95
#define mmMC_XBAR_FIFO_MON_MAX_THSH                                             0xc96
#define mmMC_XBAR_SPARE0                                                        0xc97
#define mmMC_XBAR_SPARE1                                                        0xc98
#define mmMC_CITF_PERFCOUNTER_LO                                                0x7a0
#define mmMC_HUB_PERFCOUNTER_LO                                                 0x7a1
#define mmMC_RPB_PERFCOUNTER_LO                                                 0x7a2
#define mmMC_MCBVM_PERFCOUNTER_LO                                               0x7a3
#define mmMC_MCDVM_PERFCOUNTER_LO                                               0x7a4
#define mmMC_VM_L2_PERFCOUNTER_LO                                               0x7a5
#define mmMC_ARB_PERFCOUNTER_LO                                                 0x7a6
#define mmATC_PERFCOUNTER_LO                                                    0x7a7
#define mmMC_CITF_PERFCOUNTER_HI                                                0x7a8
#define mmMC_HUB_PERFCOUNTER_HI                                                 0x7a9
#define mmMC_MCBVM_PERFCOUNTER_HI                                               0x7aa
#define mmMC_MCDVM_PERFCOUNTER_HI                                               0x7ab
#define mmMC_RPB_PERFCOUNTER_HI                                                 0x7ac
#define mmMC_VM_L2_PERFCOUNTER_HI                                               0x7ad
#define mmMC_ARB_PERFCOUNTER_HI                                                 0x7ae
#define mmATC_PERFCOUNTER_HI                                                    0x7af
#define mmMC_CITF_PERFCOUNTER0_CFG                                              0x7b0
#define mmMC_CITF_PERFCOUNTER1_CFG                                              0x7b1
#define mmMC_CITF_PERFCOUNTER2_CFG                                              0x7b2
#define mmMC_CITF_PERFCOUNTER3_CFG                                              0x7b3
#define mmMC_HUB_PERFCOUNTER0_CFG                                               0x7b4
#define mmMC_HUB_PERFCOUNTER1_CFG                                               0x7b5
#define mmMC_HUB_PERFCOUNTER2_CFG                                               0x7b6
#define mmMC_HUB_PERFCOUNTER3_CFG                                               0x7b7
#define mmMC_RPB_PERFCOUNTER0_CFG                                               0x7b8
#define mmMC_RPB_PERFCOUNTER1_CFG                                               0x7b9
#define mmMC_RPB_PERFCOUNTER2_CFG                                               0x7ba
#define mmMC_RPB_PERFCOUNTER3_CFG                                               0x7bb
#define mmMC_ARB_PERFCOUNTER0_CFG                                               0x7bc
#define mmMC_ARB_PERFCOUNTER1_CFG                                               0x7bd
#define mmMC_ARB_PERFCOUNTER2_CFG                                               0x7be
#define mmMC_ARB_PERFCOUNTER3_CFG                                               0x7bf
#define mmMC_MCBVM_PERFCOUNTER0_CFG                                             0x7c0
#define mmMC_MCBVM_PERFCOUNTER1_CFG                                             0x7c1
#define mmMC_MCBVM_PERFCOUNTER2_CFG                                             0x7c2
#define mmMC_MCBVM_PERFCOUNTER3_CFG                                             0x7c3
#define mmMC_MCDVM_PERFCOUNTER0_CFG                                             0x7c4
#define mmMC_MCDVM_PERFCOUNTER1_CFG                                             0x7c5
#define mmMC_MCDVM_PERFCOUNTER2_CFG                                             0x7c6
#define mmMC_MCDVM_PERFCOUNTER3_CFG                                             0x7c7
#define mmATC_PERFCOUNTER0_CFG                                                  0x7c8
#define mmATC_PERFCOUNTER1_CFG                                                  0x7c9
#define mmATC_PERFCOUNTER2_CFG                                                  0x7ca
#define mmATC_PERFCOUNTER3_CFG                                                  0x7cb
#define mmMC_VM_L2_PERFCOUNTER0_CFG                                             0x7cc
#define mmMC_VM_L2_PERFCOUNTER1_CFG                                             0x7cd
#define mmMC_CITF_PERFCOUNTER_RSLT_CNTL                                         0x7ce
#define mmMC_HUB_PERFCOUNTER_RSLT_CNTL                                          0x7cf
#define mmMC_RPB_PERFCOUNTER_RSLT_CNTL                                          0x7d0
#define mmMC_MCBVM_PERFCOUNTER_RSLT_CNTL                                        0x7d1
#define mmMC_MCDVM_PERFCOUNTER_RSLT_CNTL                                        0x7d2
#define mmMC_VM_L2_PERFCOUNTER_RSLT_CNTL                                        0x7d3
#define mmMC_ARB_PERFCOUNTER_RSLT_CNTL                                          0x7d4
#define mmATC_PERFCOUNTER_RSLT_CNTL                                             0x7d5
#define mmCHUB_ATC_PERFCOUNTER_LO                                               0x7d6
#define mmCHUB_ATC_PERFCOUNTER_HI                                               0x7d7
#define mmCHUB_ATC_PERFCOUNTER0_CFG                                             0x7d8
#define mmCHUB_ATC_PERFCOUNTER1_CFG                                             0x7d9
#define mmCHUB_ATC_PERFCOUNTER_RSLT_CNTL                                        0x7da
#define mmMC_GRUB_PERFCOUNTER_LO                                                0x7e4
#define mmMC_GRUB_PERFCOUNTER_HI                                                0x7e5
#define mmMC_GRUB_PERFCOUNTER0_CFG                                              0x7e6
#define mmMC_GRUB_PERFCOUNTER1_CFG                                              0x7e7
#define mmMC_GRUB_PERFCOUNTER_RSLT_CNTL                                         0x7e8
#define mmATC_VM_APERTURE0_LOW_ADDR                                             0xcc0
#define mmATC_VM_APERTURE1_LOW_ADDR                                             0xcc1
#define mmATC_VM_APERTURE0_HIGH_ADDR                                            0xcc2
#define mmATC_VM_APERTURE1_HIGH_ADDR                                            0xcc3
#define mmATC_VM_APERTURE0_CNTL                                                 0xcc4
#define mmATC_VM_APERTURE1_CNTL                                                 0xcc5
#define mmATC_VM_APERTURE0_CNTL2                                                0xcc6
#define mmATC_VM_APERTURE1_CNTL2                                                0xcc7
#define mmATC_ATS_CNTL                                                          0xcc9
#define mmATC_ATS_DEBUG                                                         0xcca
#define mmATC_ATS_FAULT_DEBUG                                                   0xccb
#define mmATC_ATS_STATUS                                                        0xccc
#define mmATC_ATS_FAULT_CNTL                                                    0xccd
#define mmATC_ATS_FAULT_STATUS_INFO                                             0xcce
#define mmATC_ATS_FAULT_STATUS_ADDR                                             0xccf
#define mmATC_ATS_DEFAULT_PAGE_LOW                                              0xcd0
#define mmATC_ATS_DEFAULT_PAGE_CNTL                                             0xcd1
#define mmATC_ATS_FAULT_STATUS_INFO2                                            0xcd2
#define mmATC_MISC_CG                                                           0xcd4
#define mmATC_L2_CNTL                                                           0xcd5
#define mmATC_L2_CNTL2                                                          0xcd6
#define mmATC_L2_DEBUG                                                          0xcd7
#define mmATC_L2_DEBUG2                                                         0xcd8
#define mmATC_L2_CACHE_DATA0                                                    0xcd9
#define mmATC_L2_CACHE_DATA1                                                    0xcda
#define mmATC_L2_CACHE_DATA2                                                    0xcdb
#define mmATC_L1_CNTL                                                           0xcdc
#define mmATC_L1_ADDRESS_OFFSET                                                 0xcdd
#define mmATC_L1RD_DEBUG_TLB                                                    0xcde
#define mmATC_L1WR_DEBUG_TLB                                                    0xcdf
#define mmATC_L1RD_STATUS                                                       0xce0
#define mmATC_L1WR_STATUS                                                       0xce1
#define mmATC_L1RD_DEBUG2_TLB                                                   0xce2
#define mmATC_L1WR_DEBUG2_TLB                                                   0xce3
#define mmATC_VMID_PASID_MAPPING_UPDATE_STATUS                                  0xce6
#define mmATC_VMID0_PASID_MAPPING                                               0xce7
#define mmATC_VMID1_PASID_MAPPING                                               0xce8
#define mmATC_VMID2_PASID_MAPPING                                               0xce9
#define mmATC_VMID3_PASID_MAPPING                                               0xcea
#define mmATC_VMID4_PASID_MAPPING                                               0xceb
#define mmATC_VMID5_PASID_MAPPING                                               0xcec
#define mmATC_VMID6_PASID_MAPPING                                               0xced
#define mmATC_VMID7_PASID_MAPPING                                               0xcee
#define mmATC_VMID8_PASID_MAPPING                                               0xcef
#define mmATC_VMID9_PASID_MAPPING                                               0xcf0
#define mmATC_VMID10_PASID_MAPPING                                              0xcf1
#define mmATC_VMID11_PASID_MAPPING                                              0xcf2
#define mmATC_VMID12_PASID_MAPPING                                              0xcf3
#define mmATC_VMID13_PASID_MAPPING                                              0xcf4
#define mmATC_VMID14_PASID_MAPPING                                              0xcf5
#define mmATC_VMID15_PASID_MAPPING                                              0xcf6
#define mmATC_ATS_VMID_STATUS                                                   0xd07
#define mmATC_ATS_SMU_STATUS                                                    0xd08
#define mmATC_L2_CNTL3                                                          0xd09
#define mmATC_L2_STATUS                                                         0xd0a
#define mmATC_L2_STATUS2                                                        0xd0b
#define mmGMCON_RENG_RAM_INDEX                                                  0xd40
#define mmGMCON_RENG_RAM_DATA                                                   0xd41
#define mmGMCON_RENG_EXECUTE                                                    0xd42
#define mmGMCON_MISC                                                            0xd43
#define mmGMCON_MISC2                                                           0xd44
#define mmGMCON_STCTRL_REGISTER_SAVE_RANGE0                                     0xd45
#define mmGMCON_STCTRL_REGISTER_SAVE_RANGE1                                     0xd46
#define mmGMCON_STCTRL_REGISTER_SAVE_RANGE2                                     0xd47
#define mmGMCON_STCTRL_REGISTER_SAVE_EXCL_SET0                                  0xd48
#define mmGMCON_STCTRL_REGISTER_SAVE_EXCL_SET1                                  0xd49
#define mmGMCON_PERF_MON_CNTL0                                                  0xd4a
#define mmGMCON_PERF_MON_CNTL1                                                  0xd4b
#define mmGMCON_PERF_MON_RSLT0                                                  0xd4c
#define mmGMCON_PERF_MON_RSLT1                                                  0xd4d
#define mmGMCON_PGFSM_CONFIG                                                    0xd4e
#define mmGMCON_PGFSM_WRITE                                                     0xd4f
#define mmGMCON_PGFSM_READ                                                      0xd50
#define mmGMCON_MISC3                                                           0xd51
#define mmGMCON_MASK                                                            0xd52
#define mmGMCON_LPT_TARGET                                                      0xd53
#define mmGMCON_DEBUG                                                           0xd5f
#define mmVM_L2_CNTL                                                            0x500
#define mmVM_L2_CNTL2                                                           0x501
#define mmVM_L2_CNTL3                                                           0x502
#define mmVM_L2_STATUS                                                          0x503
#define mmVM_CONTEXT0_CNTL                                                      0x504
#define mmVM_CONTEXT1_CNTL                                                      0x505
#define mmVM_DUMMY_PAGE_FAULT_CNTL                                              0x506
#define mmVM_DUMMY_PAGE_FAULT_ADDR                                              0x507
#define mmVM_CONTEXT0_CNTL2                                                     0x50c
#define mmVM_CONTEXT1_CNTL2                                                     0x50d
#define mmVM_CONTEXT8_PAGE_TABLE_BASE_ADDR                                      0x50e
#define mmVM_CONTEXT9_PAGE_TABLE_BASE_ADDR                                      0x50f
#define mmVM_CONTEXT10_PAGE_TABLE_BASE_ADDR                                     0x510
#define mmVM_CONTEXT11_PAGE_TABLE_BASE_ADDR                                     0x511
#define mmVM_CONTEXT12_PAGE_TABLE_BASE_ADDR                                     0x512
#define mmVM_CONTEXT13_PAGE_TABLE_BASE_ADDR                                     0x513
#define mmVM_CONTEXT14_PAGE_TABLE_BASE_ADDR                                     0x514
#define mmVM_CONTEXT15_PAGE_TABLE_BASE_ADDR                                     0x515
#define mmVM_INVALIDATE_REQUEST                                                 0x51e
#define mmVM_INVALIDATE_RESPONSE                                                0x51f
#define mmVM_PRT_APERTURE0_LOW_ADDR                                             0x52c
#define mmVM_PRT_APERTURE1_LOW_ADDR                                             0x52d
#define mmVM_PRT_APERTURE2_LOW_ADDR                                             0x52e
#define mmVM_PRT_APERTURE3_LOW_ADDR                                             0x52f
#define mmVM_PRT_APERTURE0_HIGH_ADDR                                            0x530
#define mmVM_PRT_APERTURE1_HIGH_ADDR                                            0x531
#define mmVM_PRT_APERTURE2_HIGH_ADDR                                            0x532
#define mmVM_PRT_APERTURE3_HIGH_ADDR                                            0x533
#define mmVM_PRT_CNTL                                                           0x534
#define mmVM_CONTEXTS_DISABLE                                                   0x535
#define mmVM_CONTEXT0_PROTECTION_FAULT_STATUS                                   0x536
#define mmVM_CONTEXT1_PROTECTION_FAULT_STATUS                                   0x537
#define mmVM_CONTEXT0_PROTECTION_FAULT_MCCLIENT                                 0x538
#define mmVM_CONTEXT1_PROTECTION_FAULT_MCCLIENT                                 0x539
#define mmVM_CONTEXT0_PROTECTION_FAULT_ADDR                                     0x53e
#define mmVM_CONTEXT1_PROTECTION_FAULT_ADDR                                     0x53f
#define mmVM_CONTEXT0_PROTECTION_FAULT_DEFAULT_ADDR                             0x546
#define mmVM_CONTEXT1_PROTECTION_FAULT_DEFAULT_ADDR                             0x547
#define mmVM_FAULT_CLIENT_ID                                                    0x54e
#define mmVM_CONTEXT0_PAGE_TABLE_BASE_ADDR                                      0x54f
#define mmVM_CONTEXT1_PAGE_TABLE_BASE_ADDR                                      0x550
#define mmVM_CONTEXT2_PAGE_TABLE_BASE_ADDR                                      0x551
#define mmVM_CONTEXT3_PAGE_TABLE_BASE_ADDR                                      0x552
#define mmVM_CONTEXT4_PAGE_TABLE_BASE_ADDR                                      0x553
#define mmVM_CONTEXT5_PAGE_TABLE_BASE_ADDR                                      0x554
#define mmVM_CONTEXT6_PAGE_TABLE_BASE_ADDR                                      0x555
#define mmVM_CONTEXT7_PAGE_TABLE_BASE_ADDR                                      0x556
#define mmVM_CONTEXT0_PAGE_TABLE_START_ADDR                                     0x557
#define mmVM_CONTEXT1_PAGE_TABLE_START_ADDR                                     0x558
#define mmVM_CONTEXT0_PAGE_TABLE_END_ADDR                                       0x55f
#define mmVM_CONTEXT1_PAGE_TABLE_END_ADDR                                       0x560
#define mmVM_DEBUG                                                              0x56f
#define mmVM_L2_CG                                                              0x570
#define mmVM_L2_BANK_SELECT_MASKA                                               0x572
#define mmVM_L2_BANK_SELECT_MASKB                                               0x573
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR                             0x575
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR                            0x576
#define mmVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET                                0x577
#define mmVM_L2_CNTL4                                                           0x578
#define mmVM_L2_BANK_SELECT_RESERVED_CID                                        0x579
#define mmMC_VM_FB_SIZE_OFFSET_VF0                                              0xf980
#define mmMC_VM_FB_SIZE_OFFSET_VF1                                              0xf981
#define mmMC_VM_FB_SIZE_OFFSET_VF2                                              0xf982
#define mmMC_VM_FB_SIZE_OFFSET_VF3                                              0xf983
#define mmMC_VM_FB_SIZE_OFFSET_VF4                                              0xf984
#define mmMC_VM_FB_SIZE_OFFSET_VF5                                              0xf985
#define mmMC_VM_FB_SIZE_OFFSET_VF6                                              0xf986
#define mmMC_VM_FB_SIZE_OFFSET_VF7                                              0xf987
#define mmMC_VM_FB_SIZE_OFFSET_VF8                                              0xf988
#define mmMC_VM_FB_SIZE_OFFSET_VF9                                              0xf989
#define mmMC_VM_FB_SIZE_OFFSET_VF10                                             0xf98a
#define mmMC_VM_FB_SIZE_OFFSET_VF11                                             0xf98b
#define mmMC_VM_FB_SIZE_OFFSET_VF12                                             0xf98c
#define mmMC_VM_FB_SIZE_OFFSET_VF13                                             0xf98d
#define mmMC_VM_FB_SIZE_OFFSET_VF14                                             0xf98e
#define mmMC_VM_FB_SIZE_OFFSET_VF15                                             0xf98f
#define mmMC_VM_NB_MMIOBASE                                                     0xf990
#define mmMC_VM_NB_MMIOLIMIT                                                    0xf991
#define mmMC_VM_NB_PCI_CTRL                                                     0xf992
#define mmMC_VM_NB_PCI_ARB                                                      0xf993
#define mmMC_VM_NB_TOP_OF_DRAM_SLOT1                                            0xf994
#define mmMC_VM_NB_LOWER_TOP_OF_DRAM2                                           0xf995
#define mmMC_VM_NB_UPPER_TOP_OF_DRAM2                                           0xf996
#define mmMC_VM_NB_TOP_OF_DRAM3                                                 0xf997
#define mmMC_VM_MARC_BASE_LO_0                                                  0xf998
#define mmMC_VM_MARC_BASE_LO_1                                                  0xf99e
#define mmMC_VM_MARC_BASE_LO_2                                                  0xf9a4
#define mmMC_VM_MARC_BASE_LO_3                                                  0xf9aa
#define mmMC_VM_MARC_BASE_HI_0                                                  0xf999
#define mmMC_VM_MARC_BASE_HI_1                                                  0xf99f
#define mmMC_VM_MARC_BASE_HI_2                                                  0xf9a5
#define mmMC_VM_MARC_BASE_HI_3                                                  0xf9ab
#define mmMC_VM_MARC_RELOC_LO_0                                                 0xf99a
#define mmMC_VM_MARC_RELOC_LO_1                                                 0xf9a0
#define mmMC_VM_MARC_RELOC_LO_2                                                 0xf9a6
#define mmMC_VM_MARC_RELOC_LO_3                                                 0xf9ac
#define mmMC_VM_MARC_RELOC_HI_0                                                 0xf99b
#define mmMC_VM_MARC_RELOC_HI_1                                                 0xf9a1
#define mmMC_VM_MARC_RELOC_HI_2                                                 0xf9a7
#define mmMC_VM_MARC_RELOC_HI_3                                                 0xf9ad
#define mmMC_VM_MARC_LEN_LO_0                                                   0xf99c
#define mmMC_VM_MARC_LEN_LO_1                                                   0xf9a2
#define mmMC_VM_MARC_LEN_LO_2                                                   0xf9a8
#define mmMC_VM_MARC_LEN_LO_3                                                   0xf9ae
#define mmMC_VM_MARC_LEN_HI_0                                                   0xf99d
#define mmMC_VM_MARC_LEN_HI_1                                                   0xf9a3
#define mmMC_VM_MARC_LEN_HI_2                                                   0xf9a9
#define mmMC_VM_MARC_LEN_HI_3                                                   0xf9af
#define mmMC_VM_MARC_CNTL                                                       0xf9b0
#define mmMC_ARB_HARSH_EN_RD                                                    0xdc0
#define mmMC_ARB_HARSH_EN_WR                                                    0xdc1
#define mmMC_ARB_HARSH_TX_HI0_RD                                                0xdc2
#define mmMC_ARB_HARSH_TX_HI0_WR                                                0xdc3
#define mmMC_ARB_HARSH_TX_HI1_RD                                                0xdc4
#define mmMC_ARB_HARSH_TX_HI1_WR                                                0xdc5
#define mmMC_ARB_HARSH_TX_LO0_RD                                                0xdc6
#define mmMC_ARB_HARSH_TX_LO0_WR                                                0xdc7
#define mmMC_ARB_HARSH_TX_LO1_RD                                                0xdc8
#define mmMC_ARB_HARSH_TX_LO1_WR                                                0xdc9
#define mmMC_ARB_HARSH_BWPERIOD0_RD                                             0xdca
#define mmMC_ARB_HARSH_BWPERIOD0_WR                                             0xdcb
#define mmMC_ARB_HARSH_BWPERIOD1_RD                                             0xdcc
#define mmMC_ARB_HARSH_BWPERIOD1_WR                                             0xdcd
#define mmMC_ARB_HARSH_BWCNT0_RD                                                0xdce
#define mmMC_ARB_HARSH_BWCNT0_WR                                                0xdcf
#define mmMC_ARB_HARSH_BWCNT1_RD                                                0xdd0
#define mmMC_ARB_HARSH_BWCNT1_WR                                                0xdd1
#define mmMC_ARB_HARSH_SAT0_RD                                                  0xdd2
#define mmMC_ARB_HARSH_SAT0_WR                                                  0xdd3
#define mmMC_ARB_HARSH_SAT1_RD                                                  0xdd4
#define mmMC_ARB_HARSH_SAT1_WR                                                  0xdd5
#define mmMC_ARB_HARSH_CTL_RD                                                   0xdd6
#define mmMC_ARB_HARSH_CTL_WR                                                   0xdd7
#define mmMC_ARB_GRUB_PRIORITY1_RD                                              0xdd8
#define mmMC_ARB_GRUB_PRIORITY1_WR                                              0xdd9
#define mmMC_ARB_GRUB_PRIORITY2_RD                                              0xdda
#define mmMC_ARB_GRUB_PRIORITY2_WR                                              0xddb
#define mmMC_FUS_DRAM0_CS0_BASE                                                 0xa05
#define mmMC_FUS_DRAM1_CS0_BASE                                                 0xa06
#define mmMC_FUS_DRAM0_CS1_BASE                                                 0xa07
#define mmMC_FUS_DRAM1_CS1_BASE                                                 0xa08
#define mmMC_FUS_DRAM0_CS2_BASE                                                 0xa09
#define mmMC_FUS_DRAM1_CS2_BASE                                                 0xa0a
#define mmMC_FUS_DRAM0_CS3_BASE                                                 0xa0b
#define mmMC_FUS_DRAM1_CS3_BASE                                                 0xa0c
#define mmMC_FUS_DRAM0_CS01_MASK                                                0xa0d
#define mmMC_FUS_DRAM1_CS01_MASK                                                0xa0e
#define mmMC_FUS_DRAM0_CS23_MASK                                                0xa0f
#define mmMC_FUS_DRAM1_CS23_MASK                                                0xa10
#define mmMC_FUS_DRAM0_BANK_ADDR_MAPPING                                        0xa11
#define mmMC_FUS_DRAM1_BANK_ADDR_MAPPING                                        0xa12
#define mmMC_FUS_DRAM0_CTL_BASE                                                 0xa13
#define mmMC_FUS_DRAM1_CTL_BASE                                                 0xa14
#define mmMC_FUS_DRAM0_CTL_LIMIT                                                0xa15
#define mmMC_FUS_DRAM1_CTL_LIMIT                                                0xa16
#define mmMC_FUS_DRAM_CTL_HIGH_01                                               0xa17
#define mmMC_FUS_DRAM_CTL_HIGH_23                                               0xa18
#define mmMC_FUS_DRAM_MODE                                                      0xa19
#define mmMC_FUS_DRAM_APER_BASE                                                 0xa1a
#define mmMC_FUS_DRAM_APER_TOP                                                  0xa1b
#define mmMC_FUS_DRAM_APER_DEF                                                  0xa1e
#define mmMC_FUS_ARB_GARLIC_ISOC_PRI                                            0xa1f
#define mmMC_FUS_ARB_GARLIC_CNTL                                                0xa20
#define mmMC_FUS_ARB_GARLIC_WR_PRI                                              0xa21
#define mmMC_FUS_ARB_GARLIC_WR_PRI2                                             0xa22
#define mmMC_CG_DATAPORT                                                        0xa32
#define mmMC_GRUB_PROBE_MAP                                                     0xa33
#define mmMC_GRUB_POST_PROBE_DELAY                                              0xa34
#define mmMC_GRUB_PROBE_CREDITS                                                 0xa35
#define mmMC_GRUB_FEATURES                                                      0xa36
#define mmMC_GRUB_TX_CREDITS                                                    0xa37
#define mmMC_GRUB_TCB_INDEX                                                     0xa38
#define mmMC_GRUB_TCB_DATA_LO                                                   0xa39
#define mmMC_GRUB_TCB_DATA_HI                                                   0xa3a
#define mmMCIF_WB_BUFMGR_SW_CONTROL                                             0x5e78
#define mmMCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL                                    0x5e78
#define mmMCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL                                    0x5eb8
#define mmMCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL                                    0x5ef8
#define mmMCIF_WB_BUFMGR_CUR_LINE_R                                             0x5e79
#define mmMCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R                                    0x5e79
#define mmMCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R                                    0x5eb9
#define mmMCIF_WB2_MCIF_WB_BUFMGR_CUR_LINE_R                                    0x5ef9
#define mmMCIF_WB_BUFMGR_STATUS                                                 0x5e7a
#define mmMCIF_WB0_MCIF_WB_BUFMGR_STATUS                                        0x5e7a
#define mmMCIF_WB1_MCIF_WB_BUFMGR_STATUS                                        0x5eba
#define mmMCIF_WB2_MCIF_WB_BUFMGR_STATUS                                        0x5efa
#define mmMCIF_WB_BUF_PITCH                                                     0x5e7b
#define mmMCIF_WB0_MCIF_WB_BUF_PITCH                                            0x5e7b
#define mmMCIF_WB1_MCIF_WB_BUF_PITCH                                            0x5ebb
#define mmMCIF_WB2_MCIF_WB_BUF_PITCH                                            0x5efb
#define mmMCIF_WB_BUF_1_STATUS                                                  0x5e7c
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS                                         0x5e7c
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS                                         0x5ebc
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS                                         0x5efc
#define mmMCIF_WB_BUF_1_STATUS2                                                 0x5e7d
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS2                                        0x5e7d
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS2                                        0x5ebd
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS2                                        0x5efd
#define mmMCIF_WB_BUF_2_STATUS                                                  0x5e7e
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS                                         0x5e7e
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS                                         0x5ebe
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS                                         0x5efe
#define mmMCIF_WB_BUF_2_STATUS2                                                 0x5e7f
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS2                                        0x5e7f
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS2                                        0x5ebf
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS2                                        0x5eff
#define mmMCIF_WB_BUF_3_STATUS                                                  0x5e80
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS                                         0x5e80
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS                                         0x5ec0
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS                                         0x5f00
#define mmMCIF_WB_BUF_3_STATUS2                                                 0x5e81
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS2                                        0x5e81
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS2                                        0x5ec1
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS2                                        0x5f01
#define mmMCIF_WB_BUF_4_STATUS                                                  0x5e82
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS                                         0x5e82
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS                                         0x5ec2
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS                                         0x5f02
#define mmMCIF_WB_BUF_4_STATUS2                                                 0x5e83
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS2                                        0x5e83
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS2                                        0x5ec3
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS2                                        0x5f03
#define mmMCIF_WB_ARBITRATION_CONTROL                                           0x5e84
#define mmMCIF_WB0_MCIF_WB_ARBITRATION_CONTROL                                  0x5e84
#define mmMCIF_WB1_MCIF_WB_ARBITRATION_CONTROL                                  0x5ec4
#define mmMCIF_WB2_MCIF_WB_ARBITRATION_CONTROL                                  0x5f04
#define mmMCIF_WB_URGENCY_WATERMARK                                             0x5e85
#define mmMCIF_WB0_MCIF_WB_URGENCY_WATERMARK                                    0x5e85
#define mmMCIF_WB1_MCIF_WB_URGENCY_WATERMARK                                    0x5ec5
#define mmMCIF_WB2_MCIF_WB_URGENCY_WATERMARK                                    0x5f05
#define mmMCIF_WB_TEST_DEBUG_INDEX                                              0x5e86
#define mmMCIF_WB0_MCIF_WB_TEST_DEBUG_INDEX                                     0x5e86
#define mmMCIF_WB1_MCIF_WB_TEST_DEBUG_INDEX                                     0x5ec6
#define mmMCIF_WB2_MCIF_WB_TEST_DEBUG_INDEX                                     0x5f06
#define mmMCIF_WB_TEST_DEBUG_DATA                                               0x5e87
#define mmMCIF_WB0_MCIF_WB_TEST_DEBUG_DATA                                      0x5e87
#define mmMCIF_WB1_MCIF_WB_TEST_DEBUG_DATA                                      0x5ec7
#define mmMCIF_WB2_MCIF_WB_TEST_DEBUG_DATA                                      0x5f07
#define mmMCIF_WB_BUF_1_ADDR_Y                                                  0x5e88
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y                                         0x5e88
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y                                         0x5ec8
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y                                         0x5f08
#define mmMCIF_WB_BUF_1_ADDR_Y_OFFSET                                           0x5e89
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                  0x5e89
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                  0x5ec9
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                  0x5f09
#define mmMCIF_WB_BUF_1_ADDR_C                                                  0x5e8a
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C                                         0x5e8a
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C                                         0x5eca
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C                                         0x5f0a
#define mmMCIF_WB_BUF_1_ADDR_C_OFFSET                                           0x5e8b
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET                                  0x5e8b
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET                                  0x5ecb
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C_OFFSET                                  0x5f0b
#define mmMCIF_WB_BUF_2_ADDR_Y                                                  0x5e8c
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y                                         0x5e8c
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y                                         0x5ecc
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y                                         0x5f0c
#define mmMCIF_WB_BUF_2_ADDR_Y_OFFSET                                           0x5e8d
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                  0x5e8d
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                  0x5ecd
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                  0x5f0d
#define mmMCIF_WB_BUF_2_ADDR_C                                                  0x5e8e
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C                                         0x5e8e
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C                                         0x5ece
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C                                         0x5f0e
#define mmMCIF_WB_BUF_2_ADDR_C_OFFSET                                           0x5e8f
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET                                  0x5e8f
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET                                  0x5ecf
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C_OFFSET                                  0x5f0f
#define mmMCIF_WB_BUF_3_ADDR_Y                                                  0x5e90
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y                                         0x5e90
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y                                         0x5ed0
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y                                         0x5f10
#define mmMCIF_WB_BUF_3_ADDR_Y_OFFSET                                           0x5e91
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                  0x5e91
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                  0x5ed1
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                  0x5f11
#define mmMCIF_WB_BUF_3_ADDR_C                                                  0x5e92
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C                                         0x5e92
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C                                         0x5ed2
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C                                         0x5f12
#define mmMCIF_WB_BUF_3_ADDR_C_OFFSET                                           0x5e93
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET                                  0x5e93
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET                                  0x5ed3
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C_OFFSET                                  0x5f13
#define mmMCIF_WB_BUF_4_ADDR_Y                                                  0x5e94
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y                                         0x5e94
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y                                         0x5ed4
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y                                         0x5f14
#define mmMCIF_WB_BUF_4_ADDR_Y_OFFSET                                           0x5e95
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                  0x5e95
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                  0x5ed5
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                  0x5f15
#define mmMCIF_WB_BUF_4_ADDR_C                                                  0x5e96
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C                                         0x5e96
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C                                         0x5ed6
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C                                         0x5f16
#define mmMCIF_WB_BUF_4_ADDR_C_OFFSET                                           0x5e97
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET                                  0x5e97
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET                                  0x5ed7
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C_OFFSET                                  0x5f17
#define mmMCIF_WB_BUFMGR_VCE_CONTROL                                            0x5e98
#define mmMCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL                                   0x5e98
#define mmMCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL                                   0x5ed8
#define mmMCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL                                   0x5f18
#define mmMCIF_WB_HVVMID_CONTROL                                                0x5e99
#define mmMCIF_WB0_MCIF_WB_HVVMID_CONTROL                                       0x5e99
#define mmMCIF_WB1_MCIF_WB_HVVMID_CONTROL                                       0x5ed9
#define mmMCIF_WB2_MCIF_WB_HVVMID_CONTROL                                       0x5f19

#endif /* GMC_8_2_D_H */
