untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8orivPAGWqU5oIJWxuw0SbZFtd+BSiX70ix/PXm4NF8axSgyiBw9ECF0hBRdJKGEo6XQEI4xg4cpxTDGfck0LBA0=

OpenBSD 7.6 errata 018, June 17, 2025:

In acme-client(1), handle as yet unobserved "processing" state when
fetching an issued certificate by retrying instead of giving up.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 018_acme.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install new acme-client:
    cd /usr/src/usr.sbin/acme-client
    make obj
    make
    make install

Index: usr.sbin/acme-client/netproc.c
===================================================================
RCS file: /cvs/src/usr.sbin/acme-client/netproc.c,v
diff -u -p -r1.35 netproc.c
--- usr.sbin/acme-client/netproc.c	28 Apr 2024 10:09:25 -0000	1.35
+++ usr.sbin/acme-client/netproc.c	3 Jun 2025 14:40:08 -0000
@@ -661,7 +661,7 @@ netproc(int kfd, int afd, int Cfd, int c
     int revocate, struct authority_c *authority,
     const char *const *alts, size_t altsz)
 {
-	int		 rc = 0;
+	int		 rc = 0, retries = 0;
 	size_t		 i;
 	char		*cert = NULL, *thumb = NULL, *error = NULL;
 	struct conn	 c;
@@ -851,6 +851,9 @@ netproc(int kfd, int afd, int Cfd, int c
 			if (!docert(&c, order.finalize, cert))
 				goto out;
 			break;
+		case ORDER_PROCESSING:
+			/* we'll just retry */
+			break;
 		default:
 			warnx("unhandled status: %d", order.status);
 			goto out;
@@ -859,8 +862,19 @@ netproc(int kfd, int afd, int Cfd, int c
 			goto out;
 
 		dodbg("order.status %d", order.status);
-		if (order.status == ORDER_PENDING)
+		switch (order.status) {
+		case ORDER_PENDING:
+		case ORDER_PROCESSING:
+			if (retries++ > RETRY_MAX) {
+				warnx("too many retries");
+				goto out;
+			}
 			sleep(RETRY_DELAY);
+			break;
+		default:
+			retries = 0; /* state changed, we made progress */
+			break;
+		}
 	}
 
 	if (order.status != ORDER_VALID) {
