/* OS/2 REXX */
/* Copyright (C)1996 by Holger.Veit@gmd.de */
/* This script cleans the 3.1.2D directory before installation of 3.1.2E
 * It is mandatory to call this script before
 * This file is different from a simple recursive remove-everything,
 * it will preserve installed user apps and certain user files.
 */
'@echo off'
ADDRESS CMD
CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs
env = 'OS2ENVIRONMENT'
x11root = VALUE('X11ROOT',,env)
IF x11root = '' THEN DO
	SAY "You must have the environment variable X11ROOT set to point to"
	SAY "the root of your XFree86 3.1.2D installation".
	EXIT
END

bindir=x11root'\XFree86\bin'
libdir=x11root'\XFree86\lib'
mandir=x11root'\XFree86\man'

dir=bindir
ext=".exe"
lst="appres atobm bdftopcf beforelight bitmap bmtoa dga editres fsinfo "
lst=lst||"fslsfonts fstobdf iceauth imake makedepend mkfontdir oclock "
lst=lst||"reconfig resize showrgb smproxy twm xauth xclipboard xclock "
lst=lst||"xcmsdb xconsole xcutsel xdpyinfo xf86config XF86_8514 XF86_AGX "
lst=lst||"XF86_I128 XF86_Mach32 XF86_Mach64 XF86_Mach8 XF86_Mono XF86_P9000 "
lst=lst||"XF86_S3 XF86_SVGA XF86_VGA16 XF86_W32 xfd xfs xhost xieperf xinit "
lst=lst||"xkbbell xkbcomp xkbevd xkbprint xkbvleds xkbwatch xkill xlogo "
lst=lst||"xlsatoms xlsclients xlsfonts xmag xman xmh xmodmap Xnest xprop "
lst=lst||"xrdb xrefresh xset xsetmode xsetpointer xsetroot xsm xstdcmap "
lst=lst||"xterm Xvfb xvidtune xwd xwininfo xwud"
CALL clearit dir,lst,ext

dir=bindir
ext=".cmd"
lst="rstart xmkmf imakesvc indir make mkdirhier os2inst"
CALL clearit dir,lst,ext

dirtoclean=libdir
ext=""
lst="FS.a FS.lib ICE.a ICE.dll ICE.lib ICE_s.a oldX.a oldX.lib "
lst=lst||"PEX5.a PEX5.dll PEX5.lib PEX5_s.a SM.a SM.dll SM.lib SM_s.a X11.a "
lst=lst||"X11.dll X11.lib X11_s.a Xau.a Xau.lib Xaw.a Xaw.dll Xaw.lib Xaw_s.a "
lst=lst||"Xdmcp.a Xdmcp.lib Xext.a Xext.dll Xext.lib Xext_s.a Xi.a Xi.dll Xi.lib "
lst=lst||"XIE.a XIE.dll XIE.lib XIE_s.a Xi_s.a xkbfile.a xkbfile.lib Xmu.a Xmu.dll "
lst=lst||"Xmu.lib Xmu_s.a Xss.a Xss.lib Xt.a Xt.dll Xt.lib Xtst.a Xtst.dll Xtst.lib "
lst=lst||"Xtst_s.a Xt_s.a Xxf86dga.a Xxf86dga.lib Xxf86misc.a Xxf86misc.lib Xxf86vm.a "
lst=lst||"Xxf86vm.lib"
CALL clearit dir,lst,ext

dir=libdir'\X11\app-defaults'
ext=""
lst="XTerm XTerm-color"
CALL clearit dir,lst,ext

dir=libdir'\X11\config'
ext=""
lst="Imake.cf Imake.rules Imake.tmpl Library.tmpl os2.cf os2.rules "
lst=lst||"os2Lib.rules os2Lib.tmpl Project.tmpl Server.tmpl site.def xf86.rules "
lst=lst||"xf86.tmpl xf86site.def xfree86.cf"
CALL clearit dir,lst,ext

dir=libdir'\X11\doc'
ext=""
lst="AccelCards BetaReport COPYRIGHT Devices INSTALL LbxproxyOnly "
lst=lst||"Monitors QuickStart.doc README README.agx README.ark README.ati "
lst=lst||"README.cirrus README.clkprog README.Config README.DGA README.LinkKit "
lst=lst||"README.Mach64 README.Oak README.P9000 README.S3 README.trident README.tseng "
lst=lst||"README.Video7 README.W32 README.WstDig RELNOTES ServersOnly VGADriver.Doc "
lst=lst||"xinput"
CALL clearit dir,lst,ext

dir=mandir'\man1'
ext=""
lst="SuperProbe.1 xf86config.1 XF86_8514.1 XF86_Accel.1 XF86_AGX.1 "
lst=lst||"XF86_I128.1 XF86_Mach32.1 XF86_Mach64.1 XF86_Mach8.1 XF86_Mono.1 "
lst=lst||"XF86_P9000.1 XF86_S3.1 XF86_SVGA.1 XF86_VGA16.1 XF86_W32.1 "
lst=lst||"XFree86.1 Xserver.1 XF86Config.1"
CALL clearit dir,lst,ext
EXIT

clearit: PROCEDURE
	ARG dir,list,ext
	DO i=1 TO WORDS(list)
		file = dir'\'WORD(list,i)||ext
		SAY "deleting "file
		Call SysFileDelete(file)
	END
	RETURN
