//
// ThumbnailImage.cpp - thumbnail image class.
//
// Copyright (c) 2005  Yuuichi Teranishi
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

#include "ThumbnailImage.h"

ThumbnailImage::ThumbnailImage ()
{
    FMalloc = NULL;
    FDesktopFolder = NULL;
    // Initialize COM
    CoInitialize (NULL);
    SHGetMalloc (&FMalloc);
    SHGetDesktopFolder (&FDesktopFolder);
}

ThumbnailImage::~ThumbnailImage ()
{
    if(FDesktopFolder != NULL)
      {
        FDesktopFolder->Release();
        FDesktopFolder = NULL;
      }
    if(FMalloc != NULL)
      {
        FMalloc->Release();
        FMalloc = NULL;
      }
}

HBITMAP ThumbnailImage::ExtractFolder (LPOLESTR AFileName,
				       int AThumbWidth,
				       int AThumbHeight,
				       DWORD dwRecClrDepth,
				       LPSHELLFOLDER AFolder)
{
    HBITMAP hBitmap = NULL;
    HRESULT hRes;

    LPITEMIDLIST    pIDLFile;
    hRes = AFolder->ParseDisplayName(NULL, NULL, AFileName,
				     NULL, &pIDLFile, NULL);
    LPCITEMIDLIST pICDLFile = pIDLFile;
    if(hRes == NO_ERROR)
      {
	LPEXTRACTIMAGE pExtractImage;
	hRes = AFolder->GetUIObjectOf(NULL, 1, &pICDLFile,
				      IID_IExtractImage,NULL,
				      (void**)&pExtractImage);
        if(hRes == NO_ERROR)
	  {
	    OLECHAR wszPathBuffer[MAX_PATH];
	    DWORD dwFlags = IEIFLAG_SCREEN;
	    SIZE    size = {AThumbWidth,AThumbHeight};
	    hRes = pExtractImage->GetLocation(wszPathBuffer,
					      MAX_PATH, NULL,
					      &size, dwRecClrDepth, &dwFlags);
	    if(hRes == NO_ERROR) 
	      {
		hRes = pExtractImage->Extract(&hBitmap);
	      }
            pExtractImage->Release();
	  }
        FMalloc->Free(pIDLFile);
      }
    return hBitmap;
}

HBITMAP ThumbnailImage::ExtractFile(LPOLESTR AFolderPath,
				    LPOLESTR AFileName,
				    int AThumbWidth,   
				    int AThumbHeight,  
				    DWORD dwRecClrDepth)
{
  HBITMAP hBitmap = NULL;
  HRESULT hRes;

  LPITEMIDLIST    pIDLFolder;
  hRes = FDesktopFolder->ParseDisplayName (NULL, NULL, AFolderPath,
					   NULL,&pIDLFolder, NULL);
  if (hRes == NO_ERROR)
    {
      LPSHELLFOLDER pFolder;
      hRes = FDesktopFolder->BindToObject(pIDLFolder, NULL,
					  IID_IShellFolder,
					  (void**)&pFolder);
      if(hRes == NO_ERROR)
	{
	  hBitmap = ExtractFolder (AFileName, AThumbWidth,
				   AThumbHeight, dwRecClrDepth, pFolder);
	  pFolder->Release();
	}
      FMalloc->Free(pIDLFolder);
    }
  return hBitmap;
}
