#include <windows.h>
#include <stdio.h>
#include "DropSource.h"

HRESULT __stdcall CDropSource::QueryInterface(const IID& iid, void** ppv)
{
  HRESULT hr;

  if(iid == IID_IDropSource || iid == IID_IUnknown){
    hr = S_OK;
    *ppv = (void*)this;
    AddRef();
  }else{
    hr = E_NOINTERFACE;
    *ppv = 0;
  }
  return hr;
}


ULONG __stdcall CDropSource::AddRef()
{
  InterlockedIncrement(&_RefCount);
  return (ULONG)_RefCount;
}


ULONG __stdcall CDropSource::Release()
{
  ULONG ret = (ULONG)InterlockedDecrement(&_RefCount);
  if(ret == 0){
    delete this;
  }
  return (ULONG)_RefCount;
}

HRESULT __stdcall CDropSource::QueryContinueDrag(BOOL fEscapePressed,
						 DWORD grfKeyState)
{
  if (fEscapePressed ||
     (MK_LBUTTON | MK_RBUTTON) == (grfKeyState & (MK_LBUTTON | MK_RBUTTON)))
    {
      return DRAGDROP_S_CANCEL;
    }
  if ((grfKeyState & (MK_LBUTTON | MK_RBUTTON)) == 0)
    {
      char ret_string[10];
      fprintf (stdout, "OK");
      fgets (ret_string, 10, stdin);
      fprintf (stdout, "READ:", ret_string);
      return DRAGDROP_S_DROP;
    }
  return S_OK;
}

HRESULT __stdcall CDropSource::GiveFeedback(DWORD dwEffect)
{
  return DRAGDROP_S_USEDEFAULTCURSORS;
}
