/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.classdiagram.command.JavaClass;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.LeafType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaFile {
    private static final Pattern classDefinition = MyPattern.cmpile("^(?:public[%s]+|abstract[%s]+|final[%s]+)*(class|interface|enum|annotation)[%s]+(\\w+)(?:.*\\b(extends|implements)[%s]+([\\w%s,]+))?");
    private static final Pattern packageDefinition = MyPattern.cmpile("^package[%s]+([\\w+.]+)[%s]*;");
    private final List<JavaClass> all = new ArrayList<JavaClass>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFile(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            this.initFromReader(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private void initFromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = packageDefinition.matcher(string = string.trim());
            if (matcher.find()) {
                string2 = matcher.group(1);
                continue;
            }
            Matcher matcher2 = classDefinition.matcher(string);
            if (!matcher2.find()) continue;
            String string3 = matcher2.group(2);
            String string4 = matcher2.group(4);
            LeafType leafType = LeafType.valueOf(matcher2.group(1).toUpperCase());
            LeafType leafType2 = JavaFile.getParentType(leafType, matcher2.group(3));
            this.all.add(new JavaClass(string2, string3, string4, leafType, leafType2));
        }
    }

    static LeafType getParentType(LeafType leafType, String string) {
        if (string == null) {
            return null;
        }
        if (leafType == LeafType.CLASS) {
            if (string.equals("extends")) {
                return LeafType.CLASS;
            }
            return LeafType.INTERFACE;
        }
        return LeafType.INTERFACE;
    }

    public List<JavaClass> getJavaClasses() {
        return Collections.unmodifiableList(this.all);
    }
}

